<?php

use App\Http\Controllers\Admin\Brief\BriefController;
use App\Http\Controllers\Admin\Brief\BriefLinkController;
use App\Http\Controllers\Admin\Brief\BriefLogController;
use App\Http\Controllers\Admin\Brief\MobileAppBriefController;
use App\Http\Controllers\Admin\Brief\SemBriefController;
use App\Http\Controllers\Admin\Brief\SmmBriefController;
use App\Http\Controllers\Admin\Brief\WebBriefController;
use App\Http\Controllers\Admin\Brief\VideoBriefController;
use App\Http\Controllers\Admin\StaffController;
use App\Http\Controllers\Auth\LoginController;
use App\Models\Setting;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

// Route::get('/', function () {
//     return Redirect::route('admin.login');
// })->middleware('guest');


// Route::get('/login', function () {
//     return Inertia::render('Login');
// })->name('admin.login')->middleware('guest');


Route::middleware(['auth', 'check2fa'])->group(function () {
    // Route::get('/dashboard', function () {
    //     return redirect()->route('brief.list');
    // })->name('brief.dashboard');

    Route::controller(BriefController::class)->group(function () {
        Route::get('/list', 'index')->name('brief.list');
        // Route::get('/detail/{id}', 'detail')->name('brief.detail');
        Route::get('/form/{id?}', 'form')->name('brief.form');
        Route::get('/view/{id}', 'view')->name('brief.view');
        Route::get('/detail/details/{id?}', 'details')->name('brief-detail.details');
        Route::get('/detail/{id?}', 'briefDetail')->name('brief-detail.detail');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('brief-detail.activity');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('brief.download');
        Route::get('/viewform', 'viewForm')->name('brief.viewform');
        Route::post('/delete/{id?}', 'delete')->name('brief.delete');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('brief.updateMetadata');
        Route::post('/copy/activity', 'copyActivity')->name('brief.copy.activity');
    });

    Route::controller(BriefLinkController::class)->prefix('/link') ->group(function (){
        Route::get('/list','index')->name('brief.link.list');
        Route::post('/update-metadata/{id}','updateMetadata')->name('brief.link.updateMetadata');
        // Route::get('/form/{token?}','form')->name('brief.link.form');
        Route::get('/detail/{id?}', 'detail')->name('brief.link.detail');
        Route::get('/add', 'add')->name('brief.link.add');
        Route::get('/edit/{id}', 'edit')->name('brief.link.edit.id');
        Route::post('/create', 'create')->name('brief.link.create');
        Route::get('/delete/{id}', 'delete')->name('brief.link.delete.id');
        Route::post('/update/{id}', 'update')->name('brief.link.update');
        Route::post('/status-change', 'statusChange')->name('brief.link.status.change');
        Route::post('/create-log', 'createLog' )->name('brief.link.createLog');
    });

    Route::controller(WebBriefController::class)->prefix('/web')->group(function () {
        Route::get('/list', 'list')->name('web.brief.list');
        Route::get('/detail', 'detail')->name('web.brief.detail');
        Route::get('/form/{id?}', 'form')->name('web.brief.form');
        Route::get('/view/{id?}', 'view')->name('web.brief.view');
        Route::get('/brief-detail/{id?}', 'briefDetail')->name('web.brief-detail.detail');
        Route::get('/detail/details/{id?}', 'details')->name('web.brief-detail.details');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('web.brief.download');
        Route::post('/delete/{id?}', 'delete')->name('web.brief.delete');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('web.brief.updateMetadata');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('web.brief-detail.activity');
    });

    Route::controller(VideoBriefController::class)->prefix('/video')->group(function () {
        Route::get('/list', 'list')->name('video.brief.list');
        Route::post('/delete/{id?}', 'delete')->name('video.brief.delete');
        // Route::get('/detail', 'detail')->name('video.brief.detail');
        Route::get('/view/{id?}', 'view')->name('video.brief.view');
        Route::get('/brief-detail/{id?}', 'briefDetail')->name('video.brief-detail.detail');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('video.brief-detail.activity');
        Route::get('/detail/details/{id?}', 'details')->name('video.brief-detail.details');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('video.brief.download');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('video.brief.updateMetadata');
    });


    Route::controller(BriefLogController::class)->group(function () {
        Route::post('/brief-logs/{id}', 'create')->name('brief.log.create');
        Route::post('/brief-logs/{id}/{logID}/update', 'update')->name('brief.log.update');
        Route::post('/brief-logs/{id}/{logID}/delete', 'delete')->name('brief.log.delete');

        Route::get('/brief-logs/create-file', 'createLogFile')->name('brief.log.createFile');
    });


    Route::controller(StaffController::class)->prefix('/staff')->group(function () {
        Route::get('/list', 'index')->name('staff.list');
        Route::get('/detail', 'detail')->name('staff.detail');
        Route::get('/activity', 'activity')->name('staff.activity');
    });

    Route::controller(SmmBriefController::class)->prefix('/smm')->group(function () {
        Route::get('/list', 'index')->name('smm.brief.list');
        Route::get('/view/{id}', 'view')->name('smm.brief.view');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('smm.brief.download');
        Route::post('/delete/{id?}', 'delete')->name('smm.brief.delete');
        Route::get('/brief-detail/{id?}', 'briefDetail')->name('smm.brief-detail.detail');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('smm.brief.updateMetadata');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('smm.brief-detail.activity');
        Route::get('/detail/details/{id?}', 'details')->name('smm.brief-detail.details');
    });

    Route::controller(MobileAppBriefController::class)->prefix('/mobile-app')->group(function () {
        Route::get('/list', 'index')->name('app.brief.list');
        Route::get('/brief-detail/{id?}', 'briefDetail')->name('app.brief-detail.detail');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('app.brief-detail.activity');
        Route::get('/detail/details/{id?}', 'details')->name('app.brief-detail.details');
        Route::get('/view/{id}', 'view')->name('app.brief.view');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('app.brief.updateMetadata');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('app.brief.download');
        Route::post('/delete/{id?}', 'delete')->name('app.brief.delete');

        // Route::get('/list', 'index')->name('app.brief.list');
        // Route::post('/delete/{id?}', 'delete')->name('smm.   brief.delete');
    });

    Route::controller(SemBriefController::class)->prefix('/sem')->group(function () {
        Route::get('/list', 'index')->name('sem.brief.list');
        Route::get('/view/{id}', 'view')->name('sem.brief.view');
        Route::get('/download/{id?}/{fingerprint?}', 'downloadBrief')->name('sem.brief.download');
        Route::post('/delete/{id?}', 'delete')->name('sem.brief.delete');
        Route::get('/brief-detail/{id?}', 'briefDetail')->name('sem.brief-detail.detail');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('sem.brief.updateMetadata');
        Route::get('/detail/activity/{id?}', 'briefActivity')->name('sem.brief-detail.activity');
        Route::get('/detail/details/{id?}', 'details')->name('sem.brief-detail.details');
    });
});


Route::controller(BriefLinkController::class)->prefix('/link') ->group(function (){
    Route::get('/form/{token?}','form')->name('brief.link.form');
    Route::get('/expired', 'expired')->name('brief.link.expired');
});



// Route::get('/logout', [LoginController::class, 'logout'])->name('admin.logout');
