<?php

use App\Http\Controllers\Admin\CountryCurrenciesController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\LeadController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\PaymentLinkController;
use App\Http\Controllers\Admin\PaymentLogController;
use App\Http\Controllers\Admin\QuotesController;
use App\Http\Controllers\Admin\ProductCatalogController;
use App\Http\Controllers\Admin\TeamController;
use App\Http\Controllers\Admin\StaffController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\TwoFactorAuthController;
use App\Http\Controllers\Admin\UserActivityController;
use App\Http\Controllers\Auth\LoginController;
use App\Models\Setting;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Redirect::route('admin.login');
})->middleware('guest');


Route::get('/login', function () {

    $excludeArr = array('mail_setting_billing', 'mail_setting_general');

    $brand_settings = Arr::pluck(Setting::whereNotIn('key', $excludeArr)->get(), 'value', 'key');

    return Inertia::render('Login', [
        'brand_settings' => $brand_settings,
    ]);
})->name('admin.login')->middleware('guest');

Route::get('/two-step-verification', function () {
    $excludeArr = array('mail_setting_billing', 'mail_setting_general');

    $brand_settings = Arr::pluck(Setting::whereNotIn('key', $excludeArr)->get(), 'value', 'key');

    return Inertia::render('TwoStep', [
        'brand_settings' => $brand_settings,
    ]);
})->name('admin.twoStep')->middleware('guest');

Route::controller(TwoFactorAuthController::class)->group(function () {
    Route::get('/two-step', 'show2faForm')->name('admin.2fa');
    Route::post('/2fa/send', 'sendVerificationCodes')->name('admin.sendverificationcode');
    Route::post('/2fa/twostep/enable', 'twoStepAuthenticationEnable')->name('admin.twoStepAuthenticationEnable');
    Route::post('/2fa/disable/{userID}', 'disable')->name('admin.twoStepAuthenticationDisable');
    Route::post('2fa/password/verify/{id}', 'verifyPassword')->name('admin.verify.password');
});


Route::middleware(['auth', 'check2fa'])->group(function () {

    Route::get('/user-activities/{userId}', [UserActivityController::class, 'showUserActivities'])->name('admin.user.activities');

    Route::controller(DashboardController::class)->group(function () {
        Route::get('/dashboard', 'index')->name('admin.dashboard');
        Route::get('/dailyGraph', 'dailyGraph')->name('admin.dashboard.dailyGraph');
        Route::post('/dashboard/user', 'userDashboardAction')->name('admin.dashboard.user');
        Route::get('/search', 'searchAction')->name('admin.search');
        Route::get('/payouts', 'payouts')->name('admin.payouts');
    });

    Route::controller(CountryCurrenciesController::class)->group(function () {
        Route::get('/settings/countries', 'list')->name('admin.settings.countries');
    });

    Route::controller(CustomerController::class)->group(function () {
        Route::get('/customer/search', 'search')->name('admin.customer.search');
        Route::post('/customer', 'create')->name('admin.customer.create');
        Route::get('/customer', 'list')->name('admin.customer.list');
        Route::get('/customer/detail/{id}', 'detail')->name('admin.customer.detail');
        Route::post('/customer/update/{clientID}', 'update')->name('admin.customer.update');
        Route::post('/customer/update-metadata/{clientID}', 'updateMetadata')->name('admin.customer.update.metadata');
        Route::post('/customer/delete/{id?}', 'delete')->name('admin.customer.delete');
        Route::post('/customer/export', 'export')->name('admin.customer.export');
        Route::post('/customer/import', 'import')->name('admin.customer.import');

        // add to allow/block list
        Route::post('/customer/{id}/allow-block-list', 'allowOrBlockCustomer')->name('admin.customer.allow.block.list');
    });

    Route::controller(PaymentController::class)->group(function () {
        Route::get('/payment', 'list')->name('admin.payment.list');
        Route::get('/payment/detail/{id?}', 'detail')->name('admin.payment.detail.id');
        Route::get('/payment/detail/{token?}', 'detail')->name('admin.payment.detail');
        Route::post('/payment/update/{paymentID}', 'update')->name('admin.payment.update');
        Route::post('/payment/refund/', 'refund')->name('admin.payment.refund');
        Route::post('/payment/refund/single', 'singleRefund')->name('admin.payment.refund.single');
        Route::get('/unread-payments', 'showUnreadPayments')->name('admin.unread.payments');
        Route::post('/payment/export', 'export')->name('admin.payment.export');
        Route::get('/payment/view/receipt/{id?}', 'viewReceipt')->name('admin.payment.view.receipt');
        Route::post('/payment/update_description/{id}', 'updateDescription')->name('admin.payment.update.description');
        Route::get('/payment/refund/list', 'refundPayments')->name('admin.payment.refund.list');
        Route::post('/payment/search', 'searchPayment')->name('admin.payment.search');
        //Route::post('/payment/customer/relation','addManuallyPaymentAsRelated')->name('admin.payment.customer.relation');
        Route::post('/payment/customer/relation', 'bindCustomerManually')->name('admin.payment.customer.relation');
    });

    // NOTIFICATION
    Route::controller(NotificationController::class)->group(function () {
        Route::get('/notification/{id?}', 'list')->name('admin.notification');
        Route::get('/notificationspopup', 'popup')->name('admin.notification.popup');
        Route::get('/markoneasread', 'markOneRead')->name('admin.notification.markoneread');
        Route::post('/markallread', 'markAllRead')->name('admin.notification.markallread');
        Route::get('/new-features', 'newFeatures')->name('admin.notification.newfeatures');
    });

    Route::controller(PaymentLinkController::class)->group(function () {
        Route::get('/payment/generate/{customerID?}', 'create')->name('admin.payment.generate');
        Route::post('/payment/generate', 'generate')->name('admin.payment.linkgenerator.create');
        Route::get('/payment/edit/{id}', 'edit')->name('admin.payment.edit');
        // Route::post('/customer/delete/{id?}', 'delete')->name('admin.paymentlink.delete');
        Route::post('/payment/link/update/{id}', 'update')->name('admin.payment.linkgenerator.update');
        Route::get('/payment/links', 'list')->name('admin.payment.linkgenerator.list');
        Route::put('/payment/links/update_metadata/{id?}', 'updateMetaData')->name('admin.payment.linkgenerator.update.metadata');
        Route::get('/payment/links/detail/{id?}', 'detail')->name('admin.payment.linkgenerator.detail');
        Route::post('/payment/links/status-change', 'statusChange')->name('admin.payment.linkgenerator.status-change');
    });

    Route::controller(InvoiceController::class)->group(function () {
        Route::get('/invoice', 'list')->name('admin.invoice.list');
        Route::get('/invoice/create/{customer_id?}', 'create')->name('admin.invoice.create');
        Route::post('/invoice/create', 'store')->name('admin.invoice.store');
        Route::get('/invoice/detail/{id?}', 'detail')->name('admin.invoice.detail.id');
        Route::get('/invoice/edit/{id?}', 'getInvoice')->name('admin.invoice.edit');
        Route::post('/invoice/update/{id}', 'update')->name('admin.invoice.update');
        Route::post('/invoice/update/metadata/{id}', 'updateMetadata')->name('admin.invoice.metadata.update');
        Route::get('/invoice/download/{id}', 'downloadInvoice')->name('admin.invoice.download');
        Route::post('/invoice/send/testInvoice', 'sendTestingInvoice')->name('admin.invoice.sendTestInvoice');
        Route::post('/invoice/duplicate', 'duplicateInvoice')->name('admin.invoice.duplicate');
        Route::get('/invoice/delete/{invoiceID}', 'delete')->name('admin.invoice.delete');
        Route::post('/invoice/export', 'export')->name('admin.invoice.export');
    });

    Route::controller(PaymentLogController::class)->group(function () {
        Route::get('/logs/{id}', 'logDetail')->name('admin.logs.detail');
        Route::get('/events/{id}', 'eventDetail')->name('admin.events.detail');

        Route::get('/payment-logs', 'list')->name('admin.payment.log.list');
        Route::post('/payment-logs/{id}', 'create')->name('admin.payment.log.create');
        Route::post('/payment-logs/{id}/{logID}/update', 'update')->name('admin.payment.log.update');
        Route::post('/payment-logs/{id}/{logID}/delete', 'delete')->name('admin.payment.log.delete');
    });

    Route::controller(QuotesController::class)->group(function () {
        Route::get('/quotes', 'list')->name('admin.quote.list');
        Route::post('/quotes/{id}', 'create')->name('admin.quote.create');
        Route::post('/quotes/{id}/{quoteID}/update', 'update')->name('admin.quote.update');
        Route::post('/quotes/{id}/{quoteID}/delete', 'delete')->name('admin.quote.delete');
    });

    Route::controller(ProductCatalogController::class)->group(function () {
        Route::get('/products/list', 'list')->name('admin.products.list');
        Route::get('/product/create', 'create')->name('admin.product');
        Route::post('/product/create', 'generate')->name('admin.product.create');
        Route::get('/product/edit/{productID}', 'getProduct')->name('admin.product.edit');
        Route::post('/product/{productID}', 'update')->name('admin.product.update');
        Route::get('/product/archived/{productID}', 'archived')->name('admin.product.archived');
        Route::get('/product/delete/{productID}', 'delete')->name('admin.product.delete');
        Route::get('/product/restore/{productID}', 'restore')->name('admin.product.restore');
        Route::get('/product/detail/{productID}', 'detail')->name('admin.product.detail');
        Route::post('/product/update/metadata/{productID}', 'updateMetadata')->name('admin.product.metadata.update');
    });

    Route::controller(CouponController::class)->group(function () {
        Route::get('/products/coupon/list', 'index')->name('admin.coupons.list');
        Route::get('/products/coupon/detail', 'detail')->name('admin.coupons.detail');
        Route::get('/products/coupon/create', 'create')->name('admin.coupons.create');
        Route::post('/products/coupon/store', 'store')->name('admin.coupons.store');
        Route::post('/products/coupon/update/metadata/{id}', 'updateMetadata')->name('admin.coupon.metadata.update');
        Route::get('/products/coupon/edit/{id}', 'edit')->name('admin.coupons.edit');
        Route::post('/products/coupon/update/{id}', 'update')->name('admin.coupons.update');
        Route::post('/products/coupon/delete/{id}', 'delete')->name('admin.coupons.delete');
        Route::post('/products/coupon/active/{id}', 'active')->name('admin.coupons.active');
    });

    Route::controller(TeamController::class)->group(function () {
        Route::get('/team', 'list')->name('admin.team.list');
        Route::get('/team/create', 'create')->name('admin.team');
        Route::post('/team/create', 'generate')->name('admin.team.create');
        Route::get('/team/edit/{teamID}', 'getTeam')->name('admin.team.edit');
        Route::post('/team/{teamID}', 'update')->name('admin.team.update');
        Route::get('/team/archived/{teamID}', 'archived')->name('admin.team.archived');
        Route::get('/team/delete/{teamID}', 'delete')->name('admin.team.delete');
        Route::get('/team/restore/{teamID}', 'restore')->name('admin.team.restore');
        Route::get('/team/detail/{teamID}', 'detail')->name('admin.team.detail');
        Route::post('/team/update/metadata/{teamID}', 'updateMetadata')->name('admin.team.metadata.update');
    });

    Route::controller(StaffController::class)->group(function () {
        Route::get('staff', 'list')->name('admin.staff.list');
        // Route::get('staff/detail', 'detail')->name('admin.staff.detail');
        Route::post('staff/profile/create', 'create')->name('admin.staff.profile.create');
        Route::post('staff/profile/update/{id}', 'update')->name('admin.staff.profile.update');
        Route::get('staff/detail/overview/{id?}', 'detailOverview')->name('admin.staff.detail.overview');
        Route::get('staff/detail/permissions/{id}', 'detailPermission')->name('admin.staff.detail.permissions');
        Route::get('staff/detail/payments/{id}', 'detailPayment')->name('admin.staff.detail.payments');
        Route::put('staff/permission/{permissionId}/{userId}', 'permission')->name('admin.staff.permission');
        Route::post('staff/session/signout', 'signoutStaffSessions')->name('admin.staff.session.signout');
        Route::post('/staff/delete/{id?}', 'delete')->name('admin.staff.delete');
        Route::post('staff/send/otp', 'sendOtp')->name('admin.staff.sendotp');
        Route::post('staff/session/signout/id', 'signoutStaffSessionsId')->name('admin.staff.session.signout.id');
        Route::post('staff/password/verify', 'verifyPassword')->name('admin.staff.verify.password');
        Route::post('/staff/export', 'export')->name('admin.staff.export');
        Route::get('staff/detail/dailyStaffPayments/{id?}', 'dailyStaffPayments')->name('admin.staff.dailyStaffPayments');
        Route::get('staff/detail/logins/{id}', 'detailLogin')->name('admin.staff.detail.logins');
    });


    Route::controller(ProfileController::class)->group(function () {
        Route::get('/profile', 'profile')->name('admin.profile');
        Route::post('/profile/update/{id}', 'update')->name('admin.profile.update');
    });

    Route::controller(SettingController::class)->group(function () {
        Route::get('settings', 'index')->name('admin.settings');
        Route::get('settings/download/backup', 'downloadDBBackup')->name('admin.backup.download');
    });

    Route::controller(RoleController::class)->group(function () {
        Route::get('/role', 'list')->name('admin.role.list');
        Route::get('/role/create', 'create')->name('admin.role');
        Route::post('/role/create', 'generate')->name('admin.role.create');
        Route::get('/role/edit/{roleID}', 'getrole')->name('admin.role.edit');
        Route::post('/role/{roleID}', 'update')->name('admin.role.update');
        Route::get('/role/archived/{roleID}', 'archived')->name('admin.role.archived');
        Route::get('/role/delete/{roleID}', 'delete')->name('admin.role.delete');
        Route::get('/role/restore/{roleID}', 'restore')->name('admin.role.restore');
        Route::get('/role/detail/{roleID}', 'detail')->name('admin.role.detail');
        Route::post('/role/update/metadata/{roleID}', 'updateMetadata')->name('admin.role.metadata.update');
    });

    Route::controller(LeadController::class)->prefix('/lead')->group(function () {
        Route::get('/list', 'index')->name('admin.lead.list');
        Route::get('/detail/{id}', 'detail')->name('admin.lead.detail.id');
        Route::get('/add', 'add')->name('admin.lead.add');
        Route::post('/create', 'create')->name('admin.lead.create');
        Route::get('/edit/{id}', 'edit')->name('admin.lead.edit.id');
        Route::post('/update/{id}', 'update')->name('admin.lead.update');
        Route::post('/update-metadata/{id}', 'updateMetadata')->name('admin.lead.updateMetaData');
        Route::get('/delete/{id}', 'delete')->name('admin.lead.delete.id');
        Route::post('/update/value/{id}', 'updateValue')->name('admin.lead.updateValue.id');
    });
});

Route::get('/logout', [LoginController::class, 'logout'])->name('admin.logout');

Route::get('/link-storage', function () {
    Artisan::call('storage:link');
});
