<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 100%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    vertical-align: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}
.checkbox-description span{
    vertical-align: 5px;
}

.radio_text{
    margin-left: 0.5rem;
    cursor: pointer;
}

.radio_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.radio_row label{
    margin-bottom: 0;
    vertical-align: 3px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}


@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}

.other_row{
    display: flex;
}

.other_row_input{
    border: none;
    border-bottom: 1px solid #10111a29;
    margin-bottom: -0.25em;
}
  </style>
</head>

<body>
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">Mobile App Brief Questionnaire</h1>
                <p class="header-description description">Please take your time on the submission below. The more detailed, accurate and extensive information provided, the higher quality product you will receive.</p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                Your contact information is safe with us and are never shared with any third party.
                            </li>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                    @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Client's Full Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Client's Phone Number <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Mobile Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_name" class="input-label mb-2">Official Business Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Name" name="business_name" class="input business-name-input" value="{{ $formData["business_name"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_address" class="input-label mb-2">Registered Business Address (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Address" name="business_address" class="input business-address-input" value="{{ $formData["business_address"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_phone" class="input-label mb-2">Business Contact Number (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Phone" name="business_phone" class="input business-phone-input" value="{{ $formData["business_phone"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_email" class="input-label mb-2">Business Email (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Email" name="business_email" class="input business-email-input" value="{{ $formData["business_email"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_link" class="input-label mb-2">Current Website URL (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Website Link" name="website_link" class="input website-link-input" value="{{ $formData["website_link"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_hosting" class="input-label mb-2">Current Web Hosting Provider (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Website Hosting" name="website_hosting" class="input website-hosting-input" value="{{ $formData["website_hosting"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_domain" class="input-label mb-2">Current Domain Address (If Any) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Website Domain" name="website_domain" class="input website-domain-input" value="{{ $formData["website_domain"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_operations" class="input-label mb-2">Please describe your organization's operations in a few sentences. <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Operations" name="business_operations" class="input business-operations-input" value="{{ $formData["business_operations"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">What will be the primary purpose of your mobile app? <span class="asterisk">*</span></legend>

                            @php
                                $options = [
                                    'relaying_information_about_your_business' => 'Relaying Information About Your Business',
                                    'buying_selling_online' => 'Buying and(or) Selling Online',
                                    'appointment_booking' => 'Appointment Booking',
                                    'office_productivity' => 'Office Productivity',
                                    'improve_customer_service' => 'Improve Your Customer Service',
                                    'travel_apps' => 'Travel Apps',
                                    'medical_app' => 'Medical App'
                                ];

                                $selectedValue = $formData["app_purpose"] ?? '';
                            @endphp

                            @foreach ($options as $value => $label)
                                <div class="radio_row">
                                    <input type="radio" id="{{ $value }}" name="app_purpose" value="{{ $value }}" {{ $selectedValue == $value ? 'checked' : '' }}>
                                    <label for="{{ $value }}" class="radio_text">{{ $label }}</label>
                                </div>
                            @endforeach

                            <div class="radio_row other_row">
                                <input type="radio" id="custom" name="app_purpose" value="other" {{ !array_key_exists($selectedValue, $options) ? 'checked' : '' }}>
                                <label for="custom" class="radio_text">Other</label>
                                @if (!array_key_exists($selectedValue, $options))
                                        <input class="other_row_input" type="text" name="other_app_purpose" value="{{ $selectedValue }}" placeholder="Please specify">
                                @endif
                            </div>

                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">What Overall Look and Feel & Flow would you like to portray with your Mobile App? <span class="asterisk">*</span></legend>

                            @php
                                $lookOptions = [
                                    'corporate' => 'Corporate',
                                    'fun' => 'Fun',
                                    'high_tech' => 'High Tech',
                                    'modern' => 'Modern',
                                    'classic' => 'Classic',
                                    'vintage' => 'Vintage'
                                ];

                                $selectedLook = $formData["app_look"] ?? '';
                            @endphp

                            @foreach ($lookOptions as $value => $label)
                                <div class="radio_row">
                                    <input type="radio" id="{{ $value }}" name="app_look" value="{{ $value }}" {{ $selectedLook == $value ? 'checked' : '' }}>
                                    <label for="{{ $value }}" class="radio_text">{{ $label }}</label>
                                </div>
                            @endforeach

                            <div class="radio_row other_row">
                                <input type="radio" id="other_look" name="app_look" value="other" {{ !array_key_exists($selectedLook, $lookOptions) ? 'checked' : '' }}>
                                <label for="other_look" class="radio_text">Other</label>
                                @if (!array_key_exists($selectedLook, $lookOptions))
                                    <input class="other_row_input" type="text" name="custom_app_look" value="{{ $selectedLook }}" placeholder="Please specify">
                                @endif
                            </div>

                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_specification" class="input-label mb-2">Please provide detail Information & functional specifications that your Mobile App will provide <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Secification" name="app_specification" class="input app-specification-input" value="{{ $formData["app_specification"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">
                                Would you like to avail CMS features for your Mobile App?
                                <span class="asterisk">*</span>
                            </legend>
                            <p class="description">CMS is a system which lets you add content and make day-to-day updates on your mobile app.</p>
                            <div class="radio_row">
                                <input type="radio" id="cms_yes" name="is_cms" value="yes" {{ $formData["is_cms"] == 'yes' ? 'checked' : '' }}>
                                <label for="cms_yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="cms_no" name="is_cms" value="no" {{ $formData["is_cms"] == 'no' ? 'checked' : '' }}>
                                <label for="cms_no" class="radio_text">No</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="cms_maybe" name="is_cms" value="maybe" {{ $formData["is_cms"] == 'maybe' ? 'checked' : '' }}>
                                <label for="cms_maybe" class="radio_text">Maybe</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="content_restriction" class="input-label mb-2">Is there any content restriction outside of the US? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Restrictions" name="content_restriction" class="input content-restriction-input" value="{{ $formData["content_restriction"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="users_accomplishment" class="input-label mb-2">What goals do you have for users to accomplish in your Mobile App? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Restrictions" name="users_accomplishment" class="input content-restriction-input" value="{{ $formData["users_accomplishment"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="users_accomplishment" class="input-label mb-2">What goals do you have for users to accomplish in your Mobile App? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Restrictions" name="users_accomplishment" class="input users-accomplishment-input" value="{{ $formData["users_accomplishment"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_design" class="input-label mb-2">Do you have wireframes or app designs (PSD/AI files) ready for the application? Or would you like to avail our services on App Design? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Design" name="app_design" class="input app-design-input" value="{{ $formData["app_design"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="publish_assistance" class="input-label mb-2">Would you like to avail assistance publish app on App Stores like Google play & Apple App Store? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Publish Assistance" name="publish_assistance" class="input app-publish-assistance-input" value="{{ $formData["publish_assistance"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_pages_section" class="input-label mb-2">Pages/Section you require e.g. About Us, Services/Products, Contact Us <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Pages" name="app_pages_section" class="input app-page-section-input" value="{{ $formData["app_pages_section"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_reference" class="input-label mb-2">Do you have any reference app(s) which works similar to your requirement? Please list the ones you found<br> closest. <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Reference" name="app_reference" class="input app-reference-input" value="{{ $formData["app_reference"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_users" class="input-label mb-2">Please provide details information about the users who will using your Mobile App? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Users" name="app_users" class="input app-users-input" value="{{ $formData["app_users"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">
                                Would you need push notifications for your application?
                                <span class="asterisk">*</span>
                            </legend>
                            <div class="radio_row">
                                <input type="radio" id="is_push_notification_yes" name="is_push_notification" value="yes" {{ $formData["is_push_notification"] == 'yes' ? 'checked' : '' }}>
                                <label for="is_push_notification_yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_push_notification_no" name="is_push_notification" value="no" {{ $formData["is_push_notification"] == 'no' ? 'checked' : '' }}>
                                <label for="is_push_notification_no" class="radio_text">No</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_push_notification_maybe" name="is_push_notification" value="maybe" {{ $formData["is_push_notification"] == 'maybe' ? 'checked' : '' }}>
                                <label for="is_push_notification_maybe" class="radio_text">Maybe</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="is_third_party_api" class="input-label mb-2">Would you like to integrate or use any Third party API services for your application? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Usage of Third Party APIs" name="is_third_party_api" class="input is-third-party-apis-input" value="{{ $formData["is_third_party_api"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_tagline" class="input-label mb-2">Do you have a tagline/slogan? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Slogan" name="app_tagline" class="input app-tagline-input" value="{{ $formData["app_tagline"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">
                                Do you have a high-resolution logo?
                                <span class="asterisk">*</span>
                            </legend>
                            <div class="radio_row">
                                <input type="radio" id="is_app_logo_yes" name="is_app_logo" value="yes" {{ $formData["is_app_logo"] == 'yes' ? 'checked' : '' }}>
                                <label for="is_app_logo_yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_app_logo_no" name="is_app_logo" value="no" {{ $formData["is_app_logo"] == 'no' ? 'checked' : '' }}>
                                <label for="is_app_logo_no" class="radio_text">No</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_app_logo_maybe" name="is_app_logo" value="maybe" {{ $formData["is_app_logo"] == 'maybe' ? 'checked' : '' }}>
                                <label for="is_app_logo_maybe" class="radio_text">Maybe</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">
                                Have you considered redesigning your logo?
                                <span class="asterisk">*</span>
                            </legend>
                            <div class="radio_row">
                                <input type="radio" id="is_logo_redesign_yes" name="is_logo_redesign" value="yes" {{ $formData["is_logo_redesign"] == 'yes' ? 'checked' : '' }}>
                                <label for="is_logo_redesign_yes" class="radio_text">Yes</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_logo_redesign_no" name="is_logo_redesign" value="no" {{ $formData["is_logo_redesign"] == 'no' ? 'checked' : '' }}>
                                <label for="is_logo_redesign_no" class="radio_text">No</label>
                            </div>
                            <div class="radio_row">
                                <input type="radio" id="is_logo_redesign_maybe" name="is_logo_redesign" value="maybe" {{ $formData["is_logo_redesign"] == 'maybe' ? 'checked' : '' }}>
                                <label for="is_logo_redesign_maybe" class="radio_text">Maybe</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_font_style" class="input-label mb-2">Please specify if you would like to use a specific font style <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Font Style" name="app_font_style" class="input app-font-style-input" value="{{ $formData["app_font_style"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="app_colors" class="input-label mb-2">Are there any colors that you want incorporated into the Mobile App? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="App Colors" name="app_colors" class="input app-colors-input" value="{{ $formData["app_colors"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="comments" class="input-label mb-2">Anything else that you would like to add, feel free to use the space below <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Comments" name="comments" class="input comments-input" value="{{ $formData["comments"] }}" >
                        </fieldset>
                    </section>
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>

  <script src="{{ asset(mix('js/app.js')) }}"></script>
