<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <title>Email Verification</title>
    <style>
        body {
            font-family: "Poppins", sans-serif !important;
            background-color: #f6f8fa;
            color: black;
            padding: 20px;
        }

        .crm-password-box {
            width: 52%;
            margin: auto;
            border-radius: 6px;
            /* box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.1); */
            padding: 20px;
            margin-bottom: 32px;
            margin-top: 12px;
            background-color: white;
        }

        .crm-password-header {
            color: #666ee8;
            font-size: 1.5rem;
            font-weight: 700;
            border-bottom: 1px solid #ccc9c9;
            width: 100%;
            height: 40px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .crm-password-header img {
            height: 30px;
            display: inline-block;
            margin: 0 auto;
            width: auto;
        }

        .password-text {
            color: #666ee8;
            font-size: 1.2rem;
            font-weight: 700;
            margin: 1rem auto;
            text-align: center;
        }

        .crm-password-text {
            font-size: 1rem;
            color: #525f7f;
            margin: 1rem auto;
            display: table;
        }

        .verify-button {
            background-color: #666ee8;
            color: white;
            padding: 10px 20px;
            text-align: center;
            display: inline-block;
            font-weight: 600;
            border: none;
            cursor: pointer;
            text-decoration: none;
            margin-top: 20px;
            width: 100%;
            box-sizing: border-box;
            border-radius: 0.25rem;
        }

        .support-text {
            margin-top: 1rem;
            font-size: 1rem;
            color: #525f7f;
        }

        .footer-text {
            font-size: 14px;
            margin-top: 1rem;
            color: #525f7f;
        }

        .address-text {
            font-size: small;
            padding: 1rem 0;
            border-top: 1px solid #ccc9c9;
            width: 100%;
            color: #91a0b1;
        }

        a {
            text-decoration: none;
        }
    </style>
</head>

<body style="background-color: #f6f8fa; color: black; padding: 20px;">
    <div class="crm-password-box">
        <div class="crm-password-header" style="display: flex;"><img src="{{ (!empty($data['brand_settings']['logo']) ? asset($data['brand_settings']['logo']) : '') }}" alt="" /></div>
        <p class="crm-password-text">Your password for dashboard is</p>
        <p class="crm-password-text"><span class="password-text">{{ $data['password'] }}</span></p>
        <a href="{{ route('admin.login') }}" class="verify-button" style="color: white">Login to your account</a>
        <div class="support-text">
            Note: Please don't share this password to anyone. Change this password before 24 hours after that your password get's expired.
        </div>
        <div class="footer-text">
            Thanks,<br>
            {{ $data['brand_settings']['company_name'] }}<br>
            <br>
        </div>
        <div class="address-text">
            {{ $data['brand_settings']['company_address'] }}
        </div>
    </div>
</body>

</html>
