import { createApp, h } from "vue";
import { createInertiaApp, Head, Link } from "@inertiajs/vue3";
import route from "ziggy-js";
import Layout from "../js/Pages/Admin/Shared/Layout/Main.vue"
import BriefLayout from "../js/Pages/Brief/Shared/Layout/Main.vue"
import { modulePermission } from "./Pages/Admin/Shared/Composables/authorization";
import { createGtm } from '@gtm-support/vue-gtm';
import {GTM_KEY} from './Pages/Shared/Composables/Config/constants.js'

createInertiaApp({
    resolve: async name => {
        try {
            let page = (await import(`@Pages/${name}.vue`)).default;

            if (!page.layout) {
                if (name.startsWith('Admin/')) {
                    page.layout ??= Layout;
                } else if (name.startsWith('Brief/')) {
                    page.layout ??= Layout;
                    // page.layout ??= BriefLayout;
                } else {
                    page.layout ??= undefined;
                }
            }

            return page;
        } catch (error) {
            console.log(error);
            throw error;
        }
    },
    setup({ el, App, props, plugin }) {
        const app = createApp({ render: () => h(App, props) });

        app.config.globalProperties.$modulePermission = modulePermission;
        // app.config.globalProperties.$zopim = window.$zopim;F

        app.use(plugin)
            .component('Link', Link)
            .component('Head', Head)
            .mixin({ methods: { route } })
            .mount(el);

        app.use(
            createGtm({
                id: GTM_KEY, // Your GTM single container ID, array of container ids ['GTM-xxxxxx', 'GTM-yyyyyy'] or array of objects [{id: 'GTM-xxxxxx', queryParams: { gtm_auth: 'abc123', gtm_preview: 'env-4', gtm_cookies_win: 'x'}}, {id: 'GTM-yyyyyy', queryParams: {gtm_auth: 'abc234', gtm_preview: 'env-5', gtm_cookies_win: 'x'}}], // Your GTM single container ID or array of container ids ['GTM-xxxxxx', 'GTM-yyyyyy']
                defer: false, // Script can be set to `defer` to speed up page load at the cost of less accurate results (in case visitor leaves before script is loaded, which is unlikely but possible). Defaults to false, so the script is loaded `async` by default
                compatibility: false, // Will add `async` and `defer` to the script tag to not block requests for old browsers that do not support `async`
                debug: true,
            }),
        );
    },
});
