export function usePayment() {
    const validateDate = (dateString) => {
        const dateRegex = /^(0[1-9]|1[0-2])\/(\d{2})$/;
        if (!dateRegex.test(dateString)) {
            return false;
        }

        const [month, year] = dateString.split("/").map(Number);
        const currentDate = new Date();
        const currentMonth = currentDate.getMonth() + 1;
        const currentYear = currentDate.getFullYear() % 100;

        if (month < 1 || month > 12) {
            return false;
        }

        if (
            year < currentYear ||
            (year === currentYear && month < currentMonth)
        ) {
            return false;
        }

        return true;
    };

    const identifyCreditCardAndLength = (creditCardNumber) => {
        // Remove spaces from the credit card number
        const sanitizedCardNumber = creditCardNumber.replace(/\s+/g, "");
        const regexPatterns = {
            visa: { pattern: /^4\d{15}$/, length: 16 },
            mastercard: { pattern: /^5[1-5][0-9]{14}$/, length: 16 },
            cartesBancaires: {
                pattern:
                    /^(?:4[0-9]{12}(?:[0-9]{3})?|4\d{3}\s?\d{4}\s?\d{4}\s?\d{4})$/,
                length: 16,
            },
            eftposAustralia: {
                pattern: /^(?:4\d{15}|(?:4\d{3}-\d{4}-\d{4}-\d{4}))$/,
                length: 16,
            },
            amex: { pattern: /^3[47][0-9]{13}$/, length: 15 },
            diners14: {
                pattern: /^3(?:0[0-5]|[68][0-9])[0-9]{11}$/,
                length: 14,
            },
            diners16: {
                pattern: /^3(?:0[0-5]|[68][0-9])[0-9]{13}$/,
                length: 16,
            },
            dina: { pattern: /^65[0-9]{14}$/, length: 16 },
            bccard: { pattern: /^9[0-9]{15}$/, length: 16 },
            jcb: { pattern: /^(?:2131|1800|35\d{3})\d{11}$/, length: 16 },
            unionpay16: { pattern: /^62[0-9]{14}$/, length: 16 },
            unionpay19: { pattern: /^62[0-9]{17}$/, length: 19 },
            discover: { pattern: /^6(?:011|5[0-9]{2})[0-9]{12}$/, length: 16 },
        };

        for (const [issuer, { pattern, length }] of Object.entries(
            regexPatterns
        )) {
            if (pattern.test(sanitizedCardNumber)) {
                return {
                    issuer: issuer,
                    length: length,
                };
            }
        }

        return null;
    };

    const backspaceFocus = (refVal, value) => {
        if (value.length == 0) {
            refVal.focus();
        }
    };

    const paymentGateway = (gateway) => {
        let method = "creditCard";
        if (gateway == "afterpay") {
            method = "afterpay";
        }

        return method;
    };

    return {
        validateDate,
        identifyCreditCardAndLength,
        backspaceFocus,
        paymentGateway,
    };
}
