import { computed } from "vue";

export const findByID = (arr, id) => {
  if(arr.length > 0) {
    return arr.find(item => id == item.id);
  } else {
    return {};
  }
};

export const isJsonString = (str) => {
  try {
    return JSON.parse(str);
  } catch (e) {
      return false;
  }
};

export const formatText = (text) => {
    return text.split(/[_ ]/).map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
};

export const siteURL = computed(() => process.env.MIX_BRAND_URL);

export const capitalizeWords = (words) => {
  return words.toLowerCase().replace(/(^\w{1})|(\s+\w{1})/g, letter => letter.toUpperCase());
};

export const briefBadge = (badgeType) => {
    const badges = {
        logo_brief: {title: 'Logo', class: 'success'},
        web_brief: {title: 'Web', class: 'primary'},
        video_brief: {title: 'Video', class: 'info'},
        mobile_app_brief: {title: 'Mobile App', class: 'danger'},
        sem_brief: {title: 'SEM', class: 'dark'},
        smm_brief: {title: 'SMM', class: 'warning'},
    }

    return badges[badgeType];
}