(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_Pages_Admin_Brief_Brief_BriefDetail_vue"],{

/***/ "./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js":
/*!******************************************************************!*\
  !*** ./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   componentsToDebugString: () => (/* binding */ componentsToDebugString),
/* harmony export */   "default": () => (/* binding */ index),
/* harmony export */   getFullscreenElement: () => (/* binding */ getFullscreenElement),
/* harmony export */   getUnstableAudioFingerprint: () => (/* binding */ getUnstableAudioFingerprint),
/* harmony export */   getUnstableCanvasFingerprint: () => (/* binding */ getUnstableCanvasFingerprint),
/* harmony export */   getUnstableScreenFrame: () => (/* binding */ getUnstableScreenFrame),
/* harmony export */   getUnstableScreenResolution: () => (/* binding */ getUnstableScreenResolution),
/* harmony export */   getWebGLContext: () => (/* binding */ getWebGLContext),
/* harmony export */   hashComponents: () => (/* binding */ hashComponents),
/* harmony export */   isAndroid: () => (/* binding */ isAndroid),
/* harmony export */   isChromium: () => (/* binding */ isChromium),
/* harmony export */   isDesktopWebKit: () => (/* binding */ isDesktopWebKit),
/* harmony export */   isEdgeHTML: () => (/* binding */ isEdgeHTML),
/* harmony export */   isGecko: () => (/* binding */ isGecko),
/* harmony export */   isTrident: () => (/* binding */ isTrident),
/* harmony export */   isWebKit: () => (/* binding */ isWebKit),
/* harmony export */   load: () => (/* binding */ load),
/* harmony export */   loadSources: () => (/* binding */ loadSources),
/* harmony export */   murmurX64Hash128: () => (/* binding */ murmurX64Hash128),
/* harmony export */   prepareForSources: () => (/* binding */ prepareForSources),
/* harmony export */   sources: () => (/* binding */ sources),
/* harmony export */   transformSource: () => (/* binding */ transformSource),
/* harmony export */   withIframe: () => (/* binding */ withIframe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.mjs");
/**
 * FingerprintJS v4.5.0 - Copyright (c) FingerprintJS, Inc, 2024 (https://fingerprint.com)
 *
 * Licensed under Business Source License 1.1 https://mariadb.com/bsl11/
 * Licensor: FingerprintJS, Inc.
 * Licensed Work: FingerprintJS browser fingerprinting library
 * Additional Use Grant: None
 * Change Date: Four years from first release for the specific version.
 * Change License: MIT, text at https://opensource.org/license/mit/ with the following copyright notice:
 * Copyright 2015-present FingerprintJS, Inc.
 */



var version = "4.5.0";

function wait(durationMs, resolveWith) {
    return new Promise(function (resolve) { return setTimeout(resolve, durationMs, resolveWith); });
}
/**
 * Allows asynchronous actions and microtasks to happen.
 */
function releaseEventLoop() {
    // Don't use setTimeout because Chrome throttles it in some cases causing very long agent execution:
    // https://stackoverflow.com/a/6032591/1118709
    // https://github.com/chromium/chromium/commit/0295dd09496330f3a9103ef7e543fa9b6050409b
    // Reusing a MessageChannel object gives no noticeable benefits
    return new Promise(function (resolve) {
        var channel = new MessageChannel();
        channel.port1.onmessage = function () { return resolve(); };
        channel.port2.postMessage(null);
    });
}
function requestIdleCallbackIfAvailable(fallbackTimeout, deadlineTimeout) {
    if (deadlineTimeout === void 0) { deadlineTimeout = Infinity; }
    var requestIdleCallback = window.requestIdleCallback;
    if (requestIdleCallback) {
        // The function `requestIdleCallback` loses the binding to `window` here.
        // `globalThis` isn't always equal `window` (see https://github.com/fingerprintjs/fingerprintjs/issues/683).
        // Therefore, an error can occur. `call(window,` prevents the error.
        return new Promise(function (resolve) { return requestIdleCallback.call(window, function () { return resolve(); }, { timeout: deadlineTimeout }); });
    }
    else {
        return wait(Math.min(fallbackTimeout, deadlineTimeout));
    }
}
function isPromise(value) {
    return !!value && typeof value.then === 'function';
}
/**
 * Calls a maybe asynchronous function without creating microtasks when the function is synchronous.
 * Catches errors in both cases.
 *
 * If just you run a code like this:
 * ```
 * console.time('Action duration')
 * await action()
 * console.timeEnd('Action duration')
 * ```
 * The synchronous function time can be measured incorrectly because another microtask may run before the `await`
 * returns the control back to the code.
 */
function awaitIfAsync(action, callback) {
    try {
        var returnedValue = action();
        if (isPromise(returnedValue)) {
            returnedValue.then(function (result) { return callback(true, result); }, function (error) { return callback(false, error); });
        }
        else {
            callback(true, returnedValue);
        }
    }
    catch (error) {
        callback(false, error);
    }
}
/**
 * If you run many synchronous tasks without using this function, the JS main loop will be busy and asynchronous tasks
 * (e.g. completing a network request, rendering the page) won't be able to happen.
 * This function allows running many synchronous tasks such way that asynchronous tasks can run too in background.
 */
function mapWithBreaks(items, callback, loopReleaseInterval) {
    if (loopReleaseInterval === void 0) { loopReleaseInterval = 16; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var results, lastLoopReleaseTime, i, now;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0:
                    results = Array(items.length);
                    lastLoopReleaseTime = Date.now();
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < items.length)) return [3 /*break*/, 4];
                    results[i] = callback(items[i], i);
                    now = Date.now();
                    if (!(now >= lastLoopReleaseTime + loopReleaseInterval)) return [3 /*break*/, 3];
                    lastLoopReleaseTime = now;
                    return [4 /*yield*/, releaseEventLoop()];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    ++i;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/, results];
            }
        });
    });
}
/**
 * Makes the given promise never emit an unhandled promise rejection console warning.
 * The promise will still pass errors to the next promises.
 * Returns the input promise for convenience.
 *
 * Otherwise, promise emits a console warning unless it has a `catch` listener.
 */
function suppressUnhandledRejectionWarning(promise) {
    promise.then(undefined, function () { return undefined; });
    return promise;
}

/*
 * This file contains functions to work with pure data only (no browser features, DOM, side effects, etc).
 */
/**
 * Does the same as Array.prototype.includes but has better typing
 */
function includes(haystack, needle) {
    for (var i = 0, l = haystack.length; i < l; ++i) {
        if (haystack[i] === needle) {
            return true;
        }
    }
    return false;
}
/**
 * Like `!includes()` but with proper typing
 */
function excludes(haystack, needle) {
    return !includes(haystack, needle);
}
/**
 * Be careful, NaN can return
 */
function toInt(value) {
    return parseInt(value);
}
/**
 * Be careful, NaN can return
 */
function toFloat(value) {
    return parseFloat(value);
}
function replaceNaN(value, replacement) {
    return typeof value === 'number' && isNaN(value) ? replacement : value;
}
function countTruthy(values) {
    return values.reduce(function (sum, value) { return sum + (value ? 1 : 0); }, 0);
}
function round(value, base) {
    if (base === void 0) { base = 1; }
    if (Math.abs(base) >= 1) {
        return Math.round(value / base) * base;
    }
    else {
        // Sometimes when a number is multiplied by a small number, precision is lost,
        // for example 1234 * 0.0001 === 0.12340000000000001, and it's more precise divide: 1234 / (1 / 0.0001) === 0.1234.
        var counterBase = 1 / base;
        return Math.round(value * counterBase) / counterBase;
    }
}
/**
 * Parses a CSS selector into tag name with HTML attributes.
 * Only single element selector are supported (without operators like space, +, >, etc).
 *
 * Multiple values can be returned for each attribute. You decide how to handle them.
 */
function parseSimpleCssSelector(selector) {
    var _a, _b;
    var errorMessage = "Unexpected syntax '".concat(selector, "'");
    var tagMatch = /^\s*([a-z-]*)(.*)$/i.exec(selector);
    var tag = tagMatch[1] || undefined;
    var attributes = {};
    var partsRegex = /([.:#][\w-]+|\[.+?\])/gi;
    var addAttribute = function (name, value) {
        attributes[name] = attributes[name] || [];
        attributes[name].push(value);
    };
    for (;;) {
        var match = partsRegex.exec(tagMatch[2]);
        if (!match) {
            break;
        }
        var part = match[0];
        switch (part[0]) {
            case '.':
                addAttribute('class', part.slice(1));
                break;
            case '#':
                addAttribute('id', part.slice(1));
                break;
            case '[': {
                var attributeMatch = /^\[([\w-]+)([~|^$*]?=("(.*?)"|([\w-]+)))?(\s+[is])?\]$/.exec(part);
                if (attributeMatch) {
                    addAttribute(attributeMatch[1], (_b = (_a = attributeMatch[4]) !== null && _a !== void 0 ? _a : attributeMatch[5]) !== null && _b !== void 0 ? _b : '');
                }
                else {
                    throw new Error(errorMessage);
                }
                break;
            }
            default:
                throw new Error(errorMessage);
        }
    }
    return [tag, attributes];
}
/**
 * Converts a string to UTF8 bytes
 */
function getUTF8Bytes(input) {
    // Benchmark: https://jsbench.me/b6klaaxgwq/1
    // If you want to just count bytes, see solutions at https://jsbench.me/ehklab415e/1
    var result = new Uint8Array(input.length);
    for (var i = 0; i < input.length; i++) {
        // `charCode` is faster than encoding, so we prefer that when it's possible
        var charCode = input.charCodeAt(i);
        // In case of non-ASCII symbols we use proper encoding
        if (charCode > 127) {
            return new TextEncoder().encode(input);
        }
        result[i] = charCode;
    }
    return result;
}

/*
 * Based on https://github.com/karanlyons/murmurHash3.js/blob/a33d0723127e2e5415056c455f8aed2451ace208/murmurHash3.js
 */
/**
 * Adds two 64-bit values (provided as tuples of 32-bit values)
 * and updates (mutates) first value to write the result
 */
function x64Add(m, n) {
    var m0 = m[0] >>> 16, m1 = m[0] & 0xffff, m2 = m[1] >>> 16, m3 = m[1] & 0xffff;
    var n0 = n[0] >>> 16, n1 = n[0] & 0xffff, n2 = n[1] >>> 16, n3 = n[1] & 0xffff;
    var o0 = 0, o1 = 0, o2 = 0, o3 = 0;
    o3 += m3 + n3;
    o2 += o3 >>> 16;
    o3 &= 0xffff;
    o2 += m2 + n2;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o1 += m1 + n1;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o0 += m0 + n0;
    o0 &= 0xffff;
    m[0] = (o0 << 16) | o1;
    m[1] = (o2 << 16) | o3;
}
/**
 * Multiplies two 64-bit values (provided as tuples of 32-bit values)
 * and updates (mutates) first value to write the result
 */
function x64Multiply(m, n) {
    var m0 = m[0] >>> 16, m1 = m[0] & 0xffff, m2 = m[1] >>> 16, m3 = m[1] & 0xffff;
    var n0 = n[0] >>> 16, n1 = n[0] & 0xffff, n2 = n[1] >>> 16, n3 = n[1] & 0xffff;
    var o0 = 0, o1 = 0, o2 = 0, o3 = 0;
    o3 += m3 * n3;
    o2 += o3 >>> 16;
    o3 &= 0xffff;
    o2 += m2 * n3;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o2 += m3 * n2;
    o1 += o2 >>> 16;
    o2 &= 0xffff;
    o1 += m1 * n3;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o1 += m2 * n2;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o1 += m3 * n1;
    o0 += o1 >>> 16;
    o1 &= 0xffff;
    o0 += m0 * n3 + m1 * n2 + m2 * n1 + m3 * n0;
    o0 &= 0xffff;
    m[0] = (o0 << 16) | o1;
    m[1] = (o2 << 16) | o3;
}
/**
 * Provides left rotation of the given int64 value (provided as tuple of two int32)
 * by given number of bits. Result is written back to the value
 */
function x64Rotl(m, bits) {
    var m0 = m[0];
    bits %= 64;
    if (bits === 32) {
        m[0] = m[1];
        m[1] = m0;
    }
    else if (bits < 32) {
        m[0] = (m0 << bits) | (m[1] >>> (32 - bits));
        m[1] = (m[1] << bits) | (m0 >>> (32 - bits));
    }
    else {
        bits -= 32;
        m[0] = (m[1] << bits) | (m0 >>> (32 - bits));
        m[1] = (m0 << bits) | (m[1] >>> (32 - bits));
    }
}
/**
 * Provides a left shift of the given int32 value (provided as tuple of [0, int32])
 * by given number of bits. Result is written back to the value
 */
function x64LeftShift(m, bits) {
    bits %= 64;
    if (bits === 0) {
        return;
    }
    else if (bits < 32) {
        m[0] = m[1] >>> (32 - bits);
        m[1] = m[1] << bits;
    }
    else {
        m[0] = m[1] << (bits - 32);
        m[1] = 0;
    }
}
/**
 * Provides a XOR of the given int64 values(provided as tuple of two int32).
 * Result is written back to the first value
 */
function x64Xor(m, n) {
    m[0] ^= n[0];
    m[1] ^= n[1];
}
var F1 = [0xff51afd7, 0xed558ccd];
var F2 = [0xc4ceb9fe, 0x1a85ec53];
/**
 * Calculates murmurHash3's final x64 mix of that block and writes result back to the input value.
 * (`[0, h[0] >>> 1]` is a 33 bit unsigned right shift. This is the
 * only place where we need to right shift 64bit ints.)
 */
function x64Fmix(h) {
    var shifted = [0, h[0] >>> 1];
    x64Xor(h, shifted);
    x64Multiply(h, F1);
    shifted[1] = h[0] >>> 1;
    x64Xor(h, shifted);
    x64Multiply(h, F2);
    shifted[1] = h[0] >>> 1;
    x64Xor(h, shifted);
}
var C1 = [0x87c37b91, 0x114253d5];
var C2 = [0x4cf5ad43, 0x2745937f];
var M$1 = [0, 5];
var N1 = [0, 0x52dce729];
var N2 = [0, 0x38495ab5];
/**
 * Given a string and an optional seed as an int, returns a 128 bit
 * hash using the x64 flavor of MurmurHash3, as an unsigned hex.
 * All internal functions mutates passed value to achieve minimal memory allocations and GC load
 *
 * Benchmark https://jsbench.me/p4lkpaoabi/1
 */
function x64hash128(input, seed) {
    var key = getUTF8Bytes(input);
    seed = seed || 0;
    var length = [0, key.length];
    var remainder = length[1] % 16;
    var bytes = length[1] - remainder;
    var h1 = [0, seed];
    var h2 = [0, seed];
    var k1 = [0, 0];
    var k2 = [0, 0];
    var i;
    for (i = 0; i < bytes; i = i + 16) {
        k1[0] = key[i + 4] | (key[i + 5] << 8) | (key[i + 6] << 16) | (key[i + 7] << 24);
        k1[1] = key[i] | (key[i + 1] << 8) | (key[i + 2] << 16) | (key[i + 3] << 24);
        k2[0] = key[i + 12] | (key[i + 13] << 8) | (key[i + 14] << 16) | (key[i + 15] << 24);
        k2[1] = key[i + 8] | (key[i + 9] << 8) | (key[i + 10] << 16) | (key[i + 11] << 24);
        x64Multiply(k1, C1);
        x64Rotl(k1, 31);
        x64Multiply(k1, C2);
        x64Xor(h1, k1);
        x64Rotl(h1, 27);
        x64Add(h1, h2);
        x64Multiply(h1, M$1);
        x64Add(h1, N1);
        x64Multiply(k2, C2);
        x64Rotl(k2, 33);
        x64Multiply(k2, C1);
        x64Xor(h2, k2);
        x64Rotl(h2, 31);
        x64Add(h2, h1);
        x64Multiply(h2, M$1);
        x64Add(h2, N2);
    }
    k1[0] = 0;
    k1[1] = 0;
    k2[0] = 0;
    k2[1] = 0;
    var val = [0, 0];
    switch (remainder) {
        case 15:
            val[1] = key[i + 14];
            x64LeftShift(val, 48);
            x64Xor(k2, val);
        // fallthrough
        case 14:
            val[1] = key[i + 13];
            x64LeftShift(val, 40);
            x64Xor(k2, val);
        // fallthrough
        case 13:
            val[1] = key[i + 12];
            x64LeftShift(val, 32);
            x64Xor(k2, val);
        // fallthrough
        case 12:
            val[1] = key[i + 11];
            x64LeftShift(val, 24);
            x64Xor(k2, val);
        // fallthrough
        case 11:
            val[1] = key[i + 10];
            x64LeftShift(val, 16);
            x64Xor(k2, val);
        // fallthrough
        case 10:
            val[1] = key[i + 9];
            x64LeftShift(val, 8);
            x64Xor(k2, val);
        // fallthrough
        case 9:
            val[1] = key[i + 8];
            x64Xor(k2, val);
            x64Multiply(k2, C2);
            x64Rotl(k2, 33);
            x64Multiply(k2, C1);
            x64Xor(h2, k2);
        // fallthrough
        case 8:
            val[1] = key[i + 7];
            x64LeftShift(val, 56);
            x64Xor(k1, val);
        // fallthrough
        case 7:
            val[1] = key[i + 6];
            x64LeftShift(val, 48);
            x64Xor(k1, val);
        // fallthrough
        case 6:
            val[1] = key[i + 5];
            x64LeftShift(val, 40);
            x64Xor(k1, val);
        // fallthrough
        case 5:
            val[1] = key[i + 4];
            x64LeftShift(val, 32);
            x64Xor(k1, val);
        // fallthrough
        case 4:
            val[1] = key[i + 3];
            x64LeftShift(val, 24);
            x64Xor(k1, val);
        // fallthrough
        case 3:
            val[1] = key[i + 2];
            x64LeftShift(val, 16);
            x64Xor(k1, val);
        // fallthrough
        case 2:
            val[1] = key[i + 1];
            x64LeftShift(val, 8);
            x64Xor(k1, val);
        // fallthrough
        case 1:
            val[1] = key[i];
            x64Xor(k1, val);
            x64Multiply(k1, C1);
            x64Rotl(k1, 31);
            x64Multiply(k1, C2);
            x64Xor(h1, k1);
        // fallthrough
    }
    x64Xor(h1, length);
    x64Xor(h2, length);
    x64Add(h1, h2);
    x64Add(h2, h1);
    x64Fmix(h1);
    x64Fmix(h2);
    x64Add(h1, h2);
    x64Add(h2, h1);
    return (('00000000' + (h1[0] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h1[1] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h2[0] >>> 0).toString(16)).slice(-8) +
        ('00000000' + (h2[1] >>> 0).toString(16)).slice(-8));
}

/**
 * Converts an error object to a plain object that can be used with `JSON.stringify`.
 * If you just run `JSON.stringify(error)`, you'll get `'{}'`.
 */
function errorToObject(error) {
    var _a;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({ name: error.name, message: error.message, stack: (_a = error.stack) === null || _a === void 0 ? void 0 : _a.split('\n') }, error);
}
function isFunctionNative(func) {
    return /^function\s.*?\{\s*\[native code]\s*}$/.test(String(func));
}

function isFinalResultLoaded(loadResult) {
    return typeof loadResult !== 'function';
}
/**
 * Loads the given entropy source. Returns a function that gets an entropy component from the source.
 *
 * The result is returned synchronously to prevent `loadSources` from
 * waiting for one source to load before getting the components from the other sources.
 */
function loadSource(source, sourceOptions) {
    var sourceLoadPromise = suppressUnhandledRejectionWarning(new Promise(function (resolveLoad) {
        var loadStartTime = Date.now();
        // `awaitIfAsync` is used instead of just `await` in order to measure the duration of synchronous sources
        // correctly (other microtasks won't affect the duration).
        awaitIfAsync(source.bind(null, sourceOptions), function () {
            var loadArgs = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                loadArgs[_i] = arguments[_i];
            }
            var loadDuration = Date.now() - loadStartTime;
            // Source loading failed
            if (!loadArgs[0]) {
                return resolveLoad(function () { return ({ error: loadArgs[1], duration: loadDuration }); });
            }
            var loadResult = loadArgs[1];
            // Source loaded with the final result
            if (isFinalResultLoaded(loadResult)) {
                return resolveLoad(function () { return ({ value: loadResult, duration: loadDuration }); });
            }
            // Source loaded with "get" stage
            resolveLoad(function () {
                return new Promise(function (resolveGet) {
                    var getStartTime = Date.now();
                    awaitIfAsync(loadResult, function () {
                        var getArgs = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            getArgs[_i] = arguments[_i];
                        }
                        var duration = loadDuration + Date.now() - getStartTime;
                        // Source getting failed
                        if (!getArgs[0]) {
                            return resolveGet({ error: getArgs[1], duration: duration });
                        }
                        // Source getting succeeded
                        resolveGet({ value: getArgs[1], duration: duration });
                    });
                });
            });
        });
    }));
    return function getComponent() {
        return sourceLoadPromise.then(function (finalizeSource) { return finalizeSource(); });
    };
}
/**
 * Loads the given entropy sources. Returns a function that collects the entropy components.
 *
 * The result is returned synchronously in order to allow start getting the components
 * before the sources are loaded completely.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function loadSources(sources, sourceOptions, excludeSources, loopReleaseInterval) {
    var includedSources = Object.keys(sources).filter(function (sourceKey) { return excludes(excludeSources, sourceKey); });
    // Using `mapWithBreaks` allows asynchronous sources to complete between synchronous sources
    // and measure the duration correctly
    var sourceGettersPromise = suppressUnhandledRejectionWarning(mapWithBreaks(includedSources, function (sourceKey) { return loadSource(sources[sourceKey], sourceOptions); }, loopReleaseInterval));
    return function getComponents() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
            var sourceGetters, componentPromises, componentArray, components, index;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, sourceGettersPromise];
                    case 1:
                        sourceGetters = _a.sent();
                        return [4 /*yield*/, mapWithBreaks(sourceGetters, function (sourceGetter) { return suppressUnhandledRejectionWarning(sourceGetter()); }, loopReleaseInterval)];
                    case 2:
                        componentPromises = _a.sent();
                        return [4 /*yield*/, Promise.all(componentPromises)
                            // Keeping the component keys order the same as the source keys order
                        ];
                    case 3:
                        componentArray = _a.sent();
                        components = {};
                        for (index = 0; index < includedSources.length; ++index) {
                            components[includedSources[index]] = componentArray[index];
                        }
                        return [2 /*return*/, components];
                }
            });
        });
    };
}
/**
 * Modifies an entropy source by transforming its returned value with the given function.
 * Keeps the source properties: sync/async, 1/2 stages.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function transformSource(source, transformValue) {
    var transformLoadResult = function (loadResult) {
        if (isFinalResultLoaded(loadResult)) {
            return transformValue(loadResult);
        }
        return function () {
            var getResult = loadResult();
            if (isPromise(getResult)) {
                return getResult.then(transformValue);
            }
            return transformValue(getResult);
        };
    };
    return function (options) {
        var loadResult = source(options);
        if (isPromise(loadResult)) {
            return loadResult.then(transformLoadResult);
        }
        return transformLoadResult(loadResult);
    };
}

/*
 * Functions to help with features that vary through browsers
 */
/**
 * Checks whether the browser is based on Trident (the Internet Explorer engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isTrident() {
    var w = window;
    var n = navigator;
    // The properties are checked to be in IE 10, IE 11 and not to be in other browsers in October 2020
    return (countTruthy([
        'MSCSSMatrix' in w,
        'msSetImmediate' in w,
        'msIndexedDB' in w,
        'msMaxTouchPoints' in n,
        'msPointerEnabled' in n,
    ]) >= 4);
}
/**
 * Checks whether the browser is based on EdgeHTML (the pre-Chromium Edge engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isEdgeHTML() {
    // Based on research in October 2020
    var w = window;
    var n = navigator;
    return (countTruthy(['msWriteProfilerMark' in w, 'MSStream' in w, 'msLaunchUri' in n, 'msSaveBlob' in n]) >= 3 &&
        !isTrident());
}
/**
 * Checks whether the browser is based on Chromium without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isChromium() {
    // Based on research in October 2020. Tested to detect Chromium 42-86.
    var w = window;
    var n = navigator;
    return (countTruthy([
        'webkitPersistentStorage' in n,
        'webkitTemporaryStorage' in n,
        n.vendor.indexOf('Google') === 0,
        'webkitResolveLocalFileSystemURL' in w,
        'BatteryManager' in w,
        'webkitMediaStream' in w,
        'webkitSpeechGrammar' in w,
    ]) >= 5);
}
/**
 * Checks whether the browser is based on mobile or desktop Safari without using user-agent.
 * All iOS browsers use WebKit (the Safari engine).
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isWebKit() {
    // Based on research in August 2024
    var w = window;
    var n = navigator;
    return (countTruthy([
        'ApplePayError' in w,
        'CSSPrimitiveValue' in w,
        'Counter' in w,
        n.vendor.indexOf('Apple') === 0,
        'RGBColor' in w,
        'WebKitMediaKeys' in w,
    ]) >= 4);
}
/**
 * Checks whether this WebKit browser is a desktop browser.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isDesktopWebKit() {
    // Checked in Safari and DuckDuckGo
    var w = window;
    var HTMLElement = w.HTMLElement, Document = w.Document;
    return (countTruthy([
        'safari' in w,
        !('ongestureend' in w),
        !('TouchEvent' in w),
        !('orientation' in w),
        HTMLElement && !('autocapitalize' in HTMLElement.prototype),
        Document && 'pointerLockElement' in Document.prototype,
    ]) >= 4);
}
/**
 * Checks whether this WebKit browser is Safari.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * Warning! The function works properly only for Safari version 15.4 and newer.
 */
function isSafariWebKit() {
    // Checked in Safari, Chrome, Firefox, Yandex, UC Browser, Opera, Edge and DuckDuckGo.
    // iOS Safari and Chrome were checked on iOS 11-18. DuckDuckGo was checked on iOS 17 and macOS 14.
    // Desktop Safari versions 12-18 were checked.
    // The other browsers were checked on iOS 17 and 18; there was no chance to check them on the other OS versions.
    var w = window;
    return (
    // Filters-out Chrome, Yandex, DuckDuckGo (macOS and iOS), Edge
    isFunctionNative(w.print) &&
        // Doesn't work in Safari < 15.4
        String(w.browser) === '[object WebPageNamespace]');
}
/**
 * Checks whether the browser is based on Gecko (Firefox engine) without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isGecko() {
    var _a, _b;
    var w = window;
    // Based on research in September 2020
    return (countTruthy([
        'buildID' in navigator,
        'MozAppearance' in ((_b = (_a = document.documentElement) === null || _a === void 0 ? void 0 : _a.style) !== null && _b !== void 0 ? _b : {}),
        'onmozfullscreenchange' in w,
        'mozInnerScreenX' in w,
        'CSSMozDocumentRule' in w,
        'CanvasCaptureMediaStream' in w,
    ]) >= 4);
}
/**
 * Checks whether the browser is based on Chromium version ≥86 without using user-agent.
 * It doesn't check that the browser is based on Chromium, there is a separate function for this.
 */
function isChromium86OrNewer() {
    // Checked in Chrome 85 vs Chrome 86 both on desktop and Android
    var w = window;
    return (countTruthy([
        !('MediaSettingsRange' in w),
        'RTCEncodedAudioFrame' in w,
        '' + w.Intl === '[object Intl]',
        '' + w.Reflect === '[object Reflect]',
    ]) >= 3);
}
/**
 * Checks whether the browser is based on WebKit version ≥606 (Safari ≥12) without using user-agent.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * @see https://en.wikipedia.org/wiki/Safari_version_history#Release_history Safari-WebKit versions map
 */
function isWebKit606OrNewer() {
    // Checked in Safari 9–17
    var w = window;
    return (countTruthy([
        'DOMRectList' in w,
        'RTCPeerConnectionIceEvent' in w,
        'SVGGeometryElement' in w,
        'ontransitioncancel' in w,
    ]) >= 3);
}
/**
 * Checks whether the browser is based on WebKit version ≥616 (Safari ≥17) without using user-agent.
 * It doesn't check that the browser is based on WebKit, there is a separate function for this.
 *
 * @see https://developer.apple.com/documentation/safari-release-notes/safari-17-release-notes Safari 17 release notes
 * @see https://tauri.app/v1/references/webview-versions/#webkit-versions-in-safari Safari-WebKit versions map
 */
function isWebKit616OrNewer() {
    var w = window;
    var n = navigator;
    var CSS = w.CSS, HTMLButtonElement = w.HTMLButtonElement;
    return (countTruthy([
        !('getStorageUpdates' in n),
        HTMLButtonElement && 'popover' in HTMLButtonElement.prototype,
        'CSSCounterStyleRule' in w,
        CSS.supports('font-size-adjust: ex-height 0.5'),
        CSS.supports('text-transform: full-width'),
    ]) >= 4);
}
/**
 * Checks whether the device is an iPad.
 * It doesn't check that the engine is WebKit and that the WebKit isn't desktop.
 */
function isIPad() {
    // Checked on:
    // Safari on iPadOS (both mobile and desktop modes): 8, 11-17
    // Chrome on iPadOS (both mobile and desktop modes): 11-17
    // Safari on iOS (both mobile and desktop modes): 9-17
    // Chrome on iOS (both mobile and desktop modes): 9-17
    // Before iOS 13. Safari tampers the value in "request desktop site" mode since iOS 13.
    if (navigator.platform === 'iPad') {
        return true;
    }
    var s = screen;
    var screenRatio = s.width / s.height;
    return (countTruthy([
        'MediaSource' in window,
        !!Element.prototype.webkitRequestFullscreen,
        // iPhone 4S that runs iOS 9 matches this, but it is not supported
        screenRatio > 0.65 && screenRatio < 1.53,
    ]) >= 2);
}
/**
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getFullscreenElement() {
    var d = document;
    return d.fullscreenElement || d.msFullscreenElement || d.mozFullScreenElement || d.webkitFullscreenElement || null;
}
function exitFullscreen() {
    var d = document;
    // `call` is required because the function throws an error without a proper "this" context
    return (d.exitFullscreen || d.msExitFullscreen || d.mozCancelFullScreen || d.webkitExitFullscreen).call(d);
}
/**
 * Checks whether the device runs on Android without using user-agent.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function isAndroid() {
    var isItChromium = isChromium();
    var isItGecko = isGecko();
    var w = window;
    var n = navigator;
    var c = 'connection';
    // Chrome removes all words "Android" from `navigator` when desktop version is requested
    // Firefox keeps "Android" in `navigator.appVersion` when desktop version is requested
    if (isItChromium) {
        return (countTruthy([
            !('SharedWorker' in w),
            // `typechange` is deprecated, but it's still present on Android (tested on Chrome Mobile 117)
            // Removal proposal https://bugs.chromium.org/p/chromium/issues/detail?id=699892
            // Note: this expression returns true on ChromeOS, so additional detectors are required to avoid false-positives
            n[c] && 'ontypechange' in n[c],
            !('sinkId' in new window.Audio()),
        ]) >= 2);
    }
    else if (isItGecko) {
        return countTruthy(['onorientationchange' in w, 'orientation' in w, /android/i.test(navigator.appVersion)]) >= 2;
    }
    else {
        // Only 2 browser engines are presented on Android.
        // Actually, there is also Android 4.1 browser, but it's not worth detecting it at the moment.
        return false;
    }
}

/**
 * A deep description: https://fingerprint.com/blog/audio-fingerprinting/
 * Inspired by and based on https://github.com/cozylife/audio-fingerprint
 *
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * Audio signal is noised in private mode of Safari 17, so audio fingerprinting is skipped in Safari 17.
 */
function getAudioFingerprint() {
    if (doesBrowserPerformAntifingerprinting$1()) {
        return -4 /* SpecialFingerprint.KnownForAntifingerprinting */;
    }
    return getUnstableAudioFingerprint();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableAudioFingerprint() {
    var w = window;
    var AudioContext = w.OfflineAudioContext || w.webkitOfflineAudioContext;
    if (!AudioContext) {
        return -2 /* SpecialFingerprint.NotSupported */;
    }
    // In some browsers, audio context always stays suspended unless the context is started in response to a user action
    // (e.g. a click or a tap). It prevents audio fingerprint from being taken at an arbitrary moment of time.
    // Such browsers are old and unpopular, so the audio fingerprinting is just skipped in them.
    // See a similar case explanation at https://stackoverflow.com/questions/46363048/onaudioprocess-not-called-on-ios11#46534088
    if (doesBrowserSuspendAudioContext()) {
        return -1 /* SpecialFingerprint.KnownForSuspending */;
    }
    var hashFromIndex = 4500;
    var hashToIndex = 5000;
    var context = new AudioContext(1, hashToIndex, 44100);
    var oscillator = context.createOscillator();
    oscillator.type = 'triangle';
    oscillator.frequency.value = 10000;
    var compressor = context.createDynamicsCompressor();
    compressor.threshold.value = -50;
    compressor.knee.value = 40;
    compressor.ratio.value = 12;
    compressor.attack.value = 0;
    compressor.release.value = 0.25;
    oscillator.connect(compressor);
    compressor.connect(context.destination);
    oscillator.start(0);
    var _a = startRenderingAudio(context), renderPromise = _a[0], finishRendering = _a[1];
    // Suppresses the console error message in case when the fingerprint fails before requested
    var fingerprintPromise = suppressUnhandledRejectionWarning(renderPromise.then(function (buffer) { return getHash(buffer.getChannelData(0).subarray(hashFromIndex)); }, function (error) {
        if (error.name === "timeout" /* InnerErrorName.Timeout */ || error.name === "suspended" /* InnerErrorName.Suspended */) {
            return -3 /* SpecialFingerprint.Timeout */;
        }
        throw error;
    }));
    return function () {
        finishRendering();
        return fingerprintPromise;
    };
}
/**
 * Checks if the current browser is known for always suspending audio context
 */
function doesBrowserSuspendAudioContext() {
    // Mobile Safari 11 and older
    return isWebKit() && !isDesktopWebKit() && !isWebKit606OrNewer();
}
/**
 * Checks if the current browser is known for applying anti-fingerprinting measures in all or some critical modes
 */
function doesBrowserPerformAntifingerprinting$1() {
    // Safari 17
    return isWebKit() && isWebKit616OrNewer() && isSafariWebKit();
}
/**
 * Starts rendering the audio context.
 * When the returned function is called, the render process starts finishing.
 */
function startRenderingAudio(context) {
    var renderTryMaxCount = 3;
    var renderRetryDelay = 500;
    var runningMaxAwaitTime = 500;
    var runningSufficientTime = 5000;
    var finalize = function () { return undefined; };
    var resultPromise = new Promise(function (resolve, reject) {
        var isFinalized = false;
        var renderTryCount = 0;
        var startedRunningAt = 0;
        context.oncomplete = function (event) { return resolve(event.renderedBuffer); };
        var startRunningTimeout = function () {
            setTimeout(function () { return reject(makeInnerError("timeout" /* InnerErrorName.Timeout */)); }, Math.min(runningMaxAwaitTime, startedRunningAt + runningSufficientTime - Date.now()));
        };
        var tryRender = function () {
            try {
                var renderingPromise = context.startRendering();
                // `context.startRendering` has two APIs: Promise and callback, we check that it's really a promise just in case
                if (isPromise(renderingPromise)) {
                    // Suppresses all unhandled rejections in case of scheduled redundant retries after successful rendering
                    suppressUnhandledRejectionWarning(renderingPromise);
                }
                switch (context.state) {
                    case 'running':
                        startedRunningAt = Date.now();
                        if (isFinalized) {
                            startRunningTimeout();
                        }
                        break;
                    // Sometimes the audio context doesn't start after calling `startRendering` (in addition to the cases where
                    // audio context doesn't start at all). A known case is starting an audio context when the browser tab is in
                    // background on iPhone. Retries usually help in this case.
                    case 'suspended':
                        // The audio context can reject starting until the tab is in foreground. Long fingerprint duration
                        // in background isn't a problem, therefore the retry attempts don't count in background. It can lead to
                        // a situation when a fingerprint takes very long time and finishes successfully. FYI, the audio context
                        // can be suspended when `document.hidden === false` and start running after a retry.
                        if (!document.hidden) {
                            renderTryCount++;
                        }
                        if (isFinalized && renderTryCount >= renderTryMaxCount) {
                            reject(makeInnerError("suspended" /* InnerErrorName.Suspended */));
                        }
                        else {
                            setTimeout(tryRender, renderRetryDelay);
                        }
                        break;
                }
            }
            catch (error) {
                reject(error);
            }
        };
        tryRender();
        finalize = function () {
            if (!isFinalized) {
                isFinalized = true;
                if (startedRunningAt > 0) {
                    startRunningTimeout();
                }
            }
        };
    });
    return [resultPromise, finalize];
}
function getHash(signal) {
    var hash = 0;
    for (var i = 0; i < signal.length; ++i) {
        hash += Math.abs(signal[i]);
    }
    return hash;
}
function makeInnerError(name) {
    var error = new Error(name);
    error.name = name;
    return error;
}

/**
 * Creates and keeps an invisible iframe while the given function runs.
 * The given function is called when the iframe is loaded and has a body.
 * The iframe allows to measure DOM sizes inside itself.
 *
 * Notice: passing an initial HTML code doesn't work in IE.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function withIframe(action, initialHtml, domPollInterval) {
    var _a, _b, _c;
    if (domPollInterval === void 0) { domPollInterval = 50; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var d, iframe;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_d) {
            switch (_d.label) {
                case 0:
                    d = document;
                    _d.label = 1;
                case 1:
                    if (!!d.body) return [3 /*break*/, 3];
                    return [4 /*yield*/, wait(domPollInterval)];
                case 2:
                    _d.sent();
                    return [3 /*break*/, 1];
                case 3:
                    iframe = d.createElement('iframe');
                    _d.label = 4;
                case 4:
                    _d.trys.push([4, , 10, 11]);
                    return [4 /*yield*/, new Promise(function (_resolve, _reject) {
                            var isComplete = false;
                            var resolve = function () {
                                isComplete = true;
                                _resolve();
                            };
                            var reject = function (error) {
                                isComplete = true;
                                _reject(error);
                            };
                            iframe.onload = resolve;
                            iframe.onerror = reject;
                            var style = iframe.style;
                            style.setProperty('display', 'block', 'important'); // Required for browsers to calculate the layout
                            style.position = 'absolute';
                            style.top = '0';
                            style.left = '0';
                            style.visibility = 'hidden';
                            if (initialHtml && 'srcdoc' in iframe) {
                                iframe.srcdoc = initialHtml;
                            }
                            else {
                                iframe.src = 'about:blank';
                            }
                            d.body.appendChild(iframe);
                            // WebKit in WeChat doesn't fire the iframe's `onload` for some reason.
                            // This code checks for the loading state manually.
                            // See https://github.com/fingerprintjs/fingerprintjs/issues/645
                            var checkReadyState = function () {
                                var _a, _b;
                                // The ready state may never become 'complete' in Firefox despite the 'load' event being fired.
                                // So an infinite setTimeout loop can happen without this check.
                                // See https://github.com/fingerprintjs/fingerprintjs/pull/716#issuecomment-986898796
                                if (isComplete) {
                                    return;
                                }
                                // Make sure iframe.contentWindow and iframe.contentWindow.document are both loaded
                                // The contentWindow.document can miss in JSDOM (https://github.com/jsdom/jsdom).
                                if (((_b = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document) === null || _b === void 0 ? void 0 : _b.readyState) === 'complete') {
                                    resolve();
                                }
                                else {
                                    setTimeout(checkReadyState, 10);
                                }
                            };
                            checkReadyState();
                        })];
                case 5:
                    _d.sent();
                    _d.label = 6;
                case 6:
                    if (!!((_b = (_a = iframe.contentWindow) === null || _a === void 0 ? void 0 : _a.document) === null || _b === void 0 ? void 0 : _b.body)) return [3 /*break*/, 8];
                    return [4 /*yield*/, wait(domPollInterval)];
                case 7:
                    _d.sent();
                    return [3 /*break*/, 6];
                case 8: return [4 /*yield*/, action(iframe, iframe.contentWindow)];
                case 9: return [2 /*return*/, _d.sent()];
                case 10:
                    (_c = iframe.parentNode) === null || _c === void 0 ? void 0 : _c.removeChild(iframe);
                    return [7 /*endfinally*/];
                case 11: return [2 /*return*/];
            }
        });
    });
}
/**
 * Creates a DOM element that matches the given selector.
 * Only single element selector are supported (without operators like space, +, >, etc).
 */
function selectorToElement(selector) {
    var _a = parseSimpleCssSelector(selector), tag = _a[0], attributes = _a[1];
    var element = document.createElement(tag !== null && tag !== void 0 ? tag : 'div');
    for (var _i = 0, _b = Object.keys(attributes); _i < _b.length; _i++) {
        var name_1 = _b[_i];
        var value = attributes[name_1].join(' ');
        // Changing the `style` attribute can cause a CSP error, therefore we change the `style.cssText` property.
        // https://github.com/fingerprintjs/fingerprintjs/issues/733
        if (name_1 === 'style') {
            addStyleString(element.style, value);
        }
        else {
            element.setAttribute(name_1, value);
        }
    }
    return element;
}
/**
 * Adds CSS styles from a string in such a way that doesn't trigger a CSP warning (unsafe-inline or unsafe-eval)
 */
function addStyleString(style, source) {
    // We don't use `style.cssText` because browsers must block it when no `unsafe-eval` CSP is presented: https://csplite.com/csp145/#w3c_note
    // Even though the browsers ignore this standard, we don't use `cssText` just in case.
    for (var _i = 0, _a = source.split(';'); _i < _a.length; _i++) {
        var property = _a[_i];
        var match = /^\s*([\w-]+)\s*:\s*(.+?)(\s*!([\w-]+))?\s*$/.exec(property);
        if (match) {
            var name_2 = match[1], value = match[2], priority = match[4];
            style.setProperty(name_2, value, priority || ''); // The last argument can't be undefined in IE11
        }
    }
}
/**
 * Returns true if the code runs in an iframe, and any parent page's origin doesn't match the current origin
 */
function isAnyParentCrossOrigin() {
    var currentWindow = window;
    for (;;) {
        var parentWindow = currentWindow.parent;
        if (!parentWindow || parentWindow === currentWindow) {
            return false; // The top page is reached
        }
        try {
            if (parentWindow.location.origin !== currentWindow.location.origin) {
                return true;
            }
        }
        catch (error) {
            // The error is thrown when `origin` is accessed on `parentWindow.location` when the parent is cross-origin
            if (error instanceof Error && error.name === 'SecurityError') {
                return true;
            }
            throw error;
        }
        currentWindow = parentWindow;
    }
}

// We use m or w because these two characters take up the maximum width.
// And we use a LLi so that the same matching fonts can get separated.
var testString = 'mmMwWLliI0O&1';
// We test using 48px font size, we may use any size. I guess larger the better.
var textSize = '48px';
// A font will be compared against all the three default fonts.
// And if for any default fonts it doesn't match, then that font is available.
var baseFonts = ['monospace', 'sans-serif', 'serif'];
var fontList = [
    // This is android-specific font from "Roboto" family
    'sans-serif-thin',
    'ARNO PRO',
    'Agency FB',
    'Arabic Typesetting',
    'Arial Unicode MS',
    'AvantGarde Bk BT',
    'BankGothic Md BT',
    'Batang',
    'Bitstream Vera Sans Mono',
    'Calibri',
    'Century',
    'Century Gothic',
    'Clarendon',
    'EUROSTILE',
    'Franklin Gothic',
    'Futura Bk BT',
    'Futura Md BT',
    'GOTHAM',
    'Gill Sans',
    'HELV',
    'Haettenschweiler',
    'Helvetica Neue',
    'Humanst521 BT',
    'Leelawadee',
    'Letter Gothic',
    'Levenim MT',
    'Lucida Bright',
    'Lucida Sans',
    'Menlo',
    'MS Mincho',
    'MS Outlook',
    'MS Reference Specialty',
    'MS UI Gothic',
    'MT Extra',
    'MYRIAD PRO',
    'Marlett',
    'Meiryo UI',
    'Microsoft Uighur',
    'Minion Pro',
    'Monotype Corsiva',
    'PMingLiU',
    'Pristina',
    'SCRIPTINA',
    'Segoe UI Light',
    'Serifa',
    'SimHei',
    'Small Fonts',
    'Staccato222 BT',
    'TRAJAN PRO',
    'Univers CE 55 Medium',
    'Vrinda',
    'ZWAdobeF',
];
// kudos to http://www.lalit.org/lab/javascript-css-font-detect/
function getFonts() {
    var _this = this;
    // Running the script in an iframe makes it not affect the page look and not be affected by the page CSS. See:
    // https://github.com/fingerprintjs/fingerprintjs/issues/592
    // https://github.com/fingerprintjs/fingerprintjs/issues/628
    return withIframe(function (_, _a) {
        var document = _a.document;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
            var holder, spansContainer, defaultWidth, defaultHeight, createSpan, createSpanWithFonts, initializeBaseFontsSpans, initializeFontsSpans, isFontAvailable, baseFontsSpans, fontsSpans, index;
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
                holder = document.body;
                holder.style.fontSize = textSize;
                spansContainer = document.createElement('div');
                spansContainer.style.setProperty('visibility', 'hidden', 'important');
                defaultWidth = {};
                defaultHeight = {};
                createSpan = function (fontFamily) {
                    var span = document.createElement('span');
                    var style = span.style;
                    style.position = 'absolute';
                    style.top = '0';
                    style.left = '0';
                    style.fontFamily = fontFamily;
                    span.textContent = testString;
                    spansContainer.appendChild(span);
                    return span;
                };
                createSpanWithFonts = function (fontToDetect, baseFont) {
                    return createSpan("'".concat(fontToDetect, "',").concat(baseFont));
                };
                initializeBaseFontsSpans = function () {
                    return baseFonts.map(createSpan);
                };
                initializeFontsSpans = function () {
                    // Stores {fontName : [spans for that font]}
                    var spans = {};
                    var _loop_1 = function (font) {
                        spans[font] = baseFonts.map(function (baseFont) { return createSpanWithFonts(font, baseFont); });
                    };
                    for (var _i = 0, fontList_1 = fontList; _i < fontList_1.length; _i++) {
                        var font = fontList_1[_i];
                        _loop_1(font);
                    }
                    return spans;
                };
                isFontAvailable = function (fontSpans) {
                    return baseFonts.some(function (baseFont, baseFontIndex) {
                        return fontSpans[baseFontIndex].offsetWidth !== defaultWidth[baseFont] ||
                            fontSpans[baseFontIndex].offsetHeight !== defaultHeight[baseFont];
                    });
                };
                baseFontsSpans = initializeBaseFontsSpans();
                fontsSpans = initializeFontsSpans();
                // add all the spans to the DOM
                holder.appendChild(spansContainer);
                // get the default width for the three base fonts
                for (index = 0; index < baseFonts.length; index++) {
                    defaultWidth[baseFonts[index]] = baseFontsSpans[index].offsetWidth; // width for the default font
                    defaultHeight[baseFonts[index]] = baseFontsSpans[index].offsetHeight; // height for the default font
                }
                // check available fonts
                return [2 /*return*/, fontList.filter(function (font) { return isFontAvailable(fontsSpans[font]); })];
            });
        });
    });
}

function getPlugins() {
    var rawPlugins = navigator.plugins;
    if (!rawPlugins) {
        return undefined;
    }
    var plugins = [];
    // Safari 10 doesn't support iterating navigator.plugins with for...of
    for (var i = 0; i < rawPlugins.length; ++i) {
        var plugin = rawPlugins[i];
        if (!plugin) {
            continue;
        }
        var mimeTypes = [];
        for (var j = 0; j < plugin.length; ++j) {
            var mimeType = plugin[j];
            mimeTypes.push({
                type: mimeType.type,
                suffixes: mimeType.suffixes,
            });
        }
        plugins.push({
            name: plugin.name,
            description: plugin.description,
            mimeTypes: mimeTypes,
        });
    }
    return plugins;
}

/**
 * @see https://www.browserleaks.com/canvas#how-does-it-work
 *
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * Canvas image is noised in private mode of Safari 17, so image rendering is skipped in Safari 17.
 */
function getCanvasFingerprint() {
    return getUnstableCanvasFingerprint(doesBrowserPerformAntifingerprinting());
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableCanvasFingerprint(skipImages) {
    var _a;
    var winding = false;
    var geometry;
    var text;
    var _b = makeCanvasContext(), canvas = _b[0], context = _b[1];
    if (!isSupported(canvas, context)) {
        geometry = text = "unsupported" /* ImageStatus.Unsupported */;
    }
    else {
        winding = doesSupportWinding(context);
        if (skipImages) {
            geometry = text = "skipped" /* ImageStatus.Skipped */;
        }
        else {
            _a = renderImages(canvas, context), geometry = _a[0], text = _a[1];
        }
    }
    return { winding: winding, geometry: geometry, text: text };
}
function makeCanvasContext() {
    var canvas = document.createElement('canvas');
    canvas.width = 1;
    canvas.height = 1;
    return [canvas, canvas.getContext('2d')];
}
function isSupported(canvas, context) {
    return !!(context && canvas.toDataURL);
}
function doesSupportWinding(context) {
    // https://web.archive.org/web/20170825024655/http://blogs.adobe.com/webplatform/2013/01/30/winding-rules-in-canvas/
    // https://github.com/Modernizr/Modernizr/blob/master/feature-detects/canvas/winding.js
    context.rect(0, 0, 10, 10);
    context.rect(2, 2, 6, 6);
    return !context.isPointInPath(5, 5, 'evenodd');
}
function renderImages(canvas, context) {
    renderTextImage(canvas, context);
    var textImage1 = canvasToString(canvas);
    var textImage2 = canvasToString(canvas); // It's slightly faster to double-encode the text image
    // Some browsers add a noise to the canvas: https://github.com/fingerprintjs/fingerprintjs/issues/791
    // The canvas is excluded from the fingerprint in this case
    if (textImage1 !== textImage2) {
        return ["unstable" /* ImageStatus.Unstable */, "unstable" /* ImageStatus.Unstable */];
    }
    // Text is unstable:
    // https://github.com/fingerprintjs/fingerprintjs/issues/583
    // https://github.com/fingerprintjs/fingerprintjs/issues/103
    // Therefore it's extracted into a separate image.
    renderGeometryImage(canvas, context);
    var geometryImage = canvasToString(canvas);
    return [geometryImage, textImage1];
}
function renderTextImage(canvas, context) {
    // Resizing the canvas cleans it
    canvas.width = 240;
    canvas.height = 60;
    context.textBaseline = 'alphabetic';
    context.fillStyle = '#f60';
    context.fillRect(100, 1, 62, 20);
    context.fillStyle = '#069';
    // It's important to use explicit built-in fonts in order to exclude the affect of font preferences
    // (there is a separate entropy source for them).
    context.font = '11pt "Times New Roman"';
    // The choice of emojis has a gigantic impact on rendering performance (especially in FF).
    // Some newer emojis cause it to slow down 50-200 times.
    // There must be no text to the right of the emoji, see https://github.com/fingerprintjs/fingerprintjs/issues/574
    // A bare emoji shouldn't be used because the canvas will change depending on the script encoding:
    // https://github.com/fingerprintjs/fingerprintjs/issues/66
    // Escape sequence shouldn't be used too because Terser will turn it into a bare unicode.
    var printedText = "Cwm fjordbank gly ".concat(String.fromCharCode(55357, 56835) /* 😃 */);
    context.fillText(printedText, 2, 15);
    context.fillStyle = 'rgba(102, 204, 0, 0.2)';
    context.font = '18pt Arial';
    context.fillText(printedText, 4, 45);
}
function renderGeometryImage(canvas, context) {
    // Resizing the canvas cleans it
    canvas.width = 122;
    canvas.height = 110;
    // Canvas blending
    // https://web.archive.org/web/20170826194121/http://blogs.adobe.com/webplatform/2013/01/28/blending-features-in-canvas/
    // http://jsfiddle.net/NDYV8/16/
    context.globalCompositeOperation = 'multiply';
    for (var _i = 0, _a = [
        ['#f2f', 40, 40],
        ['#2ff', 80, 40],
        ['#ff2', 60, 80],
    ]; _i < _a.length; _i++) {
        var _b = _a[_i], color = _b[0], x = _b[1], y = _b[2];
        context.fillStyle = color;
        context.beginPath();
        context.arc(x, y, 40, 0, Math.PI * 2, true);
        context.closePath();
        context.fill();
    }
    // Canvas winding
    // https://web.archive.org/web/20130913061632/http://blogs.adobe.com/webplatform/2013/01/30/winding-rules-in-canvas/
    // http://jsfiddle.net/NDYV8/19/
    context.fillStyle = '#f9c';
    context.arc(60, 60, 60, 0, Math.PI * 2, true);
    context.arc(60, 60, 20, 0, Math.PI * 2, true);
    context.fill('evenodd');
}
function canvasToString(canvas) {
    return canvas.toDataURL();
}
/**
 * Checks if the current browser is known for applying anti-fingerprinting measures in all or some critical modes
 */
function doesBrowserPerformAntifingerprinting() {
    // Safari 17
    return isWebKit() && isWebKit616OrNewer() && isSafariWebKit();
}

/**
 * This is a crude and primitive touch screen detection. It's not possible to currently reliably detect the availability
 * of a touch screen with a JS, without actually subscribing to a touch event.
 *
 * @see http://www.stucox.com/blog/you-cant-detect-a-touchscreen/
 * @see https://github.com/Modernizr/Modernizr/issues/548
 */
function getTouchSupport() {
    var n = navigator;
    var maxTouchPoints = 0;
    var touchEvent;
    if (n.maxTouchPoints !== undefined) {
        maxTouchPoints = toInt(n.maxTouchPoints);
    }
    else if (n.msMaxTouchPoints !== undefined) {
        maxTouchPoints = n.msMaxTouchPoints;
    }
    try {
        document.createEvent('TouchEvent');
        touchEvent = true;
    }
    catch (_a) {
        touchEvent = false;
    }
    var touchStart = 'ontouchstart' in window;
    return {
        maxTouchPoints: maxTouchPoints,
        touchEvent: touchEvent,
        touchStart: touchStart,
    };
}

function getOsCpu() {
    return navigator.oscpu;
}

function getLanguages() {
    var n = navigator;
    var result = [];
    var language = n.language || n.userLanguage || n.browserLanguage || n.systemLanguage;
    if (language !== undefined) {
        result.push([language]);
    }
    if (Array.isArray(n.languages)) {
        // Starting from Chromium 86, there is only a single value in `navigator.language` in Incognito mode:
        // the value of `navigator.language`. Therefore the value is ignored in this browser.
        if (!(isChromium() && isChromium86OrNewer())) {
            result.push(n.languages);
        }
    }
    else if (typeof n.languages === 'string') {
        var languages = n.languages;
        if (languages) {
            result.push(languages.split(','));
        }
    }
    return result;
}

function getColorDepth() {
    return window.screen.colorDepth;
}

function getDeviceMemory() {
    // `navigator.deviceMemory` is a string containing a number in some unidentified cases
    return replaceNaN(toFloat(navigator.deviceMemory), undefined);
}

/**
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 * The window resolution is always the document size in private mode of Safari 17,
 * so the window resolution is not used in Safari 17.
 */
function getScreenResolution() {
    if (isWebKit() && isWebKit616OrNewer() && isSafariWebKit()) {
        return undefined;
    }
    return getUnstableScreenResolution();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableScreenResolution() {
    var s = screen;
    // Some browsers return screen resolution as strings, e.g. "1200", instead of a number, e.g. 1200.
    // I suspect it's done by certain plugins that randomize browser properties to prevent fingerprinting.
    // Some browsers even return  screen resolution as not numbers.
    var parseDimension = function (value) { return replaceNaN(toInt(value), null); };
    var dimensions = [parseDimension(s.width), parseDimension(s.height)];
    dimensions.sort().reverse();
    return dimensions;
}

var screenFrameCheckInterval = 2500;
var roundingPrecision = 10;
// The type is readonly to protect from unwanted mutations
var screenFrameBackup;
var screenFrameSizeTimeoutId;
/**
 * Starts watching the screen frame size. When a non-zero size appears, the size is saved and the watch is stopped.
 * Later, when `getScreenFrame` runs, it will return the saved non-zero size if the current size is null.
 *
 * This trick is required to mitigate the fact that the screen frame turns null in some cases.
 * See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
 */
function watchScreenFrame() {
    if (screenFrameSizeTimeoutId !== undefined) {
        return;
    }
    var checkScreenFrame = function () {
        var frameSize = getCurrentScreenFrame();
        if (isFrameSizeNull(frameSize)) {
            screenFrameSizeTimeoutId = setTimeout(checkScreenFrame, screenFrameCheckInterval);
        }
        else {
            screenFrameBackup = frameSize;
            screenFrameSizeTimeoutId = undefined;
        }
    };
    checkScreenFrame();
}
/**
 * A version of the entropy source without stabilization.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getUnstableScreenFrame() {
    var _this = this;
    watchScreenFrame();
    return function () { return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
        var frameSize;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0:
                    frameSize = getCurrentScreenFrame();
                    if (!isFrameSizeNull(frameSize)) return [3 /*break*/, 2];
                    if (screenFrameBackup) {
                        return [2 /*return*/, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__spreadArray)([], screenFrameBackup, true)];
                    }
                    if (!getFullscreenElement()) return [3 /*break*/, 2];
                    // Some browsers set the screen frame to zero when programmatic fullscreen is on.
                    // There is a chance of getting a non-zero frame after exiting the fullscreen.
                    // See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
                    return [4 /*yield*/, exitFullscreen()];
                case 1:
                    // Some browsers set the screen frame to zero when programmatic fullscreen is on.
                    // There is a chance of getting a non-zero frame after exiting the fullscreen.
                    // See more on this at https://github.com/fingerprintjs/fingerprintjs/issues/568
                    _a.sent();
                    frameSize = getCurrentScreenFrame();
                    _a.label = 2;
                case 2:
                    if (!isFrameSizeNull(frameSize)) {
                        screenFrameBackup = frameSize;
                    }
                    return [2 /*return*/, frameSize];
            }
        });
    }); };
}
/**
 * A version of the entropy source with stabilization to make it suitable for static fingerprinting.
 *
 * Sometimes the available screen resolution changes a bit, e.g. 1900x1440 → 1900x1439. A possible reason: macOS Dock
 * shrinks to fit more icons when there is too little space. The rounding is used to mitigate the difference.
 *
 * The frame width is always 0 in private mode of Safari 17, so the frame is not used in Safari 17.
 */
function getScreenFrame() {
    var _this = this;
    if (isWebKit() && isWebKit616OrNewer() && isSafariWebKit()) {
        return function () { return Promise.resolve(undefined); };
    }
    var screenFrameGetter = getUnstableScreenFrame();
    return function () { return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(_this, void 0, void 0, function () {
        var frameSize, processSize;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, screenFrameGetter()];
                case 1:
                    frameSize = _a.sent();
                    processSize = function (sideSize) { return (sideSize === null ? null : round(sideSize, roundingPrecision)); };
                    // It might look like I don't know about `for` and `map`.
                    // In fact, such code is used to avoid TypeScript issues without using `as`.
                    return [2 /*return*/, [processSize(frameSize[0]), processSize(frameSize[1]), processSize(frameSize[2]), processSize(frameSize[3])]];
            }
        });
    }); };
}
function getCurrentScreenFrame() {
    var s = screen;
    // Some browsers return screen resolution as strings, e.g. "1200", instead of a number, e.g. 1200.
    // I suspect it's done by certain plugins that randomize browser properties to prevent fingerprinting.
    //
    // Some browsers (IE, Edge ≤18) don't provide `screen.availLeft` and `screen.availTop`. The property values are
    // replaced with 0 in such cases to not lose the entropy from `screen.availWidth` and `screen.availHeight`.
    return [
        replaceNaN(toFloat(s.availTop), null),
        replaceNaN(toFloat(s.width) - toFloat(s.availWidth) - replaceNaN(toFloat(s.availLeft), 0), null),
        replaceNaN(toFloat(s.height) - toFloat(s.availHeight) - replaceNaN(toFloat(s.availTop), 0), null),
        replaceNaN(toFloat(s.availLeft), null),
    ];
}
function isFrameSizeNull(frameSize) {
    for (var i = 0; i < 4; ++i) {
        if (frameSize[i]) {
            return false;
        }
    }
    return true;
}

function getHardwareConcurrency() {
    // sometimes hardware concurrency is a string
    return replaceNaN(toInt(navigator.hardwareConcurrency), undefined);
}

function getTimezone() {
    var _a;
    var DateTimeFormat = (_a = window.Intl) === null || _a === void 0 ? void 0 : _a.DateTimeFormat;
    if (DateTimeFormat) {
        var timezone = new DateTimeFormat().resolvedOptions().timeZone;
        if (timezone) {
            return timezone;
        }
    }
    // For browsers that don't support timezone names
    // The minus is intentional because the JS offset is opposite to the real offset
    var offset = -getTimezoneOffset();
    return "UTC".concat(offset >= 0 ? '+' : '').concat(offset);
}
function getTimezoneOffset() {
    var currentYear = new Date().getFullYear();
    // The timezone offset may change over time due to daylight saving time (DST) shifts.
    // The non-DST timezone offset is used as the result timezone offset.
    // Since the DST season differs in the northern and the southern hemispheres,
    // both January and July timezones offsets are considered.
    return Math.max(
    // `getTimezoneOffset` returns a number as a string in some unidentified cases
    toFloat(new Date(currentYear, 0, 1).getTimezoneOffset()), toFloat(new Date(currentYear, 6, 1).getTimezoneOffset()));
}

function getSessionStorage() {
    try {
        return !!window.sessionStorage;
    }
    catch (error) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

// https://bugzilla.mozilla.org/show_bug.cgi?id=781447
function getLocalStorage() {
    try {
        return !!window.localStorage;
    }
    catch (e) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

function getIndexedDB() {
    // IE and Edge don't allow accessing indexedDB in private mode, therefore IE and Edge will have different
    // visitor identifier in normal and private modes.
    if (isTrident() || isEdgeHTML()) {
        return undefined;
    }
    try {
        return !!window.indexedDB;
    }
    catch (e) {
        /* SecurityError when referencing it means it exists */
        return true;
    }
}

function getOpenDatabase() {
    return !!window.openDatabase;
}

function getCpuClass() {
    return navigator.cpuClass;
}

function getPlatform() {
    // Android Chrome 86 and 87 and Android Firefox 80 and 84 don't mock the platform value when desktop mode is requested
    var platform = navigator.platform;
    // iOS mocks the platform value when desktop version is requested: https://github.com/fingerprintjs/fingerprintjs/issues/514
    // iPad uses desktop mode by default since iOS 13
    // The value is 'MacIntel' on M1 Macs
    // The value is 'iPhone' on iPod Touch
    if (platform === 'MacIntel') {
        if (isWebKit() && !isDesktopWebKit()) {
            return isIPad() ? 'iPad' : 'iPhone';
        }
    }
    return platform;
}

function getVendor() {
    return navigator.vendor || '';
}

/**
 * Checks for browser-specific (not engine specific) global variables to tell browsers with the same engine apart.
 * Only somewhat popular browsers are considered.
 */
function getVendorFlavors() {
    var flavors = [];
    for (var _i = 0, _a = [
        // Blink and some browsers on iOS
        'chrome',
        // Safari on macOS
        'safari',
        // Chrome on iOS (checked in 85 on 13 and 87 on 14)
        '__crWeb',
        '__gCrWeb',
        // Yandex Browser on iOS, macOS and Android (checked in 21.2 on iOS 14, macOS and Android)
        'yandex',
        // Yandex Browser on iOS (checked in 21.2 on 14)
        '__yb',
        '__ybro',
        // Firefox on iOS (checked in 32 on 14)
        '__firefox__',
        // Edge on iOS (checked in 46 on 14)
        '__edgeTrackingPreventionStatistics',
        'webkit',
        // Opera Touch on iOS (checked in 2.6 on 14)
        'oprt',
        // Samsung Internet on Android (checked in 11.1)
        'samsungAr',
        // UC Browser on Android (checked in 12.10 and 13.0)
        'ucweb',
        'UCShellJava',
        // Puffin on Android (checked in 9.0)
        'puffinDevice',
        // UC on iOS and Opera on Android have no specific global variables
        // Edge for Android isn't checked
    ]; _i < _a.length; _i++) {
        var key = _a[_i];
        var value = window[key];
        if (value && typeof value === 'object') {
            flavors.push(key);
        }
    }
    return flavors.sort();
}

/**
 * navigator.cookieEnabled cannot detect custom or nuanced cookie blocking configurations. For example, when blocking
 * cookies via the Advanced Privacy Settings in IE9, it always returns true. And there have been issues in the past with
 * site-specific exceptions. Don't rely on it.
 *
 * @see https://github.com/Modernizr/Modernizr/blob/master/feature-detects/cookies.js Taken from here
 */
function areCookiesEnabled() {
    var d = document;
    // Taken from here: https://github.com/Modernizr/Modernizr/blob/master/feature-detects/cookies.js
    // navigator.cookieEnabled cannot detect custom or nuanced cookie blocking configurations. For example, when blocking
    // cookies via the Advanced Privacy Settings in IE9, it always returns true. And there have been issues in the past
    // with site-specific exceptions. Don't rely on it.
    // try..catch because some in situations `document.cookie` is exposed but throws a
    // SecurityError if you try to access it; e.g. documents created from data URIs
    // or in sandboxed iframes (depending on flags/context)
    try {
        // Create cookie
        d.cookie = 'cookietest=1; SameSite=Strict;';
        var result = d.cookie.indexOf('cookietest=') !== -1;
        // Delete cookie
        d.cookie = 'cookietest=1; SameSite=Strict; expires=Thu, 01-Jan-1970 00:00:01 GMT';
        return result;
    }
    catch (e) {
        return false;
    }
}

/**
 * Only single element selector are supported (no operators like space, +, >, etc).
 * `embed` and `position: fixed;` will be considered as blocked anyway because it always has no offsetParent.
 * Avoid `iframe` and anything with `[src=]` because they produce excess HTTP requests.
 *
 * The "inappropriate" selectors are obfuscated. See https://github.com/fingerprintjs/fingerprintjs/issues/734.
 * A function is used instead of a plain object to help tree-shaking.
 *
 * The function code is generated automatically. See docs/content_blockers.md to learn how to make the list.
 */
function getFilters() {
    var fromB64 = atob; // Just for better minification
    return {
        abpIndo: [
            '#Iklan-Melayang',
            '#Kolom-Iklan-728',
            '#SidebarIklan-wrapper',
            '[title="ALIENBOLA" i]',
            fromB64('I0JveC1CYW5uZXItYWRz'),
        ],
        abpvn: ['.quangcao', '#mobileCatfish', fromB64('LmNsb3NlLWFkcw=='), '[id^="bn_bottom_fixed_"]', '#pmadv'],
        adBlockFinland: [
            '.mainostila',
            fromB64('LnNwb25zb3JpdA=='),
            '.ylamainos',
            fromB64('YVtocmVmKj0iL2NsaWNrdGhyZ2guYXNwPyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hcHAucmVhZHBlYWsuY29tL2FkcyJd'),
        ],
        adBlockPersian: [
            '#navbar_notice_50',
            '.kadr',
            'TABLE[width="140px"]',
            '#divAgahi',
            fromB64('YVtocmVmXj0iaHR0cDovL2cxLnYuZndtcm0ubmV0L2FkLyJd'),
        ],
        adBlockWarningRemoval: [
            '#adblock-honeypot',
            '.adblocker-root',
            '.wp_adblock_detect',
            fromB64('LmhlYWRlci1ibG9ja2VkLWFk'),
            fromB64('I2FkX2Jsb2NrZXI='),
        ],
        adGuardAnnoyances: [
            '.hs-sosyal',
            '#cookieconsentdiv',
            'div[class^="app_gdpr"]',
            '.as-oil',
            '[data-cypress="soft-push-notification-modal"]',
        ],
        adGuardBase: [
            '.BetterJsPopOverlay',
            fromB64('I2FkXzMwMFgyNTA='),
            fromB64('I2Jhbm5lcmZsb2F0MjI='),
            fromB64('I2NhbXBhaWduLWJhbm5lcg=='),
            fromB64('I0FkLUNvbnRlbnQ='),
        ],
        adGuardChinese: [
            fromB64('LlppX2FkX2FfSA=='),
            fromB64('YVtocmVmKj0iLmh0aGJldDM0LmNvbSJd'),
            '#widget-quan',
            fromB64('YVtocmVmKj0iLzg0OTkyMDIwLnh5eiJd'),
            fromB64('YVtocmVmKj0iLjE5NTZobC5jb20vIl0='),
        ],
        adGuardFrench: [
            '#pavePub',
            fromB64('LmFkLWRlc2t0b3AtcmVjdGFuZ2xl'),
            '.mobile_adhesion',
            '.widgetadv',
            fromB64('LmFkc19iYW4='),
        ],
        adGuardGerman: ['aside[data-portal-id="leaderboard"]'],
        adGuardJapanese: [
            '#kauli_yad_1',
            fromB64('YVtocmVmXj0iaHR0cDovL2FkMi50cmFmZmljZ2F0ZS5uZXQvIl0='),
            fromB64('Ll9wb3BJbl9pbmZpbml0ZV9hZA=='),
            fromB64('LmFkZ29vZ2xl'),
            fromB64('Ll9faXNib29zdFJldHVybkFk'),
        ],
        adGuardMobile: [
            fromB64('YW1wLWF1dG8tYWRz'),
            fromB64('LmFtcF9hZA=='),
            'amp-embed[type="24smi"]',
            '#mgid_iframe1',
            fromB64('I2FkX2ludmlld19hcmVh'),
        ],
        adGuardRussian: [
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZC5sZXRtZWFkcy5jb20vIl0='),
            fromB64('LnJlY2xhbWE='),
            'div[id^="smi2adblock"]',
            fromB64('ZGl2W2lkXj0iQWRGb3hfYmFubmVyXyJd'),
            '#psyduckpockeball',
        ],
        adGuardSocial: [
            fromB64('YVtocmVmXj0iLy93d3cuc3R1bWJsZXVwb24uY29tL3N1Ym1pdD91cmw9Il0='),
            fromB64('YVtocmVmXj0iLy90ZWxlZ3JhbS5tZS9zaGFyZS91cmw/Il0='),
            '.etsy-tweet',
            '#inlineShare',
            '.popup-social',
        ],
        adGuardSpanishPortuguese: ['#barraPublicidade', '#Publicidade', '#publiEspecial', '#queTooltip', '.cnt-publi'],
        adGuardTrackingProtection: [
            '#qoo-counter',
            fromB64('YVtocmVmXj0iaHR0cDovL2NsaWNrLmhvdGxvZy5ydS8iXQ=='),
            fromB64('YVtocmVmXj0iaHR0cDovL2hpdGNvdW50ZXIucnUvdG9wL3N0YXQucGhwIl0='),
            fromB64('YVtocmVmXj0iaHR0cDovL3RvcC5tYWlsLnJ1L2p1bXAiXQ=='),
            '#top100counter',
        ],
        adGuardTurkish: [
            '#backkapat',
            fromB64('I3Jla2xhbWk='),
            fromB64('YVtocmVmXj0iaHR0cDovL2Fkc2Vydi5vbnRlay5jb20udHIvIl0='),
            fromB64('YVtocmVmXj0iaHR0cDovL2l6bGVuemkuY29tL2NhbXBhaWduLyJd'),
            fromB64('YVtocmVmXj0iaHR0cDovL3d3dy5pbnN0YWxsYWRzLm5ldC8iXQ=='),
        ],
        bulgarian: [fromB64('dGQjZnJlZW5ldF90YWJsZV9hZHM='), '#ea_intext_div', '.lapni-pop-over', '#xenium_hot_offers'],
        easyList: [
            '.yb-floorad',
            fromB64('LndpZGdldF9wb19hZHNfd2lkZ2V0'),
            fromB64('LnRyYWZmaWNqdW5reS1hZA=='),
            '.textad_headline',
            fromB64('LnNwb25zb3JlZC10ZXh0LWxpbmtz'),
        ],
        easyListChina: [
            fromB64('LmFwcGd1aWRlLXdyYXBbb25jbGljayo9ImJjZWJvcy5jb20iXQ=='),
            fromB64('LmZyb250cGFnZUFkdk0='),
            '#taotaole',
            '#aafoot.top_box',
            '.cfa_popup',
        ],
        easyListCookie: [
            '.ezmob-footer',
            '.cc-CookieWarning',
            '[data-cookie-number]',
            fromB64('LmF3LWNvb2tpZS1iYW5uZXI='),
            '.sygnal24-gdpr-modal-wrap',
        ],
        easyListCzechSlovak: [
            '#onlajny-stickers',
            fromB64('I3Jla2xhbW5pLWJveA=='),
            fromB64('LnJla2xhbWEtbWVnYWJvYXJk'),
            '.sklik',
            fromB64('W2lkXj0ic2tsaWtSZWtsYW1hIl0='),
        ],
        easyListDutch: [
            fromB64('I2FkdmVydGVudGll'),
            fromB64('I3ZpcEFkbWFya3RCYW5uZXJCbG9jaw=='),
            '.adstekst',
            fromB64('YVtocmVmXj0iaHR0cHM6Ly94bHR1YmUubmwvY2xpY2svIl0='),
            '#semilo-lrectangle',
        ],
        easyListGermany: [
            '#SSpotIMPopSlider',
            fromB64('LnNwb25zb3JsaW5rZ3J1ZW4='),
            fromB64('I3dlcmJ1bmdza3k='),
            fromB64('I3Jla2xhbWUtcmVjaHRzLW1pdHRl'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9iZDc0Mi5jb20vIl0='),
        ],
        easyListItaly: [
            fromB64('LmJveF9hZHZfYW5udW5jaQ=='),
            '.sb-box-pubbliredazionale',
            fromB64('YVtocmVmXj0iaHR0cDovL2FmZmlsaWF6aW9uaWFkcy5zbmFpLml0LyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZHNlcnZlci5odG1sLml0LyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9hZmZpbGlhemlvbmlhZHMuc25haS5pdC8iXQ=='),
        ],
        easyListLithuania: [
            fromB64('LnJla2xhbW9zX3RhcnBhcw=='),
            fromB64('LnJla2xhbW9zX251b3JvZG9z'),
            fromB64('aW1nW2FsdD0iUmVrbGFtaW5pcyBza3lkZWxpcyJd'),
            fromB64('aW1nW2FsdD0iRGVkaWt1b3RpLmx0IHNlcnZlcmlhaSJd'),
            fromB64('aW1nW2FsdD0iSG9zdGluZ2FzIFNlcnZlcmlhaS5sdCJd'),
        ],
        estonian: [fromB64('QVtocmVmKj0iaHR0cDovL3BheTRyZXN1bHRzMjQuZXUiXQ==')],
        fanboyAnnoyances: ['#ac-lre-player', '.navigate-to-top', '#subscribe_popup', '.newsletter_holder', '#back-top'],
        fanboyAntiFacebook: ['.util-bar-module-firefly-visible'],
        fanboyEnhancedTrackers: [
            '.open.pushModal',
            '#issuem-leaky-paywall-articles-zero-remaining-nag',
            '#sovrn_container',
            'div[class$="-hide"][zoompage-fontsize][style="display: block;"]',
            '.BlockNag__Card',
        ],
        fanboySocial: ['#FollowUs', '#meteored_share', '#social_follow', '.article-sharer', '.community__social-desc'],
        frellwitSwedish: [
            fromB64('YVtocmVmKj0iY2FzaW5vcHJvLnNlIl1bdGFyZ2V0PSJfYmxhbmsiXQ=='),
            fromB64('YVtocmVmKj0iZG9rdG9yLXNlLm9uZWxpbmsubWUiXQ=='),
            'article.category-samarbete',
            fromB64('ZGl2LmhvbGlkQWRz'),
            'ul.adsmodern',
        ],
        greekAdBlock: [
            fromB64('QVtocmVmKj0iYWRtYW4ub3RlbmV0LmdyL2NsaWNrPyJd'),
            fromB64('QVtocmVmKj0iaHR0cDovL2F4aWFiYW5uZXJzLmV4b2R1cy5nci8iXQ=='),
            fromB64('QVtocmVmKj0iaHR0cDovL2ludGVyYWN0aXZlLmZvcnRobmV0LmdyL2NsaWNrPyJd'),
            'DIV.agores300',
            'TABLE.advright',
        ],
        hungarian: [
            '#cemp_doboz',
            '.optimonk-iframe-container',
            fromB64('LmFkX19tYWlu'),
            fromB64('W2NsYXNzKj0iR29vZ2xlQWRzIl0='),
            '#hirdetesek_box',
        ],
        iDontCareAboutCookies: [
            '.alert-info[data-block-track*="CookieNotice"]',
            '.ModuleTemplateCookieIndicator',
            '.o--cookies--container',
            '#cookies-policy-sticky',
            '#stickyCookieBar',
        ],
        icelandicAbp: [fromB64('QVtocmVmXj0iL2ZyYW1ld29yay9yZXNvdXJjZXMvZm9ybXMvYWRzLmFzcHgiXQ==')],
        latvian: [
            fromB64('YVtocmVmPSJodHRwOi8vd3d3LnNhbGlkemluaS5sdi8iXVtzdHlsZT0iZGlzcGxheTogYmxvY2s7IHdpZHRoOiAxMjBweDsgaGVpZ2h0O' +
                'iA0MHB4OyBvdmVyZmxvdzogaGlkZGVuOyBwb3NpdGlvbjogcmVsYXRpdmU7Il0='),
            fromB64('YVtocmVmPSJodHRwOi8vd3d3LnNhbGlkemluaS5sdi8iXVtzdHlsZT0iZGlzcGxheTogYmxvY2s7IHdpZHRoOiA4OHB4OyBoZWlnaHQ6I' +
                'DMxcHg7IG92ZXJmbG93OiBoaWRkZW47IHBvc2l0aW9uOiByZWxhdGl2ZTsiXQ=='),
        ],
        listKr: [
            fromB64('YVtocmVmKj0iLy9hZC5wbGFuYnBsdXMuY28ua3IvIl0='),
            fromB64('I2xpdmVyZUFkV3JhcHBlcg=='),
            fromB64('YVtocmVmKj0iLy9hZHYuaW1hZHJlcC5jby5rci8iXQ=='),
            fromB64('aW5zLmZhc3R2aWV3LWFk'),
            '.revenue_unit_item.dable',
        ],
        listeAr: [
            fromB64('LmdlbWluaUxCMUFk'),
            '.right-and-left-sponsers',
            fromB64('YVtocmVmKj0iLmFmbGFtLmluZm8iXQ=='),
            fromB64('YVtocmVmKj0iYm9vcmFxLm9yZyJd'),
            fromB64('YVtocmVmKj0iZHViaXp6bGUuY29tL2FyLz91dG1fc291cmNlPSJd'),
        ],
        listeFr: [
            fromB64('YVtocmVmXj0iaHR0cDovL3Byb21vLnZhZG9yLmNvbS8iXQ=='),
            fromB64('I2FkY29udGFpbmVyX3JlY2hlcmNoZQ=='),
            fromB64('YVtocmVmKj0id2Vib3JhbWEuZnIvZmNnaS1iaW4vIl0='),
            '.site-pub-interstitiel',
            'div[id^="crt-"][data-criteo-id]',
        ],
        officialPolish: [
            '#ceneo-placeholder-ceneo-12',
            fromB64('W2hyZWZePSJodHRwczovL2FmZi5zZW5kaHViLnBsLyJd'),
            fromB64('YVtocmVmXj0iaHR0cDovL2Fkdm1hbmFnZXIudGVjaGZ1bi5wbC9yZWRpcmVjdC8iXQ=='),
            fromB64('YVtocmVmXj0iaHR0cDovL3d3dy50cml6ZXIucGwvP3V0bV9zb3VyY2UiXQ=='),
            fromB64('ZGl2I3NrYXBpZWNfYWQ='),
        ],
        ro: [
            fromB64('YVtocmVmXj0iLy9hZmZ0cmsuYWx0ZXgucm8vQ291bnRlci9DbGljayJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9ibGFja2ZyaWRheXNhbGVzLnJvL3Ryay9zaG9wLyJd'),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9ldmVudC4ycGVyZm9ybWFudC5jb20vZXZlbnRzL2NsaWNrIl0='),
            fromB64('YVtocmVmXj0iaHR0cHM6Ly9sLnByb2ZpdHNoYXJlLnJvLyJd'),
            'a[href^="/url/"]',
        ],
        ruAd: [
            fromB64('YVtocmVmKj0iLy9mZWJyYXJlLnJ1LyJd'),
            fromB64('YVtocmVmKj0iLy91dGltZy5ydS8iXQ=='),
            fromB64('YVtocmVmKj0iOi8vY2hpa2lkaWtpLnJ1Il0='),
            '#pgeldiz',
            '.yandex-rtb-block',
        ],
        thaiAds: [
            'a[href*=macau-uta-popup]',
            fromB64('I2Fkcy1nb29nbGUtbWlkZGxlX3JlY3RhbmdsZS1ncm91cA=='),
            fromB64('LmFkczMwMHM='),
            '.bumq',
            '.img-kosana',
        ],
        webAnnoyancesUltralist: [
            '#mod-social-share-2',
            '#social-tools',
            fromB64('LmN0cGwtZnVsbGJhbm5lcg=='),
            '.zergnet-recommend',
            '.yt.btn-link.btn-md.btn',
        ],
    };
}
/**
 * The order of the returned array means nothing (it's always sorted alphabetically).
 *
 * Notice that the source is slightly unstable.
 * Safari provides a 2-taps way to disable all content blockers on a page temporarily.
 * Also content blockers can be disabled permanently for a domain, but it requires 4 taps.
 * So empty array shouldn't be treated as "no blockers", it should be treated as "no signal".
 * If you are a website owner, don't make your visitors want to disable content blockers.
 */
function getDomBlockers(_a) {
    var _b = _a === void 0 ? {} : _a, debug = _b.debug;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var filters, filterNames, allSelectors, blockedSelectors, activeBlockers;
        var _c;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_d) {
            switch (_d.label) {
                case 0:
                    if (!isApplicable()) {
                        return [2 /*return*/, undefined];
                    }
                    filters = getFilters();
                    filterNames = Object.keys(filters);
                    allSelectors = (_c = []).concat.apply(_c, filterNames.map(function (filterName) { return filters[filterName]; }));
                    return [4 /*yield*/, getBlockedSelectors(allSelectors)];
                case 1:
                    blockedSelectors = _d.sent();
                    if (debug) {
                        printDebug(filters, blockedSelectors);
                    }
                    activeBlockers = filterNames.filter(function (filterName) {
                        var selectors = filters[filterName];
                        var blockedCount = countTruthy(selectors.map(function (selector) { return blockedSelectors[selector]; }));
                        return blockedCount > selectors.length * 0.6;
                    });
                    activeBlockers.sort();
                    return [2 /*return*/, activeBlockers];
            }
        });
    });
}
function isApplicable() {
    // Safari (desktop and mobile) and all Android browsers keep content blockers in both regular and private mode
    return isWebKit() || isAndroid();
}
function getBlockedSelectors(selectors) {
    var _a;
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var d, root, elements, blockedSelectors, i, element, holder, i;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
            switch (_b.label) {
                case 0:
                    d = document;
                    root = d.createElement('div');
                    elements = new Array(selectors.length);
                    blockedSelectors = {} // Set() isn't used just in case somebody need older browser support
                    ;
                    forceShow(root);
                    // First create all elements that can be blocked. If the DOM steps below are done in a single cycle,
                    // browser will alternate tree modification and layout reading, that is very slow.
                    for (i = 0; i < selectors.length; ++i) {
                        element = selectorToElement(selectors[i]);
                        if (element.tagName === 'DIALOG') {
                            element.show();
                        }
                        holder = d.createElement('div') // Protects from unwanted effects of `+` and `~` selectors of filters
                        ;
                        forceShow(holder);
                        holder.appendChild(element);
                        root.appendChild(holder);
                        elements[i] = element;
                    }
                    _b.label = 1;
                case 1:
                    if (!!d.body) return [3 /*break*/, 3];
                    return [4 /*yield*/, wait(50)];
                case 2:
                    _b.sent();
                    return [3 /*break*/, 1];
                case 3:
                    d.body.appendChild(root);
                    try {
                        // Then check which of the elements are blocked
                        for (i = 0; i < selectors.length; ++i) {
                            if (!elements[i].offsetParent) {
                                blockedSelectors[selectors[i]] = true;
                            }
                        }
                    }
                    finally {
                        // Then remove the elements
                        (_a = root.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(root);
                    }
                    return [2 /*return*/, blockedSelectors];
            }
        });
    });
}
function forceShow(element) {
    element.style.setProperty('visibility', 'hidden', 'important');
    element.style.setProperty('display', 'block', 'important');
}
function printDebug(filters, blockedSelectors) {
    var message = 'DOM blockers debug:\n```';
    for (var _i = 0, _a = Object.keys(filters); _i < _a.length; _i++) {
        var filterName = _a[_i];
        message += "\n".concat(filterName, ":");
        for (var _b = 0, _c = filters[filterName]; _b < _c.length; _b++) {
            var selector = _c[_b];
            message += "\n  ".concat(blockedSelectors[selector] ? '🚫' : '➡️', " ").concat(selector);
        }
    }
    // console.log is ok here because it's under a debug clause
    // eslint-disable-next-line no-console
    console.log("".concat(message, "\n```"));
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/color-gamut
 */
function getColorGamut() {
    // rec2020 includes p3 and p3 includes srgb
    for (var _i = 0, _a = ['rec2020', 'p3', 'srgb']; _i < _a.length; _i++) {
        var gamut = _a[_i];
        if (matchMedia("(color-gamut: ".concat(gamut, ")")).matches) {
            return gamut;
        }
    }
    return undefined;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/inverted-colors
 */
function areColorsInverted() {
    if (doesMatch$5('inverted')) {
        return true;
    }
    if (doesMatch$5('none')) {
        return false;
    }
    return undefined;
}
function doesMatch$5(value) {
    return matchMedia("(inverted-colors: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/forced-colors
 */
function areColorsForced() {
    if (doesMatch$4('active')) {
        return true;
    }
    if (doesMatch$4('none')) {
        return false;
    }
    return undefined;
}
function doesMatch$4(value) {
    return matchMedia("(forced-colors: ".concat(value, ")")).matches;
}

var maxValueToCheck = 100;
/**
 * If the display is monochrome (e.g. black&white), the value will be ≥0 and will mean the number of bits per pixel.
 * If the display is not monochrome, the returned value will be 0.
 * If the browser doesn't support this feature, the returned value will be undefined.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/monochrome
 */
function getMonochromeDepth() {
    if (!matchMedia('(min-monochrome: 0)').matches) {
        // The media feature isn't supported by the browser
        return undefined;
    }
    // A variation of binary search algorithm can be used here.
    // But since expected values are very small (≤10), there is no sense in adding the complexity.
    for (var i = 0; i <= maxValueToCheck; ++i) {
        if (matchMedia("(max-monochrome: ".concat(i, ")")).matches) {
            return i;
        }
    }
    throw new Error('Too high value');
}

/**
 * @see https://www.w3.org/TR/mediaqueries-5/#prefers-contrast
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-contrast
 */
function getContrastPreference() {
    if (doesMatch$3('no-preference')) {
        return 0 /* ContrastPreference.None */;
    }
    // The sources contradict on the keywords. Probably 'high' and 'low' will never be implemented.
    // Need to check it when all browsers implement the feature.
    if (doesMatch$3('high') || doesMatch$3('more')) {
        return 1 /* ContrastPreference.More */;
    }
    if (doesMatch$3('low') || doesMatch$3('less')) {
        return -1 /* ContrastPreference.Less */;
    }
    if (doesMatch$3('forced')) {
        return 10 /* ContrastPreference.ForcedColors */;
    }
    return undefined;
}
function doesMatch$3(value) {
    return matchMedia("(prefers-contrast: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-motion
 */
function isMotionReduced() {
    if (doesMatch$2('reduce')) {
        return true;
    }
    if (doesMatch$2('no-preference')) {
        return false;
    }
    return undefined;
}
function doesMatch$2(value) {
    return matchMedia("(prefers-reduced-motion: ".concat(value, ")")).matches;
}

/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-reduced-transparency
 */
function isTransparencyReduced() {
    if (doesMatch$1('reduce')) {
        return true;
    }
    if (doesMatch$1('no-preference')) {
        return false;
    }
    return undefined;
}
function doesMatch$1(value) {
    return matchMedia("(prefers-reduced-transparency: ".concat(value, ")")).matches;
}

/**
 * @see https://www.w3.org/TR/mediaqueries-5/#dynamic-range
 */
function isHDR() {
    if (doesMatch('high')) {
        return true;
    }
    if (doesMatch('standard')) {
        return false;
    }
    return undefined;
}
function doesMatch(value) {
    return matchMedia("(dynamic-range: ".concat(value, ")")).matches;
}

var M = Math; // To reduce the minified code size
var fallbackFn = function () { return 0; };
/**
 * @see https://gitlab.torproject.org/legacy/trac/-/issues/13018
 * @see https://bugzilla.mozilla.org/show_bug.cgi?id=531915
 */
function getMathFingerprint() {
    // Native operations
    var acos = M.acos || fallbackFn;
    var acosh = M.acosh || fallbackFn;
    var asin = M.asin || fallbackFn;
    var asinh = M.asinh || fallbackFn;
    var atanh = M.atanh || fallbackFn;
    var atan = M.atan || fallbackFn;
    var sin = M.sin || fallbackFn;
    var sinh = M.sinh || fallbackFn;
    var cos = M.cos || fallbackFn;
    var cosh = M.cosh || fallbackFn;
    var tan = M.tan || fallbackFn;
    var tanh = M.tanh || fallbackFn;
    var exp = M.exp || fallbackFn;
    var expm1 = M.expm1 || fallbackFn;
    var log1p = M.log1p || fallbackFn;
    // Operation polyfills
    var powPI = function (value) { return M.pow(M.PI, value); };
    var acoshPf = function (value) { return M.log(value + M.sqrt(value * value - 1)); };
    var asinhPf = function (value) { return M.log(value + M.sqrt(value * value + 1)); };
    var atanhPf = function (value) { return M.log((1 + value) / (1 - value)) / 2; };
    var sinhPf = function (value) { return M.exp(value) - 1 / M.exp(value) / 2; };
    var coshPf = function (value) { return (M.exp(value) + 1 / M.exp(value)) / 2; };
    var expm1Pf = function (value) { return M.exp(value) - 1; };
    var tanhPf = function (value) { return (M.exp(2 * value) - 1) / (M.exp(2 * value) + 1); };
    var log1pPf = function (value) { return M.log(1 + value); };
    // Note: constant values are empirical
    return {
        acos: acos(0.123124234234234242),
        acosh: acosh(1e308),
        acoshPf: acoshPf(1e154),
        asin: asin(0.123124234234234242),
        asinh: asinh(1),
        asinhPf: asinhPf(1),
        atanh: atanh(0.5),
        atanhPf: atanhPf(0.5),
        atan: atan(0.5),
        sin: sin(-1e300),
        sinh: sinh(1),
        sinhPf: sinhPf(1),
        cos: cos(10.000000000123),
        cosh: cosh(1),
        coshPf: coshPf(1),
        tan: tan(-1e300),
        tanh: tanh(1),
        tanhPf: tanhPf(1),
        exp: exp(1),
        expm1: expm1(1),
        expm1Pf: expm1Pf(1),
        log1p: log1p(10),
        log1pPf: log1pPf(10),
        powPI: powPI(-100),
    };
}

/**
 * We use m or w because these two characters take up the maximum width.
 * Also there are a couple of ligatures.
 */
var defaultText = 'mmMwWLliI0fiflO&1';
/**
 * Settings of text blocks to measure. The keys are random but persistent words.
 */
var presets = {
    /**
     * The default font. User can change it in desktop Chrome, desktop Firefox, IE 11,
     * Android Chrome (but only when the size is ≥ than the default) and Android Firefox.
     */
    default: [],
    /** OS font on macOS. User can change its size and weight. Applies after Safari restart. */
    apple: [{ font: '-apple-system-body' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    serif: [{ fontFamily: 'serif' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    sans: [{ fontFamily: 'sans-serif' }],
    /** User can change it in desktop Chrome and desktop Firefox. */
    mono: [{ fontFamily: 'monospace' }],
    /**
     * Check the smallest allowed font size. User can change it in desktop Chrome, desktop Firefox and desktop Safari.
     * The height can be 0 in Chrome on a retina display.
     */
    min: [{ fontSize: '1px' }],
    /** Tells one OS from another in desktop Chrome. */
    system: [{ fontFamily: 'system-ui' }],
};
/**
 * The result is a dictionary of the width of the text samples.
 * Heights aren't included because they give no extra entropy and are unstable.
 *
 * The result is very stable in IE 11, Edge 18 and Safari 14.
 * The result changes when the OS pixel density changes in Chromium 87. The real pixel density is required to solve,
 * but seems like it's impossible: https://stackoverflow.com/q/1713771/1118709.
 * The "min" and the "mono" (only on Windows) value may change when the page is zoomed in Firefox 87.
 */
function getFontPreferences() {
    return withNaturalFonts(function (document, container) {
        var elements = {};
        var sizes = {};
        // First create all elements to measure. If the DOM steps below are done in a single cycle,
        // browser will alternate tree modification and layout reading, that is very slow.
        for (var _i = 0, _a = Object.keys(presets); _i < _a.length; _i++) {
            var key = _a[_i];
            var _b = presets[key], _c = _b[0], style = _c === void 0 ? {} : _c, _d = _b[1], text = _d === void 0 ? defaultText : _d;
            var element = document.createElement('span');
            element.textContent = text;
            element.style.whiteSpace = 'nowrap';
            for (var _e = 0, _f = Object.keys(style); _e < _f.length; _e++) {
                var name_1 = _f[_e];
                var value = style[name_1];
                if (value !== undefined) {
                    element.style[name_1] = value;
                }
            }
            elements[key] = element;
            container.append(document.createElement('br'), element);
        }
        // Then measure the created elements
        for (var _g = 0, _h = Object.keys(presets); _g < _h.length; _g++) {
            var key = _h[_g];
            sizes[key] = elements[key].getBoundingClientRect().width;
        }
        return sizes;
    });
}
/**
 * Creates a DOM environment that provides the most natural font available, including Android OS font.
 * Measurements of the elements are zoom-independent.
 * Don't put a content to measure inside an absolutely positioned element.
 */
function withNaturalFonts(action, containerWidthPx) {
    if (containerWidthPx === void 0) { containerWidthPx = 4000; }
    /*
     * Requirements for Android Chrome to apply the system font size to a text inside an iframe:
     * - The iframe mustn't have a `display: none;` style;
     * - The text mustn't be positioned absolutely;
     * - The text block must be wide enough.
     *   2560px on some devices in portrait orientation for the biggest font size option (32px);
     * - There must be much enough text to form a few lines (I don't know the exact numbers);
     * - The text must have the `text-size-adjust: none` style. Otherwise the text will scale in "Desktop site" mode;
     *
     * Requirements for Android Firefox to apply the system font size to a text inside an iframe:
     * - The iframe document must have a header: `<meta name="viewport" content="width=device-width, initial-scale=1" />`.
     *   The only way to set it is to use the `srcdoc` attribute of the iframe;
     * - The iframe content must get loaded before adding extra content with JavaScript;
     *
     * https://example.com as the iframe target always inherits Android font settings so it can be used as a reference.
     *
     * Observations on how page zoom affects the measurements:
     * - macOS Safari 11.1, 12.1, 13.1, 14.0: zoom reset + offsetWidth = 100% reliable;
     * - macOS Safari 11.1, 12.1, 13.1, 14.0: zoom reset + getBoundingClientRect = 100% reliable;
     * - macOS Safari 14.0: offsetWidth = 5% fluctuation;
     * - macOS Safari 14.0: getBoundingClientRect = 5% fluctuation;
     * - iOS Safari 9, 10, 11.0, 12.0: haven't found a way to zoom a page (pinch doesn't change layout);
     * - iOS Safari 13.1, 14.0: zoom reset + offsetWidth = 100% reliable;
     * - iOS Safari 13.1, 14.0: zoom reset + getBoundingClientRect = 100% reliable;
     * - iOS Safari 14.0: offsetWidth = 100% reliable;
     * - iOS Safari 14.0: getBoundingClientRect = 100% reliable;
     * - Chrome 42, 65, 80, 87: zoom 1/devicePixelRatio + offsetWidth = 1px fluctuation;
     * - Chrome 42, 65, 80, 87: zoom 1/devicePixelRatio + getBoundingClientRect = 100% reliable;
     * - Chrome 87: offsetWidth = 1px fluctuation;
     * - Chrome 87: getBoundingClientRect = 0.7px fluctuation;
     * - Firefox 48, 51: offsetWidth = 10% fluctuation;
     * - Firefox 48, 51: getBoundingClientRect = 10% fluctuation;
     * - Firefox 52, 53, 57, 62, 66, 67, 68, 71, 75, 80, 84: offsetWidth = width 100% reliable, height 10% fluctuation;
     * - Firefox 52, 53, 57, 62, 66, 67, 68, 71, 75, 80, 84: getBoundingClientRect = width 100% reliable, height 10%
     *   fluctuation;
     * - Android Chrome 86: haven't found a way to zoom a page (pinch doesn't change layout);
     * - Android Firefox 84: font size in accessibility settings changes all the CSS sizes, but offsetWidth and
     *   getBoundingClientRect keep measuring with regular units, so the size reflects the font size setting and doesn't
     *   fluctuate;
     * - IE 11, Edge 18: zoom 1/devicePixelRatio + offsetWidth = 100% reliable;
     * - IE 11, Edge 18: zoom 1/devicePixelRatio + getBoundingClientRect = reflects the zoom level;
     * - IE 11, Edge 18: offsetWidth = 100% reliable;
     * - IE 11, Edge 18: getBoundingClientRect = 100% reliable;
     */
    return withIframe(function (_, iframeWindow) {
        var iframeDocument = iframeWindow.document;
        var iframeBody = iframeDocument.body;
        var bodyStyle = iframeBody.style;
        bodyStyle.width = "".concat(containerWidthPx, "px");
        bodyStyle.webkitTextSizeAdjust = bodyStyle.textSizeAdjust = 'none';
        // See the big comment above
        if (isChromium()) {
            iframeBody.style.zoom = "".concat(1 / iframeWindow.devicePixelRatio);
        }
        else if (isWebKit()) {
            iframeBody.style.zoom = 'reset';
        }
        // See the big comment above
        var linesOfText = iframeDocument.createElement('div');
        linesOfText.textContent = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__spreadArray)([], Array((containerWidthPx / 20) << 0), true).map(function () { return 'word'; }).join(' ');
        iframeBody.appendChild(linesOfText);
        return action(iframeDocument, iframeBody);
    }, '<!doctype html><html><head><meta name="viewport" content="width=device-width, initial-scale=1">');
}

function isPdfViewerEnabled() {
    return navigator.pdfViewerEnabled;
}

/**
 * Unlike most other architectures, on x86/x86-64 when floating-point instructions
 * have no NaN arguments, but produce NaN output, the output NaN has sign bit set.
 * We use it to distinguish x86/x86-64 from other architectures, by doing subtraction
 * of two infinities (must produce NaN per IEEE 754 standard).
 *
 * See https://codebrowser.bddppq.com/pytorch/pytorch/third_party/XNNPACK/src/init.c.html#79
 */
function getArchitecture() {
    var f = new Float32Array(1);
    var u8 = new Uint8Array(f.buffer);
    f[0] = Infinity;
    f[0] = f[0] - f[0];
    return u8[3];
}

/**
 * The return type is a union instead of the enum, because it's too challenging to embed the const enum into another
 * project. Turning it into a union is a simple and an elegant solution.
 */
function getApplePayState() {
    var ApplePaySession = window.ApplePaySession;
    if (typeof (ApplePaySession === null || ApplePaySession === void 0 ? void 0 : ApplePaySession.canMakePayments) !== 'function') {
        return -1 /* ApplePayState.NoAPI */;
    }
    if (willPrintConsoleError()) {
        return -3 /* ApplePayState.NotAvailableInFrame */;
    }
    try {
        return ApplePaySession.canMakePayments() ? 1 /* ApplePayState.Enabled */ : 0 /* ApplePayState.Disabled */;
    }
    catch (error) {
        return getStateFromError(error);
    }
}
/**
 * Starting from Safari 15 calling `ApplePaySession.canMakePayments()` produces this error message when FingerprintJS
 * runs in an iframe with a cross-origin parent page, and the iframe on that page has no allow="payment *" attribute:
 *   Feature policy 'Payment' check failed for element with origin 'https://example.com' and allow attribute ''.
 * This function checks whether the error message is expected.
 *
 * We check for cross-origin parents, which is prone to false-positive results. Instead, we should check for allowed
 * feature/permission, but we can't because none of these API works in Safari yet:
 *   navigator.permissions.query({ name: ‘payment' })
 *   navigator.permissions.query({ name: ‘payment-handler' })
 *   document.featurePolicy
 */
var willPrintConsoleError = isAnyParentCrossOrigin;
function getStateFromError(error) {
    // See full expected error messages in the test
    if (error instanceof Error && error.name === 'InvalidAccessError' && /\bfrom\b.*\binsecure\b/i.test(error.message)) {
        return -2 /* ApplePayState.NotAvailableInInsecureContext */;
    }
    throw error;
}

/**
 * Checks whether the Safari's Privacy Preserving Ad Measurement setting is on.
 * The setting is on when the value is not undefined.
 * A.k.a. private click measurement, privacy-preserving ad attribution.
 *
 * Unfortunately, it doesn't work in mobile Safari.
 * Probably, it will start working in mobile Safari or stop working in desktop Safari later.
 * We've found no way to detect the setting state in mobile Safari. Help wanted.
 *
 * @see https://webkit.org/blog/11529/introducing-private-click-measurement-pcm/
 * @see https://developer.apple.com/videos/play/wwdc2021/10033
 */
function getPrivateClickMeasurement() {
    var _a;
    var link = document.createElement('a');
    var sourceId = (_a = link.attributionSourceId) !== null && _a !== void 0 ? _a : link.attributionsourceid;
    return sourceId === undefined ? undefined : String(sourceId);
}

/** WebGl context is not available */
var STATUS_NO_GL_CONTEXT = -1;
/** WebGL context `getParameter` method is not a function */
var STATUS_GET_PARAMETER_NOT_A_FUNCTION = -2;
var validContextParameters = new Set([
    10752, 2849, 2884, 2885, 2886, 2928, 2929, 2930, 2931, 2932, 2960, 2961, 2962, 2963, 2964, 2965, 2966, 2967, 2968,
    2978, 3024, 3042, 3088, 3089, 3106, 3107, 32773, 32777, 32777, 32823, 32824, 32936, 32937, 32938, 32939, 32968, 32969,
    32970, 32971, 3317, 33170, 3333, 3379, 3386, 33901, 33902, 34016, 34024, 34076, 3408, 3410, 3411, 3412, 3413, 3414,
    3415, 34467, 34816, 34817, 34818, 34819, 34877, 34921, 34930, 35660, 35661, 35724, 35738, 35739, 36003, 36004, 36005,
    36347, 36348, 36349, 37440, 37441, 37443, 7936, 7937, 7938,
    // SAMPLE_ALPHA_TO_COVERAGE (32926) and SAMPLE_COVERAGE (32928) are excluded because they trigger a console warning
    // in IE, Chrome ≤ 59 and Safari ≤ 13 and give no entropy.
]);
var validExtensionParams = new Set([
    34047,
    35723,
    36063,
    34852,
    34853,
    34854,
    34229,
    36392,
    36795,
    38449, // MAX_VIEWS_OVR
]);
var shaderTypes = ['FRAGMENT_SHADER', 'VERTEX_SHADER'];
var precisionTypes = ['LOW_FLOAT', 'MEDIUM_FLOAT', 'HIGH_FLOAT', 'LOW_INT', 'MEDIUM_INT', 'HIGH_INT'];
var rendererInfoExtensionName = 'WEBGL_debug_renderer_info';
var polygonModeExtensionName = 'WEBGL_polygon_mode';
/**
 * Gets the basic and simple WebGL parameters
 */
function getWebGlBasics(_a) {
    var _b, _c, _d, _e, _f, _g;
    var cache = _a.cache;
    var gl = getWebGLContext(cache);
    if (!gl) {
        return STATUS_NO_GL_CONTEXT;
    }
    if (!isValidParameterGetter(gl)) {
        return STATUS_GET_PARAMETER_NOT_A_FUNCTION;
    }
    var debugExtension = shouldAvoidDebugRendererInfo() ? null : gl.getExtension(rendererInfoExtensionName);
    return {
        version: ((_b = gl.getParameter(gl.VERSION)) === null || _b === void 0 ? void 0 : _b.toString()) || '',
        vendor: ((_c = gl.getParameter(gl.VENDOR)) === null || _c === void 0 ? void 0 : _c.toString()) || '',
        vendorUnmasked: debugExtension ? (_d = gl.getParameter(debugExtension.UNMASKED_VENDOR_WEBGL)) === null || _d === void 0 ? void 0 : _d.toString() : '',
        renderer: ((_e = gl.getParameter(gl.RENDERER)) === null || _e === void 0 ? void 0 : _e.toString()) || '',
        rendererUnmasked: debugExtension ? (_f = gl.getParameter(debugExtension.UNMASKED_RENDERER_WEBGL)) === null || _f === void 0 ? void 0 : _f.toString() : '',
        shadingLanguageVersion: ((_g = gl.getParameter(gl.SHADING_LANGUAGE_VERSION)) === null || _g === void 0 ? void 0 : _g.toString()) || '',
    };
}
/**
 * Gets the advanced and massive WebGL parameters and extensions
 */
function getWebGlExtensions(_a) {
    var cache = _a.cache;
    var gl = getWebGLContext(cache);
    if (!gl) {
        return STATUS_NO_GL_CONTEXT;
    }
    if (!isValidParameterGetter(gl)) {
        return STATUS_GET_PARAMETER_NOT_A_FUNCTION;
    }
    var extensions = gl.getSupportedExtensions();
    var contextAttributes = gl.getContextAttributes();
    var unsupportedExtensions = [];
    // Features
    var attributes = [];
    var parameters = [];
    var extensionParameters = [];
    var shaderPrecisions = [];
    // Context attributes
    if (contextAttributes) {
        for (var _i = 0, _b = Object.keys(contextAttributes); _i < _b.length; _i++) {
            var attributeName = _b[_i];
            attributes.push("".concat(attributeName, "=").concat(contextAttributes[attributeName]));
        }
    }
    // Context parameters
    var constants = getConstantsFromPrototype(gl);
    for (var _c = 0, constants_1 = constants; _c < constants_1.length; _c++) {
        var constant = constants_1[_c];
        var code = gl[constant];
        parameters.push("".concat(constant, "=").concat(code).concat(validContextParameters.has(code) ? "=".concat(gl.getParameter(code)) : ''));
    }
    // Extension parameters
    if (extensions) {
        for (var _d = 0, extensions_1 = extensions; _d < extensions_1.length; _d++) {
            var name_1 = extensions_1[_d];
            if ((name_1 === rendererInfoExtensionName && shouldAvoidDebugRendererInfo()) ||
                (name_1 === polygonModeExtensionName && shouldAvoidPolygonModeExtensions())) {
                continue;
            }
            var extension = gl.getExtension(name_1);
            if (!extension) {
                unsupportedExtensions.push(name_1);
                continue;
            }
            for (var _e = 0, _f = getConstantsFromPrototype(extension); _e < _f.length; _e++) {
                var constant = _f[_e];
                var code = extension[constant];
                extensionParameters.push("".concat(constant, "=").concat(code).concat(validExtensionParams.has(code) ? "=".concat(gl.getParameter(code)) : ''));
            }
        }
    }
    // Shader precision
    for (var _g = 0, shaderTypes_1 = shaderTypes; _g < shaderTypes_1.length; _g++) {
        var shaderType = shaderTypes_1[_g];
        for (var _h = 0, precisionTypes_1 = precisionTypes; _h < precisionTypes_1.length; _h++) {
            var precisionType = precisionTypes_1[_h];
            var shaderPrecision = getShaderPrecision(gl, shaderType, precisionType);
            shaderPrecisions.push("".concat(shaderType, ".").concat(precisionType, "=").concat(shaderPrecision.join(',')));
        }
    }
    // Postprocess
    extensionParameters.sort();
    parameters.sort();
    return {
        contextAttributes: attributes,
        parameters: parameters,
        shaderPrecisions: shaderPrecisions,
        extensions: extensions,
        extensionParameters: extensionParameters,
        unsupportedExtensions: unsupportedExtensions,
    };
}
/**
 * This function usually takes the most time to execute in all the sources, therefore we cache its result.
 *
 * Warning for package users:
 * This function is out of Semantic Versioning, i.e. can change unexpectedly. Usage is at your own risk.
 */
function getWebGLContext(cache) {
    if (cache.webgl) {
        return cache.webgl.context;
    }
    var canvas = document.createElement('canvas');
    var context;
    canvas.addEventListener('webglCreateContextError', function () { return (context = undefined); });
    for (var _i = 0, _a = ['webgl', 'experimental-webgl']; _i < _a.length; _i++) {
        var type = _a[_i];
        try {
            context = canvas.getContext(type);
        }
        catch (_b) {
            // Ok, continue
        }
        if (context) {
            break;
        }
    }
    cache.webgl = { context: context };
    return context;
}
/**
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLShaderPrecisionFormat
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/getShaderPrecisionFormat
 * https://www.khronos.org/registry/webgl/specs/latest/1.0/#5.12
 */
function getShaderPrecision(gl, shaderType, precisionType) {
    var shaderPrecision = gl.getShaderPrecisionFormat(gl[shaderType], gl[precisionType]);
    return shaderPrecision ? [shaderPrecision.rangeMin, shaderPrecision.rangeMax, shaderPrecision.precision] : [];
}
function getConstantsFromPrototype(obj) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    var keys = Object.keys(obj.__proto__);
    return keys.filter(isConstantLike);
}
function isConstantLike(key) {
    return typeof key === 'string' && !key.match(/[^A-Z0-9_x]/);
}
/**
 * Some browsers print a console warning when the WEBGL_debug_renderer_info extension is requested.
 * JS Agent aims to avoid printing messages to console, so we avoid this extension in that browsers.
 */
function shouldAvoidDebugRendererInfo() {
    return isGecko();
}
/**
 * Some browsers print a console warning when the WEBGL_polygon_mode extension is requested.
 * JS Agent aims to avoid printing messages to console, so we avoid this extension in that browsers.
 */
function shouldAvoidPolygonModeExtensions() {
    return isChromium() || isWebKit();
}
/**
 * Some unknown browsers have no `getParameter` method
 */
function isValidParameterGetter(gl) {
    return typeof gl.getParameter === 'function';
}

function getAudioContextBaseLatency() {
    var _a;
    // The signal emits warning in Chrome and Firefox, therefore it is enabled on Safari where it doesn't produce warning
    // and on Android where it's less visible
    var isAllowedPlatform = isAndroid() || isWebKit();
    if (!isAllowedPlatform) {
        return -2 /* SpecialFingerprint.Disabled */;
    }
    if (!window.AudioContext) {
        return -1 /* SpecialFingerprint.NotSupported */;
    }
    return (_a = new AudioContext().baseLatency) !== null && _a !== void 0 ? _a : -1 /* SpecialFingerprint.NotSupported */;
}

/**
 * The list of entropy sources used to make visitor identifiers.
 *
 * This value isn't restricted by Semantic Versioning, i.e. it may be changed without bumping minor or major version of
 * this package.
 *
 * Note: Rollup and Webpack are smart enough to remove unused properties of this object during tree-shaking, so there is
 * no need to export the sources individually.
 */
var sources = {
    // READ FIRST:
    // See https://github.com/fingerprintjs/fingerprintjs/blob/master/contributing.md#how-to-make-an-entropy-source
    // to learn how entropy source works and how to make your own.
    // The sources run in this exact order.
    // The asynchronous sources are at the start to run in parallel with other sources.
    fonts: getFonts,
    domBlockers: getDomBlockers,
    fontPreferences: getFontPreferences,
    audio: getAudioFingerprint,
    screenFrame: getScreenFrame,
    canvas: getCanvasFingerprint,
    osCpu: getOsCpu,
    languages: getLanguages,
    colorDepth: getColorDepth,
    deviceMemory: getDeviceMemory,
    screenResolution: getScreenResolution,
    hardwareConcurrency: getHardwareConcurrency,
    timezone: getTimezone,
    sessionStorage: getSessionStorage,
    localStorage: getLocalStorage,
    indexedDB: getIndexedDB,
    openDatabase: getOpenDatabase,
    cpuClass: getCpuClass,
    platform: getPlatform,
    plugins: getPlugins,
    touchSupport: getTouchSupport,
    vendor: getVendor,
    vendorFlavors: getVendorFlavors,
    cookiesEnabled: areCookiesEnabled,
    colorGamut: getColorGamut,
    invertedColors: areColorsInverted,
    forcedColors: areColorsForced,
    monochrome: getMonochromeDepth,
    contrast: getContrastPreference,
    reducedMotion: isMotionReduced,
    reducedTransparency: isTransparencyReduced,
    hdr: isHDR,
    math: getMathFingerprint,
    pdfViewerEnabled: isPdfViewerEnabled,
    architecture: getArchitecture,
    applePay: getApplePayState,
    privateClickMeasurement: getPrivateClickMeasurement,
    audioBaseLatency: getAudioContextBaseLatency,
    // Some sources can affect other sources (e.g. WebGL can affect canvas), so it's important to run these sources
    // after other sources.
    webGlBasics: getWebGlBasics,
    webGlExtensions: getWebGlExtensions,
};
/**
 * Loads the built-in entropy sources.
 * Returns a function that collects the entropy components to make the visitor identifier.
 */
function loadBuiltinSources(options) {
    return loadSources(sources, options, []);
}

var commentTemplate = '$ if upgrade to Pro: https://fpjs.dev/pro';
function getConfidence(components) {
    var openConfidenceScore = getOpenConfidenceScore(components);
    var proConfidenceScore = deriveProConfidenceScore(openConfidenceScore);
    return { score: openConfidenceScore, comment: commentTemplate.replace(/\$/g, "".concat(proConfidenceScore)) };
}
function getOpenConfidenceScore(components) {
    // In order to calculate the true probability of the visitor identifier being correct, we need to know the number of
    // website visitors (the higher the number, the less the probability because the fingerprint entropy is limited).
    // JS agent doesn't know the number of visitors, so we can only do an approximate assessment.
    if (isAndroid()) {
        return 0.4;
    }
    // Safari (mobile and desktop)
    if (isWebKit()) {
        return isDesktopWebKit() && !(isWebKit616OrNewer() && isSafariWebKit()) ? 0.5 : 0.3;
    }
    var platform = 'value' in components.platform ? components.platform.value : '';
    // Windows
    if (/^Win/.test(platform)) {
        // The score is greater than on macOS because of the higher variety of devices running Windows.
        // Chrome provides more entropy than Firefox according too
        // https://netmarketshare.com/browser-market-share.aspx?options=%7B%22filter%22%3A%7B%22%24and%22%3A%5B%7B%22platform%22%3A%7B%22%24in%22%3A%5B%22Windows%22%5D%7D%7D%5D%7D%2C%22dateLabel%22%3A%22Trend%22%2C%22attributes%22%3A%22share%22%2C%22group%22%3A%22browser%22%2C%22sort%22%3A%7B%22share%22%3A-1%7D%2C%22id%22%3A%22browsersDesktop%22%2C%22dateInterval%22%3A%22Monthly%22%2C%22dateStart%22%3A%222019-11%22%2C%22dateEnd%22%3A%222020-10%22%2C%22segments%22%3A%22-1000%22%7D
        // So we assign the same score to them.
        return 0.6;
    }
    // macOS
    if (/^Mac/.test(platform)) {
        // Chrome provides more entropy than Safari and Safari provides more entropy than Firefox.
        // Chrome is more popular than Safari and Safari is more popular than Firefox according to
        // https://netmarketshare.com/browser-market-share.aspx?options=%7B%22filter%22%3A%7B%22%24and%22%3A%5B%7B%22platform%22%3A%7B%22%24in%22%3A%5B%22Mac%20OS%22%5D%7D%7D%5D%7D%2C%22dateLabel%22%3A%22Trend%22%2C%22attributes%22%3A%22share%22%2C%22group%22%3A%22browser%22%2C%22sort%22%3A%7B%22share%22%3A-1%7D%2C%22id%22%3A%22browsersDesktop%22%2C%22dateInterval%22%3A%22Monthly%22%2C%22dateStart%22%3A%222019-11%22%2C%22dateEnd%22%3A%222020-10%22%2C%22segments%22%3A%22-1000%22%7D
        // So we assign the same score to them.
        return 0.5;
    }
    // Another platform, e.g. a desktop Linux. It's rare, so it should be pretty unique.
    return 0.7;
}
function deriveProConfidenceScore(openConfidenceScore) {
    return round(0.99 + 0.01 * openConfidenceScore, 0.0001);
}

function componentsToCanonicalString(components) {
    var result = '';
    for (var _i = 0, _a = Object.keys(components).sort(); _i < _a.length; _i++) {
        var componentKey = _a[_i];
        var component = components[componentKey];
        var value = 'error' in component ? 'error' : JSON.stringify(component.value);
        result += "".concat(result ? '|' : '').concat(componentKey.replace(/([:|\\])/g, '\\$1'), ":").concat(value);
    }
    return result;
}
function componentsToDebugString(components) {
    return JSON.stringify(components, function (_key, value) {
        if (value instanceof Error) {
            return errorToObject(value);
        }
        return value;
    }, 2);
}
function hashComponents(components) {
    return x64hash128(componentsToCanonicalString(components));
}
/**
 * Makes a GetResult implementation that calculates the visitor id hash on demand.
 * Designed for optimisation.
 */
function makeLazyGetResult(components) {
    var visitorIdCache;
    // This function runs very fast, so there is no need to make it lazy
    var confidence = getConfidence(components);
    // A plain class isn't used because its getters and setters aren't enumerable.
    return {
        get visitorId() {
            if (visitorIdCache === undefined) {
                visitorIdCache = hashComponents(this.components);
            }
            return visitorIdCache;
        },
        set visitorId(visitorId) {
            visitorIdCache = visitorId;
        },
        confidence: confidence,
        components: components,
        version: version,
    };
}
/**
 * A delay is required to ensure consistent entropy components.
 * See https://github.com/fingerprintjs/fingerprintjs/issues/254
 * and https://github.com/fingerprintjs/fingerprintjs/issues/307
 * and https://github.com/fingerprintjs/fingerprintjs/commit/945633e7c5f67ae38eb0fea37349712f0e669b18
 */
function prepareForSources(delayFallback) {
    if (delayFallback === void 0) { delayFallback = 50; }
    // A proper deadline is unknown. Let it be twice the fallback timeout so that both cases have the same average time.
    return requestIdleCallbackIfAvailable(delayFallback, delayFallback * 2);
}
/**
 * The function isn't exported from the index file to not allow to call it without `load()`.
 * The hiding gives more freedom for future non-breaking updates.
 *
 * A factory function is used instead of a class to shorten the attribute names in the minified code.
 * Native private class fields could've been used, but TypeScript doesn't allow them with `"target": "es5"`.
 */
function makeAgent(getComponents, debug) {
    var creationTime = Date.now();
    return {
        get: function (options) {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
                var startTime, components, result;
                return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            startTime = Date.now();
                            return [4 /*yield*/, getComponents()];
                        case 1:
                            components = _a.sent();
                            result = makeLazyGetResult(components);
                            if (debug || (options === null || options === void 0 ? void 0 : options.debug)) {
                                // console.log is ok here because it's under a debug clause
                                // eslint-disable-next-line no-console
                                console.log("Copy the text below to get the debug data:\n\n```\nversion: ".concat(result.version, "\nuserAgent: ").concat(navigator.userAgent, "\ntimeBetweenLoadAndGet: ").concat(startTime - creationTime, "\nvisitorId: ").concat(result.visitorId, "\ncomponents: ").concat(componentsToDebugString(components), "\n```"));
                            }
                            return [2 /*return*/, result];
                    }
                });
            });
        },
    };
}
/**
 * Sends an unpersonalized AJAX request to collect installation statistics
 */
function monitor() {
    // The FingerprintJS CDN (https://github.com/fingerprintjs/cdn) replaces `window.__fpjs_d_m` with `true`
    if (window.__fpjs_d_m || Math.random() >= 0.001) {
        return;
    }
    try {
        var request = new XMLHttpRequest();
        request.open('get', "https://m1.openfpcdn.io/fingerprintjs/v".concat(version, "/npm-monitoring"), true);
        request.send();
    }
    catch (error) {
        // console.error is ok here because it's an unexpected error handler
        // eslint-disable-next-line no-console
        console.error(error);
    }
}
/**
 * Builds an instance of Agent and waits a delay required for a proper operation.
 */
function load(options) {
    var _a;
    if (options === void 0) { options = {}; }
    return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
        var delayFallback, debug, getComponents;
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if ((_a = options.monitoring) !== null && _a !== void 0 ? _a : true) {
                        monitor();
                    }
                    delayFallback = options.delayFallback, debug = options.debug;
                    return [4 /*yield*/, prepareForSources(delayFallback)];
                case 1:
                    _b.sent();
                    getComponents = loadBuiltinSources({ cache: {}, debug: debug });
                    return [2 /*return*/, makeAgent(getComponents, debug)];
            }
        });
    });
}

// The default export is a syntax sugar (`import * as FP from '...' → import FP from '...'`).
// It should contain all the public exported values.
var index = { load: load, hashComponents: hashComponents, componentsToDebugString: componentsToDebugString };
// The exports below are for private usage. They may change unexpectedly. Use them at your own risk.
/** Not documented, out of Semantic Versioning, usage is at your own risk */
var murmurX64Hash128 = x64hash128;




/***/ }),

/***/ "./node_modules/@vue-leaflet/vue-leaflet/dist/vue-leaflet.es.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@vue-leaflet/vue-leaflet/dist/vue-leaflet.es.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Functions: () => (/* binding */ go),
/* harmony export */   InjectionKeys: () => (/* binding */ Qt),
/* harmony export */   LCircle: () => (/* binding */ Xt),
/* harmony export */   LCircleMarker: () => (/* binding */ Yt),
/* harmony export */   LControl: () => (/* binding */ Vt),
/* harmony export */   LControlAttribution: () => (/* binding */ xt),
/* harmony export */   LControlLayers: () => (/* binding */ Rt),
/* harmony export */   LControlScale: () => (/* binding */ eo),
/* harmony export */   LControlZoom: () => (/* binding */ to),
/* harmony export */   LFeatureGroup: () => (/* binding */ oo),
/* harmony export */   LGeoJson: () => (/* binding */ no),
/* harmony export */   LGridLayer: () => (/* binding */ ro),
/* harmony export */   LIcon: () => (/* binding */ so),
/* harmony export */   LImageOverlay: () => (/* binding */ ao),
/* harmony export */   LLayerGroup: () => (/* binding */ lo),
/* harmony export */   LMap: () => (/* binding */ io),
/* harmony export */   LMarker: () => (/* binding */ uo),
/* harmony export */   LPolygon: () => (/* binding */ co),
/* harmony export */   LPolyline: () => (/* binding */ po),
/* harmony export */   LPopup: () => (/* binding */ yo),
/* harmony export */   LRectangle: () => (/* binding */ mo),
/* harmony export */   LTileLayer: () => (/* binding */ vo),
/* harmony export */   LTooltip: () => (/* binding */ bo),
/* harmony export */   LWmsTileLayer: () => (/* binding */ fo),
/* harmony export */   Utilities: () => (/* binding */ Kt)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

const ce = (e, o) => {
  for (const t of Object.keys(o))
    e.on(t, o[t]);
}, ye = (e) => {
  for (const o of Object.keys(e)) {
    const t = e[o];
    t && k(t.cancel) && t.cancel();
  }
}, Je = (e) => !e || typeof e.charAt != "function" ? e : e.charAt(0).toUpperCase() + e.slice(1), k = (e) => typeof e == "function", L = (e, o, t) => {
  for (const n in t) {
    const s = "set" + Je(n);
    e[s] ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(
      () => t[n],
      (r, l) => {
        e[s](r, l);
      }
    ) : o[s] && (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(
      () => t[n],
      (r) => {
        o[s](r);
      }
    );
  }
}, f = (e, o, t = {}) => {
  const n = { ...t };
  for (const s in e) {
    const r = o[s], l = e[s];
    r && (r && r.custom === !0 || l !== void 0 && (n[s] = l));
  }
  return n;
}, T = (e) => {
  const o = {}, t = {};
  for (const n in e)
    if (n.startsWith("on") && !n.startsWith("onUpdate") && n !== "onReady") {
      const s = n.slice(2).toLocaleLowerCase();
      o[s] = e[n];
    } else
      t[n] = e[n];
  return { listeners: o, attrs: t };
}, qe = async (e) => {
  const o = await Promise.all([
    __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_images_marker-icon-2x_png").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/images/marker-icon-2x.png */ "./node_modules/leaflet/dist/images/marker-icon-2x.png")),
    Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/images/marker-icon.png */ "./node_modules/leaflet/dist/images/marker-icon.png")),
    Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/images/marker-shadow.png */ "./node_modules/leaflet/dist/images/marker-shadow.png"))
  ]);
  delete e.Default.prototype._getIconUrl, e.Default.mergeOptions({
    iconRetinaUrl: o[0].default,
    iconUrl: o[1].default,
    shadowUrl: o[2].default
  });
}, Y = (e) => {
  const o = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(
    (...n) => console.warn(`Method ${e} has been invoked without being replaced`)
  ), t = (...n) => o.value(...n);
  return t.wrapped = o, (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(e, t), t;
}, V = (e, o) => e.wrapped.value = o, b = typeof self == "object" && self.self === self && self || typeof __webpack_require__.g == "object" && __webpack_require__.g.global === __webpack_require__.g && __webpack_require__.g || globalThis, m = (e) => {
  const o = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(e);
  if (o === void 0)
    throw new Error(
      `Attempt to inject ${e.description} before it was provided.`
    );
  return o;
}, Kt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  WINDOW_OR_GLOBAL: b,
  assertInject: m,
  bindEventHandlers: ce,
  cancelDebounces: ye,
  capitalizeFirstLetter: Je,
  isFunction: k,
  propsBinder: L,
  propsToLeafletOptions: f,
  provideLeafletWrapper: Y,
  remapEvents: T,
  resetWebpackIcon: qe,
  updateLeafletWrapper: V
}, Symbol.toStringTag, { value: "Module" })), h = Symbol(
  "useGlobalLeaflet"
), M = Symbol("addLayer"), ee = Symbol("removeLayer"), H = Symbol(
  "registerControl"
), me = Symbol(
  "registerLayerControl"
), ve = Symbol(
  "canSetParentHtml"
), be = Symbol("setParentHtml"), fe = Symbol("setIcon"), ge = Symbol("bindPopup"), Le = Symbol("bindTooltip"), he = Symbol("unbindPopup"), Oe = Symbol("unbindTooltip"), Qt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  AddLayerInjection: M,
  BindPopupInjection: ge,
  BindTooltipInjection: Le,
  CanSetParentHtmlInjection: ve,
  RegisterControlInjection: H,
  RegisterLayerControlInjection: me,
  RemoveLayerInjection: ee,
  SetIconInjection: fe,
  SetParentHtmlInjection: be,
  UnbindPopupInjection: he,
  UnbindTooltipInjection: Oe,
  UseGlobalLeafletInjection: h
}, Symbol.toStringTag, { value: "Module" })), W = {
  options: {
    type: Object,
    default: () => ({}),
    custom: !0
  }
}, J = (e) => ({ options: e.options, methods: {} }), bt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  componentProps: W,
  setupComponent: J
}, Symbol.toStringTag, { value: "Module" })), D = {
  ...W,
  pane: {
    type: String
  },
  attribution: {
    type: String
  },
  name: {
    type: String,
    custom: !0
  },
  layerType: {
    type: String,
    custom: !0
  },
  visible: {
    type: Boolean,
    custom: !0,
    default: !0
  }
}, q = (e, o, t) => {
  const n = m(M), s = m(ee), { options: r, methods: l } = J(e), a = f(
    e,
    D,
    r
  ), i = () => n({ leafletObject: o.value }), u = () => s({ leafletObject: o.value }), d = {
    ...l,
    setAttribution(y) {
      u(), o.value.options.attribution = y, e.visible && i();
    },
    setName() {
      u(), e.visible && i();
    },
    setLayerType() {
      u(), e.visible && i();
    },
    setVisible(y) {
      o.value && (y ? i() : u());
    },
    bindPopup(y) {
      if (!o.value || !k(o.value.bindPopup)) {
        console.warn(
          "Attempt to bind popup before bindPopup method available on layer."
        );
        return;
      }
      o.value.bindPopup(y);
    },
    bindTooltip(y) {
      if (!o.value || !k(o.value.bindTooltip)) {
        console.warn(
          "Attempt to bind tooltip before bindTooltip method available on layer."
        );
        return;
      }
      o.value.bindTooltip(y);
    },
    unbindTooltip() {
      o.value && (k(o.value.closeTooltip) && o.value.closeTooltip(), k(o.value.unbindTooltip) && o.value.unbindTooltip());
    },
    unbindPopup() {
      o.value && (k(o.value.closePopup) && o.value.closePopup(), k(o.value.unbindPopup) && o.value.unbindPopup());
    },
    updateVisibleProp(y) {
      t.emit("update:visible", y);
    }
  };
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(ge, d.bindPopup), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(Le, d.bindTooltip), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(he, d.unbindPopup), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(Oe, d.unbindTooltip), (0,vue__WEBPACK_IMPORTED_MODULE_0__.onUnmounted)(() => {
    d.unbindPopup(), d.unbindTooltip(), u();
  }), { options: a, methods: d };
}, G = (e, o) => {
  if (e && o.default)
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { style: { display: "none" } }, o.default());
}, ft = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  layerProps: D,
  render: G,
  setupLayer: q
}, Symbol.toStringTag, { value: "Module" })), Se = {
  ...D,
  interactive: {
    type: Boolean,
    default: void 0
  },
  bubblingMouseEvents: {
    type: Boolean,
    default: void 0
  }
}, Ke = (e, o, t) => {
  const { options: n, methods: s } = q(
    e,
    o,
    t
  );
  return { options: f(
    e,
    Se,
    n
  ), methods: s };
}, gt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  interactiveLayerProps: Se,
  setupInteractiveLayer: Ke
}, Symbol.toStringTag, { value: "Module" })), ne = {
  ...Se,
  stroke: {
    type: Boolean,
    default: void 0
  },
  color: {
    type: String
  },
  weight: {
    type: Number
  },
  opacity: {
    type: Number
  },
  lineCap: {
    type: String
  },
  lineJoin: {
    type: String
  },
  dashArray: {
    type: String
  },
  dashOffset: {
    type: String
  },
  fill: {
    type: Boolean,
    default: void 0
  },
  fillColor: {
    type: String
  },
  fillOpacity: {
    type: Number
  },
  fillRule: {
    type: String
  },
  className: {
    type: String
  }
}, _e = (e, o, t) => {
  const { options: n, methods: s } = Ke(e, o, t), r = f(
    e,
    ne,
    n
  ), l = m(ee), a = {
    ...s,
    setStroke(i) {
      o.value.setStyle({ stroke: i });
    },
    setColor(i) {
      o.value.setStyle({ color: i });
    },
    setWeight(i) {
      o.value.setStyle({ weight: i });
    },
    setOpacity(i) {
      o.value.setStyle({ opacity: i });
    },
    setLineCap(i) {
      o.value.setStyle({ lineCap: i });
    },
    setLineJoin(i) {
      o.value.setStyle({ lineJoin: i });
    },
    setDashArray(i) {
      o.value.setStyle({ dashArray: i });
    },
    setDashOffset(i) {
      o.value.setStyle({ dashOffset: i });
    },
    setFill(i) {
      o.value.setStyle({ fill: i });
    },
    setFillColor(i) {
      o.value.setStyle({ fillColor: i });
    },
    setFillOpacity(i) {
      o.value.setStyle({ fillOpacity: i });
    },
    setFillRule(i) {
      o.value.setStyle({ fillRule: i });
    },
    setClassName(i) {
      o.value.setStyle({ className: i });
    }
  };
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
    l({ leafletObject: o.value });
  }), { options: r, methods: a };
}, Lt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  pathProps: ne,
  setupPath: _e
}, Symbol.toStringTag, { value: "Module" })), re = {
  ...ne,
  /**
   * Radius of the marker in pixels.
   */
  radius: {
    type: Number
  },
  latLng: {
    type: [Object, Array],
    required: !0,
    custom: !0
  }
}, je = (e, o, t) => {
  const { options: n, methods: s } = _e(
    e,
    o,
    t
  ), r = f(
    e,
    re,
    n
  ), l = {
    ...s,
    setRadius(a) {
      o.value.setRadius(a);
    },
    setLatLng(a) {
      o.value.setLatLng(a);
    }
  };
  return { options: r, methods: l };
}, ht = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  circleMarkerProps: re,
  setupCircleMarker: je
}, Symbol.toStringTag, { value: "Module" })), Pe = {
  ...re,
  /**
   * Radius of the circle in meters.
   */
  radius: {
    type: Number
  }
}, Qe = (e, o, t) => {
  const { options: n, methods: s } = je(e, o, t), r = f(
    e,
    Pe,
    n
  ), l = {
    ...s
  };
  return { options: r, methods: l };
}, Ot = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  circleProps: Pe,
  setupCircle: Qe
}, Symbol.toStringTag, { value: "Module" })), Xt = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LCircle",
  props: Pe,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = Qe(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { circle: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(i(e.latLng, l));
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), Yt = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LCircleMarker",
  props: re,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = je(
      e,
      t,
      o
    );
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { circleMarker: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        i(e.latLng, l)
      );
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), F = {
  ...W,
  position: {
    type: String
  }
}, K = (e, o) => {
  const { options: t, methods: n } = J(e), s = f(
    e,
    F,
    t
  ), r = {
    ...n,
    setPosition(l) {
      o.value && o.value.setPosition(l);
    }
  };
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onUnmounted)(() => {
    o.value && o.value.remove();
  }), { options: s, methods: r };
}, Xe = (e) => e.default ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "root" }, e.default()) : null, St = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  controlProps: F,
  renderLControl: Xe,
  setupControl: K
}, Symbol.toStringTag, { value: "Module" })), Vt = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LControl",
  props: {
    ...F,
    disableClickPropagation: {
      type: Boolean,
      custom: !0,
      default: !0
    },
    disableScrollPropagation: {
      type: Boolean,
      custom: !0,
      default: !1
    }
  },
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(H), { options: l, methods: a } = K(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { Control: i, DomEvent: u } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js")), d = i.extend({
        onAdd() {
          return n.value;
        }
      });
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(new d(l)), L(a, t.value, e), r({ leafletObject: t.value }), e.disableClickPropagation && n.value && u.disableClickPropagation(n.value), e.disableScrollPropagation && n.value && u.disableScrollPropagation(n.value), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { root: n, leafletObject: t };
  },
  render() {
    return Xe(this.$slots);
  }
}), Ce = {
  ...F,
  prefix: {
    type: String
  }
}, Ye = (e, o) => {
  const { options: t, methods: n } = K(
    e,
    o
  ), s = f(
    e,
    Ce,
    t
  ), r = {
    ...n,
    setPrefix(l) {
      o.value.setPrefix(l);
    }
  };
  return { options: s, methods: r };
}, _t = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  controlAttributionProps: Ce,
  setupControlAttribution: Ye
}, Symbol.toStringTag, { value: "Module" })), xt = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LControlAttribution",
  props: Ce,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(H), { options: r, methods: l } = Ye(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { control: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        a.attribution(r)
      ), L(l, t.value, e), s({ leafletObject: t.value }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), Te = {
  ...F,
  collapsed: {
    type: Boolean,
    default: void 0
  },
  autoZIndex: {
    type: Boolean,
    default: void 0
  },
  hideSingleBase: {
    type: Boolean,
    default: void 0
  },
  sortLayers: {
    type: Boolean,
    default: void 0
  },
  sortFunction: {
    type: Function
  }
}, Ve = (e, o) => {
  const { options: t } = K(e, o);
  return { options: f(
    e,
    Te,
    t
  ), methods: {
    addLayer(r) {
      r.layerType === "base" ? o.value.addBaseLayer(r.leafletObject, r.name) : r.layerType === "overlay" && o.value.addOverlay(r.leafletObject, r.name);
    },
    removeLayer(r) {
      o.value.removeLayer(r.leafletObject);
    }
  } };
}, jt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  controlLayersProps: Te,
  setupControlLayers: Ve
}, Symbol.toStringTag, { value: "Module" })), Rt = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LControlLayers",
  props: Te,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(me), { options: r, methods: l } = Ve(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { control: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        a.layers(void 0, void 0, r)
      ), L(l, t.value, e), s({
        ...e,
        ...l,
        leafletObject: t.value
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), Me = {
  ...F,
  maxWidth: {
    type: Number
  },
  metric: {
    type: Boolean,
    default: void 0
  },
  imperial: {
    type: Boolean,
    default: void 0
  },
  updateWhenIdle: {
    type: Boolean,
    default: void 0
  }
}, xe = (e, o) => {
  const { options: t, methods: n } = K(
    e,
    o
  );
  return { options: f(
    e,
    Me,
    t
  ), methods: n };
}, Pt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  controlScaleProps: Me,
  setupControlScale: xe
}, Symbol.toStringTag, { value: "Module" })), eo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LControlScale",
  props: Me,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(H), { options: r, methods: l } = xe(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { control: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(a.scale(r)), L(l, t.value, e), s({ leafletObject: t.value }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), Be = {
  ...F,
  zoomInText: {
    type: String
  },
  zoomInTitle: {
    type: String
  },
  zoomOutText: {
    type: String
  },
  zoomOutTitle: {
    type: String
  }
}, Re = (e, o) => {
  const { options: t, methods: n } = K(
    e,
    o
  );
  return { options: f(
    e,
    Be,
    t
  ), methods: n };
}, Ct = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  controlZoomProps: Be,
  setupControlZoom: Re
}, Symbol.toStringTag, { value: "Module" })), to = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LControlZoom",
  props: Be,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(H), { options: r, methods: l } = Re(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { control: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(a.zoom(r)), L(l, t.value, e), s({ leafletObject: t.value }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), te = {
  ...D
}, se = (e, o, t) => {
  const { options: n, methods: s } = q(
    e,
    o,
    t
  ), r = f(
    e,
    te,
    n
  ), l = {
    ...s,
    addLayer(a) {
      o.value.addLayer(a.leafletObject);
    },
    removeLayer(a) {
      o.value.removeLayer(a.leafletObject);
    }
  };
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(M, l.addLayer), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(ee, l.removeLayer), { options: r, methods: l };
}, Tt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  layerGroupProps: te,
  setupLayerGroup: se
}, Symbol.toStringTag, { value: "Module" })), we = {
  ...te
}, et = (e, o, t) => {
  const { options: n, methods: s } = se(
    e,
    o,
    t
  ), r = f(
    e,
    we,
    n
  ), l = {
    ...s
  };
  return { options: r, methods: l };
}, Mt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  featureGroupProps: we,
  setupFeatureGroup: et
}, Symbol.toStringTag, { value: "Module" })), oo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: we,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { methods: l, options: a } = et(
      e,
      t,
      o
    );
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { featureGroup: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        i(void 0, a)
      );
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(l, t.value, e), r({
        ...e,
        ...l,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), Ie = {
  ...te,
  geojson: {
    type: [Object, Array],
    custom: !0
  },
  optionsStyle: {
    type: Function,
    custom: !0
  }
}, tt = (e, o, t) => {
  const { options: n, methods: s } = se(
    e,
    o,
    t
  ), r = f(
    e,
    Ie,
    n
  );
  Object.prototype.hasOwnProperty.call(e, "optionsStyle") && (r.style = e.optionsStyle);
  const l = {
    ...s,
    setGeojson(a) {
      o.value.clearLayers(), o.value.addData(a);
    },
    setOptionsStyle(a) {
      o.value.setStyle(a);
    },
    getGeoJSONData() {
      return o.value.toGeoJSON();
    },
    getBounds() {
      return o.value.getBounds();
    }
  };
  return { options: r, methods: l };
}, Bt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  geoJSONProps: Ie,
  setupGeoJSON: tt
}, Symbol.toStringTag, { value: "Module" })), no = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: Ie,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { methods: l, options: a } = tt(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { geoJSON: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(i(e.geojson, a));
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(l, t.value, e), r({
        ...e,
        ...l,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), ae = {
  ...D,
  opacity: {
    type: Number
  },
  zIndex: {
    type: Number
  },
  tileSize: {
    type: [Number, Array, Object]
  },
  noWrap: {
    type: Boolean,
    default: void 0
  },
  minZoom: {
    type: Number
  },
  maxZoom: {
    type: Number
  },
  className: {
    type: String
  }
}, Ae = (e, o, t) => {
  const { options: n, methods: s } = q(
    e,
    o,
    t
  ), r = f(
    e,
    ae,
    n
  ), l = {
    ...s,
    setTileComponent() {
      var a;
      (a = o.value) == null || a.redraw();
    }
  };
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onUnmounted)(() => {
    o.value.off();
  }), { options: r, methods: l };
}, ot = (e, o, t, n) => e.extend({
  initialize(s) {
    this.tileComponents = {}, this.on("tileunload", this._unloadTile), t.setOptions(this, s);
  },
  createTile(s) {
    const r = this._tileCoordsToKey(s);
    this.tileComponents[r] = o.create("div");
    const l = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)({ setup: n, props: ["coords"] }, { coords: s });
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.render)(l, this.tileComponents[r]), this.tileComponents[r];
  },
  _unloadTile(s) {
    const r = this._tileCoordsToKey(s.coords);
    this.tileComponents[r] && (this.tileComponents[r].innerHTML = "", this.tileComponents[r] = void 0);
  }
}), wt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  CreateVueGridLayer: ot,
  gridLayerProps: ae,
  setupGridLayer: Ae
}, Symbol.toStringTag, { value: "Module" })), ro = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: {
    ...ae,
    childRender: {
      type: Function,
      required: !0
    }
  },
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), r = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), l = m(M), { options: a, methods: i } = Ae(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { GridLayer: u, DomUtil: d, Util: y } = r ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js")), w = ot(
        u,
        d,
        y,
        e.childRender
      );
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(new w(a));
      const { listeners: v } = T(o.attrs);
      t.value.on(v), L(i, t.value, e), l({
        ...e,
        ...i,
        leafletObject: t.value
      }), s.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { root: n, ready: s, leafletObject: t };
  },
  render() {
    return this.ready ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { style: { display: "none" }, ref: "root" }) : null;
  }
}), de = {
  iconUrl: {
    type: String
  },
  iconRetinaUrl: {
    type: String
  },
  iconSize: {
    type: [Object, Array]
  },
  iconAnchor: {
    type: [Object, Array]
  },
  popupAnchor: {
    type: [Object, Array]
  },
  tooltipAnchor: {
    type: [Object, Array]
  },
  shadowUrl: {
    type: String
  },
  shadowRetinaUrl: {
    type: String
  },
  shadowSize: {
    type: [Object, Array]
  },
  shadowAnchor: {
    type: [Object, Array]
  },
  bgPos: {
    type: [Object, Array]
  },
  className: {
    type: String
  }
}, It = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  iconProps: de
}, Symbol.toStringTag, { value: "Module" })), so = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LIcon",
  props: {
    ...de,
    ...W
  },
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(ve), r = m(be), l = m(fe);
    let a, i, u, d, y;
    const w = (N, P, B) => {
      const I = N && N.innerHTML;
      if (!P) {
        B && y && s() && r(I);
        return;
      }
      const { listeners: E } = T(o.attrs);
      y && i(y, E);
      const { options: ue } = J(e), $ = f(
        e,
        de,
        ue
      );
      I && ($.html = I), y = $.html ? u($) : d($), a(y, E), l(y);
    }, v = () => {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => w(t.value, !0, !1));
    }, z = () => {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => w(t.value, !1, !0));
    }, Z = {
      setIconUrl: v,
      setIconRetinaUrl: v,
      setIconSize: v,
      setIconAnchor: v,
      setPopupAnchor: v,
      setTooltipAnchor: v,
      setShadowUrl: v,
      setShadowRetinaUrl: v,
      setShadowAnchor: v,
      setBgPos: v,
      setClassName: v,
      setHtml: v
    };
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const {
        DomEvent: N,
        divIcon: P,
        icon: B
      } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      a = N.on, i = N.off, u = P, d = B, L(Z, {}, e), new MutationObserver(z).observe(t.value, {
        attributes: !0,
        childList: !0,
        characterData: !0,
        subtree: !0
      }), v();
    }), { root: t };
  },
  render() {
    const e = this.$slots.default ? this.$slots.default() : void 0;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "root" }, e);
  }
}), Ge = {
  ...D,
  opacity: {
    type: Number
  },
  alt: {
    type: String
  },
  interactive: {
    type: Boolean,
    default: void 0
  },
  crossOrigin: {
    type: Boolean,
    default: void 0
  },
  errorOverlayUrl: {
    type: String
  },
  zIndex: {
    type: Number
  },
  className: {
    type: String
  },
  url: {
    type: String,
    required: !0,
    custom: !0
  },
  bounds: {
    type: [Array, Object],
    required: !0,
    custom: !0
  }
}, nt = (e, o, t) => {
  const { options: n, methods: s } = q(
    e,
    o,
    t
  ), r = f(
    e,
    Ge,
    n
  ), l = {
    ...s,
    /**
     * Sets the opacity of the overlay.
     * @param {number} opacity
     */
    setOpacity(a) {
      return o.value.setOpacity(a);
    },
    /**
     * Changes the URL of the image.
     * @param {string} url
     */
    setUrl(a) {
      return o.value.setUrl(a);
    },
    /**
     * Update the bounds that this ImageOverlay covers
     * @param {LatLngBounds | Array<Array<number>>} bounds
     */
    setBounds(a) {
      return o.value.setBounds(a);
    },
    /**
     * Get the bounds that this ImageOverlay covers
     * @returns {LatLngBounds}
     */
    getBounds() {
      return o.value.getBounds();
    },
    /**
     * Returns the instance of HTMLImageElement used by this overlay.
     * @returns {HTMLElement}
     */
    getElement() {
      return o.value.getElement();
    },
    /**
     * Brings the layer to the top of all overlays.
     */
    bringToFront() {
      return o.value.bringToFront();
    },
    /**
     * Brings the layer to the bottom of all overlays.
     */
    bringToBack() {
      return o.value.bringToBack();
    },
    /**
     * Changes the zIndex of the image overlay.
     * @param {number} zIndex
     */
    setZIndex(a) {
      return o.value.setZIndex(a);
    }
  };
  return { options: r, methods: l };
}, At = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  imageOverlayProps: Ge,
  setupImageOverlay: nt
}, Symbol.toStringTag, { value: "Module" })), ao = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LImageOverlay",
  props: Ge,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = nt(
      e,
      t,
      o
    );
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { imageOverlay: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        i(e.url, e.bounds, l)
      );
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), lo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: te,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { methods: l } = se(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { layerGroup: a } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        a(void 0, e.options)
      );
      const { listeners: i } = T(o.attrs);
      t.value.on(i), L(l, t.value, e), r({
        ...e,
        ...l,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
});
function rt(e, o, t) {
  var n, s, r;
  o === void 0 && (o = 50), t === void 0 && (t = {});
  var l = (n = t.isImmediate) != null && n, a = (s = t.callback) != null && s, i = t.maxWait, u = Date.now(), d = [];
  function y() {
    if (i !== void 0) {
      var v = Date.now() - u;
      if (v + o >= i)
        return i - v;
    }
    return o;
  }
  var w = function() {
    var v = [].slice.call(arguments), z = this;
    return new Promise(function(Z, N) {
      var P = l && r === void 0;
      if (r !== void 0 && clearTimeout(r), r = setTimeout(function() {
        if (r = void 0, u = Date.now(), !l) {
          var I = e.apply(z, v);
          a && a(I), d.forEach(function(E) {
            return (0, E.resolve)(I);
          }), d = [];
        }
      }, y()), P) {
        var B = e.apply(z, v);
        return a && a(B), Z(B);
      }
      d.push({ resolve: Z, reject: N });
    });
  };
  return w.cancel = function(v) {
    r !== void 0 && clearTimeout(r), d.forEach(function(z) {
      return (0, z.reject)(v);
    }), d = [];
  }, w;
}
const We = {
  ...W,
  /**
   * The center of the map, supports .sync modifier
   */
  center: {
    type: [Object, Array]
  },
  /**
   * The bounds of the map, supports .sync modifier
   */
  bounds: {
    type: [Array, Object]
  },
  /**
   * The max bounds of the map
   */
  maxBounds: {
    type: [Array, Object]
  },
  /**
   * The zoom of the map, supports .sync modifier
   */
  zoom: {
    type: Number
  },
  /**
   * The minZoom of the map
   */
  minZoom: {
    type: Number
  },
  /**
   * The maxZoom of the map
   */
  maxZoom: {
    type: Number
  },
  /**
   * The paddingBottomRight of the map
   */
  paddingBottomRight: {
    type: [Object, Array]
  },
  /**
   * The paddingTopLeft of the map
   */
  paddingTopLeft: {
    type: Object
  },
  /**
   * The padding of the map
   */
  padding: {
    type: Object
  },
  /**
   * The worldCopyJump option for the map
   */
  worldCopyJump: {
    type: Boolean,
    default: void 0
  },
  /**
   * The CRS to use for the map. Can be an object that defines a coordinate reference
   * system for projecting geographical points into screen coordinates and back
   * (see https://leafletjs.com/reference-1.7.1.html#crs-l-crs-base), or a string
   * name identifying one of Leaflet's defined CRSs, such as "EPSG4326".
   */
  crs: {
    type: [String, Object]
  },
  maxBoundsViscosity: {
    type: Number
  },
  inertia: {
    type: Boolean,
    default: void 0
  },
  inertiaDeceleration: {
    type: Number
  },
  inertiaMaxSpeed: {
    type: Number
  },
  easeLinearity: {
    type: Number
  },
  zoomAnimation: {
    type: Boolean,
    default: void 0
  },
  zoomAnimationThreshold: {
    type: Number
  },
  fadeAnimation: {
    type: Boolean,
    default: void 0
  },
  markerZoomAnimation: {
    type: Boolean,
    default: void 0
  },
  noBlockingAnimations: {
    type: Boolean,
    default: void 0
  },
  useGlobalLeaflet: {
    type: Boolean,
    default: !0,
    custom: !0
  }
}, io = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  inheritAttrs: !1,
  emits: ["ready", "update:zoom", "update:center", "update:bounds"],
  props: We,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.reactive)({
      ready: !1,
      layersToAdd: [],
      layersInControl: []
    }), { options: s } = J(e), r = f(
      e,
      We,
      s
    ), { listeners: l, attrs: a } = T(o.attrs), i = Y(M), u = Y(ee), d = Y(H), y = Y(
      me
    );
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(h, e.useGlobalLeaflet);
    const w = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const P = {};
      return e.noBlockingAnimations && (P.animate = !1), P;
    }), v = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      const P = w.value;
      return e.padding && (P.padding = e.padding), e.paddingTopLeft && (P.paddingTopLeft = e.paddingTopLeft), e.paddingBottomRight && (P.paddingBottomRight = e.paddingBottomRight), P;
    }), z = {
      moveend: rt((P) => {
        n.leafletRef && (o.emit("update:zoom", n.leafletRef.getZoom()), o.emit("update:center", n.leafletRef.getCenter()), o.emit("update:bounds", n.leafletRef.getBounds()));
      }),
      overlayadd(P) {
        const B = n.layersInControl.find((I) => I.name === P.name);
        B && B.updateVisibleProp(!0);
      },
      overlayremove(P) {
        const B = n.layersInControl.find((I) => I.name === P.name);
        B && B.updateVisibleProp(!1);
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      e.useGlobalLeaflet && (b.L = b.L || await Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(__webpack_require__, /*! leaflet */ "./node_modules/leaflet/dist/leaflet-src.js", 23)));
      const { map: P, CRS: B, Icon: I, latLngBounds: E, latLng: ue, stamp: $ } = e.useGlobalLeaflet ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      try {
        r.beforeMapMount && await r.beforeMapMount();
      } catch (p) {
        console.error(
          `The following error occurred running the provided beforeMapMount hook ${p.message}`
        );
      }
      await qe(I);
      const yt = typeof r.crs == "string" ? B[r.crs] : r.crs;
      r.crs = yt || B.EPSG3857;
      const Q = {
        addLayer(p) {
          p.layerType !== void 0 && (n.layerControl === void 0 ? n.layersToAdd.push(p) : n.layersInControl.find(
            (X) => $(X.leafletObject) === $(p.leafletObject)
          ) || (n.layerControl.addLayer(p), n.layersInControl.push(p))), p.visible !== !1 && n.leafletRef.addLayer(p.leafletObject);
        },
        removeLayer(p) {
          p.layerType !== void 0 && (n.layerControl === void 0 ? n.layersToAdd = n.layersToAdd.filter(
            (C) => C.name !== p.name
          ) : (n.layerControl.removeLayer(p.leafletObject), n.layersInControl = n.layersInControl.filter(
            (C) => $(C.leafletObject) !== $(p.leafletObject)
          ))), n.leafletRef.removeLayer(p.leafletObject);
        },
        registerLayerControl(p) {
          n.layerControl = p, n.layersToAdd.forEach((C) => {
            n.layerControl.addLayer(C);
          }), n.layersToAdd = [], d(p);
        },
        registerControl(p) {
          n.leafletRef.addControl(p.leafletObject);
        },
        setZoom(p) {
          const C = n.leafletRef.getZoom();
          p !== C && n.leafletRef.setZoom(p, w.value);
        },
        setCrs(p) {
          const C = n.leafletRef.getBounds();
          n.leafletRef.options.crs = p, n.leafletRef.fitBounds(C, {
            animate: !1,
            padding: [0, 0]
          });
        },
        fitBounds(p) {
          n.leafletRef.fitBounds(p, v.value);
        },
        setBounds(p) {
          if (!p)
            return;
          const C = E(p);
          if (!C.isValid())
            return;
          !(n.lastSetBounds || n.leafletRef.getBounds()).equals(C, 0) && (n.lastSetBounds = C, n.leafletRef.fitBounds(C));
        },
        setCenter(p) {
          if (p == null)
            return;
          const C = ue(p), X = n.lastSetCenter || n.leafletRef.getCenter();
          (X.lat !== C.lat || X.lng !== C.lng) && (n.lastSetCenter = C, n.leafletRef.panTo(C, w.value));
        }
      };
      V(i, Q.addLayer), V(u, Q.removeLayer), V(d, Q.registerControl), V(y, Q.registerLayerControl), n.leafletRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(P(t.value, r)), L(Q, n.leafletRef, e), ce(n.leafletRef, z), ce(n.leafletRef, l), n.ready = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", n.leafletRef));
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      ye(z), n.leafletRef && (n.leafletRef.off(), n.leafletRef.remove());
    });
    const Z = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => n.leafletRef), N = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => n.ready);
    return { root: t, ready: N, leafletObject: Z, attrs: a };
  },
  render({ attrs: e }) {
    return e.style || (e.style = {}), e.style.width || (e.style.width = "100%"), e.style.height || (e.style.height = "100%"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(
      "div",
      {
        ...e,
        ref: "root"
      },
      this.ready && this.$slots.default ? this.$slots.default() : {}
    );
  }
}), Gt = ["Symbol(Comment)", "Symbol(Text)"], zt = ["LTooltip", "LPopup"], ze = {
  ...D,
  draggable: {
    type: Boolean,
    default: void 0
  },
  icon: {
    type: [Object]
  },
  zIndexOffset: {
    type: Number
  },
  latLng: {
    type: [Object, Array],
    custom: !0,
    required: !0
  }
}, st = (e, o, t) => {
  const { options: n, methods: s } = q(
    e,
    o,
    t
  ), r = f(
    e,
    ze,
    n
  ), l = {
    ...s,
    setDraggable(a) {
      o.value.dragging && (a ? o.value.dragging.enable() : o.value.dragging.disable());
    },
    latLngSync(a) {
      t.emit("update:latLng", a.latlng), t.emit("update:lat-lng", a.latlng);
    },
    setLatLng(a) {
      if (a != null && o.value) {
        const i = o.value.getLatLng();
        (!i || !i.equals(a)) && o.value.setLatLng(a);
      }
    }
  };
  return { options: r, methods: l };
}, at = (e, o) => {
  const t = o.slots.default && o.slots.default();
  return t && t.length && t.some(Nt);
};
function Nt(e) {
  return !(Gt.includes(e.type.toString()) || zt.includes(e.type.name));
}
const $t = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  markerProps: ze,
  setupMarker: st,
  shouldBlankIcon: at
}, Symbol.toStringTag, { value: "Module" })), uo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LMarker",
  props: ze,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(
      ve,
      () => {
        var u;
        return !!((u = t.value) != null && u.getElement());
      }
    ), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(be, (u) => {
      var y, w;
      const d = k((y = t.value) == null ? void 0 : y.getElement) && ((w = t.value) == null ? void 0 : w.getElement());
      d && (d.innerHTML = u);
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(
      fe,
      (u) => {
        var d;
        return ((d = t.value) == null ? void 0 : d.setIcon) && t.value.setIcon(u);
      }
    );
    const { options: l, methods: a } = st(e, t, o), i = {
      moveHandler: rt(a.latLngSync)
    };
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { marker: u, divIcon: d } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      at(l, o) && (l.icon = d({ className: "" })), t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(u(e.latLng, l));
      const { listeners: y } = T(o.attrs);
      t.value.on(y), t.value.on("move", i.moveHandler), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => ye(i)), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), le = {
  ...ne,
  smoothFactor: {
    type: Number
  },
  noClip: {
    type: Boolean,
    default: void 0
  },
  latLngs: {
    type: Array,
    required: !0,
    custom: !0
  }
}, Ne = (e, o, t) => {
  const { options: n, methods: s } = _e(
    e,
    o,
    t
  ), r = f(
    e,
    le,
    n
  ), l = {
    ...s,
    setSmoothFactor(a) {
      o.value.setStyle({ smoothFactor: a });
    },
    setNoClip(a) {
      o.value.setStyle({ noClip: a });
    },
    addLatLng(a) {
      o.value.addLatLng(a);
    }
  };
  return { options: r, methods: l };
}, kt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  polylineProps: le,
  setupPolyline: Ne
}, Symbol.toStringTag, { value: "Module" })), x = {
  ...le
}, $e = (e, o, t) => {
  const { options: n, methods: s } = Ne(
    e,
    o,
    t
  ), r = f(
    e,
    x,
    n
  ), l = {
    ...s,
    toGeoJSON(a) {
      return o.value.toGeoJSON(a);
    }
  };
  return { options: r, methods: l };
}, Ut = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  polygonProps: x,
  setupPolygon: $e
}, Symbol.toStringTag, { value: "Module" })), co = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LPolygon",
  props: x,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = $e(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { polygon: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(i(e.latLngs, l));
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), po = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LPolyline",
  props: le,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = Ne(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { polyline: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        i(e.latLngs, l)
      );
      const { listeners: u } = T(o.attrs);
      t.value.on(u), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), ke = {
  ...W,
  content: {
    type: String,
    default: null
  }
}, Ue = (e, o) => {
  const { options: t, methods: n } = J(e), s = {
    ...n,
    setContent(r) {
      o.value && r !== null && r !== void 0 && o.value.setContent(r);
    }
  };
  return { options: t, methods: s };
}, De = (e) => e.default ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "root" }, e.default()) : null, Dt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  popperProps: ke,
  render: De,
  setupPopper: Ue
}, Symbol.toStringTag, { value: "Module" })), lt = {
  ...ke,
  latLng: {
    type: [Object, Array],
    default: () => []
  }
}, it = (e, o) => {
  const { options: t, methods: n } = Ue(e, o);
  return { options: t, methods: n };
}, Ft = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  popupProps: lt,
  setupPopup: it
}, Symbol.toStringTag, { value: "Module" })), yo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LPopup",
  props: lt,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(ge), l = m(he), { options: a, methods: i } = it(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { popup: u } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(u(a)), e.latLng !== void 0 && t.value.setLatLng(e.latLng), L(i, t.value, e);
      const { listeners: d } = T(o.attrs);
      t.value.on(d), t.value.setContent(e.content || n.value || ""), r(t.value), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      l();
    }), { root: n, leafletObject: t };
  },
  render() {
    return De(this.$slots);
  }
}), Fe = {
  ...x,
  latLngs: {
    ...x.latLngs,
    required: !1
  },
  bounds: {
    type: Object,
    custom: !0
  }
}, ut = (e, o, t) => {
  const { options: n, methods: s } = $e(
    e,
    o,
    t
  ), r = f(
    e,
    Fe,
    n
  ), l = {
    ...s,
    setBounds(a) {
      o.value.setBounds(a);
    },
    setLatLngs(a) {
      o.value.setBounds(a);
    }
  };
  return { options: r, methods: l };
}, Zt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  rectangleProps: Fe,
  setupRectangle: ut
}, Symbol.toStringTag, { value: "Module" })), mo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LRectangle",
  props: Fe,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!1), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(M), { options: l, methods: a } = ut(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { rectangle: i, latLngBounds: u } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js")), d = e.bounds ? u(e.bounds) : u(e.latLngs || []);
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(i(d, l));
      const { listeners: y } = T(o.attrs);
      t.value.on(y), L(a, t.value, e), r({
        ...e,
        ...a,
        leafletObject: t.value
      }), n.value = !0, (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { ready: n, leafletObject: t };
  },
  render() {
    return G(this.ready, this.$slots);
  }
}), ie = {
  ...ae,
  tms: {
    type: Boolean,
    default: void 0
  },
  subdomains: {
    type: [String, Array],
    validator: (e) => typeof e == "string" ? !0 : Array.isArray(e) ? e.every((o) => typeof o == "string") : !1
  },
  detectRetina: {
    type: Boolean,
    default: void 0
  },
  url: {
    type: String,
    required: !0,
    custom: !0
  }
}, Ze = (e, o, t) => {
  const { options: n, methods: s } = Ae(e, o, t), r = f(
    e,
    ie,
    n
  ), l = {
    ...s
  };
  return { options: r, methods: l };
}, Et = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  setupTileLayer: Ze,
  tileLayerProps: ie
}, Symbol.toStringTag, { value: "Module" })), vo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: ie,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(M), { options: r, methods: l } = Ze(e, t, o);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { tileLayer: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(a(e.url, r));
      const { listeners: i } = T(o.attrs);
      t.value.on(i), L(l, t.value, e), s({
        ...e,
        ...l,
        leafletObject: t.value
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), ct = {
  ...ke
}, dt = (e, o) => {
  const { options: t, methods: n } = Ue(e, o), s = m(Oe);
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
    s();
  }), { options: t, methods: n };
}, Ht = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  setupTooltip: dt,
  tooltipProps: ct
}, Symbol.toStringTag, { value: "Module" })), bo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "LTooltip",
  props: ct,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null), s = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), r = m(Le), { options: l, methods: a } = dt(e, t);
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { tooltip: i } = s ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(i(l)), L(a, t.value, e);
      const { listeners: u } = T(o.attrs);
      t.value.on(u), t.value.setContent(e.content || n.value || ""), r(t.value), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { root: n, leafletObject: t };
  },
  render() {
    return De(this.$slots);
  }
}), Ee = {
  ...ie,
  layers: {
    type: String,
    required: !0
  },
  styles: {
    type: String
  },
  format: {
    type: String
  },
  transparent: {
    type: Boolean,
    default: void 0
  },
  version: {
    type: String
  },
  crs: {
    type: Object
  },
  uppercase: {
    type: Boolean,
    default: void 0
  }
}, pt = (e, o, t) => {
  const { options: n, methods: s } = Ze(e, o, t);
  return {
    options: f(
      e,
      Ee,
      n
    ),
    methods: {
      ...s
    }
  };
}, Wt = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  setupWMSTileLayer: pt,
  wmsTileLayerProps: Ee
}, Symbol.toStringTag, { value: "Module" })), fo = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  props: Ee,
  setup(e, o) {
    const t = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(), n = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(h), s = m(M), { options: r, methods: l } = pt(
      e,
      t,
      o
    );
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(async () => {
      const { tileLayer: a } = n ? b.L : await __webpack_require__.e(/*! import() */ "node_modules_leaflet_dist_leaflet-src_esm_js").then(__webpack_require__.bind(__webpack_require__, /*! leaflet/dist/leaflet-src.esm */ "./node_modules/leaflet/dist/leaflet-src.esm.js"));
      t.value = (0,vue__WEBPACK_IMPORTED_MODULE_0__.markRaw)(
        a.wms(e.url, r)
      );
      const { listeners: i } = T(o.attrs);
      t.value.on(i), L(l, t.value, e), s({
        ...e,
        ...l,
        leafletObject: t.value
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => o.emit("ready", t.value));
    }), { leafletObject: t };
  },
  render() {
    return null;
  }
}), go = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Circle: Ot,
  CircleMarker: ht,
  Component: bt,
  Control: St,
  ControlAttribution: _t,
  ControlLayers: jt,
  ControlScale: Pt,
  ControlZoom: Ct,
  FeatureGroup: Mt,
  GeoJSON: Bt,
  GridLayer: wt,
  Icon: It,
  ImageOverlay: At,
  InteractiveLayer: gt,
  Layer: ft,
  LayerGroup: Tt,
  Marker: $t,
  Path: Lt,
  Polygon: Ut,
  Polyline: kt,
  Popper: Dt,
  Popup: Ft,
  Rectangle: Zt,
  TileLayer: Et,
  Tooltip: Ht,
  WmsTileLayer: Wt
}, Symbol.toStringTag, { value: "Module" }));



/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Components/Popups/DeletePopup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue");
/* harmony import */ var _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_DetailSection_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/DetailSection.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/DetailSection.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_BriefDetails_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/BriefDetails.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_BriefInsights_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/BriefInsights.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_ActivitiesSection_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue");
/* harmony import */ var _Brief_Shared_Components_MetaData_MetaData_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @Brief/Shared/Components/MetaData/MetaData.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/MetaData/MetaData.vue");
/* harmony import */ var _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @Brief/Shared/Composables/functions */ "./resources/js/Pages/Admin/Brief/Shared/Composables/functions.js");
/* harmony import */ var ziggy_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ziggy-js */ "./node_modules/ziggy-js/dist/index.js");
/* harmony import */ var ziggy_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(ziggy_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _Brief_Shared_Components_EventsLog_EventsLog_vue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @Brief/Shared/Components/EventsLog/EventsLog.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_RelatedBriefs_vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue");
/* harmony import */ var _Brief_Brief_BriefDetailLayout__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @Brief/Brief/BriefDetailLayout */ "./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_Detail_BriefActivities_vue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/Detail/BriefActivities.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }












// import TimeLine from "@Brief/Shared/Components/TimeLine/TimeLine.vue";







/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'BriefDetail',
  props: {
    page: {
      type: Object,
      required: true
    },
    briefDetails: {
      type: Array,
      required: true
    },
    brief: {
      type: Object,
      required: true
    },
    activities: {
      type: Object,
      required: true
    },
    logs: {
      type: Object,
      required: true
    },
    linkLogs: {
      type: Object,
      required: true
    },
    relatedBrief: {
      type: Object,
      required: true
    },
    metaData: {
      type: Object,
      required: true
    },
    briefID: Number,
    activitiesLogs: {
      type: Object,
      required: true
    },
    authUserRole: String,
    total_cost: Number,
    submissionAccuracy: Number
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_17__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var deletePopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);

    // const visitToEdit = () => {
    //     router.visit(route('admin.brief.edit.id', { id: props.brief.id }));
    // };

    var handleClick = function handleClick(event, briefId, briefType) {
      var fingerprintValue = fingerprint.value;
      if ((event === null || event === void 0 ? void 0 : event.type) === 'click') {
        axios__WEBPACK_IMPORTED_MODULE_16___default().post(ziggy_js__WEBPACK_IMPORTED_MODULE_11___default()('brief.copy.activity'), {
          id: briefId,
          brief_type: briefType,
          fingerprint: fingerprintValue
        });
      }
    };
    var badgeClass = function badgeClass(briefType) {
      switch (briefType) {
        case "logo_brief":
          return "success";
        case "web_brief":
          return "secondary";
        case "video_brief":
          return "info";
        case "smm_brief":
          return "warning";
        case "sem_brief":
          return "dark";
        case "mobile_app_brief":
          return "danger";
        default:
          return "primary";
      }
    };
    var __returned__ = {
      props: props,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      deletePopupVisibility: deletePopupVisibility,
      handleClick: handleClick,
      badgeClass: badgeClass,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router;
      },
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_18__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_19__["default"];
      },
      DeletePopup: _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      Tooltip: _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
      DetailSection: _Brief_Shared_Components_Brief_Detail_DetailSection_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      BriefDetails: _Brief_Shared_Components_Brief_Detail_BriefDetails_vue__WEBPACK_IMPORTED_MODULE_6__["default"],
      BriefInsights: _Brief_Shared_Components_Brief_Detail_BriefInsights_vue__WEBPACK_IMPORTED_MODULE_7__["default"],
      ActivitiesSection: _Brief_Shared_Components_Brief_Detail_ActivitiesSection_vue__WEBPACK_IMPORTED_MODULE_8__["default"],
      MetaData: _Brief_Shared_Components_MetaData_MetaData_vue__WEBPACK_IMPORTED_MODULE_9__["default"],
      get formatText() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_10__.formatText;
      },
      get route() {
        return (ziggy_js__WEBPACK_IMPORTED_MODULE_11___default());
      },
      EventsLog: _Brief_Shared_Components_EventsLog_EventsLog_vue__WEBPACK_IMPORTED_MODULE_12__["default"],
      RelatedBriefs: _Brief_Shared_Components_Brief_Detail_RelatedBriefs_vue__WEBPACK_IMPORTED_MODULE_13__["default"],
      get BriefDetailLayout() {
        return _Brief_Brief_BriefDetailLayout__WEBPACK_IMPORTED_MODULE_14__["default"];
      },
      BriefActivities: _Brief_Shared_Components_Brief_Detail_BriefActivities_vue__WEBPACK_IMPORTED_MODULE_15__["default"],
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_16___default());
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_17__.useFingerprint;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=script&setup=true&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=script&setup=true&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var ziggy_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ziggy-js */ "./node_modules/ziggy-js/dist/index.js");
/* harmony import */ var ziggy_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(ziggy_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Brief/Shared/Composables/Brief/useDownload */ "./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js");
/* harmony import */ var _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Components/Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
/* harmony import */ var _Brief_Shared_Components_Table_Pagination_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Brief/Shared/Components/Table/Pagination.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Table/Pagination.vue");
/* harmony import */ var _Brief_Shared_Components_Title_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @Brief/Shared/Components/Title.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Title.vue");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @Admin/Shared/Components/Popups/DeletePopup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue");
/* harmony import */ var _Admin_Brief_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @Admin/Brief/Shared/Composables/useNotification */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }











/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'BriefDetailLayout',
  props: {
    page: Object !== null && Object !== void 0 ? Object : null,
    briefs: Object,
    briefDetailTab: {
      type: Object,
      required: true
    },
    briefActivityTab: {
      type: Object,
      required: true
    },
    briefID: Number,
    briefData: {
      type: Object,
      required: true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    var deletePopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_8__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      logFingerprint();
    });
    var handleClick = function handleClick(event, briefId, briefType) {
      var fingerprintValue = fingerprint.value;
      if ((event === null || event === void 0 ? void 0 : event.type) === 'click') {
        axios__WEBPACK_IMPORTED_MODULE_7___default().post(ziggy_js__WEBPACK_IMPORTED_MODULE_2___default()('brief.copy.activity'), {
          id: briefId,
          brief_type: briefType,
          fingerprint: fingerprintValue
        });
      }
    };
    var visitAddBrief = function visitAddBrief() {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(ziggy_js__WEBPACK_IMPORTED_MODULE_2___default()("brief.link.add"), {
        method: "get",
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var downloadBriefByType = function downloadBriefByType(encoded_id, name, brief_type) {
      var _useDownload = (0,_Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__.useDownload)(),
        download = _useDownload.download,
        downloadWebBrief = _useDownload.downloadWebBrief,
        downloadVideoBrief = _useDownload.downloadVideoBrief,
        downloadSmmBrief = _useDownload.downloadSmmBrief,
        downloadSemBrief = _useDownload.downloadSemBrief,
        downloadAppBrief = _useDownload.downloadAppBrief;
      var fingerprintValue = fingerprint.value;
      if (brief_type == "logo_brief") {
        download(encoded_id, name, fingerprintValue);
      } else if (brief_type == "web_brief") {
        downloadWebBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "video_brief") {
        downloadVideoBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "smm_brief") {
        downloadSmmBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "sem_brief") {
        downloadSemBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "mobile_app_brief") {
        downloadAppBrief(encoded_id, name, fingerprintValue);
      }
    };
    var __returned__ = {
      props: props,
      fingerprint: fingerprint,
      deletePopupVisibility: deletePopupVisibility,
      logFingerprint: logFingerprint,
      handleClick: handleClick,
      visitAddBrief: visitAddBrief,
      downloadBriefByType: downloadBriefByType,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      get route() {
        return (ziggy_js__WEBPACK_IMPORTED_MODULE_2___default());
      },
      get useDownload() {
        return _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_3__.useDownload;
      },
      Tooltip: _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
      Pagination: _Brief_Shared_Components_Table_Pagination_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      Title: _Brief_Shared_Components_Title_vue__WEBPACK_IMPORTED_MODULE_6__["default"],
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_7___default());
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_8__.useFingerprint;
      },
      DeletePopup: _Admin_Shared_Components_Popups_DeletePopup_vue__WEBPACK_IMPORTED_MODULE_9__["default"],
      get useNotification() {
        return _Admin_Brief_Shared_Composables_useNotification__WEBPACK_IMPORTED_MODULE_10__.useNotification;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Select',
  props: {
    options: {
      type: Array,
      required: true
    },
    suffix: String,
    "class": String,
    hideArrow: Boolean,
    hideChecks: Boolean,
    modelValue: [String, Number],
    disabled: Boolean,
    inputStyleDefault: {
      type: Boolean,
      "default": true
    },
    inputStyle: String,
    dropDownStyleDefault: {
      type: Boolean,
      "default": true
    },
    dropDownStyle: String
  },
  emits: ['update:modelValue'],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emit = __emit;
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var selected = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      label: '',
      value: null
    });
    var updateSelected = function updateSelected() {
      var _props$options;
      var value = props.modelValue || ((_props$options = props.options) === null || _props$options === void 0 || (_props$options = _props$options[0]) === null || _props$options === void 0 ? void 0 : _props$options.value);
      var matchedOption = props.options.find(function (option) {
        return option.value == value;
      });
      selected.value = matchedOption || {
        label: '',
        value: null
      };
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.modelValue;
    }, updateSelected);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.options;
    }, updateSelected, {
      immediate: true
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      if (!props.modelValue && props.options.length > 0) {
        emit('update:modelValue', props.options[0].value);
      }
      document.addEventListener('mousedown', closeSelectDrop);
    });
    var selectAreaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var checkActive = function checkActive(item) {
      return selected.value.value === item.value ? 'active' : '';
    };
    var closeSelectDrop = function closeSelectDrop(e) {
      if (visibility.value && selectAreaRef.value && !selectAreaRef.value.contains(e.target)) {
        visibility.value = false;
      }
    };
    var selectOption = function selectOption(item) {
      selected.value = item;
      visibility.value = false;
      emit('update:modelValue', item.value);
    };
    var __returned__ = {
      props: props,
      emit: emit,
      visibility: visibility,
      selected: selected,
      updateSelected: updateSelected,
      selectAreaRef: selectAreaRef,
      checkActive: checkActive,
      closeSelectDrop: closeSelectDrop,
      selectOption: selectOption,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/CreatedAtColumn.vue?vue&type=script&setup=true&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/CreatedAtColumn.vue?vue&type=script&setup=true&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'CreatedAtColumn',
  props: {
    item: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    function formatDateTime(date) {
      var options = {
        year: 'numeric',
        month: 'short',
        day: 'numeric',
        hour: 'numeric',
        minute: 'numeric',
        second: 'numeric',
        hour12: true,
        timeZone: 'America/New_York'
      };
      return date.toLocaleString('en-US', options);
    }
    var __returned__ = {
      props: props,
      formatDateTime: formatDateTime
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue?vue&type=script&setup=true&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue?vue&type=script&setup=true&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'ActivitiesSection',
  props: {
    activities: {
      type: Array,
      required: true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_0__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_1__["default"];
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=script&setup=true&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=script&setup=true&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'BriefActivities',
  props: {
    activitiesLogs: Object,
    briefID: Number,
    activityRoute: String
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var visitActivityDetailList = function visitActivityDetailList(id) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router.visit(route(props.activityRoute, {
        id: id
      }), {
        method: "get",
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var __returned__ = {
      props: props,
      visitActivityDetailList: visitActivityDetailList,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=script&setup=true&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=script&setup=true&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Brief_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @Brief/Shared/Components/Popup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue");
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _Brief_Shared_Components_TimeLine_TimeLine_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Components/TimeLine/TimeLine.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLine.vue");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _Brief_Shared_Components_Popups_BriefEdit_ProjectDetailLogoPopup_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue");
/* harmony import */ var _Brief_Shared_Components_Popups_BriefEdit_ProjectReqLogoPopup_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue");
var _props;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }



// import "leaflet/dist/leaflet.css";
// import L from 'leaflet';

// import icon from 'leaflet/dist/images/marker-icon.png';
// import iconShadow from 'leaflet/dist/images/marker-shadow.png';
// import RecentActivity from "@Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue";



// let DefaultIcon = L.icon({
//     iconUrl: (siteURL.value+icon.slice(1)),
//     shadowUrl: (siteURL.value+iconShadow.slice(1))
// });

// L.Marker.prototype.options.icon = DefaultIcon;



// import { LMap, LTileLayer,LMarker } from "@vue-leaflet/vue-leaflet";






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'BriefDetails',
  props: (_props = {
    briefDetail: Object,
    // total_cost:Number,
    // submissionAccuracy:Number,
    briefDetails: Object,
    metaData: String,
    briefID: Number,
    submitRoute: String,
    logs: Array,
    logType: String
  }, _defineProperty(_props, "logs", String), _defineProperty(_props, "designation", String), _defineProperty(_props, "routeTo", {
    type: String,
    "default": ""
  }), _props),
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var capitalizeWords = function capitalizeWords(words) {
      return words.toLowerCase().replace(/(^\w{1})|(\s+\w{1})/g, function (letter) {
        return letter.toUpperCase();
      });
    };

    // const zoom = ref(18);
    // const mapL = ref();
    // const mapShow = ref(false);
    // const attribution = '&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a> contributors';
    // const coordinates = reactive({
    //     lat: 47.41322,
    //     lng: -1.219482
    // });
    // const deviceDetails = ref();
    // const locationDetails = ref();
    // const binLookupData = ref();
    var details = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)({
      project_details: 7,
      project_requirements: 7
    });

    // onBeforeMount(async() => {
    //     deviceDetails.value = isJsonString(props.briefDetail?.device);
    //     locationDetails.value = isJsonString(props.briefDetail?.location);

    //     if(locationDetails.value?.ip) {
    //         if(locationDetails.value?.longitude) {
    //             coordinates.lat = locationDetails.value?.latitude;
    //             coordinates.lng = locationDetails.value?.longitude;
    //             mapShow.value = true;
    //         }
    //     }

    //     binLookupData.value = isJsonString(props?.briefDetail?.bin);
    // });

    var projectdetailPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)(false);
    var projectreqPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)(false);
    var showProjectDetailPopup = function showProjectDetailPopup() {
      projectdetailPopupVisibility.value = true;
    };
    var hideProjectDetailPopup = function hideProjectDetailPopup() {
      projectdetailPopupVisibility.value = false;
    };
    var showProjectReqPopup = function showProjectReqPopup() {
      projectreqPopupVisibility.value = true;
    };
    var hideProjectReqPopup = function hideProjectReqPopup() {
      projectreqPopupVisibility.value = false;
    };
    var showDetail = function showDetail(e) {
      var _parentNode, _parentNode2, _parentNode3;
      var parentNode;
      if (e.target.tagName === "A") {
        parentNode = e.target.parentNode.parentNode;
      } else if (e.target.tagName === "I") {
        parentNode = e.target.parentNode.parentNode.parentNode;
      }
      (_parentNode = parentNode) === null || _parentNode === void 0 || (_parentNode = _parentNode.querySelector(".purpleLink")) === null || _parentNode === void 0 || _parentNode.classList.toggle("showThis");
      (_parentNode2 = parentNode) === null || _parentNode2 === void 0 || (_parentNode2 = _parentNode2.querySelector(".showinnerdiv")) === null || _parentNode2 === void 0 || _parentNode2.classList.toggle("flexVisible");
      (_parentNode3 = parentNode) === null || _parentNode3 === void 0 || (_parentNode3 = _parentNode3.querySelector("i.bx-caret-right")) === null || _parentNode3 === void 0 || _parentNode3.classList.toggle("rotateIcon");
    };
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_5__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_3__.onMounted)(function () {
      logFingerprint();
    });
    var metadataPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)(false);
    var metadata = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)(props.metaData);
    var metaInputs = (0,vue__WEBPACK_IMPORTED_MODULE_3__.ref)([]);
    (0,vue__WEBPACK_IMPORTED_MODULE_3__.onMounted)(function () {
      props.metaData.forEach(function (value) {
        metaInputs.value.push({
          key: value.key,
          value: value.value
        });
      });
      if (props.metaData.length == 0) {
        addInput();
      }
    });
    var showMetaPopup = function showMetaPopup() {
      metadataPopupVisibility.value = true;
    };
    var updateMetadata = function updateMetadata() {
      var fingerprintValue = fingerprint.value;
      hideMetaPopup();
      var validMetaInputs = metaInputs.value.filter(function (metaInput) {
        return metaInput.key !== '' && metaInput.value !== '';
      });
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_4__.router.visit(route(props.submitRoute, {
        id: props === null || props === void 0 ? void 0 : props.briefID
      }), {
        method: "post",
        data: {
          metadata: validMetaInputs,
          fingerprint: fingerprintValue
        },
        replace: false,
        preserveState: false,
        preserveScroll: true
      });
    };
    var hideMetaPopup = function hideMetaPopup() {
      metadataPopupVisibility.value = false;
    };
    var removeInput = function removeInput(index) {
      if (metaInputs.value.length > 1) {
        metaInputs.value.splice(index, 1);
      }
    };
    var addInput = function addInput() {
      metaInputs.value.push({
        key: '',
        value: ''
      });
    };

    // const accuracyColor = computed(() => {
    //     const accuracy = props.submissionAccuracy;

    //     if (accuracy >= 80) {
    //       return 'green-text'; // Green for 80s and above
    //     } else if (accuracy >= 70) {
    //       return 'yellow-text'; // Yellow for 70s
    //     } else {
    //       return 'red-text'; // Red for 60s and below
    //     }
    // });

    var projectDetail = (0,vue__WEBPACK_IMPORTED_MODULE_3__.reactive)({
      first_name: "",
      last_name: "",
      email: "",
      phone: "",
      address: "",
      city: "",
      company: "",
      state: "",
      zipcode: "",
      country: 0
    });
    var __returned__ = {
      props: props,
      capitalizeWords: capitalizeWords,
      details: details,
      projectdetailPopupVisibility: projectdetailPopupVisibility,
      projectreqPopupVisibility: projectreqPopupVisibility,
      showProjectDetailPopup: showProjectDetailPopup,
      hideProjectDetailPopup: hideProjectDetailPopup,
      showProjectReqPopup: showProjectReqPopup,
      hideProjectReqPopup: hideProjectReqPopup,
      showDetail: showDetail,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      metadataPopupVisibility: metadataPopupVisibility,
      metadata: metadata,
      metaInputs: metaInputs,
      showMetaPopup: showMetaPopup,
      updateMetadata: updateMetadata,
      hideMetaPopup: hideMetaPopup,
      removeInput: removeInput,
      addInput: addInput,
      projectDetail: projectDetail,
      Popup: _Brief_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
      get siteURL() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.siteURL;
      },
      get isJsonString() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.isJsonString;
      },
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_9__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_10__["default"];
      },
      TimeLine: _Brief_Shared_Components_TimeLine_TimeLine_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      onBeforeMount: vue__WEBPACK_IMPORTED_MODULE_3__.onBeforeMount,
      reactive: vue__WEBPACK_IMPORTED_MODULE_3__.reactive,
      ref: vue__WEBPACK_IMPORTED_MODULE_3__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_3__.onMounted,
      computed: vue__WEBPACK_IMPORTED_MODULE_3__.computed,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_4__.router;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_5__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_6___default());
      },
      get formatText() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.formatText;
      },
      ProjectDetailLogoPopup: _Brief_Shared_Components_Popups_BriefEdit_ProjectDetailLogoPopup_vue__WEBPACK_IMPORTED_MODULE_7__["default"],
      ProjectReqLogoPopup: _Brief_Shared_Components_Popups_BriefEdit_ProjectReqLogoPopup_vue__WEBPACK_IMPORTED_MODULE_8__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=script&setup=true&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=script&setup=true&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var leaflet_dist_leaflet_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! leaflet/dist/leaflet.css */ "./node_modules/leaflet/dist/leaflet.css");
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! leaflet */ "./node_modules/leaflet/dist/leaflet-src.js");
/* harmony import */ var leaflet__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(leaflet__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var leaflet_dist_images_marker_icon_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! leaflet/dist/images/marker-icon.png */ "./node_modules/leaflet/dist/images/marker-icon.png");
/* harmony import */ var leaflet_dist_images_marker_shadow_png__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! leaflet/dist/images/marker-shadow.png */ "./node_modules/leaflet/dist/images/marker-shadow.png");
/* harmony import */ var _Brief_Shared_Components_Brief_RecentActivity_RecentActivity_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _vue_leaflet_vue_leaflet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @vue-leaflet/vue-leaflet */ "./node_modules/@vue-leaflet/vue-leaflet/dist/vue-leaflet.es.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_8__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }












var attribution = '&copy; <a target="_blank" href="http://osm.org/copyright">OpenStreetMap</a> contributors';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'BriefInsights',
  props: {
    briefDetail: Object,
    total_cost: Number,
    submissionAccuracy: Number,
    briefID: Number,
    logs: Array,
    logType: String,
    designation: String,
    routeTo: {
      type: String,
      "default": ""
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var DefaultIcon = leaflet__WEBPACK_IMPORTED_MODULE_2___default().icon({
      iconUrl: _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.siteURL.value + leaflet_dist_images_marker_icon_png__WEBPACK_IMPORTED_MODULE_3__["default"].slice(1),
      shadowUrl: _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.siteURL.value + leaflet_dist_images_marker_shadow_png__WEBPACK_IMPORTED_MODULE_4__["default"].slice(1)
    });
    (leaflet__WEBPACK_IMPORTED_MODULE_2___default().Marker).prototype.options.icon = DefaultIcon;
    var props = __props;
    var capitalizeWords = function capitalizeWords(words) {
      return words.toLowerCase().replace(/(^\w{1})|(\s+\w{1})/g, function (letter) {
        return letter.toUpperCase();
      });
    };
    var zoom = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)(18);
    var mapL = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)();
    var mapShow = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)(false);
    var coordinates = (0,vue__WEBPACK_IMPORTED_MODULE_6__.reactive)({
      lat: 47.41322,
      lng: -1.219482
    });
    var deviceDetails = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)();
    var locationDetails = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)();
    var binLookupData = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)();
    (0,vue__WEBPACK_IMPORTED_MODULE_6__.onBeforeMount)( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      var _props$briefDetail, _props$briefDetail2, _locationDetails$valu, _props$briefDetail3;
      var _locationDetails$valu2, _locationDetails$valu3, _locationDetails$valu4;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            deviceDetails.value = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.isJsonString)((_props$briefDetail = props.briefDetail) === null || _props$briefDetail === void 0 ? void 0 : _props$briefDetail.device);
            locationDetails.value = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.isJsonString)((_props$briefDetail2 = props.briefDetail) === null || _props$briefDetail2 === void 0 ? void 0 : _props$briefDetail2.location);
            if ((_locationDetails$valu = locationDetails.value) !== null && _locationDetails$valu !== void 0 && _locationDetails$valu.ip) {
              if ((_locationDetails$valu2 = locationDetails.value) !== null && _locationDetails$valu2 !== void 0 && _locationDetails$valu2.longitude) {
                coordinates.lat = (_locationDetails$valu3 = locationDetails.value) === null || _locationDetails$valu3 === void 0 ? void 0 : _locationDetails$valu3.latitude;
                coordinates.lng = (_locationDetails$valu4 = locationDetails.value) === null || _locationDetails$valu4 === void 0 ? void 0 : _locationDetails$valu4.longitude;
                mapShow.value = true;
              }
            }
            binLookupData.value = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.isJsonString)(props === null || props === void 0 || (_props$briefDetail3 = props.briefDetail) === null || _props$briefDetail3 === void 0 ? void 0 : _props$briefDetail3.bin);
          case 4:
          case "end":
            return _context.stop();
        }
      }, _callee);
    })));
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_6__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint)();
            case 2:
              fingerprintResult = _context2.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_6__.onMounted)(function () {
      logFingerprint();
    });
    var accuracyColor = (0,vue__WEBPACK_IMPORTED_MODULE_6__.computed)(function () {
      var accuracy = props.submissionAccuracy;
      if (accuracy >= 80) {
        return 'green-text'; // Green for 80s and above
      } else if (accuracy >= 70) {
        return 'yellow-text'; // Yellow for 70s
      } else {
        return 'red-text'; // Red for 60s and below
      }
    });
    var __returned__ = {
      get DefaultIcon() {
        return DefaultIcon;
      },
      set DefaultIcon(v) {
        DefaultIcon = v;
      },
      props: props,
      capitalizeWords: capitalizeWords,
      zoom: zoom,
      mapL: mapL,
      mapShow: mapShow,
      attribution: attribution,
      coordinates: coordinates,
      deviceDetails: deviceDetails,
      locationDetails: locationDetails,
      binLookupData: binLookupData,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      accuracyColor: accuracyColor,
      get siteURL() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.siteURL;
      },
      get isJsonString() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.isJsonString;
      },
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_9__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_10__["default"];
      },
      get L() {
        return (leaflet__WEBPACK_IMPORTED_MODULE_2___default());
      },
      get icon() {
        return leaflet_dist_images_marker_icon_png__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get iconShadow() {
        return leaflet_dist_images_marker_shadow_png__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      RecentActivity: _Brief_Shared_Components_Brief_RecentActivity_RecentActivity_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      onBeforeMount: vue__WEBPACK_IMPORTED_MODULE_6__.onBeforeMount,
      reactive: vue__WEBPACK_IMPORTED_MODULE_6__.reactive,
      ref: vue__WEBPACK_IMPORTED_MODULE_6__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_6__.onMounted,
      computed: vue__WEBPACK_IMPORTED_MODULE_6__.computed,
      get LMap() {
        return _vue_leaflet_vue_leaflet__WEBPACK_IMPORTED_MODULE_11__.LMap;
      },
      get LTileLayer() {
        return _vue_leaflet_vue_leaflet__WEBPACK_IMPORTED_MODULE_11__.LTileLayer;
      },
      get LMarker() {
        return _vue_leaflet_vue_leaflet__WEBPACK_IMPORTED_MODULE_11__.LMarker;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_8___default());
      },
      get formatText() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.formatText;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/DetailSection.vue?vue&type=script&setup=true&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/DetailSection.vue?vue&type=script&setup=true&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @Brief/Shared/Composables/functions */ "./resources/js/Pages/Admin/Brief/Shared/Composables/functions.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'DetailSection',
  props: {
    heading: {
      type: String,
      required: true
    },
    items: {
      type: Array,
      required: true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var itemsArray = (0,vue__WEBPACK_IMPORTED_MODULE_1__.computed)(function () {
      return Object.entries(props.items).map(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          key = _ref3[0],
          value = _ref3[1];
        return {
          key: key,
          value: value
        };
      });
    });
    var splitItems = (0,vue__WEBPACK_IMPORTED_MODULE_1__.computed)(function () {
      var middleIndex = Math.ceil(itemsArray.value.length / 2);
      return {
        firstHalf: itemsArray.value.slice(0, middleIndex),
        secondHalf: itemsArray.value.slice(middleIndex)
      };
    });
    var firstHalf = (0,vue__WEBPACK_IMPORTED_MODULE_1__.computed)(function () {
      return splitItems.value.firstHalf;
    });
    var secondHalf = (0,vue__WEBPACK_IMPORTED_MODULE_1__.computed)(function () {
      return splitItems.value.secondHalf;
    });
    var __returned__ = {
      props: props,
      itemsArray: itemsArray,
      splitItems: splitItems,
      firstHalf: firstHalf,
      secondHalf: secondHalf,
      get formatText() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_0__.formatText;
      },
      computed: vue__WEBPACK_IMPORTED_MODULE_1__.computed
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=script&setup=true&lang=js":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=script&setup=true&lang=js ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Brief/Shared/Composables/functions */ "./resources/js/Pages/Admin/Brief/Shared/Composables/functions.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Components/Badge.vue */ "./resources/js/Pages/Admin/Shared/Components/Badge.vue");
/* harmony import */ var _Brief_Shared_Components_Table_Columns_Token_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Brief/Shared/Components/Table/Columns/Token.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Table/Columns/Token.vue");
/* harmony import */ var _Brief_Shared_Components_Brief_CreatedAtColumn_vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/CreatedAtColumn.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/CreatedAtColumn.vue");
/* harmony import */ var _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @Brief/Shared/Composables/Brief/useDownload */ "./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var _Admin_Shared_Components_TableListOptions_TableListOptions_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @Admin/Shared/Components/TableListOptions/TableListOptions.vue */ "./resources/js/Pages/Admin/Shared/Components/TableListOptions/TableListOptions.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }










/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'RelatedBriefs',
  props: {
    relatedBrief: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var briefId = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    var selectedRowOptions = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var optionsDropdownPosition = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      top: 0,
      left: 0,
      width: 0,
      height: 0
    });
    var resetOptionsDropdown = function resetOptionsDropdown() {
      selectedRowOptions.value = null;
      optionsDropdownPosition.value = {
        top: 0,
        left: 0
      };
    };
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var briefRoutes = {
      logo: 'brief-detail.detail',
      web: 'web.brief-detail.detail',
      video: 'video.brief-detail.detail',
      smm: 'smm.brief-detail.detail',
      sem: 'sem.brief-detail.detail',
      mobile_app: 'app.brief-detail.detail'
    };
    var visitBriefDetail = function visitBriefDetail(brief) {
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router.visit(route(briefRoutes[brief.brief_type], {
        id: brief.id
      }), {
        method: 'get',
        replace: false,
        preserveState: false,
        preserveScroll: false
      });
    };
    var badgeClass = function badgeClass(briefType) {
      switch (briefType) {
        case "logo":
          return "success";
        case "web":
          return "secondary";
        case "video":
          return "info";
        case "smm":
          return "warning";
        case "sem":
          return "dark";
        case "mobile_app":
          return "danger";
        default:
          return "primary";
      }
    };
    var downloadBriefByType = function downloadBriefByType(encoded_id, name, brief_type) {
      var _useDownload = (0,_Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_6__.useDownload)(),
        download = _useDownload.download,
        downloadWebBrief = _useDownload.downloadWebBrief,
        downloadVideoBrief = _useDownload.downloadVideoBrief,
        downloadSmmBrief = _useDownload.downloadSmmBrief,
        downloadSemBrief = _useDownload.downloadSemBrief,
        downloadAppBrief = _useDownload.downloadAppBrief;
      var fingerprintValue = fingerprint.value;
      if (brief_type == "logo") {
        download(encoded_id, name, fingerprintValue);
      } else if (brief_type == "web") {
        downloadWebBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "video") {
        downloadVideoBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "smm") {
        downloadSmmBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "sem") {
        downloadSemBrief(encoded_id, name, fingerprintValue);
      } else if (brief_type == "mobile_app") {
        downloadAppBrief(encoded_id, name, fingerprintValue);
      }
    };
    var showTooltip = function showTooltip(className) {
      var tooltip = document.querySelector("._".concat(className));
      if (tooltip) {
        tooltip.classList.remove('hideTooltip');
        tooltip.classList.add('showTooltip');
      }
    };
    var hideTooltip = function hideTooltip(className) {
      var tooltip = document.querySelector("._".concat(className));
      if (tooltip) {
        tooltip.classList.remove('showTooltip');
        tooltip.classList.add('hideTooltip');
      }
    };
    var toggleOptionsDropdown = function toggleOptionsDropdown(e, item) {
      var _selectedRowOptions$v;
      if (item.id !== ((_selectedRowOptions$v = selectedRowOptions.value) === null || _selectedRowOptions$v === void 0 ? void 0 : _selectedRowOptions$v.id)) {
        var elementPosition = e.currentTarget.getBoundingClientRect();
        selectedRowOptions.value = item;
        optionsDropdownPosition.value = {
          top: elementPosition.top + -120,
          left: elementPosition.left + -235,
          width: elementPosition.width,
          height: elementPosition.height
        };
      } else {
        resetOptionsDropdown();
      }
    };
    var __returned__ = {
      props: props,
      briefId: briefId,
      fingerprint: fingerprint,
      selectedRowOptions: selectedRowOptions,
      optionsDropdownPosition: optionsDropdownPosition,
      resetOptionsDropdown: resetOptionsDropdown,
      logFingerprint: logFingerprint,
      get briefRoutes() {
        return briefRoutes;
      },
      set briefRoutes(v) {
        briefRoutes = v;
      },
      visitBriefDetail: visitBriefDetail,
      badgeClass: badgeClass,
      downloadBriefByType: downloadBriefByType,
      showTooltip: showTooltip,
      hideTooltip: hideTooltip,
      toggleOptionsDropdown: toggleOptionsDropdown,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_9__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_10__["default"];
      },
      get findByID() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.findByID;
      },
      get siteURL() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.siteURL;
      },
      get isJsonString() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.isJsonString;
      },
      get formatText() {
        return _Brief_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_1__.formatText;
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router;
      },
      Badge: _Admin_Shared_Components_Badge_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
      Token: _Brief_Shared_Components_Table_Columns_Token_vue__WEBPACK_IMPORTED_MODULE_4__["default"],
      CreatedAtColumn: _Brief_Shared_Components_Brief_CreatedAtColumn_vue__WEBPACK_IMPORTED_MODULE_5__["default"],
      get useDownload() {
        return _Brief_Shared_Composables_Brief_useDownload__WEBPACK_IMPORTED_MODULE_6__.useDownload;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_7__.useFingerprint;
      },
      TableListOptions: _Admin_Shared_Components_TableListOptions_TableListOptions_vue__WEBPACK_IMPORTED_MODULE_8__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Brief_Shared_Components_Brief_RecentActivity_RecentActivityList_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var _Admin_Shared_Composables_authorization__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Composables/authorization */ "./resources/js/Pages/Admin/Shared/Composables/authorization.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_5__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }






/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'RecentActivity',
  props: {
    logs: Array,
    id: Number,
    logType: String,
    routeTo: {
      type: String,
      "default": ""
    },
    showNoteBox: {
      type: Boolean,
      "default": false
    },
    showAddNoteButton: {
      type: Boolean,
      "default": true
    }
    //   createRoute:{
    //     type: String,
    //     default: "",
    //   },
    //   updateRoute: {
    //     type: String,
    //     default: "",
    //     },
    //   deleteRoute: {
    //     type: String,
    //     default: "",
    //   }
  },
  emits: ["hideNoteBox"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emits = __emit;
    var addNoteBox = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var note = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)("");
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)([]);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(0);
    var noteTextarea = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(null);
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      logFingerprint();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.watch)(function () {
      return props.showNoteBox;
    }, function (newNoteBox) {
      addNoteBox.value = newNoteBox;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.watch)(addNoteBox, function (newValue) {
      if (newValue) {
        (0,vue__WEBPACK_IMPORTED_MODULE_1__.nextTick)(function () {
          noteTextarea.value.focus();
        });
      }
    });
    var hideNoteBox = function hideNoteBox() {
      emits("hideNoteBox");
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      window.addEventListener("keydown", cancelNote);
    });
    var type = {
      "link.created": "mdi mdi-link",
      "link.updated": "mdi mdi-link-variant",
      "created": "mdi mdi-plus-circle-outline ",
      "updated": "mdi mdi-sync",
      "downloaded": "mdi mdi-arrow-collapse-down",
      "copied": "mdi mdi-content-copy",
      "viewed": "mdi mdi-eye-outline",
      "note": "bx bx-note"
    };
    var logs = function logs() {
      var pinID = -1;
      var pinLog = {};
      var logs = props.logs.filter(function (log) {
        return log.type != 'link.error';
      });
      for (var index in logs) {
        if (logs[index].pin == 1) {
          pinID = index;
          pinLog = logs[index];
          break;
        }
      }
      if (pinID > 0) {
        logs.splice(pinID, 1);
        logs.unshift(pinLog);
      }
      return logs;
    };
    var cancelNote = function cancelNote(event) {
      if (event.code == "Escape") {
        addNoteBox.value = false;
        note.value = "";
      }
      if (event.ctrlKey && (event === null || event === void 0 ? void 0 : event.code) == "Enter") {
        if (addNoteBox.value == true) {
          addNote();
          addNoteBox.value == false;
        }
      }
    };
    var addNote = function addNote() {
      var fingerprintValue = fingerprint.value;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.create", {
        id: props.id,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          activity: note.value,
          type: "note",
          request: "",
          response: "",
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      hideNoteBox();
    };
    var editNote = function editNote(index) {
      editNoteID.value = props.logs[index].id;
      addNoteBox.value = true;
      note.value = props.logs[index].activity;
      hideNoteBox();
    };
    var updateNote = function updateNote() {
      var fingerprintValue = fingerprint.value;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.update", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          activity: note.value,
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
    };
    var deleteNote = function deleteNote(index) {
      console.log("delete");
      var fingerprintValue = fingerprint.value;
      editNoteID.value = props.logs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.delete", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
      itemRefs.value.map(function (item, i) {
        item.style.display = "none";
      });
    };
    var __returned__ = {
      props: props,
      emits: emits,
      addNoteBox: addNoteBox,
      note: note,
      itemRefs: itemRefs,
      editNoteID: editNoteID,
      noteTextarea: noteTextarea,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      hideNoteBox: hideNoteBox,
      type: type,
      logs: logs,
      cancelNote: cancelNote,
      addNote: addNote,
      editNote: editNote,
      updateNote: updateNote,
      deleteNote: deleteNote,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      watch: vue__WEBPACK_IMPORTED_MODULE_1__.watch,
      nextTick: vue__WEBPACK_IMPORTED_MODULE_1__.nextTick,
      RecentActivityList: _Brief_Shared_Components_Brief_RecentActivity_RecentActivityList_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint;
      },
      get modulePermission() {
        return _Admin_Shared_Composables_authorization__WEBPACK_IMPORTED_MODULE_4__.modulePermission;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_5___default());
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }





// import { modulePermission } from "../../../../../../../Admin/Shared/Composables/authorization";

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'RecentActivityList',
  props: {
    logs: Array,
    id: Number,
    logType: String,
    iconTypes: Object,
    routeTo: String
  },
  emits: ["editPin", "deletePin"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emits = __emit;
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    var pinToTopText = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)("Pin to the top");
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var capitalize = function capitalize(s) {
      return s && s[0].toUpperCase() + s.slice(1);
    };
    var typeIcon = function typeIcon(logType, logActivity) {
      return props.iconTypes[logType];
    };
    var openOptionPanel = function openOptionPanel(index) {
      visibility.value = true;
      itemRefs.value.forEach(function (item, i) {
        if (i !== index && item && item.style) {
          item.style.display = "none";
        }
      });
      var item = itemRefs.value[index];
      if (item && item.style) {
        item.style.display = item.style.display === "block" ? "none" : "block";
      } else {
        console.error("Item or item style is undefined.");
      }
    };
    var closeOptionPanel = function closeOptionPanel(e) {
      var clickContain = false;
      itemRefs.value.forEach(function (item) {
        var contains = item.contains(e.target);
        if (contains) {
          clickContain = true;
        }
      });
      if (visibility && itemRefs.value && !clickContain) {
        itemRefs.value.forEach(function (item) {
          return item.style.display = "none";
        });
        visibility.value = false;
      } else {
        setTimeout(function () {
          itemRefs.value.forEach(function (item) {
            return item.style.display = "none";
          });
        }, 500);
        visibility.value = false;
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      var _props$logs;
      document.addEventListener("mousedown", closeOptionPanel);
      (_props$logs = props.logs) === null || _props$logs === void 0 || _props$logs.forEach(function (log) {
        if (log.type == "note" && log.pin == 1) {
          pinToTopText.value = "Replace Pin";
        }
      });
    });
    var togglePinNote = function togglePinNote(index, pinValue) {
      var fingerprintValue = fingerprint.value;
      editNoteID.value = props.logs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router.visit(route("brief.log.update", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          pin: pinValue,
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      editNoteID.value = 0;
    };
    var editNote = function editNote(index) {
      itemRefs.value.at(index).style.display = "none";
      emits("editPin", index);
    };
    var deleteNote = function deleteNote(index) {
      emits("deletePin", index);
    };
    var __returned__ = {
      props: props,
      emits: emits,
      itemRefs: itemRefs,
      visibility: visibility,
      editNoteID: editNoteID,
      pinToTopText: pinToTopText,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      capitalize: capitalize,
      typeIcon: typeIcon,
      openOptionPanel: openOptionPanel,
      closeOptionPanel: closeOptionPanel,
      togglePinNote: togglePinNote,
      editNote: editNote,
      deleteNote: deleteNote,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_5__["default"];
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_3___default());
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=script&setup=true&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var highlight_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! highlight.js */ "./node_modules/highlight.js/lib/index.js");
/* harmony import */ var highlight_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(highlight_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'EventsLog',
  props: {
    logs: Array
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var showHideBtn = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var logs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var capitalize = function capitalize(s) {
      return s && s[0].toUpperCase() + s.slice(1);
    };
    var showHideCodeBtn = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(true);

    // const highlightCode = (code) => {
    //     if (code && /^[\],:{}\s]*$/.test(code.replace(/\\["\\\/bfnrtu]/g, '@').
    //         replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']').
    //         replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

    //         return (code != "" ? JSON.parse(code) : '');
    //     } else {
    //         return "";
    //     }
    // }

    var highlightCode = function highlightCode(code) {
      try {
        if (typeof code === 'string') {
          JSON.parse(code);
          return JSON.parse(code);
        } else {
          return code;
        }
      } catch (e) {
        return code;
      }
    };
    var Logs = function Logs() {
      var _props$logs;
      return (_props$logs = props.logs) === null || _props$logs === void 0 ? void 0 : _props$logs.filter(function (log) {
        return log.type != 'note';
      });
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      var codeElements = document.querySelectorAll('pre.code');
      codeElements.forEach(function (codeElement) {
        var codeLines = codeElement.innerText.split('\n');
        codeElement.innerHTML = codeLines.map(function (line, index) {
          return '<div class="line"><span class="line-number">' + (index + 1) + '</span>' + line + '</div>';
        }).join('\n');
        highlight_js__WEBPACK_IMPORTED_MODULE_1___default().highlightElement(codeElement);
      });
      changeCodeBtnStatus();
    });
    var changeCodeBtnStatus = function changeCodeBtnStatus() {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(function () {
        var activeTabPane = document.querySelector('.code-tab.tab-pane.active');
        if (activeTabPane) {
          var jsonCodeContainer = activeTabPane.querySelector('.jsoncodeContainer');
          var jsonCodeMainDiv = activeTabPane.querySelector('.jsoncodemaindiv');
          if (jsonCodeContainer && jsonCodeMainDiv) {
            if (jsonCodeContainer.scrollHeight < jsonCodeMainDiv.clientHeight) {
              showHideCodeBtn.value = false;
            } else {
              showHideCodeBtn.value = true;
            }
          } else {
            console.log('Elements not found within active tab pane');
          }
        } else {
          console.log('No active tab pane found');
        }
      });
    };
    var showHideJsonData = function showHideJsonData(e) {
      e.currentTarget.parentNode.classList.toggle("showAll");
    };
    var showHideAction = function showHideAction(index, num) {
      var btnIndex = 0;
      if (index == 0 & num == 1) {
        btnIndex = 0;
      } else if (index == 0 & num == 2) {
        btnIndex = 1;
      } else {
        btnIndex = index + num;
      }
      var item = showHideBtn.value.at(btnIndex);
      var jsonCodeDiv = item.closest('.jsoncodediv');
      jsonCodeDiv.classList.toggle('expanded');
      var btnText = jsonCodeDiv.classList.contains('expanded') ? 'Hide all lines' : 'See all lines';
      var iconClass = jsonCodeDiv.classList.contains('expanded') ? 'bx bxs-chevron-up' : 'bx bxs-chevron-down';
      console.log(btnText, iconClass);
      item.innerHTML = '<i class="' + iconClass + '"></i> ' + btnText;
    };
    var comment = function comment(logResponse, activity, type) {
      var response = (0,_Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString)(logResponse);
      //const typesObj = [{type: 'payment.started', message: 'A request to create a PaymentIntent is initiated'}];

      var message = '';
      switch (type) {
        case 'payment.started':
          message = 'A request to create a PaymentIntent is initiated';
          break;
        case 'payment.intent.created':
          message = 'A new payment ' + response.id + ' for ' + (response === null || response === void 0 ? void 0 : response.currency).toUpperCase() + ' ' + (response === null || response === void 0 ? void 0 : response.amount) / 100 + ' was created';
          break;
        case 'payment.intent.updated':
          message = 'A request to update a PaymentIntent ' + response.id + ' completed';
          break;
        case 'threeD_secure':
        case 'payment.intent.confirmation':
          message = 'A request to confirm a PaymentIntent ' + response.id + ' completed';
          break;
        case 'payment.intent.charge':
          message = response.id + ' was charged ' + (response === null || response === void 0 ? void 0 : response.currency).toUpperCase() + ' ' + (response === null || response === void 0 ? void 0 : response.amount) / 100;
          break;
        case 'success':
          message = 'A request to confirm a PaymentIntent ' + response.payment_intent + ' completed';
          break;
        case 'payment.intent.succeeded':
          message = 'The payment ' + response.id + ' for ' + (response === null || response === void 0 ? void 0 : response.currency).toUpperCase() + ' ' + (response === null || response === void 0 ? void 0 : response.amount) / 100 + ' has succeeded';
          break;
        default:
          message = false;
      }
      return message;
    };
    var getFirstWord = function getFirstWord(string) {
      // Split the string by the first occurrence of '.'
      var parts = string.split('.', 1);
      // Return the first part
      return parts[0];
    };
    var eventType = function eventType(type) {
      var logType = getFirstWord(type);
      if (logType == 'payment') {
        return 'PaymentIntent';
      } else {
        return 'API';
      }
    };
    logs.value = Logs();
    var __returned__ = {
      props: props,
      showHideBtn: showHideBtn,
      logs: logs,
      capitalize: capitalize,
      showHideCodeBtn: showHideCodeBtn,
      highlightCode: highlightCode,
      Logs: Logs,
      changeCodeBtnStatus: changeCodeBtnStatus,
      showHideJsonData: showHideJsonData,
      showHideAction: showHideAction,
      comment: comment,
      getFirstWord: getFirstWord,
      eventType: eventType,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      nextTick: vue__WEBPACK_IMPORTED_MODULE_0__.nextTick,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      get VueHighlightJS() {
        return (highlight_js__WEBPACK_IMPORTED_MODULE_1___default());
      },
      get isJsonString() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_2__.isJsonString;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/MetaData/MetaData.vue?vue&type=script&setup=true&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/MetaData/MetaData.vue?vue&type=script&setup=true&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Brief_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @Brief/Shared/Components/Popup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'MetaData',
  props: {
    metaData: String,
    briefID: Number,
    submitRoute: String
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      logFingerprint();
    });
    var metadataPopupVisibility = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var metadata = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(props.metaData);
    var metaInputs = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)([]);
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      props.metaData.forEach(function (value) {
        metaInputs.value.push({
          key: value.key,
          value: value.value
        });
      });
      if (props.metaData.length == 0) {
        addInput();
      }
    });
    var showMetaPopup = function showMetaPopup() {
      metadataPopupVisibility.value = true;
    };
    var updateMetadata = function updateMetadata() {
      var fingerprintValue = fingerprint.value;
      hideMetaPopup();
      var validMetaInputs = metaInputs.value.filter(function (metaInput) {
        return metaInput.key !== '' && metaInput.value !== '';
      });
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router.visit(route(props.submitRoute, {
        id: props === null || props === void 0 ? void 0 : props.briefID
      }), {
        method: "post",
        data: {
          metadata: validMetaInputs,
          fingerprint: fingerprintValue
        },
        replace: false,
        preserveState: false,
        preserveScroll: true
      });
    };
    var hideMetaPopup = function hideMetaPopup() {
      metadataPopupVisibility.value = false;
    };
    var removeInput = function removeInput(index) {
      if (metaInputs.value.length > 1) {
        metaInputs.value.splice(index, 1);
      }
    };
    var addInput = function addInput() {
      metaInputs.value.push({
        key: '',
        value: ''
      });
    };
    var __returned__ = {
      props: props,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      metadataPopupVisibility: metadataPopupVisibility,
      metadata: metadata,
      metaInputs: metaInputs,
      showMetaPopup: showMetaPopup,
      updateMetadata: updateMetadata,
      hideMetaPopup: hideMetaPopup,
      removeInput: removeInput,
      addInput: addInput,
      Popup: _Brief_Shared_Components_Popup_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.router;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_4___default());
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Popup',
  props: {
    title: String,
    visibility: Boolean,
    "class": String,
    onClose: Function,
    maxWidth: String || "450px"
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var slots = (0,vue__WEBPACK_IMPORTED_MODULE_0__.useSlots)();
    var visibilityClass = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.visibility ? "showThis" : "");
    var onCloseFunction = props.onClose ? props.onClose : function () {
      return null;
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.visibility;
    }, function (newVal) {
      visibilityClass.value = props.visibility ? "showThis" : "";
    });
    var __returned__ = {
      props: props,
      slots: slots,
      visibilityClass: visibilityClass,
      onCloseFunction: onCloseFunction,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      useSlots: vue__WEBPACK_IMPORTED_MODULE_0__.useSlots
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Popup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue");
/* harmony import */ var _Admin_Brief_Shared_Components_BriefForm_Select_Select_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Brief/Shared/Components/BriefForm/Select/Select.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'ProjectDetailLogoPopup',
  props: {
    title: String,
    projectDetail: Object,
    popupVisibility: Boolean,
    hidePopup: Function,
    onSubmit: Function,
    isUpdate: Boolean,
    errors: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var formData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      industry: "",
      business_description: "",
      services: "",
      logo_title: [],
      logo_idea: "",
      returnJson: true
    });
    var industryOptions = [{
      value: null,
      label: 'Select Your Industry',
      disabled: true
    }, {
      value: 'accounting_finance',
      label: 'Accounting & Finance'
    }, {
      value: 'adventure_outdoor',
      label: 'Adventure & Outdoor'
    }, {
      value: 'agriculture_farming',
      label: 'Agriculture & Farming'
    }, {
      value: 'art_photography',
      label: 'Art & Photography'
    }, {
      value: 'attorney_legal',
      label: 'Attorney & Legal'
    }, {
      value: 'automotive',
      label: 'Automotive'
    }, {
      value: 'aviation_marine',
      label: 'Aviation & Marine'
    }, {
      value: 'business_consulting',
      label: 'Business & Consulting'
    }, {
      value: 'church_religious',
      label: 'Church & Religious'
    }, {
      value: 'cleaning_services',
      label: 'Cleaning Services'
    }, {
      value: 'communications',
      label: 'Communications'
    }, {
      value: 'community_foundations',
      label: 'Community & Foundations'
    }, {
      value: 'computer_networking',
      label: 'Computer & Networking'
    }, {
      value: 'construction',
      label: 'Construction'
    }, {
      value: 'cosmetics_jewelry',
      label: 'Cosmetics & Jewelry'
    }, {
      value: 'design_creative_services',
      label: 'Design & Creative Services'
    }, {
      value: 'eco_friendly_green',
      label: 'Eco-Friendly/Green'
    }, {
      value: 'entertainment_media',
      label: 'Entertainment & Media'
    }, {
      value: 'fashion_apparel',
      label: 'Fashion & Apparel'
    }, {
      value: 'fitness_physical_training',
      label: 'Fitness & Physical Training'
    }, {
      value: 'food_beverages',
      label: 'Food & Beverages'
    }, {
      value: 'furniture_interior',
      label: 'Furniture & Interior'
    }, {
      value: 'games',
      label: 'Games'
    }, {
      value: 'healthcare_physician',
      label: 'Healthcare & Physician'
    }, {
      value: 'general',
      label: 'General'
    }, {
      value: 'illustrative',
      label: 'Illustrative'
    }, {
      value: 'industrial',
      label: 'Industrial'
    }, {
      value: 'internet_web',
      label: 'Internet & Web'
    }, {
      value: 'insurance',
      label: 'Insurance'
    }, {
      value: 'landscaping_yard_care',
      label: 'Landscaping & Yard Care'
    }, {
      value: 'logistics_transportation',
      label: 'Logistics & Transportation'
    }, {
      value: 'mortgage_real_estate',
      label: 'Mortgage & Real Estate'
    }, {
      value: 'nutrition_lifestyle',
      label: 'Nutrition & Lifestyle'
    }, {
      value: 'pets_animals',
      label: 'Pets & Animals'
    }, {
      value: 'pharmaceutical_bio_tech',
      label: 'Pharmaceutical & Bio Tech'
    }, {
      value: 'pool_hot_tub',
      label: 'Pool & Hot Tub'
    }, {
      value: 'printing_publishing',
      label: 'Printing & Publishing'
    }, {
      value: 'restaurant',
      label: 'Restaurant'
    }, {
      value: 'retail',
      label: 'Retail'
    }, {
      value: 'security',
      label: 'Security'
    }, {
      value: 'services',
      label: 'Services'
    }, {
      value: 'spa_salon',
      label: 'Spa & Salon'
    }, {
      value: 'sports',
      label: 'Sports'
    }, {
      value: 'staffing_recruiting',
      label: 'Staffing & Recruiting'
    }, {
      value: 'technology',
      label: 'Technology'
    }, {
      value: 'travel_hospitality',
      label: 'Travel & Hospitality'
    }, {
      value: 'oil_gas',
      label: 'Oil & Gas'
    }, {
      value: 'others',
      label: 'Others'
    }];
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      if (props.projectDetail) {
        var _props$projectDetail$, _props$projectDetail, _props$projectDetail$2, _props$projectDetail2, _props$projectDetail$3, _props$projectDetail3, _props$projectDetail$4, _props$projectDetail4, _props$projectDetail$5, _props$projectDetail5;
        formData.value.industry = (_props$projectDetail$ = (_props$projectDetail = props.projectDetail) === null || _props$projectDetail === void 0 ? void 0 : _props$projectDetail.industry.toLowerCase().replace(/\s+/g, '_')) !== null && _props$projectDetail$ !== void 0 ? _props$projectDetail$ : "";
        formData.value.business_description = (_props$projectDetail$2 = (_props$projectDetail2 = props.projectDetail) === null || _props$projectDetail2 === void 0 ? void 0 : _props$projectDetail2.business_description) !== null && _props$projectDetail$2 !== void 0 ? _props$projectDetail$2 : "";
        formData.value.services = (_props$projectDetail$3 = (_props$projectDetail3 = props.projectDetail) === null || _props$projectDetail3 === void 0 ? void 0 : _props$projectDetail3.services) !== null && _props$projectDetail$3 !== void 0 ? _props$projectDetail$3 : "";
        formData.value.logo_title = (_props$projectDetail$4 = (_props$projectDetail4 = props.projectDetail) === null || _props$projectDetail4 === void 0 ? void 0 : _props$projectDetail4.typecase) !== null && _props$projectDetail$4 !== void 0 ? _props$projectDetail$4 : "";
        formData.value.logo_idea = (_props$projectDetail$5 = (_props$projectDetail5 = props.projectDetail) === null || _props$projectDetail5 === void 0 ? void 0 : _props$projectDetail5["idea_/_concept"]) !== null && _props$projectDetail$5 !== void 0 ? _props$projectDetail$5 : "";
      }
    });
    var submit = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              try {
                props.onSubmit(formData.value);
              } catch (errors) {
                console.error(errors);
              }
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function submit() {
        return _ref2.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      formData: formData,
      industryOptions: industryOptions,
      submit: submit,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      Select: _Admin_Brief_Shared_Components_BriefForm_Select_Select_vue__WEBPACK_IMPORTED_MODULE_2__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Popup.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue");
/* harmony import */ var _Admin_Brief_Shared_Components_BriefForm_Select_Select_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Admin/Brief/Shared/Components/BriefForm/Select/Select.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue");
/* harmony import */ var _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Admin/Shared/Composables/functions */ "./resources/js/Pages/Admin/Shared/Composables/functions.js");
/* harmony import */ var _Admin_Shared_Components_DatePicker_DatePicker_vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @Admin/Shared/Components/DatePicker/DatePicker.vue */ "./resources/js/Pages/Admin/Shared/Components/DatePicker/DatePicker.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'ProjectReqLogoPopup',
  props: {
    title: String,
    projectReq: Object,
    popupVisibility: Boolean,
    hidePopup: Function,
    onSubmit: Function,
    isUpdate: Boolean,
    errors: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var formData = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      logo_message: "",
      logo_graphical_element: "",
      logo_customer_likes: "",
      logo_customer_dont_likes: "",
      font_base_logo: [],
      graphic_base_logo: [],
      logo_color: "",
      logo_avoid_color: "",
      logo_font: "",
      logo_use: [],
      business_growth: [],
      anything_else: "",
      completion_date: "",
      returnJson: true
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      if (props.projectReq) {
        var _props$projectReq$ide, _props$projectReq, _props$projectReq$gra, _props$projectReq2, _props$projectReq$pre, _props$projectReq3, _props$projectReq$avo, _props$projectReq4, _props$projectReq$typ, _props$projectReq5, _props$projectReq$sty, _props$projectReq6, _props$projectReq$col, _props$projectReq7, _props$projectReq$col2, _props$projectReq8, _props$projectReq$fon, _props$projectReq9, _props$projectReq$log, _props$projectReq10, _props$projectReq$str, _props$projectReq11, _props$projectReq$not, _props$projectReq12, _props$projectReq$com, _props$projectReq13;
        formData.value.logo_message = (_props$projectReq$ide = (_props$projectReq = props.projectReq) === null || _props$projectReq === void 0 ? void 0 : _props$projectReq.identity) !== null && _props$projectReq$ide !== void 0 ? _props$projectReq$ide : "";
        formData.value.logo_graphical_element = (_props$projectReq$gra = (_props$projectReq2 = props.projectReq) === null || _props$projectReq2 === void 0 ? void 0 : _props$projectReq2.graphical_element) !== null && _props$projectReq$gra !== void 0 ? _props$projectReq$gra : "";
        formData.value.logo_customer_likes = (_props$projectReq$pre = (_props$projectReq3 = props.projectReq) === null || _props$projectReq3 === void 0 ? void 0 : _props$projectReq3.preferences) !== null && _props$projectReq$pre !== void 0 ? _props$projectReq$pre : "";
        formData.value.logo_customer_dont_likes = (_props$projectReq$avo = (_props$projectReq4 = props.projectReq) === null || _props$projectReq4 === void 0 ? void 0 : _props$projectReq4.avoidances) !== null && _props$projectReq$avo !== void 0 ? _props$projectReq$avo : "";
        formData.value.font_base_logo = (_props$projectReq$typ = (_props$projectReq5 = props.projectReq) === null || _props$projectReq5 === void 0 ? void 0 : _props$projectReq5.typography) !== null && _props$projectReq$typ !== void 0 ? _props$projectReq$typ : "";
        formData.value.graphic_base_logo = (_props$projectReq$sty = (_props$projectReq6 = props.projectReq) === null || _props$projectReq6 === void 0 ? void 0 : _props$projectReq6.style) !== null && _props$projectReq$sty !== void 0 ? _props$projectReq$sty : "";
        formData.value.logo_color = (_props$projectReq$col = (_props$projectReq7 = props.projectReq) === null || _props$projectReq7 === void 0 ? void 0 : _props$projectReq7.colors_to_use) !== null && _props$projectReq$col !== void 0 ? _props$projectReq$col : "";
        formData.value.logo_avoid_color = (_props$projectReq$col2 = (_props$projectReq8 = props.projectReq) === null || _props$projectReq8 === void 0 ? void 0 : _props$projectReq8.colors_to_avoid) !== null && _props$projectReq$col2 !== void 0 ? _props$projectReq$col2 : "";
        formData.value.logo_font = (_props$projectReq$fon = (_props$projectReq9 = props.projectReq) === null || _props$projectReq9 === void 0 ? void 0 : _props$projectReq9.font_style) !== null && _props$projectReq$fon !== void 0 ? _props$projectReq$fon : "";
        formData.value.logo_use = (_props$projectReq$log = (_props$projectReq10 = props.projectReq) === null || _props$projectReq10 === void 0 ? void 0 : _props$projectReq10.logo_usage) !== null && _props$projectReq$log !== void 0 ? _props$projectReq$log : "";
        formData.value.business_growth = (_props$projectReq$str = (_props$projectReq11 = props.projectReq) === null || _props$projectReq11 === void 0 ? void 0 : _props$projectReq11.strategy) !== null && _props$projectReq$str !== void 0 ? _props$projectReq$str : "";
        formData.value.anything_else = (_props$projectReq$not = (_props$projectReq12 = props.projectReq) === null || _props$projectReq12 === void 0 ? void 0 : _props$projectReq12.note) !== null && _props$projectReq$not !== void 0 ? _props$projectReq$not : "";
        formData.value.completion_date = (_props$projectReq$com = (_props$projectReq13 = props.projectReq) === null || _props$projectReq13 === void 0 ? void 0 : _props$projectReq13.completion_date) !== null && _props$projectReq$com !== void 0 ? _props$projectReq$com : "";
      }
    });
    var formatDateForPicker = function formatDateForPicker(date) {
      if (date) {
        var parsedDate = new Date(date);
        return parsedDate.getDate() + "/" + (parsedDate.getMonth() + 1) + "/" + parsedDate.getFullYear();
      }
      return "";
    };
    var onDatePicked = function onDatePicked(date) {
      formData.value.completion_date = new Date(date || '').toISOString().split('T')[0];
    };
    var submit = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              try {
                props.onSubmit(formData.value);
              } catch (errors) {
                console.error(errors);
              }
            case 1:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function submit() {
        return _ref2.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      formData: formData,
      formatDateForPicker: formatDateForPicker,
      onDatePicked: onDatePicked,
      submit: submit,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      Select: _Admin_Brief_Shared_Components_BriefForm_Select_Select_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      get siteURL() {
        return _Admin_Shared_Composables_functions__WEBPACK_IMPORTED_MODULE_3__.siteURL;
      },
      DatePicker: _Admin_Shared_Components_DatePicker_DatePicker_vue__WEBPACK_IMPORTED_MODULE_4__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Columns/Token.vue?vue&type=script&setup=true&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Columns/Token.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Token',
  props: {
    item: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var routes = {
      logo_brief: "frontend.brief.view",
      web_brief: "frontend.web.brief.view",
      video_brief: "frontend.video.brief.view",
      smm_brief: "frontend.smm.brief.view",
      sem_brief: "frontend.sem.brief.view",
      mobile_app_brief: "frontend.app.brief.view"
    };
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint)();
            case 2:
              fingerprintResult = _context2.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var tokenField = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.item.id);
    var copiedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(event, briefType) {
        var _props$item, fingerprintValue;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              event.preventDefault();
              event.stopPropagation();
              _context.prev = 2;
              _context.next = 5;
              return navigator.clipboard.writeText(route(routes[briefType], {
                id: (_props$item = props.item) === null || _props$item === void 0 ? void 0 : _props$item.encoded_id
              }));
            case 5:
              copiedRef.value = true;
              fingerprintValue = fingerprint.value;
              _context.next = 9;
              return axios__WEBPACK_IMPORTED_MODULE_1___default().post(route('brief.copy.activity'), {
                id: props.item.id,
                brief_type: briefType,
                fingerprint: fingerprintValue
              });
            case 9:
              _context.next = 14;
              break;
            case 11:
              _context.prev = 11;
              _context.t0 = _context["catch"](2);
              alert(_context.t0.message);
            case 14:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[2, 11]]);
      }));
      return function textToCopy(_x, _x2) {
        return _ref2.apply(this, arguments);
      };
    }();
    var textToCopyRevert = function textToCopyRevert() {
      setTimeout(function () {
        copiedRef.value = false;
      }, 300);
    };
    var __returned__ = {
      props: props,
      routes: routes,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      tokenField: tokenField,
      copiedRef: copiedRef,
      textToCopy: textToCopy,
      textToCopyRevert: textToCopyRevert,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_1___default());
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Pagination.vue?vue&type=script&setup=true&lang=js":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Pagination.vue?vue&type=script&setup=true&lang=js ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Pagination',
  props: {
    links: {
      type: Array,
      "default": null
    },
    lastPage: {
      type: Number,
      "default": null
    },
    from: {
      type: Number,
      "default": null
    },
    to: {
      type: Number,
      "default": null
    },
    prevPage: {
      type: String,
      "default": null
    },
    nextPage: {
      type: String,
      "default": null
    },
    showButtons: {
      type: Boolean,
      "default": false
    },
    total: Number,
    type: String
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props,
      get Link() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.Link;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLine.vue?vue&type=script&setup=true&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLine.vue?vue&type=script&setup=true&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Brief_Shared_Components_TimeLine_TimeLineList_vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Components/TimeLine/TimeLineList.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLineList.vue");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_4__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'TimeLine',
  props: {
    logs: Array,
    id: Number,
    logType: String,
    routeTo: {
      type: String,
      "default": ""
    },
    showNoteBox: {
      type: Boolean,
      "default": false
    },
    showAddNoteButton: {
      type: Boolean,
      "default": true
    }
    //   createRoute:{
    //     type: String,
    //     default: "",
    //   },
    //   updateRoute: {
    //     type: String,
    //     default: "",
    //     },
    //   deleteRoute: {
    //     type: String,
    //     default: "",
    //   }
  },
  emits: ["hideNoteBox"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emits = __emit;
    var addNoteBox = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(false);
    var note = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)("");
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)([]);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(0);
    var noteTextarea = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)(null);
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_1__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      logFingerprint();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.watch)(function () {
      return props.showNoteBox;
    }, function (newNoteBox) {
      addNoteBox.value = newNoteBox;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.watch)(addNoteBox, function (newValue) {
      if (newValue) {
        (0,vue__WEBPACK_IMPORTED_MODULE_1__.nextTick)(function () {
          noteTextarea.value.focus();
        });
      }
    });
    var hideNoteBox = function hideNoteBox() {
      emits("hideNoteBox");
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_1__.onMounted)(function () {
      window.addEventListener("keydown", cancelNote);
    });
    var type = {
      "link.created": "mdi mdi-link",
      "link.updated": "mdi mdi-link-variant",
      "created": "mdi mdi-plus-circle-outline ",
      "updated": "mdi mdi-sync",
      "downloaded": "mdi mdi-arrow-collapse-down",
      "note": "bx bx-note"
    };
    var logs = function logs() {
      var pinID = -1;
      var pinLog = {};
      var logs = props.logs.filter(function (log) {
        return log.type != 'link.error';
      });
      for (var index in logs) {
        if (logs[index].pin == 1) {
          pinID = index;
          pinLog = logs[index];
          break;
        }
      }
      if (pinID > 0) {
        logs.splice(pinID, 1);
        logs.unshift(pinLog);
      }
      return logs;
    };
    var cancelNote = function cancelNote(event) {
      if (event.code == "Escape") {
        addNoteBox.value = false;
        note.value = "";
      }
      if (event.ctrlKey && (event === null || event === void 0 ? void 0 : event.code) == "Enter") {
        if (addNoteBox.value == true) {
          addNote();
          addNoteBox.value == false;
        }
      }
    };
    var addNote = function addNote() {
      var fingerprintValue = fingerprint.value;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.create", {
        id: props.id,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          activity: note.value,
          type: "note",
          request: "",
          response: "",
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      hideNoteBox();
    };
    var editNote = function editNote(index) {
      editNoteID.value = props.logs[index].id;
      addNoteBox.value = true;
      note.value = props.logs[index].activity;
      hideNoteBox();
    };
    var updateNote = function updateNote() {
      var fingerprintValue = fingerprint.value;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.update", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          activity: note.value,
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
    };
    var deleteNote = function deleteNote(index) {
      console.log("delete");
      var fingerprintValue = fingerprint.value;
      editNoteID.value = props.logs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router.visit(route("brief.log.delete", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      addNoteBox.value = false;
      note.value = "";
      editNoteID.value = 0;
      itemRefs.value.map(function (item, i) {
        item.style.display = "none";
      });
    };
    var __returned__ = {
      props: props,
      emits: emits,
      addNoteBox: addNoteBox,
      note: note,
      itemRefs: itemRefs,
      editNoteID: editNoteID,
      noteTextarea: noteTextarea,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      hideNoteBox: hideNoteBox,
      type: type,
      logs: logs,
      cancelNote: cancelNote,
      addNote: addNote,
      editNote: editNote,
      updateNote: updateNote,
      deleteNote: deleteNote,
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_0__.router;
      },
      ref: vue__WEBPACK_IMPORTED_MODULE_1__.ref,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_1__.onMounted,
      watch: vue__WEBPACK_IMPORTED_MODULE_1__.watch,
      nextTick: vue__WEBPACK_IMPORTED_MODULE_1__.nextTick,
      TimeLineList: _Brief_Shared_Components_TimeLine_TimeLineList_vue__WEBPACK_IMPORTED_MODULE_2__["default"],
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_3__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_4___default());
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLineList.vue?vue&type=script&setup=true&lang=js":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLineList.vue?vue&type=script&setup=true&lang=js ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parseISO/index.js");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");
/* harmony import */ var _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @Brief/Shared/Composables/useFingerprint */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_3__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }





// import { modulePermission } from "../../../../../../../Admin/Shared/Composables/authorization";

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'TimeLineList',
  props: {
    logs: Array,
    id: Number,
    logType: String,
    iconTypes: Object,
    routeTo: String
  },
  emits: ["editPin", "deletePin"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emits = __emit;
    var itemRefs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)([]);
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var editNoteID = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
    var pinToTopText = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)("Pin to the top");
    var fingerprint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    function logFingerprint() {
      return _logFingerprint.apply(this, arguments);
    }
    function _logFingerprint() {
      _logFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var fingerprintResult;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0,_Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint)();
            case 2:
              fingerprintResult = _context.sent;
              fingerprint.value = fingerprintResult;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _logFingerprint.apply(this, arguments);
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      logFingerprint();
    });
    var capitalize = function capitalize(s) {
      return s && s[0].toUpperCase() + s.slice(1);
    };
    var typeIcon = function typeIcon(logType, logActivity) {
      return props.iconTypes[logType];
    };
    var openOptionPanel = function openOptionPanel(index) {
      visibility.value = true;
      itemRefs.value.forEach(function (item, i) {
        if (i !== index && item && item.style) {
          item.style.display = "none";
        }
      });
      var item = itemRefs.value[index];
      if (item && item.style) {
        item.style.display = item.style.display === "block" ? "none" : "block";
      } else {
        console.error("Item or item style is undefined.");
      }
    };
    var closeOptionPanel = function closeOptionPanel(e) {
      var clickContain = false;
      itemRefs.value.forEach(function (item) {
        var contains = item.contains(e.target);
        if (contains) {
          clickContain = true;
        }
      });
      if (visibility && itemRefs.value && !clickContain) {
        itemRefs.value.forEach(function (item) {
          return item.style.display = "none";
        });
        visibility.value = false;
      } else {
        setTimeout(function () {
          itemRefs.value.forEach(function (item) {
            return item.style.display = "none";
          });
        }, 500);
        visibility.value = false;
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      var _props$logs;
      document.addEventListener("mousedown", closeOptionPanel);
      (_props$logs = props.logs) === null || _props$logs === void 0 || _props$logs.forEach(function (log) {
        if (log.type == "note" && log.pin == 1) {
          pinToTopText.value = "Replace Pin";
        }
      });
    });
    var togglePinNote = function togglePinNote(index, pinValue) {
      var fingerprintValue = fingerprint.value;
      editNoteID.value = props.logs[index].id;
      _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router.visit(route("brief.log.update", {
        id: props.id,
        logID: editNoteID.value,
        fingerprint: fingerprintValue
      }), {
        method: "post",
        data: {
          pin: pinValue,
          log_type: props.logType,
          routeTo: props.routeTo
        },
        replace: true,
        preserveState: true,
        preserveScroll: true
      });
      editNoteID.value = 0;
    };
    var editNote = function editNote(index) {
      itemRefs.value.at(index).style.display = "none";
      emits("editPin", index);
    };
    var deleteNote = function deleteNote(index) {
      emits("deletePin", index);
    };
    var filteredLogs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props.logs.filter(function (log) {
        return log.type !== 'downloaded' && log.type !== 'copied' && log.type !== 'viewed';
      });
    });
    var __returned__ = {
      props: props,
      emits: emits,
      itemRefs: itemRefs,
      visibility: visibility,
      editNoteID: editNoteID,
      pinToTopText: pinToTopText,
      fingerprint: fingerprint,
      logFingerprint: logFingerprint,
      capitalize: capitalize,
      typeIcon: typeIcon,
      openOptionPanel: openOptionPanel,
      closeOptionPanel: closeOptionPanel,
      togglePinNote: togglePinNote,
      editNote: editNote,
      deleteNote: deleteNote,
      filteredLogs: filteredLogs,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      },
      get parseISO() {
        return date_fns__WEBPACK_IMPORTED_MODULE_5__["default"];
      },
      get router() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_1__.router;
      },
      get useFingerprint() {
        return _Brief_Shared_Composables_useFingerprint__WEBPACK_IMPORTED_MODULE_2__.useFingerprint;
      },
      get axios() {
        return (axios__WEBPACK_IMPORTED_MODULE_3___default());
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Title.vue?vue&type=script&setup=true&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Title.vue?vue&type=script&setup=true&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Tooltip_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Tooltip.vue */ "./resources/js/Pages/Admin/Brief/Shared/Components/Tooltip.vue");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Title',
  props: {
    heading: String,
    breadcrumb: Array | String | null
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return navigator.clipboard.writeText(props.breadcrumb);
            case 3:
              alert('Text copied to clipboard: ' + props.breadcrumb);
              _context.next = 9;
              break;
            case 6:
              _context.prev = 6;
              _context.t0 = _context["catch"](0);
              alert(_context.t0.message);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 6]]);
      }));
      return function textToCopy() {
        return _ref2.apply(this, arguments);
      };
    }();
    var __returned__ = {
      props: props,
      textToCopy: textToCopy,
      Tooltip: _Tooltip_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Brief/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Tooltip',
  props: {
    copyText: String,
    tooltipText: String,
    direction: String,
    showText: String,
    showTextStyle: String,
    showTextClass: String,
    showButtonStyle: String,
    showButtonClass: String,
    showIcon: Boolean,
    showCopied: {
      type: Boolean,
      "default": true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var copiedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var staticClass = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props !== null && props !== void 0 && props.direction ? props.direction.toLowerCase() : "";
    });
    var defaultText = props.tooltipText ? props.tooltipText : "";
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return navigator.clipboard.writeText(props.copyText);
            case 3:
              if (props.showCopied) {
                copiedRef.value = true;
              }
              _context.next = 9;
              break;
            case 6:
              _context.prev = 6;
              _context.t0 = _context["catch"](0);
              alert(_context.t0.message);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 6]]);
      }));
      return function textToCopy() {
        return _ref2.apply(this, arguments);
      };
    }();
    var textToCopyRevert = function textToCopyRevert() {
      setTimeout(function () {
        copiedRef.value = false;
      }, 300);
    };
    var __returned__ = {
      props: props,
      copiedRef: copiedRef,
      staticClass: staticClass,
      defaultText: defaultText,
      textToCopy: textToCopy,
      textToCopyRevert: textToCopyRevert,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Badge',
  props: {
    badgeClass: {
      type: String,
      "default": ''
    },
    badgeText: {
      type: String,
      "default": ''
    },
    iconClass: {
      type: String,
      "default": ''
    },
    iconPosition: {
      type: String,
      "default": null
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/DatePicker/DatePicker.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/DatePicker/DatePicker.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _vuepic_vue_datepicker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @vuepic/vue-datepicker */ "./node_modules/@vuepic/vue-datepicker/dist/vue-datepicker.js");
/* harmony import */ var _vuepic_vue_datepicker_dist_main_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @vuepic/vue-datepicker/dist/main.css */ "./node_modules/@vuepic/vue-datepicker/dist/main.css");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/format/index.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/esm/parse/index.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'DatePicker',
  props: {
    startDate: String,
    visibility: {
      type: Boolean,
      "default": false
    },
    direction: {
      type: String,
      "default": "bottom"
    },
    placeholder: {
      type: String,
      "default": "Select date"
    },
    minDate: {
      type: [String, Date],
      "default": null
    }
  },
  emits: ["datePicked"],
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose,
      __emit = _ref.emit;
    __expose();
    var props = __props;
    var emit = __emit;
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.visibility);
    var dateAreaRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    var closeDateDrop = function closeDateDrop(e) {
      if (visibility.value && dateAreaRef.value && !dateAreaRef.value.contains(e.target)) {
        visibility.value = false;
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      document.addEventListener("mousedown", closeDateDrop);
    });
    var parseDate = function parseDate(dateString) {
      var _dateString$split = dateString.split(/[-\/]/),
        _dateString$split2 = _slicedToArray(_dateString$split, 3),
        day = _dateString$split2[0],
        month = _dateString$split2[1],
        year = _dateString$split2[2];
      return new Date(year, month - 1, day);
    };
    var startDate = props.startDate ? parseDate(props.startDate) : null;
    var startDay = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(startDate ? startDate.getDate() : null);
    var startMonth = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(startDate ? startDate.getMonth() + 1 : null);
    var startYear = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(startDate ? startDate.getFullYear() : null);
    var date = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(startDate);
    var updateStartDate = function updateStartDate() {
      if (startYear.value && startMonth.value && startDay.value) {
        date.value = new Date(startYear.value, startMonth.value - 1, startDay.value);
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)([date], function () {
      if (date.value) {
        var getDate = new Date(date.value);
        startDay.value = getDate.getDate();
        startMonth.value = getDate.getMonth() + 1;
        startYear.value = getDate.getFullYear();
        emit("datePicked", "".concat(startYear.value, "-").concat(startMonth.value, "-").concat(startDay.value));
        visibility.value = false;
      }
    });
    var directionClass = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props.direction === "top" ? "dropdownTop" : "dropdownBottom";
    });
    var __returned__ = {
      props: props,
      emit: emit,
      visibility: visibility,
      dateAreaRef: dateAreaRef,
      closeDateDrop: closeDateDrop,
      parseDate: parseDate,
      startDate: startDate,
      startDay: startDay,
      startMonth: startMonth,
      startYear: startYear,
      date: date,
      updateStartDate: updateStartDate,
      directionClass: directionClass,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed,
      get VueDatePicker() {
        return _vuepic_vue_datepicker__WEBPACK_IMPORTED_MODULE_1__["default"];
      },
      get format() {
        return date_fns__WEBPACK_IMPORTED_MODULE_3__["default"];
      },
      get parse() {
        return date_fns__WEBPACK_IMPORTED_MODULE_4__["default"];
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Popup',
  props: {
    title: String,
    visibility: Boolean,
    "class": String,
    onClose: Function,
    maxWidth: String || "450px"
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var slots = (0,vue__WEBPACK_IMPORTED_MODULE_0__.useSlots)();
    var visibilityClass = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.visibility ? "showThis" : "");
    var onCloseFunction = props.onClose ? props.onClose : function () {
      return null;
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(function () {
      return props.visibility;
    }, function (newVal) {
      visibilityClass.value = props.visibility ? "showThis" : "";
    });
    var __returned__ = {
      props: props,
      slots: slots,
      visibilityClass: visibilityClass,
      onCloseFunction: onCloseFunction,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      useSlots: vue__WEBPACK_IMPORTED_MODULE_0__.useSlots
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=script&setup=true&lang=js":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=script&setup=true&lang=js ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Popup_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Popup.vue */ "./resources/js/Pages/Admin/Shared/Components/Popup.vue");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'DeletePopup',
  props: {
    title: String,
    message: String,
    deleteVisibility: Boolean,
    hideDeletePopup: Function,
    onDeleteSubmit: Function
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var __returned__ = {
      props: props,
      Popup: _Popup_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/TableListOptions/TableListOptions.vue?vue&type=script&setup=true&lang=js":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/TableListOptions/TableListOptions.vue?vue&type=script&setup=true&lang=js ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @Admin/Shared/Components/Tooltip.vue */ "./resources/js/Pages/Admin/Shared/Components/Tooltip.vue");
/* harmony import */ var _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @inertiajs/vue3 */ "./node_modules/@inertiajs/vue3/dist/index.esm.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'TableListOptions',
  props: {
    options: Array,
    position: {
      top: Number,
      left: Number,
      width: Number,
      height: Number
    },
    visibility: Boolean,
    onClose: Function
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var tableListOptions = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    var props = __props;
    var popupPosition = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
      top: 0,
      left: 0
    });
    var visibility = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.visibility);
    var closeDrop = function closeDrop(e) {
      if (props.visibility && tableListOptions.value && !tableListOptions.value.contains(e.target)) {
        props.onClose();
      }
    };
    var setPosition = function setPosition() {
      var popup = tableListOptions.value;
      var body = document.body;
      var docEl = document.documentElement;
      var scrollTop = window.pageYOffset || docEl.scrollTop || body.scrollTop;
      var scrollLeft = window.pageXOffset || docEl.scrollLeft || body.scrollLeft;
      var clientTop = docEl.clientTop || body.clientTop || 0;
      var clientLeft = docEl.clientLeft || body.clientLeft || 0;
      var top = props.position.top + scrollTop - clientTop + props.position.height + 2;
      var left = props.position.left + scrollLeft - clientLeft - popup.clientWidth + props.position.width;
      var totalHeight = Math.max(body.scrollHeight, body.offsetHeight, docEl.clientHeight, docEl.scrollHeight, docEl.offsetHeight);
      if (totalHeight < top + popup.clientHeight) {
        var topForBottom = props.position.top + scrollTop - clientTop - popup.clientHeight - 2;
        popupPosition.value = {
          top: topForBottom,
          left: left
        };
      } else {
        popupPosition.value = {
          top: top,
          left: left
        };
      }
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(function () {
      setPosition();
      document.addEventListener("mousedown", closeDrop);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(props, function () {
      setPosition();
    });
    var handleItemClick = function handleItemClick(item) {
      if (item.onClick) {
        item.onClick();
      }
      if (item.preventDefault) {}
      if (!item.tooltip) {
        props.onClose();
      }
    };
    var __returned__ = {
      tableListOptions: tableListOptions,
      props: props,
      popupPosition: popupPosition,
      visibility: visibility,
      closeDrop: closeDrop,
      setPosition: setPosition,
      handleItemClick: handleItemClick,
      onMounted: vue__WEBPACK_IMPORTED_MODULE_0__.onMounted,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      watch: vue__WEBPACK_IMPORTED_MODULE_0__.watch,
      Tooltip: _Admin_Shared_Components_Tooltip_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
      get Link() {
        return _inertiajs_vue3__WEBPACK_IMPORTED_MODULE_2__.Link;
      }
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=script&setup=true&lang=js ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'Tooltip',
  props: {
    copyText: String,
    tooltipText: String,
    direction: String,
    showText: String,
    showTextStyle: String,
    showTextClass: String,
    showButtonStyle: String,
    showButtonClass: String,
    showIcon: Boolean,
    showCopied: {
      type: Boolean,
      "default": true
    }
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    __expose();
    var props = __props;
    var copiedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    var direction = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(function () {
      return props !== null && props !== void 0 && props.direction ? props.direction.toLowerCase() : "top";
    });
    var getDirectionClass = function getDirectionClass(value) {
      switch (value) {
        case 'bottom':
          return 'bottomDirectionClass';
          break;
        case 'right':
          return 'rightDirectionClass';
          break;
        case 'left':
          return 'leftDirectionClass';
          break;
        default:
          return 'topDirectionClass';
          break;
      }
      props !== null && props !== void 0 && props.direction ? props.direction.toLowerCase() : "top";
    };
    var defaultText = props.tooltipText ? props.tooltipText : "";
    var textToCopy = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              _context.next = 3;
              return navigator.clipboard.writeText(props.copyText);
            case 3:
              if (props.showCopied) {
                copiedRef.value = true;
              }
              _context.next = 9;
              break;
            case 6:
              _context.prev = 6;
              _context.t0 = _context["catch"](0);
              alert(_context.t0.message);
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[0, 6]]);
      }));
      return function textToCopy() {
        return _ref2.apply(this, arguments);
      };
    }();
    var textToCopyRevert = function textToCopyRevert() {
      setTimeout(function () {
        copiedRef.value = false;
      }, 300);
    };
    var __returned__ = {
      props: props,
      copiedRef: copiedRef,
      direction: direction,
      getDirectionClass: getDirectionClass,
      defaultText: defaultText,
      textToCopy: textToCopy,
      textToCopyRevert: textToCopyRevert,
      ref: vue__WEBPACK_IMPORTED_MODULE_0__.ref,
      computed: vue__WEBPACK_IMPORTED_MODULE_0__.computed
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=template&id=5d7e7488&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=template&id=5d7e7488&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5d7e7488"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = {
  "class": "card-header payment-details-header pb-0"
};
var _hoisted_4 = {
  "class": "row align-items-center"
};
var _hoisted_5 = {
  "class": "col-md-12"
};
var _hoisted_6 = {
  "class": "payment-details-headerLeft"
};
var _hoisted_7 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-pages-line",
    style: {
      "vertical-align": "bottom",
      "margin-right": "5px"
    }
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    style: {
      "text-transform": "uppercase"
    }
  }, "Project Name")], -1 /* HOISTED */);
});
var _hoisted_8 = {
  style: {
    "margin": "8px 0"
  }
};
var _hoisted_9 = {
  "class": "card-body"
};
var _hoisted_10 = {
  "class": "single-payment-details payment-details-cardArea mb-4"
};
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Last Update", -1 /* HOISTED */);
});
var _hoisted_12 = {
  key: 0
};
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Customer", -1 /* HOISTED */);
});
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Brief Type", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_Link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["BriefDetailLayout"], {
    page: $setup.props.page,
    briefID: $setup.props.briefID,
    briefData: $setup.props.brief
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$setup$props$brief, _$setup$props$brief2, _$setup$props$brief5, _$setup$props$brief6, _$setup$props$brief8, _$setup$props, _$setup$props2, _$setup$props$linkLog, _$setup$props3, _$setup$props$linkLog2;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [_hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.brief.business_name), 1 /* TEXT */), (_$setup$props$brief = $setup.props.brief) !== null && _$setup$props$brief !== void 0 && (_$setup$props$brief = _$setup$props$brief.brief_link) !== null && _$setup$props$brief !== void 0 && _$setup$props$brief.status ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Badge"], {
        key: 0,
        badgeClass: "badge badge-soft-success",
        badgeText: $setup.formatText((_$setup$props$brief2 = $setup.props.brief) === null || _$setup$props$brief2 === void 0 || (_$setup$props$brief2 = _$setup$props$brief2.brief_link) === null || _$setup$props$brief2 === void 0 ? void 0 : _$setup$props$brief2.status)
      }, null, 8 /* PROPS */, ["badgeText"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Tooltip"], {
        onClickCapture: _cache[0] || (_cache[0] = function ($event) {
          var _$setup$props$brief3, _$setup$props$brief4;
          return $setup.handleClick($event, (_$setup$props$brief3 = $setup.props.brief) === null || _$setup$props$brief3 === void 0 ? void 0 : _$setup$props$brief3.id, (_$setup$props$brief4 = $setup.props.brief) === null || _$setup$props$brief4 === void 0 || (_$setup$props$brief4 = _$setup$props$brief4.brief_link) === null || _$setup$props$brief4 === void 0 ? void 0 : _$setup$props$brief4.brief_type);
        }),
        showText: "<i class='las la-clipboard-list copy-icon'></i>",
        showButtonClass: "toolTipCopyButton",
        copyText: $setup.route($setup.props.page.formRoute, {
          id: $setup.props.brief.encoded_id
        }),
        tooltipText: "Copy Brief Link"
      }, null, 8 /* PROPS */, ["copyText"])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"col-md-6\">\r\n                                <div class=\"toolTip-div\">\r\n                                    <Tooltip @click.capture=\"handleClick($event, props.brief?.id, props.brief?.brief_link?.brief_type)\" :copyText=\"route(props.page.formRoute, { id: props.brief.encoded_id })\"\r\n                                        :showText=\"props.brief.encoded_id\"></Tooltip>\r\n                                </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <ul class=\"payment-actionListUl\">\r\n                                    <li>\r\n                                        <div class=\"dropdown d-inline-block\">\r\n                                            <button\r\n                                                class=\"btn btn-soft-secondary btn-sm dropdown\"\r\n                                                type=\"button\"\r\n                                                data-bs-toggle=\"dropdown\"\r\n                                                aria-expanded=\"false\"\r\n                                            >\r\n                                                <i class=\"ri-more-fill align-middle\"></i>\r\n                                            </button>\r\n                                            <ul class=\"dropdown-menu dropdown-menu-end\">\r\n                                                <div class=\"dropdown-top-caret\">\r\n                                                    <svg\r\n                                                        xmlns=\"http://www.w3.org/2000/svg\"\r\n                                                        width=\"21\"\r\n                                                        height=\"9\"\r\n                                                        role=\"presentation\"\r\n                                                    >\r\n                                                        <g fill=\"#fff\" fill-rule=\"evenodd\">\r\n                                                            <path\r\n                                                                fill=\"#fff\"\r\n                                                                fill-opacity=\"0.1\"\r\n                                                                d=\"M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z\"\r\n                                                            ></path>\r\n                                                            <path\r\n                                                                fill=\"currentcolor\"\r\n                                                                d=\"M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z\"\r\n                                                            ></path>\r\n                                                        </g>\r\n                                                    </svg>\r\n                                                </div>\r\n                                                <li>\r\n                                                    <a href=\"#!\" class=\"dropdown-item\">No option</a>\r\n                                                </li>\r\n                                            </ul>\r\n                                        </div>\r\n                                    </li>\r\n                                </ul> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" </div> ")])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [_hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO($setup.props.brief.updated_at), "PPpp")), 1 /* TEXT */)]), (_$setup$props$brief5 = $setup.props.brief) !== null && _$setup$props$brief5 !== void 0 && _$setup$props$brief5.customer ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_12, [_hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Link, {
        href: $setup.route('admin.customer.detail', {
          id: (_$setup$props$brief6 = $setup.props.brief) === null || _$setup$props$brief6 === void 0 || (_$setup$props$brief6 = _$setup$props$brief6.customer) === null || _$setup$props$brief6 === void 0 ? void 0 : _$setup$props$brief6.id
        })
      }, {
        "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
          var _$setup$props$brief7;
          return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$brief7 = $setup.props.brief) === null || _$setup$props$brief7 === void 0 || (_$setup$props$brief7 = _$setup$props$brief7.customer) === null || _$setup$props$brief7 === void 0 ? void 0 : _$setup$props$brief7.email), 1 /* TEXT */)];
        }),
        _: 1 /* STABLE */
      }, 8 /* PROPS */, ["href"])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [_hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText((_$setup$props$brief8 = $setup.props.brief) === null || _$setup$props$brief8 === void 0 || (_$setup$props$brief8 = _$setup$props$brief8.brief_link) === null || _$setup$props$brief8 === void 0 ? void 0 : _$setup$props$brief8.brief_type)), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <Badge :badgeClass=\"`badge badge-soft-${badgeClass(props.brief?.brief_link?.brief_type)}`\" :badgeText=\"formatText(props.brief?.brief_link?.brief_type)\" /> ")])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <TimeLine  :style=\"{ width: '50%', marginLeft: '50%' }\" class=\"mb-4\" :logs=\"[...props.logs.logs, ...props.linkLogs?.logs.filter(link => link.type != 'link.submitted')]\" :id=\"props.brief?.id\" :routeTo=\"props.page.route\" :logType=\"props.page.briefDirectory\" /> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <template v-for=\"(detail, key, index) in props.briefDetails\">\r\n                            <DetailSection :heading=\"key\" :items=\"detail\" />\r\n                        </template> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["BriefDetails"], {
        "class": "mb-4",
        designation: $setup.props.brief.designation,
        briefDetail: $setup.props.brief,
        metaData: (_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.metaData,
        briefID: (_$setup$props2 = $setup.props) === null || _$setup$props2 === void 0 || (_$setup$props2 = _$setup$props2.brief) === null || _$setup$props2 === void 0 ? void 0 : _$setup$props2.id,
        submitRoute: $setup.props.page.metaDataRoute,
        logs: [].concat(_toConsumableArray($setup.props.logs.logs), _toConsumableArray((_$setup$props$linkLog = $setup.props.linkLogs) === null || _$setup$props$linkLog === void 0 ? void 0 : _$setup$props$linkLog.logs.filter(function (link) {
          return link.type != 'link.submitted';
        }))),
        logType: $setup.props.page.briefDirectory,
        routeTo: $setup.props.page.route,
        briefDetails: $setup.props.briefDetails
      }, null, 8 /* PROPS */, ["designation", "briefDetail", "metaData", "briefID", "submitRoute", "logs", "logType", "routeTo", "briefDetails"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["BriefInsights"], {
        "class": "mb-4",
        designation: $setup.props.brief.designation,
        briefDetail: $setup.props.brief,
        total_cost: $setup.props.total_cost,
        submissionAccuracy: $setup.props.submissionAccuracy,
        briefID: (_$setup$props3 = $setup.props) === null || _$setup$props3 === void 0 || (_$setup$props3 = _$setup$props3.brief) === null || _$setup$props3 === void 0 ? void 0 : _$setup$props3.id,
        logs: [].concat(_toConsumableArray($setup.props.logs.logs), _toConsumableArray((_$setup$props$linkLog2 = $setup.props.linkLogs) === null || _$setup$props$linkLog2 === void 0 ? void 0 : _$setup$props$linkLog2.logs.filter(function (link) {
          return link.type != 'link.submitted';
        }))),
        logType: $setup.props.page.briefDirectory,
        routeTo: $setup.props.page.route
      }, null, 8 /* PROPS */, ["designation", "briefDetail", "total_cost", "submissionAccuracy", "briefID", "logs", "logType", "routeTo"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <MetaData class=\"mb-4\" :metaData=\"props?.metaData\" :briefID=\"props?.brief?.id\" :submitRoute=\"props.page.metaDataRoute\" /> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RelatedBriefs"], {
        "class": "mb-4",
        relatedBrief: $setup.props.relatedBrief
      }, null, 8 /* PROPS */, ["relatedBrief"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <BriefActivities v-if=\"props?.authUserRole == 'Super Admin'\" class=\"mb-4\" :activitiesLogs=\"props.activitiesLogs\" :briefID=\"props?.brief?.id\" :activityRoute=\"props.page.activityRoute\" /> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["EventsLog"], {
        logs: $setup.props.logs.logs
      }, null, 8 /* PROPS */, ["logs"])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"row col-12 mt-4\">\r\n                <ul class=\"nav nav-tabs\" id=\"myTab\" role=\"tablist\">\r\n                    <li class=\"nav-item\" role=\"presentation\">\r\n                        <a class=\"nav-link active\" id=\"events-logs-tab\" data-bs-toggle=\"tab\" href=\"#events-logs\" role=\"tab\" aria-controls=\"events-logs\" aria-selected=\"true\">Events & Logs</a>\r\n                    </li>\r\n                    <li class=\"nav-item\" role=\"presentation\">\r\n                        <a class=\"nav-link\" id=\"activities-tab\" data-bs-toggle=\"tab\" href=\"#activities\" role=\"tab\" aria-controls=\"activities\" aria-selected=\"false\">Activities</a>\r\n                    </li>\r\n                </ul>\r\n\r\n                <div class=\"tab-content\" id=\"myTabContent\">\r\n                    <div class=\"tab-pane fade show active my-4\" id=\"events-logs\" role=\"tabpanel\" aria-labelledby=\"events-logs-tab\">\r\n                        <div class=\"col-md-6\">\r\n                            <div class=\"eventslogdiv\">\r\n                                <table id=\"scroll-horizontal\" class=\"table nowrap align-middle productsTables\" style=\"width: 100%\">\r\n                                    <tbody>\r\n                                        <tr v-for=\"(log, i) in props?.logs\" :key=\"i\">\r\n                                            <td>{{ log.activity }}</td>\r\n                                            <td style=\"width: 20% !important; white-space: nowrap;\">{{ format(parseISO(log?.created_at), 'PPpp') }}</td>\r\n                                        </tr>\r\n                                    </tbody>\r\n                                </table>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class=\"tab-pane fade my-4\" id=\"activities\" role=\"tabpanel\" aria-labelledby=\"activities-tab\">\r\n                        <div class=\"col-md-6\">\r\n                            <div class=\"eventslogdiv\">\r\n                                <table id=\"scroll-horizontal\" class=\"table nowrap align-middle productsTables\" style=\"width: 100%\">\r\n                                    <tbody>\r\n                                        <tr v-for=\"(activity, i) in props?.activities\" :key=\"i\">\r\n                                            <td style=\"width: 40% !important\">{{ `${activity.userName} ${activity.os}` }}</td>\r\n                                            <td style=\"width: 40% !important\">{{ activity.ip }}</td>\r\n                                            <td style=\"width: 20% !important; white-space: nowrap;\">{{ format(parseISO(activity?.createdAt), 'PPpp') }}</td>\r\n                                        </tr>\r\n                                    </tbody>\r\n                                </table>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <Title>{{ props.page.title }}</Title> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["DeletePopup"], {
        title: "Brief",
        message: "This will permanently remove the brief.",
        deleteVisibility: $setup.deletePopupVisibility,
        hideDeletePopup: function hideDeletePopup() {
          return $setup.deletePopupVisibility = false;
        },
        onDeleteSubmit: function onDeleteSubmit() {
          var _$setup$props$brief9;
          _ctx.deleteBrief((_$setup$props$brief9 = $setup.props.brief) === null || _$setup$props$brief9 === void 0 ? void 0 : _$setup$props$brief9.id);
          $setup.deletePopupVisibility = false;
        }
      }, null, 8 /* PROPS */, ["deleteVisibility", "hideDeletePopup", "onDeleteSubmit"])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["page", "briefID", "briefData"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=template&id=29c872d2&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=template&id=29c872d2&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-29c872d2"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "col-lg-12"
};
var _hoisted_3 = {
  "class": "card"
};
var _hoisted_4 = {
  "class": "card-header payment-details-header p-0"
};
var _hoisted_5 = {
  "class": "row align-items-center"
};
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "page-title-box d-sm-flex align-items-center justify-content-between"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", {
    "class": "mb-sm-0"
  }, "BRIEF")])], -1 /* HOISTED */);
});
var _hoisted_7 = {
  "class": "col-md-6 pb-3 align-col"
};
var _hoisted_8 = {
  "class": "toolTip-div"
};
var _hoisted_9 = {
  "class": "payment-actionListUl"
};
var _hoisted_10 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "btn btn-soft-secondary btn-sm dropdown",
    type: "button",
    "data-bs-toggle": "dropdown",
    "aria-expanded": "false"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-more-fill align-middle"
  })], -1 /* HOISTED */);
});
var _hoisted_12 = {
  "class": "dropdown-menu dropdown-menu-end"
};
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "dropdown-top-caret"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    width: "21",
    height: "9",
    role: "presentation"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("g", {
    fill: "#fff",
    "fill-rule": "evenodd"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    fill: "#fff",
    "fill-opacity": "0.1",
    d: "M1 9.092h19l-6.402-6.74c-1.717-1.806-4.485-1.8-6.196 0L1 9.093zM20.342 8l-6.02-6.336c-2.108-2.22-5.538-2.218-7.645 0L.658 8h19.684z"
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("path", {
    fill: "currentcolor",
    d: "M7.402 2.353c1.711-1.801 4.48-1.807 6.196 0L20 9.093H1l6.402-6.74z"
  })])])], -1 /* HOISTED */);
});
var _hoisted_14 = {
  "class": "fade-animation"
};
var _hoisted_15 = {
  id: "briefs",
  "class": "tab-pane fade show active",
  role: "tabpanel"
};
var _hoisted_16 = {
  "class": "card-body"
};
var _hoisted_17 = {
  "class": "tab-content text-muted"
};
var _hoisted_18 = {
  "class": "tab-pane active",
  id: "invoices",
  role: "tabpanel"
};
var _hoisted_19 = {
  "class": "row align-items-center"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [_hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Tooltip"], {
    onClickCapture: _cache[0] || (_cache[0] = function ($event) {
      var _$setup$props$briefDa, _$setup$props$briefDa2;
      return $setup.handleClick($event, (_$setup$props$briefDa = $setup.props.briefData) === null || _$setup$props$briefDa === void 0 ? void 0 : _$setup$props$briefDa.id, (_$setup$props$briefDa2 = $setup.props.briefData) === null || _$setup$props$briefDa2 === void 0 || (_$setup$props$briefDa2 = _$setup$props$briefDa2.brief_link) === null || _$setup$props$briefDa2 === void 0 ? void 0 : _$setup$props$briefDa2.brief_type);
    }),
    copyText: $setup.route($setup.props.page.formRoute, {
      id: $setup.props.briefData.encoded_id
    }),
    showText: $setup.props.briefData.encoded_id
  }, null, 8 /* PROPS */, ["copyText", "showText"])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [_hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_12, [_hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item",
    onClick: _cache[1] || (_cache[1] = function ($event) {
      return $setup.visitAddBrief();
    })
  }, "Create Brief")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      var _$setup$props$briefDa3, _$setup$props$briefDa4;
      return $setup.downloadBriefByType($setup.props.briefData.encoded_id, (_$setup$props$briefDa3 = $setup.props.briefData) === null || _$setup$props$briefDa3 === void 0 ? void 0 : _$setup$props$briefDa3.name, (_$setup$props$briefDa4 = $setup.props.briefData) === null || _$setup$props$briefDa4 === void 0 || (_$setup$props$briefDa4 = _$setup$props$briefDa4.brief_link) === null || _$setup$props$briefDa4 === void 0 ? void 0 : _$setup$props$briefDa4.brief_type);
    })
  }, "Download Brief")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    href: "#!",
    "class": "dropdown-item text-red",
    onClick: _cache[3] || (_cache[3] = function ($event) {
      return $setup.deletePopupVisibility = true;
    })
  }, "Delete Brief")])])])])])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"card-header pt-0 pb-0\">\r\n          <div class=\"row align-items-center\">\r\n            <div class=\"col-md-6 p-0\"> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" {{props.tabs}} "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <ul class=\"nav nav-tabs nav-tabs-custom nav-success border-0\" role=\"tablist\">\r\n                <li\r\n                    v-for=\"(tab, index) in props.page.tabs\"\r\n                    :key=\"index\"\r\n                    class=\"nav-item\"\r\n                >\r\n                    <Link\r\n                        :href=\"route(tab.route, props.briefID)\"\r\n                        class=\"nav-link\"\r\n                        :class=\"{'active' : tab.isActive}\"\r\n                    >\r\n                    {{tab.title}}\r\n                  </Link>\r\n                </li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n        </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_14, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_19, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "body", {}, undefined, true)])])])])])])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["DeletePopup"], {
    title: "Brief",
    message: "This will permanently remove the brief’s data.",
    deleteVisibility: $setup.deletePopupVisibility,
    hideDeletePopup: function hideDeletePopup() {
      return $setup.deletePopupVisibility = false;
    },
    onDeleteSubmit: function onDeleteSubmit() {
      var _$setup$props$page, _$setup$props$briefDa5;
      $setup.axios.post($setup.route((_$setup$props$page = $setup.props.page) === null || _$setup$props$page === void 0 ? void 0 : _$setup$props$page.deleteRoute), {
        id: (_$setup$props$briefDa5 = $setup.props.briefData) === null || _$setup$props$briefDa5 === void 0 ? void 0 : _$setup$props$briefDa5.id,
        fingerprint: $setup.fingerprint
      }).then(function (response) {
        if (!response.data.errors && response.status == 200) {
          $setup.useNotification().success(response.data.message);
          $setup.deletePopupVisibility = false;
          $setup.router.visit($setup.route('brief.list'));
        } else if (response.data.errors) {
          _ctx.errors = response.data.errors;
        }
      })["catch"](function (error) {
        console.error('Error:', error);
        $setup.useNotification().error('Brief Not Deleted!');
      });
    }
  }, null, 8 /* PROPS */, ["deleteVisibility", "hideDeletePopup", "onDeleteSubmit"])], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=template&id=aa27937e":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=template&id=aa27937e ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  key: 0,
  "class": "bx bx-chevron-down"
};
var _hoisted_2 = {
  "class": "selectDropdown"
};
var _hoisted_3 = ["onClick"];
var _hoisted_4 = {
  key: 0,
  "class": "bx bx-check"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([$setup.props["class"], {
      'disabled': $setup.props.disabled,
      'selectArea': $setup.props.inputStyleDefault
    }]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.inputStyle),
    ref: "selectAreaRef"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.visibility = !$setup.visibility;
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.selected.label) + " " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.suffix), 1 /* TEXT */), !$setup.props.hideArrow ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", _hoisted_1)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), $setup.visibility ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
    key: 0,
    "class": "selectDropdownArea",
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.dropDownStyle)
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_2, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.options, function (item, index) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      key: index,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([$setup.checkActive(item), {
        'disabled': item.disabled
      }]),
      onClick: function onClick($event) {
        return $setup.selectOption(item);
      }
    }, [!$setup.props.hideChecks ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", _hoisted_4)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(item.label), 1 /* TEXT */)], 10 /* CLASS, PROPS */, _hoisted_3);
  }), 128 /* KEYED_FRAGMENT */))])], 4 /* STYLE */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 6 /* CLASS, STYLE */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/CreatedAtColumn.vue?vue&type=template&id=4ecea53f":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/CreatedAtColumn.vue?vue&type=template&id=4ecea53f ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  style: {
    "white-space": "nowrap"
  }
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", _hoisted_1, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatDateTime(new Date($setup.props.item.created_at))), 1 /* TEXT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue?vue&type=template&id=ade29908":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/ActivitiesSection.vue?vue&type=template&id=ade29908 ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  "class": "single-payment-head"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  "class": "row"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  "class": "col-lg-6 col-sm-12"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Activities")])])], -1 /* HOISTED */);
var _hoisted_4 = {
  "class": "col-md-6 mb-4"
};
var _hoisted_5 = {
  id: "scroll-horizontal",
  "class": "table nowrap align-middle productsTables",
  style: {
    "width": "100%"
  }
};
var _hoisted_6 = {
  style: {
    "width": "40% !important"
  }
};
var _hoisted_7 = {
  style: {
    "width": "40% !important"
  }
};
var _hoisted_8 = {
  style: {
    "width": "20% !important",
    "white-space": "nowrap"
  }
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [_hoisted_3, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.activities, function (activity, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)("".concat(activity.userName, " ").concat(activity.os)), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(activity.ip), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(activity === null || activity === void 0 ? void 0 : activity.createdAt), 'PPpp')), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=template&id=da06ce6a&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=template&id=da06ce6a&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-da06ce6a"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = {
  "class": "single-payment-head"
};
var _hoisted_4 = {
  "class": "row"
};
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-lg-6 col-sm-12"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Activites")], -1 /* HOISTED */);
});
var _hoisted_6 = {
  "class": "col-lg-6 col-sm-12"
};
var _hoisted_7 = {
  "class": "payment-actionListUl"
};
var _hoisted_8 = {
  key: 0,
  id: "scroll-horizontal",
  "class": "table nowrap align-middle",
  style: {
    "width": "100%"
  }
};
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "VISITOR ID")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "IP ADDRESS")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "LOCATION")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "OS")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Activity")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "FINGERPRINT")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "VISITOR COUNT")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "DATE")])])], -1 /* HOISTED */);
});
var _hoisted_10 = {
  "class": "badge badge-soft-primary count"
};
var _hoisted_11 = {
  key: 1,
  "class": "text-center na"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    type: "button",
    "class": "btn btn-light exportPopup-toggle",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      var _$setup$props;
      return $setup.visitActivityDetailList((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.briefID);
    })
  }, " View Details ")])])])])]), $setup.props.activitiesLogs.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.activitiesLogs, function (brief, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.custom_id), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.ip), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.country), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.os), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Badge"], {
      badgeClass: "badge badge-soft-success",
      badgeText: brief.activity
    }, null, 8 /* PROPS */, ["badgeText"])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.fingerprint), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief.no_of_visits), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(brief.created_at), 'PPpp')), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_11, " No briefs activities in the last 6 months "))])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=template&id=4c071e58&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=template&id=4c071e58&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-4c071e58"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details mb-4"
};
var _hoisted_2 = {
  "class": "row"
};
var _hoisted_3 = {
  key: 0,
  "class": "col-12"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "alert alert-warning alert-dismissible alert-additional fade show",
    role: "alert"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "alert-body"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "d-flex align-items-center"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "flex-shrink-0 me-3"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-information-fill fs-16 align-middle"
  })]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "flex-grow-1"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h5", {
    "class": "alert-heading m-0 fs-14"
  }, " Uh oh, something went wrong! ")])])])], -1 /* HOISTED */);
});
var _hoisted_5 = {
  "class": "col-md-6 customerleftcol"
};
var _hoisted_6 = {
  key: 0,
  "class": "clickshowcontent"
};
var _hoisted_7 = {
  "class": "d-flex justify-content-between",
  style: {
    "color": "#30313d"
  }
};
var _hoisted_8 = {
  key: 0
};
var _hoisted_9 = {
  key: 0,
  "class": "long-text"
};
var _hoisted_10 = ["src"];
var _hoisted_11 = {
  "class": "list-item"
};
var _hoisted_12 = {
  key: 1,
  "class": "long-text"
};
var _hoisted_13 = ["onClick"];
var _hoisted_14 = ["onClick"];
var _hoisted_15 = {
  "class": "clickshowcontent"
};
var _hoisted_16 = {
  "class": "d-flex justify-content-between",
  style: {
    "color": "#30313d"
  }
};
var _hoisted_17 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bx-caret-right"
  }, null, -1 /* HOISTED */);
});
var _hoisted_18 = {
  "class": "showinnerdiv"
};
var _hoisted_19 = {
  key: 0,
  "class": "payment-detail-table"
};
var _hoisted_20 = {
  key: 0
};
var _hoisted_21 = {
  "class": "key-column"
};
var _hoisted_22 = {
  "class": "value-column"
};
var _hoisted_23 = {
  key: 1,
  "class": "text-muted"
};
var _hoisted_24 = {
  "class": "col-md-6 sticky-column"
};
var _hoisted_25 = {
  "class": "popup-details-input flex180"
};
var _hoisted_26 = ["onUpdate:modelValue"];
var _hoisted_27 = {
  "class": "popup-details-input"
};
var _hoisted_28 = ["onUpdate:modelValue"];
var _hoisted_29 = ["onClick"];
var _hoisted_30 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-delete-bin-fill"
  }, null, -1 /* HOISTED */);
});
var _hoisted_31 = [_hoisted_30];
var _hoisted_32 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "mdi mdi-plus"
  }, null, -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _ctx$locationDetails;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"single-payment-head\">\r\n            <h3>Summary</h3>\r\n        </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [!((_ctx$locationDetails = _ctx.locationDetails) !== null && _ctx$locationDetails !== void 0 && _ctx$locationDetails.ip) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Warning Alert "), _hoisted_4])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.briefDetails, function (briefDetail, sectionKey) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: sectionKey
    }, [sectionKey != 'images' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      onClick: $setup.showDetail
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["bx bx-caret-right", {
        rotateIcon: sectionKey === 'project_requirements'
      }])
    }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(sectionKey)), 1 /* TEXT */)]), sectionKey === 'project_details' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
      key: 0,
      "class": "purpleLink",
      onClick: $setup.showProjectDetailPopup
    }, " Edit")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), sectionKey === 'project_requirements' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
      key: 1,
      "class": "purpleLink showThis",
      onClick: $setup.showProjectReqPopup
    }, " Edit")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["showinnerdiv", {
        'flexVisible': sectionKey === 'project_requirements'
      }]),
      style: {
        "flex-direction": "column"
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": "detailscontentdiv",
      ref_for: true,
      ref: "detailContentDiv"
    }, [sectionKey != 'images' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 0
    }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(briefDetail, function (detail, key, index) {
      var _$setup$props$briefDe, _$setup$props$briefDe2, _$setup$props$briefDe3;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: key
      }, [index <= $setup.details[sectionKey] ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(key)) + " ", 1 /* TEXT */), Array.isArray(detail) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["list-container", (_$setup$props$briefDe = $setup.props.briefDetails) !== null && _$setup$props$briefDe !== void 0 && (_$setup$props$briefDe = _$setup$props$briefDe.images) !== null && _$setup$props$briefDe !== void 0 && _$setup$props$briefDe[key] ? 'image-list-container' : ''])
      }, [(_$setup$props$briefDe2 = $setup.props.briefDetails) !== null && _$setup$props$briefDe2 !== void 0 && (_$setup$props$briefDe2 = _$setup$props$briefDe2.images) !== null && _$setup$props$briefDe2 !== void 0 && _$setup$props$briefDe2[key] ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 0
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)((_$setup$props$briefDe3 = $setup.props.briefDetails) === null || _$setup$props$briefDe3 === void 0 || (_$setup$props$briefDe3 = _$setup$props$briefDe3.images) === null || _$setup$props$briefDe3 === void 0 ? void 0 : _$setup$props$briefDe3[key], function (imageItem, imageKey, imageIndex) {
        var _$setup$props$briefDe4;
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
          key: imageItem.trim()
        }, [detail.includes(imageKey) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
          key: 0,
          "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["list-item", {
            'image-list-item': (_$setup$props$briefDe4 = $setup.props.briefDetails) === null || _$setup$props$briefDe4 === void 0 ? void 0 : _$setup$props$briefDe4.images[key]
          }])
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
          src: $setup.siteURL + imageItem,
          alt: "",
          "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)({
            'opacity-100 grayscale-0 purple-border': detail.includes(imageKey)
          })
        }, null, 10 /* CLASS, PROPS */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(imageKey.trim())), 1 /* TEXT */)], 2 /* CLASS */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
      }), 128 /* KEYED_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(detail, function (item) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(item.trim())), 1 /* TEXT */);
      }), 256 /* UNKEYED_FRAGMENT */))], 2 /* CLASS */)])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(detail), 1 /* TEXT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
    }), 128 /* KEYED_FRAGMENT */)), $setup.details[sectionKey] < Object.entries(briefDetail).length ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
      key: 0,
      "class": "detailsshowmorebtn",
      onClick: function onClick($event) {
        return $setup.details[sectionKey] = Object.entries(briefDetail).length + 1;
      }
    }, "Show More", 8 /* PROPS */, _hoisted_13)) : $setup.details[sectionKey] > Object.entries(briefDetail).length && Object.entries(briefDetail).length > 7 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
      key: 1,
      "class": "detailsshowmorebtn",
      onClick: function onClick($event) {
        return $setup.details[sectionKey] = 7;
      }
    }, "Show Less", 8 /* PROPS */, _hoisted_14)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 512 /* NEED_PATCH */)], 2 /* CLASS */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
  }), 128 /* KEYED_FRAGMENT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    onClick: $setup.showDetail
  }, [_hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Metadata")]), _ctx.$modulePermission('Customer', 'Edit') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
    key: 0,
    "class": "purpleLink showThis",
    onClick: $setup.showMetaPopup
  }, "Edit")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [$setup.props.metaData.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_19, [Object.entries($setup.metaInputs).length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tbody", _hoisted_20, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.metadata, function (meta, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(meta.key), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(meta.value), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_23, " No metadata "))])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"clickshowcontent\">\r\n                    <div class=\"d-flex justify-content-between\" style=\"color: #30313d;\">\r\n                        <a @click=\"showDetail\"><i  class=\"bx bx-caret-right rotateIcon\"></i> Insights</a>\r\n                    </div>\r\n\r\n                    <div class=\"showinnerdiv flexVisible row\">\r\n                            <div class=\"insight-row\">\r\n                                <div class=\"insight-chunk\" v-if=\"props.designation\">\r\n                                    <small class=\"insight-label\">\r\n                                        Designation\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ props.designation }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Total Spent\r\n                                    </small>\r\n                                    <span class=\"insight-value\">${{ props.total_cost }}</span>\r\n                                </div>\r\n                                <div v-if=\"props.briefDetail?.customer\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Submitted By\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ `${props.briefDetail?.customer?.first_name} ${props.briefDetail?.customer?.last_name}` }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Date Submitted On\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ format(parseISO(props.briefDetail.created_at), \"PPpp\") }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Submission Accuracy\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ props.submissionAccuracy }}%</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        State\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails?.state_prov ? locationDetails?.state_prov : 'Not Provided'  }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        City\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails?.city ? locationDetails.city : 'Not Provided' }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Country\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails?.country_name ? locationDetails.country_name : 'Not Provided' }}</span>\r\n                                </div>\r\n                                <div v-if=\"props.briefDetail\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        IP Address\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails?.ip }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Device\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ deviceDetails?.type }}</span>\r\n                                </div>\r\n                                <div v-if=\"deviceDetails\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Device Type\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ (deviceDetails?.os) ? deviceDetails?.os + ', ' : '' }}{{ (deviceDetails?.['device-brand']) ? deviceDetails?.['device-brand'] + ', ' : '' }}{{ (deviceDetails?.['name']) ? deviceDetails?.['name'] + ', ' : '' }}{{ (deviceDetails?.['device-model']) ? deviceDetails?.['device-model'] : '' }}</span>\r\n                                </div>\r\n                                <div v-if=\"deviceDetails\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Operating System\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ (deviceDetails?.os) ? deviceDetails?.os + ', ' : '' }}{{ (deviceDetails?.['os-family']) ? deviceDetails?.['os-family'] + ', ': '' }}{{ (deviceDetails?.['os-version']) ? deviceDetails?.['os-version'] + ', ' : '' }}{{ (deviceDetails?.['device-width-px']) ? deviceDetails?.['device-width-px'] + ', ' : '' }}{{ deviceDetails?.['device-height-px'] }}</span>\r\n                                </div>\r\n                                <div v-if=\"deviceDetails?.['browser-engine']\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Engine\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ deviceDetails?.['browser-engine'] }}</span>\r\n                                </div>\r\n                                <div class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Zip Code\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails?.zipcode ? locationDetails.zipcode : 'Not Provided' }}</span>\r\n                                </div>\r\n                                <div v-if=\"locationDetails && locationDetails['geocode-reverse']\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Address\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ locationDetails['geocode-reverse'] && locationDetails['geocode-reverse']?.address ? locationDetails['geocode-reverse']?.address : 'Not Provided' }}</span>\r\n                                </div>\r\n                                <div v-if=\"binLookupData\" class=\"insight-chunk\">\r\n                                    <small class=\"insight-label\">\r\n                                        Bank\r\n                                    </small>\r\n                                    <span class=\"insight-value\">{{ binLookupData?.issuer }} {{ binLookupData?.country ? \" - \" + capitalizeWords(binLookupData.country) : \"\" }}</span>\r\n                                </div>\r\n                            </div>\r\n                    </div>\r\n                </div> ")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["TimeLine"], {
    "class": "mb-4",
    logs: $setup.props.logs,
    id: $setup.props.briefID,
    routeTo: $setup.props.routeTo,
    logType: $setup.props.logType
  }, null, 8 /* PROPS */, ["logs", "id", "routeTo", "logType"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("<div id=\"gmaps-markers\" class=\"gmaps\"></div>"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <div class=\"mapdiv\">\r\n                    <h6>LOCATION</h6>\r\n                    <div id=\"map\" v-show=\"mapShow\">\r\n                        <l-map ref=\"mapL\" v-model:zoom=\"zoom\" :center=\"[coordinates.lat, coordinates.lng]\" update:visible=\"mapShow\">\r\n                            <l-tile-layer\r\n                                url=\"https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png\"\r\n                                layer-type=\"base\"\r\n                                name=\"OpenStreetMap\"\r\n                                :attribution=\"attribution\"\r\n                            ></l-tile-layer>\r\n                            <l-marker :lat-lng=\"[coordinates.lat, coordinates.lng]\"></l-marker>\r\n                        </l-map>\r\n                    </div>\r\n\r\n                </div> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <RecentActivity class=\"mt-4 mb-4\" :logs=\"props.logs\" :id=\"props.briefID\" :routeTo=\"props.routeTo\" :logType=\"props.logType\" /> ")])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: "Edit metadata",
    "class": "metaPopupArea",
    visibility: $setup.metadataPopupVisibility,
    onClose: $setup.hideMetaPopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.metaInputs, function (input, index) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
          key: index,
          "class": "flex-inputArea"
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_25, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.key = $event;
          },
          type: "text",
          placeholder: "Key"
        }, null, 8 /* PROPS */, _hoisted_26), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.key]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_27, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.value = $event;
          },
          type: "text",
          placeholder: "Value"
        }, null, 8 /* PROPS */, _hoisted_28), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.value]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
          "class": "deleteArea",
          onClick: function onClick($event) {
            return $setup.removeInput(index);
          }
        }, [].concat(_hoisted_31), 8 /* PROPS */, _hoisted_29)]);
      }), 128 /* KEYED_FRAGMENT */))];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
        "class": "btn-to-start"
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.addInput
      }, [_hoisted_32, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add another item ")])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.hideMetaPopup
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: $setup.updateMetadata
      }, " Save ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["visibility"]), $setup.props.briefDetail.brief_link.brief_type == 'logo_brief' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["ProjectDetailLogoPopup"], {
    key: 0,
    title: "Update Project Details",
    projectDetail: $setup.props.briefDetails.project_details,
    popupVisibility: $setup.projectdetailPopupVisibility,
    hidePopup: $setup.hideProjectDetailPopup,
    onSubmit: function onSubmit(formData) {
      return _ctx.updateCustomer(formData);
    },
    isUpdate: true
  }, null, 8 /* PROPS */, ["projectDetail", "popupVisibility", "onSubmit"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.props.briefDetail.brief_link.brief_type == 'logo_brief' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["ProjectReqLogoPopup"], {
    key: 1,
    title: "Update Project Requirements",
    projectReq: $setup.props.briefDetails.project_requirements,
    popupVisibility: $setup.projectreqPopupVisibility,
    hidePopup: $setup.hideProjectReqPopup,
    onSubmit: function onSubmit(formData) {
      return _ctx.updateCustomer(formData);
    },
    isUpdate: true
  }, null, 8 /* PROPS */, ["projectReq", "popupVisibility", "onSubmit"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=template&id=5019318e&scoped=true":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=template&id=5019318e&scoped=true ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5019318e"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "single-payment-head"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "row"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-lg-6 col-sm-12"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Insights")])])], -1 /* HOISTED */);
});
var _hoisted_4 = {
  "class": "row"
};
var _hoisted_5 = {
  "class": "col-md-6 customerleftcol"
};
var _hoisted_6 = {
  "class": "insight-row"
};
var _hoisted_7 = {
  key: 0,
  "class": "insight-chunk"
};
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Designation ", -1 /* HOISTED */);
});
var _hoisted_9 = {
  "class": "insight-value black-text"
};
var _hoisted_10 = {
  "class": "insight-chunk"
};
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Total Spent ", -1 /* HOISTED */);
});
var _hoisted_12 = {
  "class": "insight-value black-text"
};
var _hoisted_13 = {
  key: 1,
  "class": "insight-chunk"
};
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Submitted By ", -1 /* HOISTED */);
});
var _hoisted_15 = {
  "class": "insight-value black-text"
};
var _hoisted_16 = {
  "class": "insight-chunk"
};
var _hoisted_17 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Date Submitted On ", -1 /* HOISTED */);
});
var _hoisted_18 = {
  "class": "insight-value black-text"
};
var _hoisted_19 = {
  "class": "insight-chunk"
};
var _hoisted_20 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Submission Accuracy ", -1 /* HOISTED */);
});
var _hoisted_21 = {
  "class": "insight-chunk"
};
var _hoisted_22 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " State ", -1 /* HOISTED */);
});
var _hoisted_23 = {
  "class": "insight-value black-text"
};
var _hoisted_24 = {
  "class": "insight-chunk"
};
var _hoisted_25 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " City ", -1 /* HOISTED */);
});
var _hoisted_26 = {
  "class": "insight-value black-text"
};
var _hoisted_27 = {
  "class": "insight-chunk"
};
var _hoisted_28 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Country ", -1 /* HOISTED */);
});
var _hoisted_29 = {
  "class": "insight-value black-text"
};
var _hoisted_30 = {
  key: 2,
  "class": "insight-chunk"
};
var _hoisted_31 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " IP Address ", -1 /* HOISTED */);
});
var _hoisted_32 = {
  "class": "insight-value black-text"
};
var _hoisted_33 = {
  "class": "insight-chunk"
};
var _hoisted_34 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Device ", -1 /* HOISTED */);
});
var _hoisted_35 = {
  "class": "insight-value black-text"
};
var _hoisted_36 = {
  key: 3,
  "class": "insight-chunk"
};
var _hoisted_37 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Device Type ", -1 /* HOISTED */);
});
var _hoisted_38 = {
  "class": "insight-value black-text"
};
var _hoisted_39 = {
  key: 4,
  "class": "insight-chunk"
};
var _hoisted_40 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Operating System ", -1 /* HOISTED */);
});
var _hoisted_41 = {
  "class": "insight-value black-text"
};
var _hoisted_42 = {
  key: 5,
  "class": "insight-chunk"
};
var _hoisted_43 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Engine ", -1 /* HOISTED */);
});
var _hoisted_44 = {
  "class": "insight-value black-text"
};
var _hoisted_45 = {
  "class": "insight-chunk"
};
var _hoisted_46 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Zip Code ", -1 /* HOISTED */);
});
var _hoisted_47 = {
  "class": "insight-value black-text"
};
var _hoisted_48 = {
  key: 6,
  "class": "insight-chunk"
};
var _hoisted_49 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", {
    "class": "insight-label"
  }, " Bank ", -1 /* HOISTED */);
});
var _hoisted_50 = {
  "class": "insight-value black-text"
};
var _hoisted_51 = {
  "class": "col-md-6 sticky-column"
};
var _hoisted_52 = {
  "class": "mapdiv"
};
var _hoisted_53 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h6", null, "LOCATION", -1 /* HOISTED */);
});
var _hoisted_54 = {
  id: "map"
};
var _hoisted_55 = {
  "class": "insight-table payment-detail-table"
};
var _hoisted_56 = {
  key: 0
};
var _hoisted_57 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", {
    "class": "key-column",
    style: {
      "width": "4%",
      "vertical-align": "baseline"
    }
  }, "Address", -1 /* HOISTED */);
});
var _hoisted_58 = {
  "class": "value-column"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$briefDe, _$setup$props$briefDe2, _$setup$props$briefDe3, _$setup$locationDetai, _$setup$locationDetai2, _$setup$locationDetai3, _$setup$locationDetai4, _$setup$locationDetai5, _$setup$deviceDetails, _$setup$deviceDetails2, _$setup$deviceDetails3, _$setup$deviceDetails4, _$setup$deviceDetails5, _$setup$deviceDetails6, _$setup$deviceDetails7, _$setup$deviceDetails8, _$setup$deviceDetails9, _$setup$deviceDetails10, _$setup$deviceDetails11, _$setup$deviceDetails12, _$setup$deviceDetails13, _$setup$deviceDetails14, _$setup$deviceDetails15, _$setup$deviceDetails16, _$setup$deviceDetails17, _$setup$deviceDetails18, _$setup$deviceDetails19, _$setup$deviceDetails20, _$setup$locationDetai6, _$setup$binLookupData, _$setup$binLookupData2, _$setup$locationDetai7, _$setup$locationDetai8;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [_hoisted_3, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [$setup.props.designation ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_7, [_hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.designation), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [_hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_12, "$" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.total_cost), 1 /* TEXT */)]), (_$setup$props$briefDe = $setup.props.briefDetail) !== null && _$setup$props$briefDe !== void 0 && _$setup$props$briefDe.customer ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_13, [_hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_15, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)("".concat((_$setup$props$briefDe2 = $setup.props.briefDetail) === null || _$setup$props$briefDe2 === void 0 || (_$setup$props$briefDe2 = _$setup$props$briefDe2.customer) === null || _$setup$props$briefDe2 === void 0 ? void 0 : _$setup$props$briefDe2.first_name, " ").concat((_$setup$props$briefDe3 = $setup.props.briefDetail) === null || _$setup$props$briefDe3 === void 0 || (_$setup$props$briefDe3 = _$setup$props$briefDe3.customer) === null || _$setup$props$briefDe3 === void 0 ? void 0 : _$setup$props$briefDe3.last_name)), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [_hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO($setup.props.briefDetail.created_at), "PPpp")), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_19, [_hoisted_20, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.accuracyColor)
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.submissionAccuracy) + "%", 3 /* TEXT, CLASS */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_21, [_hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_23, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$locationDetai = $setup.locationDetails) !== null && _$setup$locationDetai !== void 0 && _$setup$locationDetai.state_prov ? (_$setup$locationDetai2 = $setup.locationDetails) === null || _$setup$locationDetai2 === void 0 ? void 0 : _$setup$locationDetai2.state_prov : 'Not Provided'), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_24, [_hoisted_25, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$locationDetai3 = $setup.locationDetails) !== null && _$setup$locationDetai3 !== void 0 && _$setup$locationDetai3.city ? $setup.locationDetails.city : 'Not Provided'), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_27, [_hoisted_28, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$locationDetai4 = $setup.locationDetails) !== null && _$setup$locationDetai4 !== void 0 && _$setup$locationDetai4.country_name ? $setup.locationDetails.country_name : 'Not Provided'), 1 /* TEXT */)]), $setup.props.briefDetail ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_30, [_hoisted_31, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_32, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$locationDetai5 = $setup.locationDetails) === null || _$setup$locationDetai5 === void 0 ? void 0 : _$setup$locationDetai5.ip), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_33, [_hoisted_34, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_35, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails = $setup.deviceDetails) === null || _$setup$deviceDetails === void 0 ? void 0 : _$setup$deviceDetails.type), 1 /* TEXT */)]), $setup.deviceDetails ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_36, [_hoisted_37, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_38, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails2 = $setup.deviceDetails) !== null && _$setup$deviceDetails2 !== void 0 && _$setup$deviceDetails2.os ? ((_$setup$deviceDetails3 = $setup.deviceDetails) === null || _$setup$deviceDetails3 === void 0 ? void 0 : _$setup$deviceDetails3.os) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails4 = $setup.deviceDetails) !== null && _$setup$deviceDetails4 !== void 0 && _$setup$deviceDetails4['device-brand'] ? ((_$setup$deviceDetails5 = $setup.deviceDetails) === null || _$setup$deviceDetails5 === void 0 ? void 0 : _$setup$deviceDetails5['device-brand']) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails6 = $setup.deviceDetails) !== null && _$setup$deviceDetails6 !== void 0 && _$setup$deviceDetails6['name'] ? ((_$setup$deviceDetails7 = $setup.deviceDetails) === null || _$setup$deviceDetails7 === void 0 ? void 0 : _$setup$deviceDetails7['name']) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails8 = $setup.deviceDetails) !== null && _$setup$deviceDetails8 !== void 0 && _$setup$deviceDetails8['device-model'] ? (_$setup$deviceDetails9 = $setup.deviceDetails) === null || _$setup$deviceDetails9 === void 0 ? void 0 : _$setup$deviceDetails9['device-model'] : ''), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), $setup.deviceDetails ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_39, [_hoisted_40, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_41, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails10 = $setup.deviceDetails) !== null && _$setup$deviceDetails10 !== void 0 && _$setup$deviceDetails10.os ? ((_$setup$deviceDetails11 = $setup.deviceDetails) === null || _$setup$deviceDetails11 === void 0 ? void 0 : _$setup$deviceDetails11.os) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails12 = $setup.deviceDetails) !== null && _$setup$deviceDetails12 !== void 0 && _$setup$deviceDetails12['os-family'] ? ((_$setup$deviceDetails13 = $setup.deviceDetails) === null || _$setup$deviceDetails13 === void 0 ? void 0 : _$setup$deviceDetails13['os-family']) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails14 = $setup.deviceDetails) !== null && _$setup$deviceDetails14 !== void 0 && _$setup$deviceDetails14['os-version'] ? ((_$setup$deviceDetails15 = $setup.deviceDetails) === null || _$setup$deviceDetails15 === void 0 ? void 0 : _$setup$deviceDetails15['os-version']) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails16 = $setup.deviceDetails) !== null && _$setup$deviceDetails16 !== void 0 && _$setup$deviceDetails16['device-width-px'] ? ((_$setup$deviceDetails17 = $setup.deviceDetails) === null || _$setup$deviceDetails17 === void 0 ? void 0 : _$setup$deviceDetails17['device-width-px']) + ', ' : '') + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails18 = $setup.deviceDetails) === null || _$setup$deviceDetails18 === void 0 ? void 0 : _$setup$deviceDetails18['device-height-px']), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (_$setup$deviceDetails19 = $setup.deviceDetails) !== null && _$setup$deviceDetails19 !== void 0 && _$setup$deviceDetails19['browser-engine'] ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_42, [_hoisted_43, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_44, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$deviceDetails20 = $setup.deviceDetails) === null || _$setup$deviceDetails20 === void 0 ? void 0 : _$setup$deviceDetails20['browser-engine']), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_45, [_hoisted_46, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_47, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$locationDetai6 = $setup.locationDetails) !== null && _$setup$locationDetai6 !== void 0 && _$setup$locationDetai6.zipcode ? $setup.locationDetails.zipcode : 'Not Provided'), 1 /* TEXT */)]), $setup.binLookupData ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_48, [_hoisted_49, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_50, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$binLookupData = $setup.binLookupData) === null || _$setup$binLookupData === void 0 ? void 0 : _$setup$binLookupData.issuer) + " " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$binLookupData2 = $setup.binLookupData) !== null && _$setup$binLookupData2 !== void 0 && _$setup$binLookupData2.country ? " - " + $setup.capitalizeWords($setup.binLookupData.country) : ""), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_51, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("<div id=\"gmaps-markers\" class=\"gmaps\"></div>"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_52, [_hoisted_53, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_54, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["LMap"], {
    ref: "mapL",
    zoom: $setup.zoom,
    "onUpdate:zoom": _cache[0] || (_cache[0] = function ($event) {
      return $setup.zoom = $event;
    }),
    center: [$setup.coordinates.lat, $setup.coordinates.lng],
    "update:visible": "mapShow"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["LTileLayer"], {
        url: "https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png",
        "layer-type": "base",
        name: "OpenStreetMap",
        attribution: $setup.attribution
      }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["LMarker"], {
        "lat-lng": [$setup.coordinates.lat, $setup.coordinates.lng]
      }, null, 8 /* PROPS */, ["lat-lng"])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["zoom", "center"])], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.mapShow]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_55, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [$setup.locationDetails && $setup.locationDetails['geocode-reverse'] ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", _hoisted_56, [_hoisted_57, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_58, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.locationDetails['geocode-reverse'] && (_$setup$locationDetai7 = $setup.locationDetails['geocode-reverse']) !== null && _$setup$locationDetai7 !== void 0 && _$setup$locationDetai7.address ? (_$setup$locationDetai8 = $setup.locationDetails['geocode-reverse']) === null || _$setup$locationDetai8 === void 0 ? void 0 : _$setup$locationDetai8.address : 'Not Provided'), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RecentActivity"], {
    "class": "mt-4 mb-4",
    logs: $setup.props.logs,
    id: $setup.props.briefID,
    routeTo: $setup.props.routeTo,
    logType: $setup.props.logType
  }, null, 8 /* PROPS */, ["logs", "id", "routeTo", "logType"])])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/DetailSection.vue?vue&type=template&id=1b712698":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/DetailSection.vue?vue&type=template&id=1b712698 ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = {
  "class": "single-payment-head"
};
var _hoisted_4 = {
  "class": "row"
};
var _hoisted_5 = {
  "class": "col-lg-6 col-sm-12"
};
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-md-6"
};
var _hoisted_8 = {
  "class": "payment-detail-table"
};
var _hoisted_9 = {
  style: {
    "width": "15vw"
  }
};
var _hoisted_10 = {
  "class": "col-md-6"
};
var _hoisted_11 = {
  "class": "payment-detail-table"
};
var _hoisted_12 = {
  style: {
    "width": "15vw"
  }
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.heading) || "Heading")), 1 /* TEXT */)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.firstHalf, function (item, index) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(item.key || "")), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(item.value || "Not Available")), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.secondHalf, function (item, index) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(item.key || "")), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.formatText(item.value || "Not Available")), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])])])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=template&id=d91abef0&scoped=true":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=template&id=d91abef0&scoped=true ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-d91abef0"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "card col-12"
};
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "single-payment-head"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "row"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-lg-6 col-sm-12"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Related Brief")])])], -1 /* HOISTED */);
});
var _hoisted_4 = {
  style: {
    "overflow-x": "auto",
    "position": "relative",
    "padding-bottom": "1rem"
  }
};
var _hoisted_5 = {
  key: 0,
  id: "scroll-horizontal",
  "class": "table nowrap align-middle",
  style: {
    "width": "100%"
  }
};
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "PROJECT NAME")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th"), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "BRIEF TYPE")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "CUSTOMER")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "CUSTOMER EMAIL")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "DEVICE TYPE")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "DEVICE IP ADDRESS")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "RESPONSIBLE PARTIES")]), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "DATE")])])], -1 /* HOISTED */);
});
var _hoisted_7 = ["onClick"];
var _hoisted_8 = {
  style: {
    "position": "relative",
    "padding": "1rem"
  }
};
var _hoisted_9 = ["src", "onMouseover", "onMouseleave"];
var _hoisted_10 = ["onMouseover", "onMouseleave"];
var _hoisted_11 = {
  "class": "more-users"
};
var _hoisted_12 = {
  key: 0
};
var _hoisted_13 = {
  "class": "payment-actionListUl"
};
var _hoisted_14 = {
  "class": "dropdown d-inline-block"
};
var _hoisted_15 = ["onClick"];
var _hoisted_16 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-more-fill align-middle"
  }, null, -1 /* HOISTED */);
});
var _hoisted_17 = [_hoisted_16];
var _hoisted_18 = {
  key: 1,
  "class": "text-center na"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [_hoisted_3, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [$setup.props.relatedBrief.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_5, [_hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.relatedBrief, function (brief, i) {
    var _brief$brief_link$cus, _brief$brief_link, _brief$brief_link$cus2, _brief$brief_link2, _JSON$parse$name, _JSON$parse, _JSON$parse2, _JSON$parse3, _brief$responsible_pa, _brief$responsible_pa2, _brief$responsible_pa3, _brief$responsible_pa4, _brief$responsible_pa5;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i,
      onClick: function onClick($event) {
        return $setup.visitBriefDetail(brief);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(brief === null || brief === void 0 ? void 0 : brief.business_name), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Badge"], {
      style: {
        "max-width": "fit-content"
      },
      iconClass: "ri ri-check-line",
      iconPosition: "left",
      badgeClass: "badge badge-soft-warning-light",
      badgeText: (brief === null || brief === void 0 ? void 0 : brief.total_sum) === 0 ? 'Zero Startup' : "$".concat(brief === null || brief === void 0 ? void 0 : brief.total_sum)
    }, null, 8 /* PROPS */, ["badgeText"])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [brief !== null && brief !== void 0 && brief.brief_type ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Badge"], {
      key: 0,
      badgeClass: "badge badge-soft-".concat($setup.badgeClass(brief === null || brief === void 0 ? void 0 : brief.brief_type)),
      badgeText: $setup.formatText(brief === null || brief === void 0 ? void 0 : brief.brief_type)
    }, null, 8 /* PROPS */, ["badgeClass", "badgeText"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 1
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" -- ")], 64 /* STABLE_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_brief$brief_link$cus = (_brief$brief_link = brief.brief_link) === null || _brief$brief_link === void 0 || (_brief$brief_link = _brief$brief_link.customer) === null || _brief$brief_link === void 0 ? void 0 : _brief$brief_link.stripe_customer_id) !== null && _brief$brief_link$cus !== void 0 ? _brief$brief_link$cus : '--'), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_brief$brief_link$cus2 = (_brief$brief_link2 = brief.brief_link) === null || _brief$brief_link2 === void 0 || (_brief$brief_link2 = _brief$brief_link2.customer) === null || _brief$brief_link2 === void 0 ? void 0 : _brief$brief_link2.email) !== null && _brief$brief_link$cus2 !== void 0 ? _brief$brief_link$cus2 : '--'), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_JSON$parse$name = (_JSON$parse = JSON.parse(brief === null || brief === void 0 ? void 0 : brief.device)) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.name) !== null && _JSON$parse$name !== void 0 ? _JSON$parse$name : '--'), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(_JSON$parse2 = JSON.parse(brief === null || brief === void 0 ? void 0 : brief.device)) !== null && _JSON$parse2 !== void 0 && _JSON$parse2.version ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Badge"], {
      key: 0,
      badgeClass: "badge badge-soft-warning-light",
      badgeText: (_JSON$parse3 = JSON.parse(brief === null || brief === void 0 ? void 0 : brief.device)) === null || _JSON$parse3 === void 0 ? void 0 : _JSON$parse3.version
    }, null, 8 /* PROPS */, ["badgeText"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 1
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" -- ")], 64 /* STABLE_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_8, [brief !== null && brief !== void 0 && (_brief$responsible_pa = brief.responsible_parties) !== null && _brief$responsible_pa !== void 0 && _brief$responsible_pa.length ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 0
    }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(brief === null || brief === void 0 || (_brief$responsible_pa2 = brief.responsible_parties) === null || _brief$responsible_pa2 === void 0 ? void 0 : _brief$responsible_pa2.slice(0, 4), function (user, index) {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: user === null || user === void 0 ? void 0 : user.id
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        src: $setup.siteURL + ((user === null || user === void 0 ? void 0 : user.image) || 'backend/images/users/user-dummy-img.jpg'),
        "class": "user-image",
        style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
          zIndex: 5 - index,
          left: 0.5 * index + 'rem'
        }),
        onMouseover: function onMouseover($event) {
          return $setup.showTooltip("".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_").concat(user === null || user === void 0 ? void 0 : user.id, "_tooltip"));
        },
        onMouseleave: function onMouseleave($event) {
          return $setup.hideTooltip("".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_").concat(user === null || user === void 0 ? void 0 : user.id, "_tooltip"));
        }
      }, null, 44 /* STYLE, PROPS, NEED_HYDRATION */, _hoisted_9), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)("_".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_").concat(user === null || user === void 0 ? void 0 : user.id, "_tooltip hideTooltip custom-tooltip user-tooltip")),
        style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
          left: 0.5 * index + 1 + 'rem'
        })
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)("".concat(user === null || user === void 0 ? void 0 : user.first_name, " ").concat(user === null || user === void 0 ? void 0 : user.last_name)), 7 /* TEXT, CLASS, STYLE */)], 64 /* STABLE_FRAGMENT */);
    }), 128 /* KEYED_FRAGMENT */)), (brief === null || brief === void 0 || (_brief$responsible_pa3 = brief.responsible_parties) === null || _brief$responsible_pa3 === void 0 ? void 0 : _brief$responsible_pa3.length) > 4 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
      key: 0,
      onMouseover: function onMouseover($event) {
        return $setup.showTooltip("".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_more_users_tooltip"));
      },
      onMouseleave: function onMouseleave($event) {
        return $setup.hideTooltip("".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_more_users_tooltip"));
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)("+".concat(brief === null || brief === void 0 || (_brief$responsible_pa4 = brief.responsible_parties) === null || _brief$responsible_pa4 === void 0 ? void 0 : _brief$responsible_pa4.slice(4).length, " More")), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)("_".concat(i, "_").concat(brief === null || brief === void 0 ? void 0 : brief.id, "_more_users_tooltip hideTooltip custom-tooltip more-user-tooltip ")),
      style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
        left: 0.5 * _ctx.index + 1 + 'rem'
      })
    }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(brief === null || brief === void 0 || (_brief$responsible_pa5 = brief.responsible_parties) === null || _brief$responsible_pa5 === void 0 ? void 0 : _brief$responsible_pa5.slice(4), function (user, nameIndex) {
      var _brief$responsible_pa6;
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)("".concat(user === null || user === void 0 ? void 0 : user.first_name, " ").concat(user === null || user === void 0 ? void 0 : user.last_name)), 1 /* TEXT */), nameIndex !== (brief === null || brief === void 0 || (_brief$responsible_pa6 = brief.responsible_parties) === null || _brief$responsible_pa6 === void 0 ? void 0 : _brief$responsible_pa6.slice(4).length) - 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_12, ", ")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
    }), 256 /* UNKEYED_FRAGMENT */))], 6 /* CLASS, STYLE */)], 40 /* PROPS, NEED_HYDRATION */, _hoisted_10)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: 1
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" -- ")], 64 /* STABLE_FRAGMENT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["CreatedAtColumn"], {
      item: brief
    }, null, 8 /* PROPS */, ["item"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_13, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", {
      onClick: _cache[0] || (_cache[0] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {}, ["stop"]))
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_14, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      "class": "btn btn-soft-secondary btn-sm dropdown",
      type: "button",
      onClick: function onClick($event) {
        return $setup.toggleOptionsDropdown($event, brief);
      }
    }, [].concat(_hoisted_17), 8 /* PROPS */, _hoisted_15)])])])])], 8 /* PROPS */, _hoisted_7);
  }), 128 /* KEYED_FRAGMENT */))])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_18, " No related briefs "))])])]), $setup.selectedRowOptions ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["TableListOptions"], {
    key: 0,
    visibility: $setup.selectedRowOptions !== null,
    position: $setup.optionsDropdownPosition,
    onClose: $setup.resetOptionsDropdown,
    options: [{
      heading: "Action",
      links: [{
        onClick: function onClick() {
          var _$setup$selectedRowOp, _$setup$selectedRowOp2, _$setup$selectedRowOp3;
          $setup.downloadBriefByType((_$setup$selectedRowOp = $setup.selectedRowOptions) === null || _$setup$selectedRowOp === void 0 ? void 0 : _$setup$selectedRowOp.encoded_id, (_$setup$selectedRowOp2 = $setup.selectedRowOptions) === null || _$setup$selectedRowOp2 === void 0 ? void 0 : _$setup$selectedRowOp2.name, (_$setup$selectedRowOp3 = $setup.selectedRowOptions) === null || _$setup$selectedRowOp3 === void 0 ? void 0 : _$setup$selectedRowOp3.brief_type);
        },
        label: "Download"
      }]
    }, {
      heading: "Connections",
      links: [{
        link: _ctx.route("admin.customer.detail", {
          id: $setup.selectedRowOptions.brief_link.customer.id
        }),
        label: "View customer"
      }]
    }]
  }, null, 8 /* PROPS */, ["visibility", "position", "options"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=template&id=8ee637c6&scoped=true":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=template&id=8ee637c6&scoped=true ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-8ee637c6"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head"
};
var _hoisted_3 = {
  "class": "row align-items-end"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-md-6"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Recent activity")], -1 /* HOISTED */);
});
var _hoisted_5 = {
  key: 0,
  "class": "col-md-6 text-right"
};
var _hoisted_6 = {
  "class": "row mb-4"
};
var _hoisted_7 = {
  "class": "col-lg-12"
};
var _hoisted_8 = {
  "class": "mt-3 text-end"
};
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Esc", -1 /* HOISTED */);
});
var _hoisted_10 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
var _hoisted_12 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, $setup.props.showAddNoteButton ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [$setup.modulePermission('Notes', 'Create') ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
    key: 0,
    "class": "payment-head-link",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.addNoteBox = true;
    })
  }, "Add note")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
    ref: "noteTextarea",
    "class": "form-control",
    rows: "4",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $setup.note = $event;
    })
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.note]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "cancelbtn",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      $setup.addNoteBox = false;
      $setup.note = '';
      $setup.hideNoteBox();
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Cancel "), _hoisted_9]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addnotepurple",
    onClick: $setup.updateNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Save Changes "), _hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_11], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.editNoteID]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addnotepurple",
    onClick: $setup.addNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add note "), _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_13], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, !$setup.editNoteID]])])])], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.addNoteBox]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["RecentActivityList"], {
    onEditPin: $setup.editNote,
    onDeletePin: $setup.deleteNote,
    iconTypes: $setup.type,
    id: $setup.props.id,
    logs: $setup.logs(),
    logType: $setup.props.logType,
    routeTo: $setup.props.routeTo
  }, null, 8 /* PROPS */, ["id", "logs", "logType", "routeTo"])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=template&id=c973a14a&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=template&id=c973a14a&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-c973a14a"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "timeline-ul"
};
var _hoisted_2 = {
  "class": "timeline-details"
};
var _hoisted_3 = ["onClick"];
var _hoisted_4 = {
  key: 0,
  "class": "bx bx-dots-horizontal-rounded"
};
var _hoisted_5 = ["onFocusout"];
var _hoisted_6 = ["onClick"];
var _hoisted_7 = ["onClick"];
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Unpin", -1 /* HOISTED */);
});
var _hoisted_9 = [_hoisted_8];
var _hoisted_10 = ["onClick"];
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Edit", -1 /* HOISTED */);
});
var _hoisted_12 = [_hoisted_11];
var _hoisted_13 = ["onClick"];
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "color-red"
  }, "Delete", -1 /* HOISTED */);
});
var _hoisted_15 = [_hoisted_14];
var _hoisted_16 = {
  key: 0,
  "class": "pinToTop"
};
var _hoisted_17 = {
  key: 1
};
var _hoisted_18 = {
  key: 2
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("ul", _hoisted_1, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.logs, function (log, i) {
    var _$setup$typeIcon;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["bg-white text-muted", log.pin ? 'bx bxs-pin' : (_$setup$typeIcon = $setup.typeIcon(log.type, log.activity)) !== null && _$setup$typeIcon !== void 0 ? _$setup$typeIcon : 'mdi mdi-circle-outline'])
    }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      "class": "threedots",
      onClick: function onClick($event) {
        return $setup.openOptionPanel(i);
      }
    }, [log.type == 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_4)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 8 /* PROPS */, _hoisted_3), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": "threedotsclickopen",
      ref_for: true,
      ref: "itemRefs",
      onFocusout: function onFocusout($event) {
        return $setup.closeOptionPanel(i);
      }
    }, [log.pin == 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 0,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 1);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.pinToTopText), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_6)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.pin == 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 1,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 0);
      }
    }, [].concat(_hoisted_9), 8 /* PROPS */, _hoisted_7)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.editNote(i);
      }
    }, [].concat(_hoisted_12), 8 /* PROPS */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
      "class": "mb-0",
      onClick: function onClick($event) {
        return $setup.deleteNote(i);
      }
    }, [].concat(_hoisted_15), 8 /* PROPS */, _hoisted_13)], 40 /* PROPS, NEED_HYDRATION */, _hoisted_5), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, log.type == 'note']]), log.pin ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_16, "Pinned note")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.type != 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(log.created_at), "PPpp")), 1 /* TEXT */)])]);
  }), 128 /* KEYED_FRAGMENT */))]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=template&id=13cb636a&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=template&id=13cb636a&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-13cb636a"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "single-payment-head"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Events and logs")], -1 /* HOISTED */);
});
var _hoisted_3 = {
  "class": "row"
};
var _hoisted_4 = {
  "class": "col-md-5"
};
var _hoisted_5 = {
  "class": "nav nav-tabs eventlogtabul"
};
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "las la-sync"
  }, null, -1 /* HOISTED */);
});
var _hoisted_7 = {
  "class": "text-muted"
};
var _hoisted_8 = ["id", "href"];
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */);
});
var _hoisted_10 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, null, -1 /* HOISTED */);
});
var _hoisted_11 = {
  "class": "col-md-7"
};
var _hoisted_12 = {
  "class": "tab-content mt-2"
};
var _hoisted_13 = ["id"];
var _hoisted_14 = {
  key: 0,
  "class": "jsoncodemaindiv"
};
var _hoisted_15 = {
  "class": "jsoncodeContainer"
};
var _hoisted_16 = {
  "class": "jsonformat"
};
var _hoisted_17 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
    "class": "mb-2"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bx-arrow-to-left"
  }), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" From your application ")], -1 /* HOISTED */);
});
var _hoisted_18 = {
  "class": "jsoncodediv"
};
var _hoisted_19 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h5", null, "Request parameters", -1 /* HOISTED */);
});
var _hoisted_20 = {
  "class": "code line-numbers",
  style: {
    "text-align": "left"
  }
};
var _hoisted_21 = {
  id: "json-code"
};
var _hoisted_22 = {
  "class": "jsonformat"
};
var _hoisted_23 = {
  "class": "jsoncodediv"
};
var _hoisted_24 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h5", null, "Request body", -1 /* HOISTED */);
});
var _hoisted_25 = {
  "class": "code line-numbers",
  style: {
    "text-align": "left"
  }
};
var _hoisted_26 = {
  id: "json-code"
};
var _hoisted_27 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "bx bxs-chevron-down"
  }, null, -1 /* HOISTED */);
});
var _hoisted_28 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "showText"
  }, "See all", -1 /* HOISTED */);
});
var _hoisted_29 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Hide", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _directive_highlightjs = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveDirective)("highlightjs");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_5, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.logs, function (log, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: log.id
    }, [log.type == 'payment.intent.status' || log.type == 'api.call.status' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 0,
      onClick: _cache[0] || (_cache[0] = function ($event) {
        return $setup.changeCodeBtnStatus();
      })
    }, [_hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.eventType(log.type)) + " status:", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(log.activity), 1 /* TEXT */)])) : log.type != 'payment.attach_payment_method' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      key: 1,
      "class": "nav-item",
      onClick: _cache[1] || (_cache[1] = function ($event) {
        return $setup.changeCodeBtnStatus();
      })
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)('nav-link ' + (i == 0 ? 'active' : '')),
      id: 'tab' + log.id,
      "data-bs-toggle": "tab",
      href: '#eventlogtab' + log.id
    }, [log.event == 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", {
      key: 0,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)('tabtags ' + (log.code != 200 ? 'error' : ''))
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(log.code == 200 ? log.code + ' OK' : log.code + ' ERR'), 3 /* TEXT, CLASS */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.comment(log.response, log.activity, log.type) ? $setup.comment(log.response, log.activity, log.type) : $setup.capitalize(log.activity)) + " ", 1 /* TEXT */), _hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(log.created_at), "PPpp")), 1 /* TEXT */), _hoisted_10], 10 /* CLASS, PROPS */, _hoisted_8)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
  }), 128 /* KEYED_FRAGMENT */))])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.logs, function (log, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)('code-tab tab-pane fade show ' + (i == 0 ? 'active' : '')),
      id: 'eventlogtab' + log.id
    }, [log.type != 'payment.intent.status' || log.type != 'api.call.status' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_14, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [_hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("POST /v1/" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(log.activity) + " ", 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(log.code != 200 ? 'error' : '')
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(log.code == 200 ? log.code + ' OK' : log.code + ' ERR'), 3 /* TEXT, CLASS */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" <a href=\"#\">View log detail</a> "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [_hoisted_19, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("pre", _hoisted_20, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("code", _hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.highlightCode(log.request)), 1 /* TEXT */)])), [[_directive_highlightjs, $setup.highlightCode(log.request)]])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_22, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_23, [_hoisted_24, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("pre", _hoisted_25, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("code", _hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.highlightCode(log.response)), 1 /* TEXT */)])), [[_directive_highlightjs, $setup.highlightCode(log.response)]])])]), $setup.showHideCodeBtn ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("button", {
      key: 0,
      "class": "showhidebtnnew",
      ref_for: true,
      ref: "showHideBtn",
      onClick: $setup.showHideJsonData
    }, [_hoisted_27, _hoisted_28, _hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" lines ")], 512 /* NEED_PATCH */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 10 /* CLASS, PROPS */, _hoisted_13);
  }), 256 /* UNKEYED_FRAGMENT */))])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/MetaData/MetaData.vue?vue&type=template&id=64e832b2":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/MetaData/MetaData.vue?vue&type=template&id=64e832b2 ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "single-payment-details mb-4"
};
var _hoisted_2 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  "class": "col-lg-6 col-sm-12"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Metadata")], -1 /* HOISTED */);
var _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "bx bx-edit"
}, null, -1 /* HOISTED */);
var _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "Edit metadata", -1 /* HOISTED */);
var _hoisted_5 = [_hoisted_3, _hoisted_4];
var _hoisted_6 = {
  "class": "row"
};
var _hoisted_7 = {
  "class": "col-9"
};
var _hoisted_8 = {
  key: 0,
  "class": "payment-detail-table"
};
var _hoisted_9 = {
  key: 0
};
var _hoisted_10 = {
  key: 1,
  "class": "text-muted"
};
var _hoisted_11 = {
  "class": "popup-details-input flex180"
};
var _hoisted_12 = ["onUpdate:modelValue"];
var _hoisted_13 = {
  "class": "popup-details-input"
};
var _hoisted_14 = ["onUpdate:modelValue"];
var _hoisted_15 = ["onClick"];
var _hoisted_16 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "ri-delete-bin-fill"
}, null, -1 /* HOISTED */);
var _hoisted_17 = [_hoisted_16];
var _hoisted_18 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "mdi mdi-plus"
}, null, -1 /* HOISTED */);
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "single-payment-head"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "row"
  }, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-lg-6 col-sm-12"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", {
    "class": "payment-actionListUl"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: $setup.showMetaPopup,
    "class": "btn btn-soft-secondary btn-sm"
  }, [].concat(_hoisted_5))])])])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [$setup.props.metaData ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_8, [Object.entries($setup.metaInputs).length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tbody", _hoisted_9, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.metadata, function (meta, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(meta.key), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(meta.value), 1 /* TEXT */)]);
  }), 128 /* KEYED_FRAGMENT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_10, " No metadata "))])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Popup"], {
    title: "Edit metadata",
    "class": "metaPopupArea",
    visibility: $setup.metadataPopupVisibility,
    onClose: $setup.hideMetaPopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.metaInputs, function (input, index) {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
          key: index,
          "class": "flex-inputArea"
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.key = $event;
          },
          type: "text",
          placeholder: "Key"
        }, null, 8 /* PROPS */, _hoisted_12), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.key]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_13, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
          "onUpdate:modelValue": function onUpdateModelValue($event) {
            return input.value = $event;
          },
          type: "text",
          placeholder: "Value"
        }, null, 8 /* PROPS */, _hoisted_14), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, input.value]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
          "class": "deleteArea",
          onClick: function onClick($event) {
            return $setup.removeInput(index);
          }
        }, [].concat(_hoisted_17), 8 /* PROPS */, _hoisted_15)]);
      }), 128 /* KEYED_FRAGMENT */))];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
        "class": "btn-to-start"
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.addInput
      }, [_hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add another item ")])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: $setup.hideMetaPopup
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: $setup.updateMetadata
      }, " Save ")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["visibility"])], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=template&id=88b7d1a2":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=template&id=88b7d1a2 ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-head"
};
var _hoisted_2 = {
  "class": "popup-body"
};
var _hoisted_3 = {
  "class": "popup-footer"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$maxWidt;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-bg", "".concat($setup.props["class"], "bg ").concat($setup.visibilityClass)]),
    onClick: _cache[0] || (_cache[0] = function () {
      return $setup.onCloseFunction && $setup.onCloseFunction.apply($setup, arguments);
    })
  }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-area", "".concat($setup.props["class"], " ").concat($setup.visibilityClass)]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
      width: (_$setup$props$maxWidt = $setup.props.maxWidth) !== null && _$setup$props$maxWidt !== void 0 ? _$setup$props$maxWidt : '450px'
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.title), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "head")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "body")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "footer")])], 6 /* CLASS, STYLE */)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=template&id=77a755ad":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=template&id=77a755ad ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-details-area"
};
var _hoisted_2 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Proejct Details Information", -1 /* HOISTED */);
var _hoisted_3 = {
  "class": "popup-details-input"
};
var _hoisted_4 = {
  "class": "input-fieldset"
};
var _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "industry",
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Industry "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_6 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_7 = {
  "class": "popup-details-input"
};
var _hoisted_8 = {
  "class": "input-fieldset"
};
var _hoisted_9 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "business_description",
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Business Description "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_10 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_11 = {
  "class": "popup-details-input"
};
var _hoisted_12 = {
  "class": "input-fieldset"
};
var _hoisted_13 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "services",
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Services "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_14 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_15 = {
  "class": "popup-details-input"
};
var _hoisted_16 = {
  "class": "input-fieldset"
};
var _hoisted_17 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "class": "input-label mb-2"
}, "Typecase", -1 /* HOISTED */);
var _hoisted_18 = {
  "class": "checkbox_row"
};
var _hoisted_19 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "as_it_is",
  "class": "checkbox_label"
}, "As it is (as shared above)", -1 /* HOISTED */);
var _hoisted_20 = {
  "class": "checkbox_row"
};
var _hoisted_21 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "capital_letters",
  "class": "checkbox_label"
}, "In CAPITAL LETTERS", -1 /* HOISTED */);
var _hoisted_22 = {
  "class": "checkbox_row"
};
var _hoisted_23 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "small_letters",
  "class": "checkbox_label"
}, "In small letters", -1 /* HOISTED */);
var _hoisted_24 = {
  "class": "checkbox_row"
};
var _hoisted_25 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "open_to_ideas",
  "class": "checkbox_label"
}, "Open to ideas", -1 /* HOISTED */);
var _hoisted_26 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_27 = {
  "class": "popup-details-input"
};
var _hoisted_28 = {
  "class": "input-fieldset"
};
var _hoisted_29 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_idea",
  "class": "input-label mb-2"
}, "Idea / Concept", -1 /* HOISTED */);
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: $setup.props.title,
    "class": "detailsPopupArea",
    visibility: $setup.props.popupVisibility,
    onClose: $setup.props.hidePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$setup$props$errors, _$setup$props$errors2, _$setup$props$errors3, _$setup$props$errors4, _$setup$props$errors5, _$setup$props$errors6, _$setup$props$errors7, _$setup$props$errors8, _$setup$props$errors9, _$setup$props$errors10, _$setup$props$errors11, _$setup$props$errors12;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_4, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["Select"], {
        options: $setup.industryOptions,
        style: {
          "width": "100%"
        },
        modelValue: $setup.formData.industry,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
          return $setup.formData.industry = $event;
        })
      }, null, 8 /* PROPS */, ["modelValue"]), (_$setup$props$errors = $setup.props.errors) !== null && _$setup$props$errors !== void 0 && _$setup$props$errors.industry && ((_$setup$props$errors2 = $setup.props.errors) === null || _$setup$props$errors2 === void 0 ? void 0 : _$setup$props$errors2.industry.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors3 = $setup.props.errors) === null || _$setup$props$errors3 === void 0 ? void 0 : _$setup$props$errors3.industry[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Business Description",
        name: "business_description",
        "class": "input business-descripiton-input",
        "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
          return $setup.formData.business_description = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.business_description]]), (_$setup$props$errors4 = $setup.props.errors) !== null && _$setup$props$errors4 !== void 0 && _$setup$props$errors4.business_description && ((_$setup$props$errors5 = $setup.props.errors) === null || _$setup$props$errors5 === void 0 ? void 0 : _$setup$props$errors5.business_description.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors6 = $setup.props.errors) === null || _$setup$props$errors6 === void 0 ? void 0 : _$setup$props$errors6.business_description[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_12, [_hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Services",
        name: "services",
        "class": "input services-input",
        "onUpdate:modelValue": _cache[2] || (_cache[2] = function ($event) {
          return $setup.formData.services = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.services]]), (_$setup$props$errors7 = $setup.props.errors) !== null && _$setup$props$errors7 !== void 0 && _$setup$props$errors7.services && ((_$setup$props$errors8 = $setup.props.errors) === null || _$setup$props$errors8 === void 0 ? void 0 : _$setup$props$errors8.services.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors9 = $setup.props.errors) === null || _$setup$props$errors9 === void 0 ? void 0 : _$setup$props$errors9.services[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_16, [_hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "as_it_is",
        name: "logo_title[]",
        value: "as_it_is",
        "onUpdate:modelValue": _cache[3] || (_cache[3] = function ($event) {
          return $setup.formData.logo_title = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_title]]), _hoisted_19]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_20, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "capital_letters",
        name: "logo_title[]",
        value: "capital_letters",
        "onUpdate:modelValue": _cache[4] || (_cache[4] = function ($event) {
          return $setup.formData.logo_title = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_title]]), _hoisted_21]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_22, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "small_letters",
        name: "logo_title[]",
        value: "small_letters",
        "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
          return $setup.formData.logo_title = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_title]]), _hoisted_23]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "open_to_ideas",
        name: "logo_title[]",
        value: "open_to_ideas",
        "onUpdate:modelValue": _cache[6] || (_cache[6] = function ($event) {
          return $setup.formData.logo_title = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_title]]), _hoisted_25]), (_$setup$props$errors10 = $setup.props.errors) !== null && _$setup$props$errors10 !== void 0 && _$setup$props$errors10.logo_title && ((_$setup$props$errors11 = $setup.props.errors) === null || _$setup$props$errors11 === void 0 ? void 0 : _$setup$props$errors11.logo_title.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_26, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors12 = $setup.props.errors) === null || _$setup$props$errors12 === void 0 ? void 0 : _$setup$props$errors12.logo_title[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_27, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_28, [_hoisted_29, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Logo's concept",
        name: "logo_idea",
        "class": "input logo-idea-input",
        "onUpdate:modelValue": _cache[7] || (_cache[7] = function ($event) {
          return $setup.formData.logo_idea = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_idea]])])])])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[8] || (_cache[8] = function () {
          var _$setup$props;
          return $setup.props.hidePopup && (_$setup$props = $setup.props).hidePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: _cache[9] || (_cache[9] = function ($event) {
          return $setup.submit();
        })
      }, [$setup.props.isUpdate ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 0
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Update")], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Add")], 64 /* STABLE_FRAGMENT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(" ") + " Brief ")])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue?vue&type=template&id=27e6ef56":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue?vue&type=template&id=27e6ef56 ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-details-area"
};
var _hoisted_2 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Proejct Requirements Information", -1 /* HOISTED */);
var _hoisted_3 = {
  "class": "popup-details-input"
};
var _hoisted_4 = {
  "class": "input-fieldset"
};
var _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_message",
  "class": "input-label mb-2"
}, "Identity", -1 /* HOISTED */);
var _hoisted_6 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_7 = {
  "class": "popup-details-input"
};
var _hoisted_8 = {
  "class": "input-fieldset"
};
var _hoisted_9 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_graphical_element",
  "class": "input-label mb-2"
}, "Graphical Element", -1 /* HOISTED */);
var _hoisted_10 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_11 = {
  "class": "popup-details-input"
};
var _hoisted_12 = {
  "class": "input-fieldset"
};
var _hoisted_13 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_customer_likes",
  "class": "input-label mb-2"
}, "Preferences", -1 /* HOISTED */);
var _hoisted_14 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_15 = {
  "class": "popup-details-input"
};
var _hoisted_16 = {
  "class": "input-fieldset"
};
var _hoisted_17 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_customer_dont_likes",
  "class": "input-label mb-2"
}, "Avoidances", -1 /* HOISTED */);
var _hoisted_18 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_19 = {
  "class": "popup-details-input"
};
var _hoisted_20 = {
  "class": "input-fieldset"
};
var _hoisted_21 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "class": "input-label mb-2"
}, "Typography", -1 /* HOISTED */);
var _hoisted_22 = {
  "class": "checkbox-image-container"
};
var _hoisted_23 = {
  "for": "just_font",
  "class": "checkbox_image_label"
};
var _hoisted_24 = ["src"];
var _hoisted_25 = {
  "class": "checkbox-description"
};
var _hoisted_26 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Just font", -1 /* HOISTED */);
var _hoisted_27 = {
  "for": "handmade",
  "class": "checkbox_image_label"
};
var _hoisted_28 = ["src"];
var _hoisted_29 = {
  "class": "checkbox-description"
};
var _hoisted_30 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Handmade", -1 /* HOISTED */);
var _hoisted_31 = {
  "for": "initials",
  "class": "checkbox_image_label"
};
var _hoisted_32 = ["src"];
var _hoisted_33 = {
  "class": "checkbox-description"
};
var _hoisted_34 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Initials", -1 /* HOISTED */);
var _hoisted_35 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_36 = {
  "class": "popup-details-input"
};
var _hoisted_37 = {
  "class": "input-fieldset"
};
var _hoisted_38 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "class": "input-label mb-2"
}, "Style", -1 /* HOISTED */);
var _hoisted_39 = {
  "class": "checkbox-image-container"
};
var _hoisted_40 = {
  "for": "abstract_graphic",
  "class": "checkbox_image_label"
};
var _hoisted_41 = ["src"];
var _hoisted_42 = {
  "class": "checkbox-description"
};
var _hoisted_43 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Abstract graphic", -1 /* HOISTED */);
var _hoisted_44 = {
  "for": "silhouette",
  "class": "checkbox_image_label"
};
var _hoisted_45 = ["src"];
var _hoisted_46 = {
  "class": "checkbox-description"
};
var _hoisted_47 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Silhouette", -1 /* HOISTED */);
var _hoisted_48 = {
  "for": "illustrated_symbol",
  "class": "checkbox_image_label"
};
var _hoisted_49 = ["src"];
var _hoisted_50 = {
  "class": "checkbox-description"
};
var _hoisted_51 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Illustrated symbol", -1 /* HOISTED */);
var _hoisted_52 = {
  "for": "emblem_crests",
  "class": "checkbox_image_label"
};
var _hoisted_53 = ["src"];
var _hoisted_54 = {
  "class": "checkbox-description"
};
var _hoisted_55 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Emblem and Crests", -1 /* HOISTED */);
var _hoisted_56 = {
  "for": "mascot",
  "class": "checkbox_image_label"
};
var _hoisted_57 = ["src"];
var _hoisted_58 = {
  "class": "checkbox-description"
};
var _hoisted_59 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Mascot", -1 /* HOISTED */);
var _hoisted_60 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_61 = {
  "class": "popup-details-input"
};
var _hoisted_62 = {
  "class": "input-fieldset"
};
var _hoisted_63 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_color",
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Colors To Use "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_64 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_65 = {
  "class": "popup-details-input"
};
var _hoisted_66 = {
  "class": "input-fieldset"
};
var _hoisted_67 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_avoid_color",
  "class": "input-label mb-2"
}, "Colors To Avoid", -1 /* HOISTED */);
var _hoisted_68 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_69 = {
  "class": "popup-details-input"
};
var _hoisted_70 = {
  "class": "input-fieldset"
};
var _hoisted_71 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "logo_font",
  "class": "input-label mb-2"
}, "Font Style", -1 /* HOISTED */);
var _hoisted_72 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_73 = {
  "class": "popup-details-input"
};
var _hoisted_74 = {
  "class": "input-fieldset"
};
var _hoisted_75 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Logo Usage "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_76 = {
  "class": "checkbox_row"
};
var _hoisted_77 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "websites",
  "class": "checkbox_label"
}, "Websites", -1 /* HOISTED */);
var _hoisted_78 = {
  "class": "checkbox_row"
};
var _hoisted_79 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "business_stationery_printing",
  "class": "checkbox_label"
}, "Business Stationery Printing", -1 /* HOISTED */);
var _hoisted_80 = {
  "class": "checkbox_row"
};
var _hoisted_81 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "signage",
  "class": "checkbox_label"
}, "Signage / Billboards / Advertisement", -1 /* HOISTED */);
var _hoisted_82 = {
  "class": "checkbox_row"
};
var _hoisted_83 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "social_media",
  "class": "checkbox_label"
}, "Online Social Media", -1 /* HOISTED */);
var _hoisted_84 = {
  "class": "checkbox_row"
};
var _hoisted_85 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "tshirt_printing",
  "class": "checkbox_label"
}, "T-Shirt Printing", -1 /* HOISTED */);
var _hoisted_86 = {
  "class": "checkbox_row"
};
var _hoisted_87 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "car_wrap",
  "class": "checkbox_label"
}, "Car Wrap / Vinyls", -1 /* HOISTED */);
var _hoisted_88 = {
  "class": "checkbox_row"
};
var _hoisted_89 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "embroidery",
  "class": "checkbox_label"
}, "Embroidery", -1 /* HOISTED */);
var _hoisted_90 = {
  "class": "checkbox_row"
};
var _hoisted_91 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "packaging",
  "class": "checkbox_label"
}, "Packaging", -1 /* HOISTED */);
var _hoisted_92 = {
  "class": "checkbox_row"
};
var _hoisted_93 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "app_icon",
  "class": "checkbox_label"
}, "App Icon", -1 /* HOISTED */);
var _hoisted_94 = {
  "class": "checkbox_row"
};
var _hoisted_95 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "flyer_brochure",
  "class": "checkbox_label"
}, "Flyer / Brochure", -1 /* HOISTED */);
var _hoisted_96 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_97 = {
  "class": "popup-details-input"
};
var _hoisted_98 = {
  "class": "input-fieldset"
};
var _hoisted_99 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "class": "input-label mb-2"
}, "Strategy", -1 /* HOISTED */);
var _hoisted_100 = {
  "class": "checkbox_row"
};
var _hoisted_101 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "branding_design",
  "class": "checkbox_label"
}, "Branding design and their printing like business cards, letterheads, etc", -1 /* HOISTED */);
var _hoisted_102 = {
  "class": "checkbox_row"
};
var _hoisted_103 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "website",
  "class": "checkbox_label"
}, "Get a website for your business", -1 /* HOISTED */);
var _hoisted_104 = {
  "class": "checkbox_row"
};
var _hoisted_105 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "mobile_app",
  "class": "checkbox_label"
}, "Get a mobile app for your business", -1 /* HOISTED */);
var _hoisted_106 = {
  "class": "checkbox_row"
};
var _hoisted_107 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "digital_marketing",
  "class": "checkbox_label"
}, "Grow your business from digital marketing", -1 /* HOISTED */);
var _hoisted_108 = {
  "class": "checkbox_row"
};
var _hoisted_109 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "telesales_support",
  "class": "checkbox_label"
}, "Get a service of telesales and support professional via chat, call and email for your business", -1 /* HOISTED */);
var _hoisted_110 = {
  "class": "checkbox_row"
};
var _hoisted_111 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "print_ad",
  "class": "checkbox_label"
}, "Put an ad on magazine and other print media", -1 /* HOISTED */);
var _hoisted_112 = {
  "class": "checkbox_row"
};
var _hoisted_113 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "tradeshow_marketing",
  "class": "checkbox_label"
}, "Get marketing support for tradeshows", -1 /* HOISTED */);
var _hoisted_114 = {
  "class": "checkbox_row"
};
var _hoisted_115 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "other",
  "class": "checkbox_label"
}, "Other", -1 /* HOISTED */);
var _hoisted_116 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_117 = {
  "class": "popup-details-input"
};
var _hoisted_118 = {
  "class": "input-fieldset"
};
var _hoisted_119 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "anything_else",
  "class": "input-label mb-2"
}, "Note", -1 /* HOISTED */);
var _hoisted_120 = {
  key: 0,
  "class": "text-danger"
};
var _hoisted_121 = {
  "class": "popup-details-input"
};
var _hoisted_122 = {
  "class": "input-fieldset"
};
var _hoisted_123 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
  "for": "completion_date",
  "class": "input-label mb-2"
}, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Completion Date "), /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
  "class": "asterisk"
}, "*")], -1 /* HOISTED */);
var _hoisted_124 = {
  key: 0,
  "class": "text-danger"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: $setup.props.title,
    "class": "detailsPopupArea",
    visibility: $setup.props.popupVisibility,
    onClose: $setup.props.hidePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      var _$setup$props$errors, _$setup$props$errors2, _$setup$props$errors3, _$setup$props$errors4, _$setup$props$errors5, _$setup$props$errors6, _$setup$props$errors7, _$setup$props$errors8, _$setup$props$errors9, _$setup$props$errors10, _$setup$props$errors11, _$setup$props$errors12, _$setup$props$errors13, _$setup$props$errors14, _$setup$props$errors15, _$setup$props$errors16, _$setup$props$errors17, _$setup$props$errors18, _$setup$props$errors19, _$setup$props$errors20, _$setup$props$errors21, _$setup$props$errors22, _$setup$props$errors23, _$setup$props$errors24, _$setup$props$errors25, _$setup$props$errors26, _$setup$props$errors27, _$setup$props$errors28, _$setup$props$errors29, _$setup$props$errors30, _$setup$props$errors31, _$setup$props$errors32, _$setup$props$errors33, _$setup$props$errors34, _$setup$props$errors35, _$setup$props$errors36, _$setup$props$project, _$setup$props$errors37, _$setup$props$errors38, _$setup$props$errors39;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [_hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_4, [_hoisted_5, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Logo's Message",
        name: "logo_message",
        "class": "input logo-message-input",
        "onUpdate:modelValue": _cache[0] || (_cache[0] = function ($event) {
          return $setup.formData.logo_message = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_message]]), (_$setup$props$errors = $setup.props.errors) !== null && _$setup$props$errors !== void 0 && _$setup$props$errors.logo_message && ((_$setup$props$errors2 = $setup.props.errors) === null || _$setup$props$errors2 === void 0 ? void 0 : _$setup$props$errors2.logo_message.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors3 = $setup.props.errors) === null || _$setup$props$errors3 === void 0 ? void 0 : _$setup$props$errors3.logo_message[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_8, [_hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Logo's Graphical Element",
        name: "logo_graphical_element",
        "class": "input logo-graphical-element-input",
        "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
          return $setup.formData.logo_graphical_element = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_graphical_element]]), (_$setup$props$errors4 = $setup.props.errors) !== null && _$setup$props$errors4 !== void 0 && _$setup$props$errors4.logo_graphical_element && ((_$setup$props$errors5 = $setup.props.errors) === null || _$setup$props$errors5 === void 0 ? void 0 : _$setup$props$errors5.logo_graphical_element.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_10, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors6 = $setup.props.errors) === null || _$setup$props$errors6 === void 0 ? void 0 : _$setup$props$errors6.logo_graphical_element[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_12, [_hoisted_13, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Your Answer",
        name: "logo_customer_likes",
        "class": "input logo-customer-likes-input",
        "onUpdate:modelValue": _cache[2] || (_cache[2] = function ($event) {
          return $setup.formData.logo_customer_likes = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_customer_likes]]), (_$setup$props$errors7 = $setup.props.errors) !== null && _$setup$props$errors7 !== void 0 && _$setup$props$errors7.logo_customer_likes && ((_$setup$props$errors8 = $setup.props.errors) === null || _$setup$props$errors8 === void 0 ? void 0 : _$setup$props$errors8.logo_customer_likes.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors9 = $setup.props.errors) === null || _$setup$props$errors9 === void 0 ? void 0 : _$setup$props$errors9.logo_customer_likes[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_16, [_hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Your Answer",
        name: "logo_customer_dont_likes",
        "class": "input logo-customer-dont-likes-input",
        "onUpdate:modelValue": _cache[3] || (_cache[3] = function ($event) {
          return $setup.formData.logo_customer_dont_likes = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_customer_dont_likes]]), (_$setup$props$errors10 = $setup.props.errors) !== null && _$setup$props$errors10 !== void 0 && _$setup$props$errors10.logo_customer_dont_likes && ((_$setup$props$errors11 = $setup.props.errors) === null || _$setup$props$errors11 === void 0 ? void 0 : _$setup$props$errors11.logo_customer_dont_likes.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors12 = $setup.props.errors) === null || _$setup$props$errors12 === void 0 ? void 0 : _$setup$props$errors12.logo_customer_dont_likes[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_19, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_20, [_hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_22, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_23, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.font_base_logo.includes('just_font') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-1.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_24), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_25, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "just_font",
        name: "font_base_logo[]",
        value: "just_font",
        "onUpdate:modelValue": _cache[4] || (_cache[4] = function ($event) {
          return $setup.formData.font_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.font_base_logo]]), _hoisted_26])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_27, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.font_base_logo.includes('handmade') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-2.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_28), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_29, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "handmade",
        name: "font_base_logo[]",
        value: "handmade",
        "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
          return $setup.formData.font_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.font_base_logo]]), _hoisted_30])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_31, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.font_base_logo.includes('initials') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-3.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_32), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_33, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "initials",
        name: "font_base_logo[]",
        value: "initials",
        "onUpdate:modelValue": _cache[6] || (_cache[6] = function ($event) {
          return $setup.formData.font_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.font_base_logo]]), _hoisted_34])])]), (_$setup$props$errors13 = $setup.props.errors) !== null && _$setup$props$errors13 !== void 0 && _$setup$props$errors13.font_base_logo && ((_$setup$props$errors14 = $setup.props.errors) === null || _$setup$props$errors14 === void 0 ? void 0 : _$setup$props$errors14.font_base_logo.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_35, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors15 = $setup.props.errors) === null || _$setup$props$errors15 === void 0 ? void 0 : _$setup$props$errors15.font_base_logo[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_36, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_37, [_hoisted_38, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_39, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_40, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.graphic_base_logo.includes('abstract_graphic') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-4.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_41), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_42, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "abstract_graphic",
        name: "graphic_base_logo[]",
        value: "abstract_graphic",
        "onUpdate:modelValue": _cache[7] || (_cache[7] = function ($event) {
          return $setup.formData.graphic_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.graphic_base_logo]]), _hoisted_43])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_44, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.graphic_base_logo.includes('silhouette') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-5.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_45), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_46, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "silhouette",
        name: "graphic_base_logo[]",
        value: "silhouette",
        "onUpdate:modelValue": _cache[8] || (_cache[8] = function ($event) {
          return $setup.formData.graphic_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.graphic_base_logo]]), _hoisted_47])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_48, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.graphic_base_logo.includes('illustrated_symbol') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-6.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_49), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_50, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "illustrated_symbol",
        name: "graphic_base_logo[]",
        value: "illustrated_symbol",
        "onUpdate:modelValue": _cache[9] || (_cache[9] = function ($event) {
          return $setup.formData.graphic_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.graphic_base_logo]]), _hoisted_51])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_52, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.graphic_base_logo.includes('emblem_crests') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-7.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_53), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_54, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "emblem_crests",
        name: "graphic_base_logo[]",
        value: "emblem_crests",
        "onUpdate:modelValue": _cache[10] || (_cache[10] = function ($event) {
          return $setup.formData.graphic_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.graphic_base_logo]]), _hoisted_55])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_56, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["checkbox-image-option purple-border", $setup.formData.graphic_base_logo.includes('mascot') ? '' : 'unchecked-img']),
        src: $setup.siteURL + 'backend/images/design-brief/image-8.jpg',
        alt: ""
      }, null, 10 /* CLASS, PROPS */, _hoisted_57), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_58, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        "class": "checkbox-image-input",
        type: "checkbox",
        id: "mascot",
        name: "graphic_base_logo[]",
        value: "mascot",
        "onUpdate:modelValue": _cache[11] || (_cache[11] = function ($event) {
          return $setup.formData.graphic_base_logo = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.graphic_base_logo]]), _hoisted_59])])]), (_$setup$props$errors16 = $setup.props.errors) !== null && _$setup$props$errors16 !== void 0 && _$setup$props$errors16.graphic_base_logo && ((_$setup$props$errors17 = $setup.props.errors) === null || _$setup$props$errors17 === void 0 ? void 0 : _$setup$props$errors17.graphic_base_logo.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_60, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors18 = $setup.props.errors) === null || _$setup$props$errors18 === void 0 ? void 0 : _$setup$props$errors18.graphic_base_logo[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_61, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_62, [_hoisted_63, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Eg: Red, Yellow, Black, etc. ",
        name: "logo_color",
        "class": "input logo-color-input",
        "onUpdate:modelValue": _cache[12] || (_cache[12] = function ($event) {
          return $setup.formData.logo_color = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_color]]), (_$setup$props$errors19 = $setup.props.errors) !== null && _$setup$props$errors19 !== void 0 && _$setup$props$errors19.graphic_base_logo && ((_$setup$props$errors20 = $setup.props.errors) === null || _$setup$props$errors20 === void 0 ? void 0 : _$setup$props$errors20.graphic_base_logo.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_64, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors21 = $setup.props.errors) === null || _$setup$props$errors21 === void 0 ? void 0 : _$setup$props$errors21.graphic_base_logo[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_65, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_66, [_hoisted_67, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Eg: Red, Yellow, Black, etc. ",
        name: "logo_avoid_color",
        "class": "input logo-avoid-color-input",
        "onUpdate:modelValue": _cache[13] || (_cache[13] = function ($event) {
          return $setup.formData.logo_avoid_color = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_avoid_color]]), (_$setup$props$errors22 = $setup.props.errors) !== null && _$setup$props$errors22 !== void 0 && _$setup$props$errors22.logo_avoid_color && ((_$setup$props$errors23 = $setup.props.errors) === null || _$setup$props$errors23 === void 0 ? void 0 : _$setup$props$errors23.logo_avoid_color.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_68, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors24 = $setup.props.errors) === null || _$setup$props$errors24 === void 0 ? void 0 : _$setup$props$errors24.logo_avoid_color[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_69, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_70, [_hoisted_71, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Eg: Bold, Fancy, Signature, etc. ",
        name: "logo_font",
        "class": "input logo-font-input",
        "onUpdate:modelValue": _cache[14] || (_cache[14] = function ($event) {
          return $setup.formData.logo_font = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.logo_font]]), (_$setup$props$errors25 = $setup.props.errors) !== null && _$setup$props$errors25 !== void 0 && _$setup$props$errors25.logo_font && ((_$setup$props$errors26 = $setup.props.errors) === null || _$setup$props$errors26 === void 0 ? void 0 : _$setup$props$errors26.logo_font.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_72, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors27 = $setup.props.errors) === null || _$setup$props$errors27 === void 0 ? void 0 : _$setup$props$errors27.logo_font[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_73, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_74, [_hoisted_75, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_76, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "websites",
        name: "logo_use[]",
        value: "websites",
        "onUpdate:modelValue": _cache[15] || (_cache[15] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_77]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_78, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "business_stationery_printing",
        name: "logo_use[]",
        value: "business_stationery_printing",
        "onUpdate:modelValue": _cache[16] || (_cache[16] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_79]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_80, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "signage",
        name: "logo_use[]",
        value: "signage",
        "onUpdate:modelValue": _cache[17] || (_cache[17] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_81]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_82, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "social_media",
        name: "logo_use[]",
        value: "social_media",
        "onUpdate:modelValue": _cache[18] || (_cache[18] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_83]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_84, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "tshirt_printing",
        name: "logo_use[]",
        value: "tshirt_printing",
        "onUpdate:modelValue": _cache[19] || (_cache[19] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_85]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_86, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "car_wrap",
        name: "logo_use[]",
        value: "car_wrap",
        "onUpdate:modelValue": _cache[20] || (_cache[20] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_87]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_88, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "embroidery",
        name: "logo_use[]",
        value: "embroidery",
        "onUpdate:modelValue": _cache[21] || (_cache[21] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_89]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_90, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "packaging",
        name: "logo_use[]",
        value: "packaging",
        "onUpdate:modelValue": _cache[22] || (_cache[22] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_91]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_92, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "app_icon",
        name: "logo_use[]",
        value: "app_icon",
        "onUpdate:modelValue": _cache[23] || (_cache[23] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_93]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_94, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "flyer_brochure",
        name: "logo_use[]",
        value: "flyer_brochure",
        "onUpdate:modelValue": _cache[24] || (_cache[24] = function ($event) {
          return $setup.formData.logo_use = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.logo_use]]), _hoisted_95]), (_$setup$props$errors28 = $setup.props.errors) !== null && _$setup$props$errors28 !== void 0 && _$setup$props$errors28.logo_use && ((_$setup$props$errors29 = $setup.props.errors) === null || _$setup$props$errors29 === void 0 ? void 0 : _$setup$props$errors29.logo_use.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_96, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors30 = $setup.props.errors) === null || _$setup$props$errors30 === void 0 ? void 0 : _$setup$props$errors30.logo_use[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_97, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_98, [_hoisted_99, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_100, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "branding_design",
        name: "business_growth[]",
        value: "branding_design",
        "onUpdate:modelValue": _cache[25] || (_cache[25] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_101]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_102, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "website",
        name: "business_growth[]",
        value: "website",
        "onUpdate:modelValue": _cache[26] || (_cache[26] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_103]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_104, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "mobile_app",
        name: "business_growth[]",
        value: "mobile_app",
        "onUpdate:modelValue": _cache[27] || (_cache[27] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_105]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_106, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "digital_marketing",
        name: "business_growth[]",
        value: "digital_marketing",
        "onUpdate:modelValue": _cache[28] || (_cache[28] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_107]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_108, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "telesales_support",
        name: "business_growth[]",
        value: "telesales_support",
        "onUpdate:modelValue": _cache[29] || (_cache[29] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_109]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_110, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "print_ad",
        name: "business_growth[]",
        value: "print_ad",
        "onUpdate:modelValue": _cache[30] || (_cache[30] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_111]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_112, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "tradeshow_marketing",
        name: "business_growth[]",
        value: "tradeshow_marketing",
        "onUpdate:modelValue": _cache[31] || (_cache[31] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_113]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_114, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "checkbox",
        id: "other",
        name: "business_growth[]",
        value: "other",
        "onUpdate:modelValue": _cache[32] || (_cache[32] = function ($event) {
          return $setup.formData.business_growth = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $setup.formData.business_growth]]), _hoisted_115]), (_$setup$props$errors31 = $setup.props.errors) !== null && _$setup$props$errors31 !== void 0 && _$setup$props$errors31.business_growth && ((_$setup$props$errors32 = $setup.props.errors) === null || _$setup$props$errors32 === void 0 ? void 0 : _$setup$props$errors32.business_growth.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_116, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors33 = $setup.props.errors) === null || _$setup$props$errors33 === void 0 ? void 0 : _$setup$props$errors33.business_growth[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_117, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_118, [_hoisted_119, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
        type: "text",
        placeholder: "Enter Your Answer",
        name: "anything_else",
        "class": "input anything-else-input",
        "onUpdate:modelValue": _cache[33] || (_cache[33] = function ($event) {
          return $setup.formData.anything_else = $event;
        })
      }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.formData.anything_else]]), (_$setup$props$errors34 = $setup.props.errors) !== null && _$setup$props$errors34 !== void 0 && _$setup$props$errors34.anything_else && ((_$setup$props$errors35 = $setup.props.errors) === null || _$setup$props$errors35 === void 0 ? void 0 : _$setup$props$errors35.anything_else.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_120, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors36 = $setup.props.errors) === null || _$setup$props$errors36 === void 0 ? void 0 : _$setup$props$errors36.anything_else[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_121, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("fieldset", _hoisted_122, [_hoisted_123, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["DatePicker"], {
        type: "date",
        startDate: (_$setup$props$project = $setup.props.projectReq) !== null && _$setup$props$project !== void 0 && _$setup$props$project.completion_date ? $setup.formatDateForPicker($setup.props.projectReq.completion_date) : null,
        direction: "top",
        onDatePicked: $setup.onDatePicked,
        minDate: new Date(),
        modelValue: $setup.formData.completion_date,
        "onUpdate:modelValue": _cache[34] || (_cache[34] = function ($event) {
          return $setup.formData.completion_date = $event;
        })
      }, null, 8 /* PROPS */, ["startDate", "minDate", "modelValue"]), (_$setup$props$errors37 = $setup.props.errors) !== null && _$setup$props$errors37 !== void 0 && _$setup$props$errors37.completion_date && ((_$setup$props$errors38 = $setup.props.errors) === null || _$setup$props$errors38 === void 0 ? void 0 : _$setup$props$errors38.completion_date.length) > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_124, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props$errors39 = $setup.props.errors) === null || _$setup$props$errors39 === void 0 ? void 0 : _$setup$props$errors39.completion_date[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])])];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[35] || (_cache[35] = function () {
          var _$setup$props;
          return $setup.props.hidePopup && (_$setup$props = $setup.props).hidePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "purpleLinkStyle",
        onClick: _cache[36] || (_cache[36] = function ($event) {
          return $setup.submit();
        })
      }, [$setup.props.isUpdate ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 0
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Update")], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Add")], 64 /* STABLE_FRAGMENT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(" ") + " Brief ")])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Columns/Token.vue?vue&type=template&id=1561aec9&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Columns/Token.vue?vue&type=template&id=1561aec9&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-1561aec9"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = ["value"];
var _hoisted_2 = {
  "class": "customTooltip"
};
var _hoisted_3 = {
  key: 0
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-check-line"
  })], -1 /* HOISTED */);
});
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copied", -1 /* HOISTED */);
});
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "btn btn-custom-primary tokenBtn flex-shrink-1 bd-highlight",
    id: "button-addon2",
    style: {
      "min-height": "24px",
      "border-radius": "3px"
    }
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "las la-clipboard-list"
  })], -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$item;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", {
    onClick: _cache[1] || (_cache[1] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {}, ["stop"])),
    "class": "copycardArea"
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "text",
    "class": "form-control tokenText w-75 bd-highlight",
    "aria-label": "Payment Link",
    "aria-describedby": "button-addon2",
    ref: "tokenField",
    value: _ctx.route($setup.routes[$setup.props.item.brief_link.brief_type], {
      id: (_$setup$props$item = $setup.props.item) === null || _$setup$props$item === void 0 ? void 0 : _$setup$props$item.encoded_id
    }),
    disabled: "",
    style: {
      "min-width": "10rem"
    }
  }, null, 8 /* PROPS */, _hoisted_1), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.textToCopy($event, $setup.props.item.brief_link.brief_type);
    }),
    onMouseleave: $setup.textToCopyRevert
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_2, [!$setup.copiedRef ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_3, "Copy Brief Response")) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [_hoisted_4, _hoisted_5], 64 /* STABLE_FRAGMENT */))]), _hoisted_6], 32 /* NEED_HYDRATION */)]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Pagination.vue?vue&type=template&id=668e6230&scoped=true":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Table/Pagination.vue?vue&type=template&id=668e6230&scoped=true ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-668e6230"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  key: 0,
  "class": "d-flex justify-content-center"
};
var _hoisted_2 = {
  "class": "pagination"
};
var _hoisted_3 = {
  "class": "page-item paginate_button page-item"
};
var _hoisted_4 = ["innerHTML"];
var _hoisted_5 = {
  key: 1,
  "class": "d-flex justify-content-between"
};
var _hoisted_6 = {
  key: 0
};
var _hoisted_7 = {
  key: 0,
  "class": "paginationButtons"
};
var _hoisted_8 = {
  key: 1,
  href: "javascript:void(0);",
  "class": "paginationButton"
};
var _hoisted_9 = {
  key: 3,
  href: "javascript:void(0);",
  "class": "paginationButton"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return $setup.props.type == 'numbers' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_2, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($props.links, function (link) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_3, [link.url ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Link"], {
      key: 0,
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)('page-link' + (link.active ? ' active' : '')),
      href: link.url,
      innerHTML: link.label
    }, null, 8 /* PROPS */, ["class", "href", "innerHTML"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
      key: 1,
      innerHTML: link.label,
      "class": "page-link disabled",
      href: "javascript:void(0);"
    }, null, 8 /* PROPS */, _hoisted_4))]);
  }), 256 /* UNKEYED_FRAGMENT */))], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.props.lastPage > 1]])])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [$setup.props.total > 20 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Viewing "), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.from || 0) + "-" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.to || 0), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" of ")])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.total || 0), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" results ")]), $setup.props.total > 20 || $setup.props.showButtons ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_7, [$setup.props.prevPage ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Link"], {
    key: 0,
    href: $setup.props.prevPage,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["paginationButton clickable", {
      disabled: $setup.props.prevPage == null
    }])
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Previous")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href", "class"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", _hoisted_8, "Previous")), $setup.props.nextPage ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Link"], {
    key: 2,
    href: $setup.props.nextPage,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["paginationButton clickable", {
      disabled: $setup.props.nextPage == null
    }])
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)("Next")];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["href", "class"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", _hoisted_9, "Next"))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]));
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLine.vue?vue&type=template&id=55bbb21c&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLine.vue?vue&type=template&id=55bbb21c&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-55bbb21c"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "single-payment-details"
};
var _hoisted_2 = {
  "class": "single-payment-head"
};
var _hoisted_3 = {
  "class": "row"
};
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": "col-lg-6 col-sm-12"
  }, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", null, "Timeline")], -1 /* HOISTED */);
});
var _hoisted_5 = {
  key: 0,
  "class": "col-lg-6 col-sm-12"
};
var _hoisted_6 = {
  "class": "payment-actionListUl"
};
var _hoisted_7 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "las la-plus"
  }, null, -1 /* HOISTED */);
});
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "Add Note", -1 /* HOISTED */);
});
var _hoisted_9 = [_hoisted_7, _hoisted_8];
var _hoisted_10 = {
  "class": "row mb-4"
};
var _hoisted_11 = {
  "class": "col-lg-12"
};
var _hoisted_12 = {
  "class": "mt-3 text-end"
};
var _hoisted_13 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Esc", -1 /* HOISTED */);
});
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_15 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
var _hoisted_16 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "ctrl", -1 /* HOISTED */);
});
var _hoisted_17 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "enter", -1 /* HOISTED */);
});
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [_hoisted_4, $setup.props.showAddNoteButton ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ul", _hoisted_6, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("li", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    "class": "btn btn-soft-secondary btn-sm",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.addNoteBox = true;
    })
  }, [].concat(_hoisted_9))])])])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
    ref: "noteTextarea",
    "class": "form-control",
    rows: "4",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $setup.note = $event;
    })
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.note]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "cancelbtn",
    onClick: _cache[2] || (_cache[2] = function ($event) {
      $setup.addNoteBox = false;
      $setup.note = '';
      $setup.hideNoteBox();
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Cancel "), _hoisted_13]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addnotepurple",
    onClick: $setup.updateNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Save Changes "), _hoisted_14, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_15], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.editNoteID]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    id: "addnotepurple",
    onClick: $setup.addNote
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add note "), _hoisted_16, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" + "), _hoisted_17], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, !$setup.editNoteID]])])])], 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, $setup.addNoteBox]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["TimeLineList"], {
    onEditPin: $setup.editNote,
    onDeletePin: $setup.deleteNote,
    iconTypes: $setup.type,
    id: $setup.props.id,
    logs: $setup.logs(),
    logType: $setup.props.logType,
    routeTo: $setup.props.routeTo
  }, null, 8 /* PROPS */, ["id", "logs", "logType", "routeTo"])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLineList.vue?vue&type=template&id=1323ffb0&scoped=true":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/TimeLine/TimeLineList.vue?vue&type=template&id=1323ffb0&scoped=true ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-1323ffb0"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "timeline-ul"
};
var _hoisted_2 = {
  "class": "timeline-details"
};
var _hoisted_3 = ["onClick"];
var _hoisted_4 = {
  key: 0,
  "class": "bx bx-dots-horizontal-rounded"
};
var _hoisted_5 = ["onFocusout"];
var _hoisted_6 = ["onClick"];
var _hoisted_7 = ["onClick"];
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Unpin", -1 /* HOISTED */);
});
var _hoisted_9 = [_hoisted_8];
var _hoisted_10 = ["onClick"];
var _hoisted_11 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, "Edit", -1 /* HOISTED */);
});
var _hoisted_12 = [_hoisted_11];
var _hoisted_13 = ["onClick"];
var _hoisted_14 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
    "class": "color-red"
  }, "Delete", -1 /* HOISTED */);
});
var _hoisted_15 = [_hoisted_14];
var _hoisted_16 = {
  key: 0,
  "class": "pinToTop"
};
var _hoisted_17 = {
  key: 1
};
var _hoisted_18 = {
  key: 2
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("ul", _hoisted_1, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.filteredLogs, function (log, i) {
    var _$setup$typeIcon;
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      key: i
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["bg-white text-muted", log.pin ? 'bx bxs-pin' : (_$setup$typeIcon = $setup.typeIcon(log.type, log.activity)) !== null && _$setup$typeIcon !== void 0 ? _$setup$typeIcon : 'mdi mdi-circle-outline'])
    }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", {
      "class": "threedots",
      onClick: function onClick($event) {
        return $setup.openOptionPanel(i);
      }
    }, [log.type == 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_4)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 8 /* PROPS */, _hoisted_3), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
      "class": "threedotsclickopen",
      ref_for: true,
      ref: "itemRefs",
      onFocusout: function onFocusout($event) {
        return $setup.closeOptionPanel(i);
      }
    }, [log.pin == 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 0,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 1);
      }
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.pinToTopText), 1 /* TEXT */)], 8 /* PROPS */, _hoisted_6)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.pin == 1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", {
      key: 1,
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.togglePinNote(i, 0);
      }
    }, [].concat(_hoisted_9), 8 /* PROPS */, _hoisted_7)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
      "class": "mb-1",
      onClick: function onClick($event) {
        return $setup.editNote(i);
      }
    }, [].concat(_hoisted_12), 8 /* PROPS */, _hoisted_10), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", {
      "class": "mb-0",
      onClick: function onClick($event) {
        return $setup.deleteNote(i);
      }
    }, [].concat(_hoisted_15), 8 /* PROPS */, _hoisted_13)], 40 /* PROPS, NEED_HYDRATION */, _hoisted_5), [[vue__WEBPACK_IMPORTED_MODULE_0__.vShow, log.type == 'note']]), log.pin ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_16, "Pinned note")) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), log.type != 'note' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_17, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_18, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.capitalize(log === null || log === void 0 ? void 0 : log.activity)), 1 /* TEXT */)), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.format($setup.parseISO(log.created_at), "PPpp")), 1 /* TEXT */)])]);
  }), 128 /* KEYED_FRAGMENT */))]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Title.vue?vue&type=template&id=611112db&scoped=true":
/*!****************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Title.vue?vue&type=template&id=611112db&scoped=true ***!
  \****************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-611112db"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "row"
};
var _hoisted_2 = {
  "class": "col-12"
};
var _hoisted_3 = {
  "class": "page-title-box d-sm-flex align-items-center justify-content-between"
};
var _hoisted_4 = {
  "class": "mb-sm-0"
};
var _hoisted_5 = {
  "class": "page-title-right"
};
var _hoisted_6 = {
  "class": "breadcrumb m-0"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props, _$setup$props2;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", _hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((_$setup$props = $setup.props) === null || _$setup$props === void 0 ? void 0 : _$setup$props.heading), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("ol", _hoisted_6, [typeof $setup.props.breadcrumb === 'string' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Tooltip"], {
    key: 0,
    "copy-text": (_$setup$props2 = $setup.props) === null || _$setup$props2 === void 0 ? void 0 : _$setup$props2.breadcrumb
  }, null, 8 /* PROPS */, ["copy-text"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.breadcrumb, function (item, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", {
      "class": "breadcrumb-item active",
      key: i
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(item), 1 /* TEXT */);
  }), 128 /* KEYED_FRAGMENT */))])])])])]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Tooltip.vue?vue&type=template&id=999db774&scoped=true":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Tooltip.vue?vue&type=template&id=999db774&scoped=true ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-999db774"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "copycardArea"
};
var _hoisted_2 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copy ID", -1 /* HOISTED */);
});
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "ctrl", -1 /* HOISTED */);
});
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "+", -1 /* HOISTED */);
});
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "i", -1 /* HOISTED */);
});
var _hoisted_6 = {
  key: 1
};
var _hoisted_7 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-check-line"
  })], -1 /* HOISTED */);
});
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copied", -1 /* HOISTED */);
});
var _hoisted_9 = ["innerHTML"];
var _hoisted_10 = {
  key: 0,
  "class": "ri-clipboard-line"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: $setup.textToCopy,
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showButtonStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showButtonClass),
    onMouseleave: $setup.textToCopyRevert
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["customTooltip", $setup.staticClass])
  }, [!$setup.copiedRef ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [!$setup.defaultText ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [_hoisted_2, _hoisted_3, _hoisted_4, _hoisted_5], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.defaultText), 1 /* TEXT */))], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [_hoisted_7, _hoisted_8], 64 /* STABLE_FRAGMENT */))], 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showTextStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showTextClass),
    innerHTML: $setup.props.showText || $setup.props.copyText
  }, null, 14 /* CLASS, STYLE, PROPS */, _hoisted_9), $setup.props.showIcon ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", _hoisted_10)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 38 /* CLASS, STYLE, NEED_HYDRATION */)]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=template&id=cc3ec3ca":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Badge.vue?vue&type=template&id=cc3ec3ca ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["", [$setup.props.badgeClass, $setup.props.iconPosition ? 'd-flex' : '', $setup.props.iconPosition === 'right' ? 'flex-row' : 'flex-row-reverse']])
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.badgeText) + " ", 1 /* TEXT */), $setup.props.iconClass ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", {
    key: 0,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["", $setup.props.iconClass])
  }, null, 2 /* CLASS */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 2 /* CLASS */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/DatePicker/DatePicker.vue?vue&type=template&id=31934ef2":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/DatePicker/DatePicker.vue?vue&type=template&id=31934ef2 ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "singleDatepickerArea",
  ref: "dateAreaRef"
};
var _hoisted_2 = {
  style: {
    "white-space": "nowrap"
  }
};
var _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
  "class": "bx bx-chevron-down"
}, null, -1 /* HOISTED */);
var _hoisted_4 = {
  "class": "datepickerInputArea"
};
var _hoisted_5 = {
  "class": "datepickerSingleInput"
};
var _hoisted_6 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "/", -1 /* HOISTED */);
var _hoisted_7 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "/", -1 /* HOISTED */);
var _hoisted_8 = {
  "class": "datepicker"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    type: "button",
    "class": "btn btn-light",
    onClick: _cache[0] || (_cache[0] = function ($event) {
      return $setup.visibility = !$setup.visibility;
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.date != null ? $setup.format($setup.date, "MMM d, yyyy") : $setup.props.placeholder), 1 /* TEXT */), _hoisted_3]), $setup.visibility ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
    key: 0,
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(['singleDatepickerDropDown', 'dropDown', $setup.directionClass])
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "number",
    "class": "day",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $setup.startDay = $event;
    }),
    onInput: $setup.updateStartDate
  }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.startDay]]), _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "number",
    "class": "month",
    "onUpdate:modelValue": _cache[2] || (_cache[2] = function ($event) {
      return $setup.startMonth = $event;
    }),
    onInput: $setup.updateStartDate
  }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.startMonth]]), _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "number",
    "class": "year",
    "onUpdate:modelValue": _cache[3] || (_cache[3] = function ($event) {
      return $setup.startYear = $event;
    }),
    onChange: $setup.updateStartDate
  }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $setup.startYear]])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["VueDatePicker"], {
    modelValue: $setup.date,
    "onUpdate:modelValue": _cache[4] || (_cache[4] = function ($event) {
      return $setup.date = $event;
    }),
    "enable-time-picker": false,
    inline: "",
    "auto-apply": "",
    "min-date": $setup.props.minDate ? new Date($setup.props.minDate) : null
  }, null, 8 /* PROPS */, ["modelValue", "min-date"])])], 2 /* CLASS */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 512 /* NEED_PATCH */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=template&id=118e72b8":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popup.vue?vue&type=template&id=118e72b8 ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "popup-head"
};
var _hoisted_2 = {
  "class": "popup-body"
};
var _hoisted_3 = {
  "class": "popup-footer"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _$setup$props$maxWidt;
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-bg", "".concat($setup.props["class"], "bg ").concat($setup.visibilityClass)]),
    onClick: _cache[0] || (_cache[0] = function () {
      return $setup.onCloseFunction && $setup.onCloseFunction.apply($setup, arguments);
    })
  }, null, 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["popup-area", "".concat($setup.props["class"], " ").concat($setup.visibilityClass)]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
      width: (_$setup$props$maxWidt = $setup.props.maxWidth) !== null && _$setup$props$maxWidt !== void 0 ? _$setup$props$maxWidt : '450px'
    })
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.title), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "head")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "body")]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "footer")])], 6 /* CLASS, STYLE */)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=template&id=e27c74de&scoped=true":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Popups/DeletePopup.vue?vue&type=template&id=e27c74de&scoped=true ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-e27c74de"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "popup-details-area text-muted"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Popup"], {
    title: "Delete ".concat($setup.props.title),
    "class": "",
    visibility: $setup.props.deleteVisibility,
    onClose: $setup.props.hideDeletePopup
  }, {
    body: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.message), 1 /* TEXT */)];
    }),
    footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        onClick: _cache[0] || (_cache[0] = function () {
          var _$setup$props;
          return $setup.props.hideDeletePopup && (_$setup$props = $setup.props).hideDeletePopup.apply(_$setup$props, arguments);
        })
      }, "Cancel"), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
        "class": "redLinkStyle",
        onClick: _cache[1] || (_cache[1] = function () {
          var _$setup$props2;
          return $setup.props.onDeleteSubmit && (_$setup$props2 = $setup.props).onDeleteSubmit.apply(_$setup$props2, arguments);
        })
      }, " Delete " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.props.title), 1 /* TEXT */)];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["title", "visibility", "onClose"]);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/TableListOptions/TableListOptions.vue?vue&type=template&id=d25715f2&scoped=true":
/*!**************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/TableListOptions/TableListOptions.vue?vue&type=template&id=d25715f2&scoped=true ***!
  \**************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-d25715f2"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  key: 0,
  "class": "dropHead"
};
var _hoisted_2 = {
  href: "#!",
  "class": "dropdown-item"
};
var _hoisted_3 = {
  key: 0
};
var _hoisted_4 = ["href", "onClick"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("ul", {
    ref: "tableListOptions",
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["tableListOptions dropdown-menu dropdown-menu-end", $setup.props.visibility ? 'show' : '']),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)({
      transform: "translate(".concat($setup.popupPosition.left, "px, ").concat($setup.popupPosition.top, "px)")
    }),
    id: "tableListOptions"
  }, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($setup.props.options, function (option, i) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
      key: i
    }, [option.heading != null && option.heading ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("a", _hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(option.heading), 1 /* TEXT */)])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(option.links, function (link, i) {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: i
      }, [link ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("li", _hoisted_3, [link.link ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 0
      }, [(link.condition !== undefined ? link.condition() : true) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Link"], {
        key: 0,
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([link["class"], "dropdown-item"]),
        href: link.link,
        onClick: function onClick($event) {
          return $setup.handleItemClick(link);
        }
      }, {
        "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
          return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(link.label), 1 /* TEXT */)];
        }),
        _: 2 /* DYNAMIC */
      }, 1032 /* PROPS, DYNAMIC_SLOTS */, ["class", "href", "onClick"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, [(link.condition !== undefined ? link.condition() : true) ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
        key: 0,
        "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([link["class"], "dropdown-item"]),
        href: link.link,
        onClick: function onClick($event) {
          return $setup.handleItemClick(link);
        }
      }, [link.tooltip ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["Tooltip"], {
        key: 0,
        tooltipText: link.tooltip.tooltipText,
        showText: link.tooltip.showText,
        showTextClass: link.tooltip.showTextClass,
        copyText: link.tooltip.copyText,
        showIcon: link.tooltip.showIcon
      }, null, 8 /* PROPS */, ["tooltipText", "showText", "showTextClass", "copyText", "showIcon"])) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        key: 1
      }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(link.label), 1 /* TEXT */)], 64 /* STABLE_FRAGMENT */))], 10 /* CLASS, PROPS */, _hoisted_4)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 64 /* STABLE_FRAGMENT */);
    }), 128 /* KEYED_FRAGMENT */))], 64 /* STABLE_FRAGMENT */);
  }), 128 /* KEYED_FRAGMENT */))], 6 /* CLASS, STYLE */);
}

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=template&id=5c57ca7b&scoped=true":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Shared/Components/Tooltip.vue?vue&type=template&id=5c57ca7b&scoped=true ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _withScopeId = function _withScopeId(n) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.pushScopeId)("data-v-5c57ca7b"), n = n(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.popScopeId)(), n;
};
var _hoisted_1 = {
  "class": "copycardArea"
};
var _hoisted_2 = ["onClick"];
var _hoisted_3 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copy ID", -1 /* HOISTED */);
});
var _hoisted_4 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "ctrl", -1 /* HOISTED */);
});
var _hoisted_5 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "+", -1 /* HOISTED */);
});
var _hoisted_6 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "code"
  }, "i", -1 /* HOISTED */);
});
var _hoisted_7 = {
  key: 1
};
var _hoisted_8 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, [/*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "ri-check-line"
  })], -1 /* HOISTED */);
});
var _hoisted_9 = /*#__PURE__*/_withScopeId(function () {
  return /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", null, "Copied", -1 /* HOISTED */);
});
var _hoisted_10 = ["innerHTML"];
var _hoisted_11 = {
  key: 0,
  "class": "ri-clipboard-line"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)($setup.textToCopy, ["stop"]),
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showButtonStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showButtonClass),
    onMouseleave: $setup.textToCopyRevert
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["customTooltip", $setup.getDirectionClass($setup.direction)])
  }, [!$setup.copiedRef ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [!$setup.defaultText ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 0
  }, [_hoisted_3, _hoisted_4, _hoisted_5, _hoisted_6], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_7, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($setup.defaultText), 1 /* TEXT */))], 64 /* STABLE_FRAGMENT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    key: 1
  }, [_hoisted_8, _hoisted_9], 64 /* STABLE_FRAGMENT */))], 2 /* CLASS */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    style: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeStyle)($setup.props.showTextStyle),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)($setup.props.showTextClass),
    innerHTML: $setup.props.showText || $setup.props.copyText
  }, null, 14 /* CLASS, STYLE, PROPS */, _hoisted_10), $setup.props.showIcon ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("i", _hoisted_11)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)], 46 /* CLASS, STYLE, PROPS, NEED_HYDRATION */, _hoisted_2)]);
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js":
/*!********************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/Brief/useDownload.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDownload: () => (/* binding */ useDownload)
/* harmony export */ });
/* harmony import */ var _downloadFile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../downloadFile */ "./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js");
/* harmony import */ var _useNotification__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../useNotification */ "./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js");


function useDownload() {
  var _useNotification = (0,_useNotification__WEBPACK_IMPORTED_MODULE_1__.useNotification)(),
    notifySuccess = _useNotification.success,
    notifyError = _useNotification.error;
  var download = function download(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadWebBrief = function downloadWebBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("web.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadVideoBrief = function downloadVideoBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("video.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadSmmBrief = function downloadSmmBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("smm.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadAppBrief = function downloadAppBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("app.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  var downloadSemBrief = function downloadSemBrief(encoded_id, cus_name, fingerprint) {
    (0,_downloadFile__WEBPACK_IMPORTED_MODULE_0__.downloadFile)(route("sem.brief.download", {
      id: encoded_id,
      fingerprint: fingerprint
    }), cus_name).then(function (response) {
      notifySuccess("".concat(response.fileName, " downloaded successfully"));
    })["catch"](function (error) {
      console.log(error.response);
      notifyError(error.response.data.message);
    });
  };
  return {
    download: download,
    downloadWebBrief: downloadWebBrief,
    downloadVideoBrief: downloadVideoBrief,
    downloadSmmBrief: downloadSmmBrief,
    downloadAppBrief: downloadAppBrief,
    downloadSemBrief: downloadSemBrief
  };
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js":
/*!***************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/downloadFile.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   downloadFile: () => (/* binding */ downloadFile)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_0__);
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var downloadFile = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(route, fileName) {
    var response, url, link;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return axios__WEBPACK_IMPORTED_MODULE_0___default().get(route, {
            responseType: "blob"
          });
        case 3:
          response = _context.sent;
          url = window.URL.createObjectURL(new Blob([response.data]));
          link = document.createElement("a");
          link.href = url;
          link.setAttribute("download", fileName + ".pdf");
          document.body.appendChild(link);
          link.click();
          return _context.abrupt("return", {
            fileName: fileName + ".pdf",
            success: true
          });
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.error("Error downloading PDF:", _context.t0);
          _context.t0.fileName = fileName + ".pdf";
          throw _context.t0;
        case 18:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function downloadFile(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js":
/*!*****************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/useFingerprint.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFingerprint: () => (/* binding */ useFingerprint)
/* harmony export */ });
/* harmony import */ var _fingerprintjs_fingerprintjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @fingerprintjs/fingerprintjs */ "./node_modules/@fingerprintjs/fingerprintjs/dist/fp.esm.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function useFingerprint() {
  return _useFingerprint.apply(this, arguments);
}
function _useFingerprint() {
  _useFingerprint = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
    var fpPromise, fp, result, visitorId;
    return _regeneratorRuntime().wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          // Initialize FingerprintJS
          fpPromise = _fingerprintjs_fingerprintjs__WEBPACK_IMPORTED_MODULE_0__["default"].load(); // Generate the fingerprint
          _context.next = 3;
          return fpPromise;
        case 3:
          fp = _context.sent;
          _context.next = 6;
          return fp.get();
        case 6:
          result = _context.sent;
          // The visitor identifier
          visitorId = result.visitorId; // Return the visitor ID
          return _context.abrupt("return", visitorId);
        case 9:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _useFingerprint.apply(this, arguments);
}

/***/ }),

/***/ "./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js":
/*!******************************************************************************!*\
  !*** ./resources/js/Pages/Admin/Brief/Shared/Composables/useNotification.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useNotification: () => (/* binding */ useNotification)
/* harmony export */ });
/* harmony import */ var _css_toast_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../css/toast.css */ "./resources/css/toast.css");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
/* harmony import */ var vue3_toastify__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue3-toastify */ "./node_modules/vue3-toastify/dist/index.mjs");



function useNotification() {
  var setting = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var isEmptyConfig = Object.keys(setting).length === 0;
  if (isEmptyConfig) {
    setting = {
      autoClose: 3000,
      theme: "dark",
      type: "success",
      position: "bottom-center"
    };
  }
  function success(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.success(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function error(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.error(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function warning(message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.warning(message, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function custom(message, btnText, callback) {
    var toastId = vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.loading({
      render: function render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('div', {
          style: {
            display: 'flex',
            width: '100%',
            justifyContent: 'space-between',
            alignItems: 'center'
          }
        }, [(0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('p', {
          style: {
            marginBottom: '0px'
          }
        }, message), (0,vue__WEBPACK_IMPORTED_MODULE_1__.h)('span', {
          style: {
            borderLeft: '1px solid gray',
            height: '4rem',
            margin: '-1rem 0rem',
            paddingLeft: '0.5rem',
            placeContent: 'center'
          }
        }, {
          onClick: function onClick(event) {
            event.stopPropagation();
            //emit('performUndo', true);
            vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.remove(toastId);
            callback();
          }
        }, btnText)]);
      }
    }, {
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose,
      closeButton: false
    });
    return {
      toastId: toastId
    };
  }
  function update(toastID, message) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.update(toastID, {
      message: message,
      position: setting.position,
      theme: setting.theme,
      autoClose: setting.autoClose
    });
  }
  function remove(toastID) {
    vue3_toastify__WEBPACK_IMPORTED_MODULE_2__.toast.remove(toastID);
  }
  return {
    success: success,
    error: error,
    warning: warning,
    custom: custom,
    update: update,
    remove: remove
  };
}

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/@vuepic/vue-datepicker/dist/main.css":
/*!*******************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/@vuepic/vue-datepicker/dist/main.css ***!
  \*******************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".dp__input_wrap{position:relative;width:100%;box-sizing:unset}.dp__input_wrap:focus{border-color:var(--dp-border-color-hover);outline:none}.dp__input{background-color:var(--dp-background-color);border-radius:var(--dp-border-radius);font-family:var(--dp-font-family);border:1px solid var(--dp-border-color);outline:none;transition:border-color .2s cubic-bezier(0.645, 0.045, 0.355, 1);width:100%;font-size:var(--dp-font-size);line-height:calc(var(--dp-font-size)*1.5);padding:var(--dp-input-padding);color:var(--dp-text-color);box-sizing:border-box}.dp__input::-moz-placeholder{opacity:.7}.dp__input::placeholder{opacity:.7}.dp__input:hover{border-color:var(--dp-border-color-hover)}.dp__input_reg{caret-color:rgba(0,0,0,0)}.dp__input_focus{border-color:var(--dp-border-color-hover)}.dp__disabled{background:var(--dp-disabled-color)}.dp__disabled::-moz-placeholder{color:var(--dp-disabled-color-text)}.dp__disabled::placeholder{color:var(--dp-disabled-color-text)}.dp__input_icons{display:inline-block;width:var(--dp-font-size);height:var(--dp-font-size);stroke-width:0;font-size:var(--dp-font-size);line-height:calc(var(--dp-font-size)*1.5);padding:6px 12px;color:var(--dp-icon-color);box-sizing:content-box}.dp__input_icon{cursor:pointer;position:absolute;top:50%;inset-inline-start:0;transform:translateY(-50%);color:var(--dp-icon-color)}.dp__clear_icon{position:absolute;top:50%;inset-inline-end:0;transform:translateY(-50%);cursor:pointer;color:var(--dp-icon-color)}.dp__input_icon_pad{padding-inline-start:var(--dp-input-icon-padding)}.dp__input_valid{box-shadow:0 0 var(--dp-border-radius) var(--dp-success-color);border-color:var(--dp-success-color)}.dp__input_valid:hover{border-color:var(--dp-success-color)}.dp__input_invalid{box-shadow:0 0 var(--dp-border-radius) var(--dp-danger-color);border-color:var(--dp-danger-color)}.dp__input_invalid:hover{border-color:var(--dp-danger-color)}.dp__menu{background:var(--dp-background-color);border-radius:var(--dp-border-radius);min-width:var(--dp-menu-min-width);font-family:var(--dp-font-family);font-size:var(--dp-font-size);-webkit-user-select:none;-moz-user-select:none;user-select:none;border:1px solid var(--dp-menu-border-color);box-sizing:border-box}.dp__menu::after{box-sizing:border-box}.dp__menu::before{box-sizing:border-box}.dp__menu:focus{border:1px solid var(--dp-menu-border-color);outline:none}.dp--menu-wrapper{position:absolute;z-index:99999}.dp__menu_inner{padding:var(--dp-menu-padding)}.dp--menu--inner-stretched{padding:6px 0}.dp__menu_index{z-index:99999}.dp-menu-loading,.dp__menu_readonly,.dp__menu_disabled{position:absolute;inset:0;z-index:999999}.dp__menu_disabled{background:rgba(255,255,255,.5);cursor:not-allowed}.dp__menu_readonly{background:rgba(0,0,0,0);cursor:default}.dp-menu-loading{background:rgba(255,255,255,.5);cursor:default}.dp--menu-load-container{display:flex;height:100%;width:100%;justify-content:center;align-items:center}.dp--menu-loader{width:48px;height:48px;border:var(--dp-loader);border-bottom-color:rgba(0,0,0,0);border-radius:50%;display:inline-block;box-sizing:border-box;animation:dp-load-rotation 1s linear infinite;position:absolute}@keyframes dp-load-rotation{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}.dp__arrow_top{left:50%;top:0;height:12px;width:12px;background-color:var(--dp-background-color);position:absolute;border-inline-end:1px solid var(--dp-menu-border-color);border-top:1px solid var(--dp-menu-border-color);transform:translate(-50%, -50%) rotate(-45deg)}.dp__arrow_bottom{left:50%;bottom:0;height:12px;width:12px;background-color:var(--dp-background-color);position:absolute;border-inline-end:1px solid var(--dp-menu-border-color);border-bottom:1px solid var(--dp-menu-border-color);transform:translate(-50%, 50%) rotate(45deg)}.dp__action_extra{text-align:center;padding:2px 0}.dp--preset-dates{padding:5px;border-inline-end:1px solid var(--dp-border-color)}@media only screen and (width <= 600px){.dp--preset-dates{display:flex;align-self:center;border:none;overflow-x:auto;max-width:calc(var(--dp-menu-width) - var(--dp-action-row-padding)*2)}}.dp--preset-dates-collapsed{display:flex;align-self:center;border:none;overflow-x:auto;max-width:calc(var(--dp-menu-width) - var(--dp-action-row-padding)*2)}.dp__sidebar_left{padding:5px;border-inline-end:1px solid var(--dp-border-color)}.dp__sidebar_right{padding:5px;margin-inline-end:1px solid var(--dp-border-color)}.dp--preset-range{display:block;width:100%;padding:5px;text-align:left;white-space:nowrap;color:var(--dp-text-color);border-radius:var(--dp-border-radius);transition:var(--dp-common-transition)}.dp--preset-range:hover{background-color:var(--dp-hover-color);color:var(--dp-hover-text-color);cursor:pointer}@media only screen and (width <= 600px){.dp--preset-range{border:1px solid var(--dp-border-color);margin:0 3px}.dp--preset-range:first-child{margin-left:0}.dp--preset-range:last-child{margin-right:0}}.dp--preset-range-collapsed{border:1px solid var(--dp-border-color);margin:0 3px}.dp--preset-range-collapsed:first-child{margin-left:0}.dp--preset-range-collapsed:last-child{margin-right:0}.dp__menu_content_wrapper{display:flex}@media only screen and (width <= 600px){.dp__menu_content_wrapper{flex-direction:column-reverse}}.dp--menu-content-wrapper-collapsed{flex-direction:column-reverse}.dp__calendar_header{position:relative;display:flex;justify-content:center;align-items:center;color:var(--dp-text-color);white-space:nowrap;font-weight:bold}.dp__calendar_header_item{text-align:center;flex-grow:1;height:var(--dp-cell-size);padding:var(--dp-cell-padding);width:var(--dp-cell-size);box-sizing:border-box}.dp__calendar_row{display:flex;justify-content:center;align-items:center;margin:var(--dp-row-margin)}.dp__calendar_item{text-align:center;flex-grow:1;box-sizing:border-box;color:var(--dp-text-color)}.dp__calendar{position:relative}.dp__calendar_header_cell{border-bottom:thin solid var(--dp-border-color);padding:var(--dp-calendar-header-cell-padding)}.dp__cell_inner{display:flex;align-items:center;text-align:center;justify-content:center;border-radius:var(--dp-cell-border-radius);height:var(--dp-cell-size);padding:var(--dp-cell-padding);width:var(--dp-cell-size);border:1px solid rgba(0,0,0,0);box-sizing:border-box;position:relative}.dp__cell_inner:hover{transition:all .2s}.dp__cell_auto_range_start,.dp__date_hover_start:hover,.dp__range_start{border-end-end-radius:0;border-start-end-radius:0}.dp__cell_auto_range_end,.dp__date_hover_end:hover,.dp__range_end{border-end-start-radius:0;border-start-start-radius:0}.dp__range_end,.dp__range_start,.dp__active_date{background:var(--dp-primary-color);color:var(--dp-primary-text-color)}.dp__cell_auto_range_end,.dp__cell_auto_range_start{border-top:1px dashed var(--dp-primary-color);border-bottom:1px dashed var(--dp-primary-color)}.dp__date_hover_end:hover,.dp__date_hover_start:hover,.dp__date_hover:hover{background:var(--dp-hover-color);color:var(--dp-hover-text-color)}.dp__cell_offset{color:var(--dp-secondary-color)}.dp__cell_disabled{color:var(--dp-secondary-color);cursor:not-allowed}.dp__range_between{background:var(--dp-range-between-dates-background-color);color:var(--dp-range-between-dates-text-color);border-radius:0;border:1px solid var(--dp-range-between-border-color)}.dp__range_between_week{background:var(--dp-primary-color);color:var(--dp-primary-text-color);border-radius:0;border-top:1px solid var(--dp-primary-color);border-bottom:1px solid var(--dp-primary-color)}.dp__today{border:1px solid var(--dp-primary-color)}.dp__week_num{color:var(--dp-secondary-color);text-align:center}.dp__cell_auto_range{border-radius:0;border-top:1px dashed var(--dp-primary-color);border-bottom:1px dashed var(--dp-primary-color)}.dp__cell_auto_range_start{border-inline-start:1px dashed var(--dp-primary-color)}.dp__cell_auto_range_end{border-inline-end:1px dashed var(--dp-primary-color)}.dp__calendar_header_separator{width:100%;height:1px;background:var(--dp-border-color)}.dp__calendar_next{margin-inline-start:var(--dp-multi-calendars-spacing)}.dp__marker_line,.dp__marker_dot{height:5px;background-color:var(--dp-marker-color);position:absolute;bottom:0}.dp__marker_dot{width:5px;border-radius:50%;left:50%;transform:translateX(-50%)}.dp__marker_line{width:100%;left:0}.dp__marker_tooltip{position:absolute;border-radius:var(--dp-border-radius);background-color:var(--dp-tooltip-color);padding:5px;border:1px solid var(--dp-border-color);z-index:99999;box-sizing:border-box;cursor:default}.dp__tooltip_content{white-space:nowrap}.dp__tooltip_text{display:flex;align-items:center;flex-flow:row nowrap;color:var(--dp-text-color)}.dp__tooltip_mark{height:5px;width:5px;border-radius:50%;background-color:var(--dp-text-color);color:var(--dp-text-color);margin-inline-end:5px}.dp__arrow_bottom_tp{bottom:0;height:8px;width:8px;background-color:var(--dp-tooltip-color);position:absolute;border-inline-end:1px solid var(--dp-border-color);border-bottom:1px solid var(--dp-border-color);transform:translate(-50%, 50%) rotate(45deg)}.dp__instance_calendar{position:relative;width:100%}@media only screen and (width <= 600px){.dp__flex_display{flex-direction:column}}.dp--flex-display-collapsed{flex-direction:column}.dp__cell_highlight{background-color:var(--dp-highlight-color)}.dp__month_year_row{display:flex;align-items:center;height:var(--dp-month-year-row-height);color:var(--dp-text-color);box-sizing:border-box}.dp__inner_nav{display:flex;align-items:center;justify-content:center;cursor:pointer;height:var(--dp-month-year-row-button-size);width:var(--dp-month-year-row-button-size);color:var(--dp-icon-color);text-align:center;border-radius:50%}.dp__inner_nav svg{height:var(--dp-button-icon-height);width:var(--dp-button-icon-height)}.dp__inner_nav:hover{background:var(--dp-hover-color);color:var(--dp-hover-icon-color)}[dir=rtl] .dp__inner_nav{transform:rotate(180deg)}.dp__inner_nav_disabled:hover,.dp__inner_nav_disabled{background:var(--dp-disabled-color);color:var(--dp-disabled-color-text);cursor:not-allowed}.dp--year-select,.dp__month_year_select{text-align:center;cursor:pointer;height:var(--dp-month-year-row-height);display:flex;align-items:center;justify-content:center;border-radius:var(--dp-border-radius);box-sizing:border-box;color:var(--dp-text-color)}.dp--year-select:hover,.dp__month_year_select:hover{background:var(--dp-hover-color);color:var(--dp-hover-text-color);transition:var(--dp-common-transition)}.dp__month_year_select{width:50%}.dp--year-select{width:100%}.dp__month_year_wrap{display:flex;width:100%}.dp__year_disable_select{justify-content:space-around}.dp__overlay{width:100%;background:var(--dp-background-color);transition:opacity 1s ease-out;z-index:99999;font-family:var(--dp-font-family);color:var(--dp-text-color);box-sizing:border-box}.dp--overlay-absolute{position:absolute;height:100%;top:0;left:0}.dp--overlay-relative{position:relative}.dp__overlay_container::-webkit-scrollbar-track{box-shadow:var(--dp-scroll-bar-background);background-color:var(--dp-scroll-bar-background)}.dp__overlay_container::-webkit-scrollbar{width:5px;background-color:var(--dp-scroll-bar-background)}.dp__overlay_container::-webkit-scrollbar-thumb{background-color:var(--dp-scroll-bar-color);border-radius:10px}.dp__overlay:focus{border:none;outline:none}.dp__container_flex{display:flex}.dp__container_block{display:block}.dp__overlay_container{flex-direction:column;overflow-y:auto}.dp__time_picker_overlay_container{height:100%}.dp__overlay_row{padding:0;box-sizing:border-box;display:flex;margin-inline:auto auto;flex-wrap:wrap;max-width:100%;width:100%;align-items:center}.dp__flex_row{flex:1}.dp__overlay_col{box-sizing:border-box;width:33%;padding:var(--dp-overlay-col-padding);white-space:nowrap}.dp__overlay_cell_pad{padding:var(--dp-common-padding) 0}.dp__overlay_cell_active{cursor:pointer;border-radius:var(--dp-border-radius);text-align:center;background:var(--dp-primary-color);color:var(--dp-primary-text-color)}.dp__overlay_cell{cursor:pointer;border-radius:var(--dp-border-radius);text-align:center}.dp__overlay_cell:hover{background:var(--dp-hover-color);color:var(--dp-hover-text-color);transition:var(--dp-common-transition)}.dp__cell_in_between{background:var(--dp-hover-color);color:var(--dp-hover-text-color)}.dp__over_action_scroll{right:5px;box-sizing:border-box}.dp__overlay_cell_disabled{cursor:not-allowed;background:var(--dp-disabled-color)}.dp__overlay_cell_disabled:hover{background:var(--dp-disabled-color)}.dp__overlay_cell_active_disabled{cursor:not-allowed;background:var(--dp-primary-disabled-color)}.dp__overlay_cell_active_disabled:hover{background:var(--dp-primary-disabled-color)}.dp__btn,.dp--qr-btn,.dp--time-invalid,.dp--time-overlay-btn{border:none;font:inherit;transition:var(--dp-common-transition);line-height:normal}.dp--year-mode-picker{display:flex;width:100%;align-items:center;justify-content:space-between;height:var(--dp-cell-size)}.dp--tp-wrap{max-width:var(--dp-menu-min-width)}.dp__time_input{width:100%;display:flex;align-items:center;justify-content:center;-webkit-user-select:none;-moz-user-select:none;user-select:none;font-family:var(--dp-font-family);color:var(--dp-text-color)}.dp__time_col_reg_block{padding:0 20px}.dp__time_col_reg_inline{padding:0 10px}.dp__time_col_reg_with_button{padding:0 15px}.dp__time_col_sec{padding:0 10px}.dp__time_col_sec_with_button{padding:0 5px}.dp__time_col{text-align:center;display:flex;align-items:center;justify-content:center;flex-direction:column}.dp__time_col_block{font-size:var(--dp-time-font-size)}.dp__time_display{cursor:pointer;color:var(--dp-text-color);border-radius:var(--dp-border-radius);display:flex;align-items:center;justify-content:center}.dp__time_display:hover:enabled{background:var(--dp-hover-color);color:var(--dp-hover-text-color)}.dp__time_display_block{padding:0 3px}.dp__time_display_inline{padding:5px}.dp__time_picker_inline_container{display:flex;width:100%;justify-content:center}.dp__inc_dec_button{padding:5px;margin:0;height:var(--dp-time-inc-dec-button-size);width:var(--dp-time-inc-dec-button-size);display:flex;align-items:center;justify-content:center;cursor:pointer;border-radius:50%;color:var(--dp-icon-color);box-sizing:border-box}.dp__inc_dec_button svg{height:var(--dp-time-inc-dec-button-size);width:var(--dp-time-inc-dec-button-size)}.dp__inc_dec_button:hover{background:var(--dp-hover-color);color:var(--dp-primary-color)}.dp__inc_dec_button_inline{width:100%;padding:0;height:8px;cursor:pointer;display:flex;align-items:center}.dp__inc_dec_button_disabled:hover,.dp__inc_dec_button_disabled{background:var(--dp-disabled-color);color:var(--dp-disabled-color-text);cursor:not-allowed}.dp__pm_am_button{background:var(--dp-primary-color);color:var(--dp-primary-text-color);border:none;padding:var(--dp-common-padding);border-radius:var(--dp-border-radius);cursor:pointer}.dp__tp_inline_btn_bar{width:100%;height:4px;background-color:var(--dp-secondary-color);transition:var(--dp-common-transition);border-collapse:collapse}.dp__tp_inline_btn_top:hover .dp__tp_btn_in_r{background-color:var(--dp-primary-color);transform:rotate(12deg) scale(1.15) translateY(-2px)}.dp__tp_inline_btn_top:hover .dp__tp_btn_in_l{background-color:var(--dp-primary-color);transform:rotate(-12deg) scale(1.15) translateY(-2px)}.dp__tp_inline_btn_bottom:hover .dp__tp_btn_in_r{background-color:var(--dp-primary-color);transform:rotate(-12deg) scale(1.15) translateY(-2px)}.dp__tp_inline_btn_bottom:hover .dp__tp_btn_in_l{background-color:var(--dp-primary-color);transform:rotate(12deg) scale(1.15) translateY(-2px)}.dp--time-overlay-btn{background:none}.dp--time-invalid{background-color:var(--dp-disabled-color)}.dp__action_row{display:flex;align-items:center;width:100%;padding:var(--dp-action-row-padding);box-sizing:border-box;color:var(--dp-text-color);flex-flow:row nowrap}.dp__action_row svg{height:var(--dp-button-icon-height);width:auto}.dp__selection_preview{display:block;color:var(--dp-text-color);font-size:var(--dp-preview-font-size);overflow:hidden;white-space:nowrap;text-overflow:ellipsis}.dp__action_buttons{display:flex;flex:0;white-space:nowrap;align-items:center;justify-content:flex-end;margin-inline-start:auto}.dp__action_button{display:inline-flex;align-items:center;background:rgba(0,0,0,0);border:1px solid rgba(0,0,0,0);padding:var(--dp-action-buttons-padding);line-height:var(--dp-action-button-height);margin-inline-start:3px;height:var(--dp-action-button-height);cursor:pointer;border-radius:var(--dp-border-radius);font-size:var(--dp-preview-font-size);font-family:var(--dp-font-family)}.dp__action_buttons .dp__action_select{background:var(--dp-primary-color);color:var(--dp-primary-text-color)}.dp__action_buttons .dp__action_select:hover{background:var(--dp-primary-color);transition:var(--dp-action-row-transtion)}.dp__action_buttons .dp__action_select:disabled{background:var(--dp-primary-disabled-color);cursor:not-allowed}.dp__action_cancel{color:var(--dp-text-color);border:1px solid var(--dp-border-color)}.dp__action_cancel:hover{border-color:var(--dp-primary-color);transition:var(--dp-action-row-transtion)}.dp-quarter-picker-wrap{display:flex;flex-direction:column;height:100%;min-width:var(--dp-menu-min-width)}.dp--qr-btn{width:100%;padding:var(--dp-common-padding)}.dp--qr-btn:not(.dp--highlighted,.dp--qr-btn-active,.dp--qr-btn-disabled,.dp--qr-btn-between){background:none}.dp--qr-btn:hover:not(.dp--qr-btn-active,.dp--qr-btn-disabled){background:var(--dp-hover-color);color:var(--dp-hover-text-color);transition:var(--dp-common-transition)}.dp--quarter-items{display:flex;flex-direction:column;flex:1;width:100%;height:100%;justify-content:space-evenly}.dp--qr-btn-active{background:var(--dp-primary-color);color:var(--dp-primary-text-color)}.dp--qr-btn-between{background:var(--dp-hover-color);color:var(--dp-hover-text-color)}.dp--qr-btn-disabled{cursor:not-allowed;background:var(--dp-disabled-color)}.dp--qr-btn-disabled:hover{background:var(--dp-disabled-color)}.dp__btn,.dp--time-overlay-btn,.dp--time-invalid,.dp--qr-btn{border:none;font:inherit;transition:var(--dp-common-transition);line-height:normal}.dp--year-mode-picker{display:flex;width:100%;align-items:center;justify-content:space-between;height:var(--dp-cell-size)}:root{--dp-common-transition: all 0.1s ease-in;--dp-menu-padding: 6px 8px;--dp-animation-duration: 0.1s;--dp-menu-appear-transition-timing: cubic-bezier(.4, 0, 1, 1);--dp-transition-timing: ease-out;--dp-action-row-transtion: all 0.2s ease-in;--dp-font-family: -apple-system, blinkmacsystemfont, \"Segoe UI\", roboto, oxygen, ubuntu, cantarell, \"Open Sans\", \"Helvetica Neue\", sans-serif;--dp-border-radius: 4px;--dp-cell-border-radius: 4px;--dp-transition-length: 22px;--dp-transition-timing-general: 0.1s;--dp-button-height: 35px;--dp-month-year-row-height: 35px;--dp-month-year-row-button-size: 25px;--dp-button-icon-height: 20px;--dp-calendar-wrap-padding: 0 5px;--dp-cell-size: 35px;--dp-cell-padding: 5px;--dp-common-padding: 10px;--dp-input-icon-padding: 35px;--dp-input-padding: 6px 30px 6px 12px;--dp-menu-min-width: 260px;--dp-action-buttons-padding: 1px 6px;--dp-row-margin: 5px 0;--dp-calendar-header-cell-padding: 0.5rem;--dp-multi-calendars-spacing: 10px;--dp-overlay-col-padding: 3px;--dp-time-inc-dec-button-size: 32px;--dp-font-size: 1rem;--dp-preview-font-size: 0.8rem;--dp-time-font-size: 2rem;--dp-action-button-height: 22px;--dp-action-row-padding: 8px}.dp__theme_dark{--dp-background-color: #212121;--dp-text-color: #fff;--dp-hover-color: #484848;--dp-hover-text-color: #fff;--dp-hover-icon-color: #959595;--dp-primary-color: #005cb2;--dp-primary-disabled-color: #61a8ea;--dp-primary-text-color: #fff;--dp-secondary-color: #a9a9a9;--dp-border-color: #2d2d2d;--dp-menu-border-color: #2d2d2d;--dp-border-color-hover: #aaaeb7;--dp-disabled-color: #737373;--dp-disabled-color-text: #d0d0d0;--dp-scroll-bar-background: #212121;--dp-scroll-bar-color: #484848;--dp-success-color: #00701a;--dp-success-color-disabled: #428f59;--dp-icon-color: #959595;--dp-danger-color: #e53935;--dp-marker-color: #e53935;--dp-tooltip-color: #3e3e3e;--dp-highlight-color: rgb(0 92 178 / 20%);--dp-range-between-dates-background-color: var(--dp-hover-color, #484848);--dp-range-between-dates-text-color: var(--dp-hover-text-color, #fff);--dp-range-between-border-color: var(--dp-hover-color, #fff);--dp-loader: 5px solid #005cb2}.dp__theme_light{--dp-background-color: #fff;--dp-text-color: #212121;--dp-hover-color: #f3f3f3;--dp-hover-text-color: #212121;--dp-hover-icon-color: #959595;--dp-primary-color: #1976d2;--dp-primary-disabled-color: #6bacea;--dp-primary-text-color: #f8f5f5;--dp-secondary-color: #c0c4cc;--dp-border-color: #ddd;--dp-menu-border-color: #ddd;--dp-border-color-hover: #aaaeb7;--dp-disabled-color: #f6f6f6;--dp-scroll-bar-background: #f3f3f3;--dp-scroll-bar-color: #959595;--dp-success-color: #76d275;--dp-success-color-disabled: #a3d9b1;--dp-icon-color: #959595;--dp-danger-color: #ff6f60;--dp-marker-color: #ff6f60;--dp-tooltip-color: #fafafa;--dp-disabled-color-text: #8e8e8e;--dp-highlight-color: rgb(25 118 210 / 10%);--dp-range-between-dates-background-color: var(--dp-hover-color, #f3f3f3);--dp-range-between-dates-text-color: var(--dp-hover-text-color, #212121);--dp-range-between-border-color: var(--dp-hover-color, #f3f3f3);--dp-loader: 5px solid #1976d2}.dp__flex{display:flex;align-items:center}.dp__btn{background:none}.dp__main{font-family:var(--dp-font-family);-webkit-user-select:none;-moz-user-select:none;user-select:none;box-sizing:border-box;position:relative;width:100%}.dp__pointer{cursor:pointer}.dp__icon{stroke:currentcolor;fill:currentcolor}.dp__button{width:100%;text-align:center;color:var(--dp-icon-color);cursor:pointer;display:flex;align-items:center;place-content:center center;padding:var(--dp-common-padding);box-sizing:border-box;height:var(--dp-button-height)}.dp__button.dp__overlay_action{position:absolute;bottom:0}.dp__button:hover{background:var(--dp-hover-color);color:var(--dp-hover-icon-color)}.dp__button svg{height:var(--dp-button-icon-height);width:auto}.dp__button_bottom{border-bottom-left-radius:var(--dp-border-radius);border-bottom-right-radius:var(--dp-border-radius)}.dp__flex_display{display:flex}.dp__flex_display_with_input{flex-direction:column;align-items:flex-start}.dp__relative{position:relative}.calendar-next-enter-active,.calendar-next-leave-active,.calendar-prev-enter-active,.calendar-prev-leave-active{transition:all var(--dp-transition-timing-general) ease-out}.calendar-next-enter-from{opacity:0;transform:translateX(var(--dp-transition-length))}.calendar-next-leave-to{opacity:0;transform:translateX(calc(var(--dp-transition-length) * -1))}.calendar-prev-enter-from{opacity:0;transform:translateX(calc(var(--dp-transition-length) * -1))}.calendar-prev-leave-to{opacity:0;transform:translateX(var(--dp-transition-length))}.dp-menu-appear-bottom-enter-active,.dp-menu-appear-bottom-leave-active,.dp-menu-appear-top-enter-active,.dp-menu-appear-top-leave-active,.dp-slide-up-enter-active,.dp-slide-up-leave-active,.dp-slide-down-enter-active,.dp-slide-down-leave-active{transition:all var(--dp-animation-duration) var(--dp-transition-timing)}.dp-menu-appear-top-enter-from,.dp-menu-appear-top-leave-to,.dp-slide-down-leave-to,.dp-slide-up-enter-from{opacity:0;transform:translateY(var(--dp-transition-length))}.dp-menu-appear-bottom-enter-from,.dp-menu-appear-bottom-leave-to,.dp-slide-down-enter-from,.dp-slide-up-leave-to{opacity:0;transform:translateY(calc(var(--dp-transition-length) * -1))}.dp--arrow-btn-nav{transition:var(--dp-common-transition)}.dp--highlighted{background-color:var(--dp-highlight-color)}\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/leaflet/dist/leaflet.css":
/*!*******************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/leaflet/dist/leaflet.css ***!
  \*******************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css-loader/dist/runtime/getUrl.js */ "./node_modules/css-loader/dist/runtime/getUrl.js");
/* harmony import */ var _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _images_layers_png__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./images/layers.png */ "./node_modules/leaflet/dist/images/layers.png");
/* harmony import */ var _images_layers_2x_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./images/layers-2x.png */ "./node_modules/leaflet/dist/images/layers-2x.png");
/* harmony import */ var _images_marker_icon_png__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./images/marker-icon.png */ "./node_modules/leaflet/dist/images/marker-icon.png");
// Imports





var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
var ___CSS_LOADER_URL_REPLACEMENT_0___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_images_layers_png__WEBPACK_IMPORTED_MODULE_2__["default"]);
var ___CSS_LOADER_URL_REPLACEMENT_1___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_images_layers_2x_png__WEBPACK_IMPORTED_MODULE_3__["default"]);
var ___CSS_LOADER_URL_REPLACEMENT_2___ = _css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_images_marker_icon_png__WEBPACK_IMPORTED_MODULE_4__["default"]);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "/* required styles */\r\n\r\n.leaflet-pane,\r\n.leaflet-tile,\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow,\r\n.leaflet-tile-container,\r\n.leaflet-pane > svg,\r\n.leaflet-pane > canvas,\r\n.leaflet-zoom-box,\r\n.leaflet-image-layer,\r\n.leaflet-layer {\r\n\tposition: absolute;\r\n\tleft: 0;\r\n\ttop: 0;\r\n\t}\r\n.leaflet-container {\r\n\toverflow: hidden;\r\n\t}\r\n.leaflet-tile,\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow {\r\n\t-webkit-user-select: none;\r\n\t   -moz-user-select: none;\r\n\t        user-select: none;\r\n\t  -webkit-user-drag: none;\r\n\t}\r\n/* Prevents IE11 from highlighting tiles in blue */\r\n.leaflet-tile::-moz-selection {\r\n\tbackground: transparent;\r\n}\r\n.leaflet-tile::selection {\r\n\tbackground: transparent;\r\n}\r\n/* Safari renders non-retina tile on retina better with this, but Chrome is worse */\r\n.leaflet-safari .leaflet-tile {\r\n\timage-rendering: -webkit-optimize-contrast;\r\n\t}\r\n/* hack that prevents hw layers \"stretching\" when loading new tiles */\r\n.leaflet-safari .leaflet-tile-container {\r\n\twidth: 1600px;\r\n\theight: 1600px;\r\n\t-webkit-transform-origin: 0 0;\r\n\t}\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow {\r\n\tdisplay: block;\r\n\t}\r\n/* .leaflet-container svg: reset svg max-width decleration shipped in Joomla! (joomla.org) 3.x */\r\n/* .leaflet-container img: map is broken in FF if you have max-width: 100% on tiles */\r\n.leaflet-container .leaflet-overlay-pane svg {\r\n\tmax-width: none !important;\r\n\tmax-height: none !important;\r\n\t}\r\n.leaflet-container .leaflet-marker-pane img,\r\n.leaflet-container .leaflet-shadow-pane img,\r\n.leaflet-container .leaflet-tile-pane img,\r\n.leaflet-container img.leaflet-image-layer,\r\n.leaflet-container .leaflet-tile {\r\n\tmax-width: none !important;\r\n\tmax-height: none !important;\r\n\twidth: auto;\r\n\tpadding: 0;\r\n\t}\r\n\r\n.leaflet-container img.leaflet-tile {\r\n\t/* See: https://bugs.chromium.org/p/chromium/issues/detail?id=600120 */\r\n\tmix-blend-mode: plus-lighter;\r\n}\r\n\r\n.leaflet-container.leaflet-touch-zoom {\r\n\ttouch-action: pan-x pan-y;\r\n\t}\r\n.leaflet-container.leaflet-touch-drag {\r\n\t/* Fallback for FF which doesn't support pinch-zoom */\r\n\ttouch-action: none;\r\n\ttouch-action: pinch-zoom;\r\n}\r\n.leaflet-container.leaflet-touch-drag.leaflet-touch-zoom {\r\n\ttouch-action: none;\r\n}\r\n.leaflet-container {\r\n\t-webkit-tap-highlight-color: transparent;\r\n}\r\n.leaflet-container a {\r\n\t-webkit-tap-highlight-color: rgba(51, 181, 229, 0.4);\r\n}\r\n.leaflet-tile {\r\n\tfilter: inherit;\r\n\tvisibility: hidden;\r\n\t}\r\n.leaflet-tile-loaded {\r\n\tvisibility: inherit;\r\n\t}\r\n.leaflet-zoom-box {\r\n\twidth: 0;\r\n\theight: 0;\r\n\tbox-sizing: border-box;\r\n\tz-index: 800;\r\n\t}\r\n/* workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=888319 */\r\n.leaflet-overlay-pane svg {\r\n\t-moz-user-select: none;\r\n\t}\r\n\r\n.leaflet-pane         { z-index: 400; }\r\n\r\n.leaflet-tile-pane    { z-index: 200; }\r\n.leaflet-overlay-pane { z-index: 400; }\r\n.leaflet-shadow-pane  { z-index: 500; }\r\n.leaflet-marker-pane  { z-index: 600; }\r\n.leaflet-tooltip-pane   { z-index: 650; }\r\n.leaflet-popup-pane   { z-index: 700; }\r\n\r\n.leaflet-map-pane canvas { z-index: 100; }\r\n.leaflet-map-pane svg    { z-index: 200; }\r\n\r\n.leaflet-vml-shape {\r\n\twidth: 1px;\r\n\theight: 1px;\r\n\t}\r\n.lvml {\r\n\tbehavior: url(#default#VML);\r\n\tdisplay: inline-block;\r\n\tposition: absolute;\r\n\t}\r\n\r\n\r\n/* control positioning */\r\n\r\n.leaflet-control {\r\n\tposition: relative;\r\n\tz-index: 800;\r\n\tpointer-events: visiblePainted; /* IE 9-10 doesn't have auto */\r\n\tpointer-events: auto;\r\n\t}\r\n.leaflet-top,\r\n.leaflet-bottom {\r\n\tposition: absolute;\r\n\tz-index: 1000;\r\n\tpointer-events: none;\r\n\t}\r\n.leaflet-top {\r\n\ttop: 0;\r\n\t}\r\n.leaflet-right {\r\n\tright: 0;\r\n\t}\r\n.leaflet-bottom {\r\n\tbottom: 0;\r\n\t}\r\n.leaflet-left {\r\n\tleft: 0;\r\n\t}\r\n.leaflet-control {\r\n\tfloat: left;\r\n\tclear: both;\r\n\t}\r\n.leaflet-right .leaflet-control {\r\n\tfloat: right;\r\n\t}\r\n.leaflet-top .leaflet-control {\r\n\tmargin-top: 10px;\r\n\t}\r\n.leaflet-bottom .leaflet-control {\r\n\tmargin-bottom: 10px;\r\n\t}\r\n.leaflet-left .leaflet-control {\r\n\tmargin-left: 10px;\r\n\t}\r\n.leaflet-right .leaflet-control {\r\n\tmargin-right: 10px;\r\n\t}\r\n\r\n\r\n/* zoom and fade animations */\r\n\r\n.leaflet-fade-anim .leaflet-popup {\r\n\topacity: 0;\r\n\ttransition: opacity 0.2s linear;\r\n\t}\r\n.leaflet-fade-anim .leaflet-map-pane .leaflet-popup {\r\n\topacity: 1;\r\n\t}\r\n.leaflet-zoom-animated {\r\n\ttransform-origin: 0 0;\r\n\t}\r\nsvg.leaflet-zoom-animated {\r\n\twill-change: transform;\r\n}\r\n\r\n.leaflet-zoom-anim .leaflet-zoom-animated {\r\n\ttransition:         transform 0.25s cubic-bezier(0,0,0.25,1);\r\n\t}\r\n.leaflet-zoom-anim .leaflet-tile,\r\n.leaflet-pan-anim .leaflet-tile {\r\n\ttransition: none;\r\n\t}\r\n\r\n.leaflet-zoom-anim .leaflet-zoom-hide {\r\n\tvisibility: hidden;\r\n\t}\r\n\r\n\r\n/* cursors */\r\n\r\n.leaflet-interactive {\r\n\tcursor: pointer;\r\n\t}\r\n.leaflet-grab {\r\n\tcursor:         grab;\r\n\t}\r\n.leaflet-crosshair,\r\n.leaflet-crosshair .leaflet-interactive {\r\n\tcursor: crosshair;\r\n\t}\r\n.leaflet-popup-pane,\r\n.leaflet-control {\r\n\tcursor: auto;\r\n\t}\r\n.leaflet-dragging .leaflet-grab,\r\n.leaflet-dragging .leaflet-grab .leaflet-interactive,\r\n.leaflet-dragging .leaflet-marker-draggable {\r\n\tcursor: move;\r\n\tcursor:         grabbing;\r\n\t}\r\n\r\n/* marker & overlays interactivity */\r\n.leaflet-marker-icon,\r\n.leaflet-marker-shadow,\r\n.leaflet-image-layer,\r\n.leaflet-pane > svg path,\r\n.leaflet-tile-container {\r\n\tpointer-events: none;\r\n\t}\r\n\r\n.leaflet-marker-icon.leaflet-interactive,\r\n.leaflet-image-layer.leaflet-interactive,\r\n.leaflet-pane > svg path.leaflet-interactive,\r\nsvg.leaflet-image-layer.leaflet-interactive path {\r\n\tpointer-events: visiblePainted; /* IE 9-10 doesn't have auto */\r\n\tpointer-events: auto;\r\n\t}\r\n\r\n/* visual tweaks */\r\n\r\n.leaflet-container {\r\n\tbackground: #ddd;\r\n\toutline-offset: 1px;\r\n\t}\r\n.leaflet-container a {\r\n\tcolor: #0078A8;\r\n\t}\r\n.leaflet-zoom-box {\r\n\tborder: 2px dotted #38f;\r\n\tbackground: rgba(255,255,255,0.5);\r\n\t}\r\n\r\n\r\n/* general typography */\r\n.leaflet-container {\r\n\tfont-family: \"Helvetica Neue\", Arial, Helvetica, sans-serif;\r\n\tfont-size: 12px;\r\n\tfont-size: 0.75rem;\r\n\tline-height: 1.5;\r\n\t}\r\n\r\n\r\n/* general toolbar styles */\r\n\r\n.leaflet-bar {\r\n\tbox-shadow: 0 1px 5px rgba(0,0,0,0.65);\r\n\tborder-radius: 4px;\r\n\t}\r\n.leaflet-bar a {\r\n\tbackground-color: #fff;\r\n\tborder-bottom: 1px solid #ccc;\r\n\twidth: 26px;\r\n\theight: 26px;\r\n\tline-height: 26px;\r\n\tdisplay: block;\r\n\ttext-align: center;\r\n\ttext-decoration: none;\r\n\tcolor: black;\r\n\t}\r\n.leaflet-bar a,\r\n.leaflet-control-layers-toggle {\r\n\tbackground-position: 50% 50%;\r\n\tbackground-repeat: no-repeat;\r\n\tdisplay: block;\r\n\t}\r\n.leaflet-bar a:hover,\r\n.leaflet-bar a:focus {\r\n\tbackground-color: #f4f4f4;\r\n\t}\r\n.leaflet-bar a:first-child {\r\n\tborder-top-left-radius: 4px;\r\n\tborder-top-right-radius: 4px;\r\n\t}\r\n.leaflet-bar a:last-child {\r\n\tborder-bottom-left-radius: 4px;\r\n\tborder-bottom-right-radius: 4px;\r\n\tborder-bottom: none;\r\n\t}\r\n.leaflet-bar a.leaflet-disabled {\r\n\tcursor: default;\r\n\tbackground-color: #f4f4f4;\r\n\tcolor: #bbb;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-bar a {\r\n\twidth: 30px;\r\n\theight: 30px;\r\n\tline-height: 30px;\r\n\t}\r\n.leaflet-touch .leaflet-bar a:first-child {\r\n\tborder-top-left-radius: 2px;\r\n\tborder-top-right-radius: 2px;\r\n\t}\r\n.leaflet-touch .leaflet-bar a:last-child {\r\n\tborder-bottom-left-radius: 2px;\r\n\tborder-bottom-right-radius: 2px;\r\n\t}\r\n\r\n/* zoom control */\r\n\r\n.leaflet-control-zoom-in,\r\n.leaflet-control-zoom-out {\r\n\tfont: bold 18px 'Lucida Console', Monaco, monospace;\r\n\ttext-indent: 1px;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-control-zoom-in, .leaflet-touch .leaflet-control-zoom-out  {\r\n\tfont-size: 22px;\r\n\t}\r\n\r\n\r\n/* layers control */\r\n\r\n.leaflet-control-layers {\r\n\tbox-shadow: 0 1px 5px rgba(0,0,0,0.4);\r\n\tbackground: #fff;\r\n\tborder-radius: 5px;\r\n\t}\r\n.leaflet-control-layers-toggle {\r\n\tbackground-image: url(" + ___CSS_LOADER_URL_REPLACEMENT_0___ + ");\r\n\twidth: 36px;\r\n\theight: 36px;\r\n\t}\r\n.leaflet-retina .leaflet-control-layers-toggle {\r\n\tbackground-image: url(" + ___CSS_LOADER_URL_REPLACEMENT_1___ + ");\r\n\tbackground-size: 26px 26px;\r\n\t}\r\n.leaflet-touch .leaflet-control-layers-toggle {\r\n\twidth: 44px;\r\n\theight: 44px;\r\n\t}\r\n.leaflet-control-layers .leaflet-control-layers-list,\r\n.leaflet-control-layers-expanded .leaflet-control-layers-toggle {\r\n\tdisplay: none;\r\n\t}\r\n.leaflet-control-layers-expanded .leaflet-control-layers-list {\r\n\tdisplay: block;\r\n\tposition: relative;\r\n\t}\r\n.leaflet-control-layers-expanded {\r\n\tpadding: 6px 10px 6px 6px;\r\n\tcolor: #333;\r\n\tbackground: #fff;\r\n\t}\r\n.leaflet-control-layers-scrollbar {\r\n\toverflow-y: scroll;\r\n\toverflow-x: hidden;\r\n\tpadding-right: 5px;\r\n\t}\r\n.leaflet-control-layers-selector {\r\n\tmargin-top: 2px;\r\n\tposition: relative;\r\n\ttop: 1px;\r\n\t}\r\n.leaflet-control-layers label {\r\n\tdisplay: block;\r\n\tfont-size: 13px;\r\n\tfont-size: 1.08333em;\r\n\t}\r\n.leaflet-control-layers-separator {\r\n\theight: 0;\r\n\tborder-top: 1px solid #ddd;\r\n\tmargin: 5px -10px 5px -6px;\r\n\t}\r\n\r\n/* Default icon URLs */\r\n.leaflet-default-icon-path { /* used only in path-guessing heuristic, see L.Icon.Default */\r\n\tbackground-image: url(" + ___CSS_LOADER_URL_REPLACEMENT_2___ + ");\r\n\t}\r\n\r\n\r\n/* attribution and scale controls */\r\n\r\n.leaflet-container .leaflet-control-attribution {\r\n\tbackground: #fff;\r\n\tbackground: rgba(255, 255, 255, 0.8);\r\n\tmargin: 0;\r\n\t}\r\n.leaflet-control-attribution,\r\n.leaflet-control-scale-line {\r\n\tpadding: 0 5px;\r\n\tcolor: #333;\r\n\tline-height: 1.4;\r\n\t}\r\n.leaflet-control-attribution a {\r\n\ttext-decoration: none;\r\n\t}\r\n.leaflet-control-attribution a:hover,\r\n.leaflet-control-attribution a:focus {\r\n\ttext-decoration: underline;\r\n\t}\r\n.leaflet-attribution-flag {\r\n\tdisplay: inline !important;\r\n\tvertical-align: baseline !important;\r\n\twidth: 1em;\r\n\theight: 0.6669em;\r\n\t}\r\n.leaflet-left .leaflet-control-scale {\r\n\tmargin-left: 5px;\r\n\t}\r\n.leaflet-bottom .leaflet-control-scale {\r\n\tmargin-bottom: 5px;\r\n\t}\r\n.leaflet-control-scale-line {\r\n\tborder: 2px solid #777;\r\n\tborder-top: none;\r\n\tline-height: 1.1;\r\n\tpadding: 2px 5px 1px;\r\n\twhite-space: nowrap;\r\n\tbox-sizing: border-box;\r\n\tbackground: rgba(255, 255, 255, 0.8);\r\n\ttext-shadow: 1px 1px #fff;\r\n\t}\r\n.leaflet-control-scale-line:not(:first-child) {\r\n\tborder-top: 2px solid #777;\r\n\tborder-bottom: none;\r\n\tmargin-top: -2px;\r\n\t}\r\n.leaflet-control-scale-line:not(:first-child):not(:last-child) {\r\n\tborder-bottom: 2px solid #777;\r\n\t}\r\n\r\n.leaflet-touch .leaflet-control-attribution,\r\n.leaflet-touch .leaflet-control-layers,\r\n.leaflet-touch .leaflet-bar {\r\n\tbox-shadow: none;\r\n\t}\r\n.leaflet-touch .leaflet-control-layers,\r\n.leaflet-touch .leaflet-bar {\r\n\tborder: 2px solid rgba(0,0,0,0.2);\r\n\tbackground-clip: padding-box;\r\n\t}\r\n\r\n\r\n/* popup */\r\n\r\n.leaflet-popup {\r\n\tposition: absolute;\r\n\ttext-align: center;\r\n\tmargin-bottom: 20px;\r\n\t}\r\n.leaflet-popup-content-wrapper {\r\n\tpadding: 1px;\r\n\ttext-align: left;\r\n\tborder-radius: 12px;\r\n\t}\r\n.leaflet-popup-content {\r\n\tmargin: 13px 24px 13px 20px;\r\n\tline-height: 1.3;\r\n\tfont-size: 13px;\r\n\tfont-size: 1.08333em;\r\n\tmin-height: 1px;\r\n\t}\r\n.leaflet-popup-content p {\r\n\tmargin: 17px 0;\r\n\tmargin: 1.3em 0;\r\n\t}\r\n.leaflet-popup-tip-container {\r\n\twidth: 40px;\r\n\theight: 20px;\r\n\tposition: absolute;\r\n\tleft: 50%;\r\n\tmargin-top: -1px;\r\n\tmargin-left: -20px;\r\n\toverflow: hidden;\r\n\tpointer-events: none;\r\n\t}\r\n.leaflet-popup-tip {\r\n\twidth: 17px;\r\n\theight: 17px;\r\n\tpadding: 1px;\r\n\r\n\tmargin: -10px auto 0;\r\n\tpointer-events: auto;\r\n\ttransform: rotate(45deg);\r\n\t}\r\n.leaflet-popup-content-wrapper,\r\n.leaflet-popup-tip {\r\n\tbackground: white;\r\n\tcolor: #333;\r\n\tbox-shadow: 0 3px 14px rgba(0,0,0,0.4);\r\n\t}\r\n.leaflet-container a.leaflet-popup-close-button {\r\n\tposition: absolute;\r\n\ttop: 0;\r\n\tright: 0;\r\n\tborder: none;\r\n\ttext-align: center;\r\n\twidth: 24px;\r\n\theight: 24px;\r\n\tfont: 16px/24px Tahoma, Verdana, sans-serif;\r\n\tcolor: #757575;\r\n\ttext-decoration: none;\r\n\tbackground: transparent;\r\n\t}\r\n.leaflet-container a.leaflet-popup-close-button:hover,\r\n.leaflet-container a.leaflet-popup-close-button:focus {\r\n\tcolor: #585858;\r\n\t}\r\n.leaflet-popup-scrolled {\r\n\toverflow: auto;\r\n\t}\r\n\r\n.leaflet-oldie .leaflet-popup-content-wrapper {\r\n\t-ms-zoom: 1;\r\n\t}\r\n.leaflet-oldie .leaflet-popup-tip {\r\n\twidth: 24px;\r\n\tmargin: 0 auto;\r\n\r\n\t-ms-filter: \"progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=0.70710678, M21=-0.70710678, M22=0.70710678)\";\r\n\tfilter: progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=0.70710678, M21=-0.70710678, M22=0.70710678);\r\n\t}\r\n\r\n.leaflet-oldie .leaflet-control-zoom,\r\n.leaflet-oldie .leaflet-control-layers,\r\n.leaflet-oldie .leaflet-popup-content-wrapper,\r\n.leaflet-oldie .leaflet-popup-tip {\r\n\tborder: 1px solid #999;\r\n\t}\r\n\r\n\r\n/* div icon */\r\n\r\n.leaflet-div-icon {\r\n\tbackground: #fff;\r\n\tborder: 1px solid #666;\r\n\t}\r\n\r\n\r\n/* Tooltip */\r\n/* Base styles for the element that has a tooltip */\r\n.leaflet-tooltip {\r\n\tposition: absolute;\r\n\tpadding: 6px;\r\n\tbackground-color: #fff;\r\n\tborder: 1px solid #fff;\r\n\tborder-radius: 3px;\r\n\tcolor: #222;\r\n\twhite-space: nowrap;\r\n\t-webkit-user-select: none;\r\n\t-moz-user-select: none;\r\n\tuser-select: none;\r\n\tpointer-events: none;\r\n\tbox-shadow: 0 1px 3px rgba(0,0,0,0.4);\r\n\t}\r\n.leaflet-tooltip.leaflet-interactive {\r\n\tcursor: pointer;\r\n\tpointer-events: auto;\r\n\t}\r\n.leaflet-tooltip-top:before,\r\n.leaflet-tooltip-bottom:before,\r\n.leaflet-tooltip-left:before,\r\n.leaflet-tooltip-right:before {\r\n\tposition: absolute;\r\n\tpointer-events: none;\r\n\tborder: 6px solid transparent;\r\n\tbackground: transparent;\r\n\tcontent: \"\";\r\n\t}\r\n\r\n/* Directions */\r\n\r\n.leaflet-tooltip-bottom {\r\n\tmargin-top: 6px;\r\n}\r\n.leaflet-tooltip-top {\r\n\tmargin-top: -6px;\r\n}\r\n.leaflet-tooltip-bottom:before,\r\n.leaflet-tooltip-top:before {\r\n\tleft: 50%;\r\n\tmargin-left: -6px;\r\n\t}\r\n.leaflet-tooltip-top:before {\r\n\tbottom: 0;\r\n\tmargin-bottom: -12px;\r\n\tborder-top-color: #fff;\r\n\t}\r\n.leaflet-tooltip-bottom:before {\r\n\ttop: 0;\r\n\tmargin-top: -12px;\r\n\tmargin-left: -6px;\r\n\tborder-bottom-color: #fff;\r\n\t}\r\n.leaflet-tooltip-left {\r\n\tmargin-left: -6px;\r\n}\r\n.leaflet-tooltip-right {\r\n\tmargin-left: 6px;\r\n}\r\n.leaflet-tooltip-left:before,\r\n.leaflet-tooltip-right:before {\r\n\ttop: 50%;\r\n\tmargin-top: -6px;\r\n\t}\r\n.leaflet-tooltip-left:before {\r\n\tright: 0;\r\n\tmargin-right: -12px;\r\n\tborder-left-color: #fff;\r\n\t}\r\n.leaflet-tooltip-right:before {\r\n\tleft: 0;\r\n\tmargin-left: -12px;\r\n\tborder-right-color: #fff;\r\n\t}\r\n\r\n/* Printing */\r\n\r\n@media print {\r\n\t/* Prevent printers from removing background-images of controls. */\r\n\t.leaflet-control {\r\n\t\t-webkit-print-color-adjust: exact;\r\n\t\tprint-color-adjust: exact;\r\n\t\t}\r\n\t}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=style&index=0&id=5d7e7488&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=style&index=0&id=5d7e7488&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.toolTipCopyButton{\r\n    padding: 2px 3px !important;\r\n    font-size: 1rem !important;\r\n    height: 100% !important;\r\n    box-shadow: 0px 1px 1px 0px rgba(16, 17, 26, 0.16), #d5dbe1 0 0 0 1px, 0 0 0 0 transparent, 0 0 0 0 transparent !important;\r\n}\r\n\r\n/* .customTooltip{\r\n    scale: 0.75 !important;\r\n    left: 0% !important;\r\n} */\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=style&index=1&id=5d7e7488&scoped=true&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetail.vue?vue&type=style&index=1&id=5d7e7488&scoped=true&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.line-separator[data-v-5d7e7488] {\r\n    margin: 0 -1rem 1.5rem;\r\n    border-bottom: 1px solid var(--vz-border-color);\n}\ntd[data-v-5d7e7488] {\r\n    width: 50% !important;\n}\n.tableBody[data-v-5d7e7488] {\r\n    display: flex;\r\n    flex-wrap: wrap;\n}\n.tableRow[data-v-5d7e7488] {\r\n    flex-basis: 50%;\r\n    display: flex;\n}\r\n\r\n/* .payment-details-cardArea > ul > li .badge {\r\n    font-size: 12px;\r\n    display: inline-flex;\r\n    gap: 5px;\r\n    padding: 5px 7px;\r\n    border: 1px solid;\r\n    width: initial;\r\n    height: initial;\r\n} */\n[data-v-5d7e7488] .threedotsclickopen{\r\n    width: auto;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=style&index=0&id=29c872d2&lang=css":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=style&index=0&id=29c872d2&lang=css ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.dropdown-btn{\r\n    color:#625afa !important;\r\n    text-align: left;\r\n    width: 100%;\r\n    padding: auto 0.5rem;\r\n}\r\n\r\ntable>*>tr>td {\r\n    white-space: nowrap;\r\n}\r\n\r\n.code {\r\n    background: rgba(255, 255, 255, 0.15);\r\n    padding: 1px 5px;\r\n    border-radius: 4px;\r\n    min-width: 25px;\r\n    text-align: center;\r\n}\r\n\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=style&index=1&id=29c872d2&scoped=true&lang=css":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Brief/BriefDetailLayout.vue?vue&type=style&index=1&id=29c872d2&scoped=true&lang=css ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.create-new-button[data-v-29c872d2]{\r\n    color: white;\r\n    border: none;\n}\n.create-new-button[data-v-29c872d2]:hover{\r\n    color: white;\n}\n.big-text[data-v-29c872d2] {\r\n  font-size: 26px !important;\r\n  text-transform: capitalize;\r\n  font-weight: 700;\n}\n.buttonWithSmallText[data-v-29c872d2] {\r\n  font-size: 12px;\r\n  white-space: nowrap;\r\n  margin-left: -100px;\n}\n.page-title-box[data-v-29c872d2] {\r\n  box-shadow: none;\r\n  border: 0;\r\n  margin-bottom: 10px;\n}\n.card-body[data-v-29c872d2],\r\n.card[data-v-29c872d2] {\r\n  padding: 0;\r\n  box-shadow: none;\n}\n.card-header[data-v-29c872d2]  {\r\n    margin-bottom: 20px;\r\n    overflow: hidden;\n}\n.nav-tabs-custom .nav-item .nav-link[data-v-29c872d2] {\r\n    padding: 0 1rem 5px;\r\n    color: #625afa;\r\n    /* border-bottom: 2px solid #625afa; */\n}\n#scroll-horizontal th[data-v-29c872d2] {\r\n    font-size: 11px;\r\n    font-weight: 700;\r\n    color: #414552;\n}\n.create-payment-btn > button[data-v-29c872d2] {\r\n    position: relative;\r\n    overflow: initial;\n}\n.customTooltip[data-v-29c872d2] {\r\n    font-size: 12px;\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 3px;\r\n    position: absolute;\r\n    left: 50%;\r\n    transform: translate(-50%);\r\n    background: #434352;\r\n    bottom: 120%;\r\n    padding: 6px 10px;\r\n    color: #fff;\r\n    border-radius: 6px;\r\n    white-space: nowrap;\r\n    transition: opacity 0.3s, visibility 0.3s;\r\n    z-index: 10010;\n}\n.customTooltip > span[data-v-29c872d2] {\r\n    display: inline-block;\n}\n.create-payment-btn > button:not(:hover) > .customTooltip[data-v-29c872d2] {\r\n    opacity: 0;\r\n    visibility: hidden;\n}\n.customTooltip > span.code[data-v-29c872d2] {\r\n    background: rgba(255, 255, 255, 0.15);\r\n    padding: 1px 5px;\r\n    border-radius: 4px;\r\n    min-width: 25px;\r\n    text-align: center;\n}\r\n\r\n/* .payment-actionListUl{\r\n    width: 4rem;\r\n} */\n.activity-section[data-v-29c872d2]{\r\n    padding: 2rem 0;\n}\n.payment-detail-table > tbody > tr[data-v-29c872d2]:first-child{\r\n    width: 40% !important;\n}\n.payment-detail-table > tbody > tr[data-v-29c872d2]:last-child{\r\n    width: 60% !important;\n}\n.dropDown[data-v-29c872d2]{\r\n    padding: 0.5rem 0 !important;\r\n    font-family: 'Poppins', sans-serif;\n}\n.dropDown[data-v-29c872d2]::before {\r\n    content: \"\";\r\n    position: absolute;\r\n    left: 50%;\r\n    bottom: 100%;\r\n    width: 0;\r\n    height: 0;\r\n    border-left: 10px solid transparent;\r\n    border-right: 10px solid transparent;\r\n    border-bottom: 10px solid #ffffff;\r\n    z-index: 1;\r\n    filter: drop-shadow(0 -0.125rem 0.125rem rgba(0, 0, 0, 0.15));\r\n    transform: translate(-50%, 0);\n}\n.dropDownBtn[data-v-29c872d2]{\r\n    padding: 0 0.5rem !important;\n}\n.tableContainer[data-v-29c872d2]{\r\n    overflow-x: scroll !important;\r\n    min-height: 1rem !important;\n}\n.align-col[data-v-29c872d2]{\r\n  display: flex;\r\n  justify-content: flex-end;\n}\n.card-header[data-v-29c872d2]{\r\n  margin: -17px -1.5rem 1.5rem -1.5rem;\n}\n.page-title-box[data-v-29c872d2]{\r\n  margin: initial;\n}\n.payment-details-header .payment-actionListUl[data-v-29c872d2] {\r\n    margin-inline-end: 3px;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=style&index=0&id=aa27937e&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/BriefForm/Select/Select.vue?vue&type=style&index=0&id=aa27937e&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n  .selectArea {\r\n    position: relative;\r\n    cursor: pointer;\r\n    transition: background 0.3s;\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    user-select: none;\r\n  }\r\n\r\n  .selectArea > p {\r\n    background: #fff;\r\n    font-size: 13px;\r\n    line-height: 20px;\r\n    min-height: 28px;\r\n    border-radius: 6px;\r\n    box-shadow: 0px 1px 1px 0px rgba(16, 17, 26, 0.16), #d5dbe1 0 0 0 1px, 0 0 0 0 transparent, 0 0 0 0 transparent;\r\n    padding: 3px 10px;\r\n    font-weight: 500;\r\n    border: 0;\r\n    outline: 0;\r\n    display: flex;\r\n    margin: 0;\r\n    gap: 0.25rem;\r\n    align-items: center;\r\n    justify-content: space-between;\r\n  }\r\n\r\n  .selectArea > p > i {\r\n    font-size: 20px;\r\n  }\r\n\r\n  .selectDropdownArea{\r\n      position: absolute;\r\n      left: 50%;\r\n      top: 100%;\r\n      transform: translate(-50%, 12px);\r\n      z-index: 10100;\r\n      min-width: 100%;\r\n  }\r\n\r\n  .selectDropdown {\r\n    width: 100%;\r\n    white-space: nowrap;\r\n    background: #fff;\r\n    padding: 0.375rem;\r\n    border-radius: 0.5rem;\r\n    box-shadow: 0 0 0.75rem rgba(0,0,0,0.15);\r\n    list-style: none;\r\n    margin: 0;\r\n    font-weight: 600;\r\n    line-height: 1.2;\r\n    max-height: 10rem;\r\n    overflow: auto\r\n  }\r\n\r\n  .selectDropdownArea::before{\r\n    content: '';\r\n    position: absolute;\r\n    left: 50%;\r\n    bottom: 100%;\r\n    width: 0;\r\n    height: 0;\r\n    border-left: 10px solid transparent;\r\n    border-right: 10px solid transparent;\r\n    border-bottom: 10px solid #ffffff;\r\n    z-index: 1;\r\n    filter: drop-shadow(0 -0.125rem 0.125rem rgba(0,0,0,0.15));\r\n    transform: translate(-50%, 0);\r\n  }\r\n\r\n  .selectDropdown > li {\r\n    width: 100%;\r\n    padding: 0.375rem 0.5rem;\r\n    border-radius: 0.375rem;\r\n    cursor: pointer;\r\n    display: flex;\r\n    align-items: center;\r\n    gap: 5px;\r\n  }\r\n\r\n  .selectDropdown > li:hover {\r\n    background: #eee;\r\n  }\r\n\r\n  .selectDropdown > li > i {\r\n    line-height: 0;\r\n    font-size: 16px;\r\n    opacity: 0;\r\n  }\r\n\r\n  .selectDropdown > li.active {\r\n    color: var(--custom-primary);\r\n  }\r\n\r\n  .selectDropdown > li.active > i {\r\n    opacity: 1;\r\n  }\r\n\r\n  .disabled {\r\n    pointer-events: none;\r\n    opacity: 0.7;\r\n  }\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=style&index=0&id=da06ce6a&scoped=true&lang=css":
/*!************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefActivities.vue?vue&type=style&index=0&id=da06ce6a&scoped=true&lang=css ***!
  \************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n/* .count{\r\n    margin-inline-start: 2px;\r\n} */\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=style&index=0&id=4c071e58&scoped=true&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=style&index=0&id=4c071e58&scoped=true&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n/* .mapdiv {\r\n    padding: 12px;\r\n    border: 1px solid #ebebeb;\r\n}\r\n.mapdiv .mapdivtable {\r\n    margin-top: 18px;\r\n    font-size: 12px;\r\n    width: 100%;\r\n    color: #626568;\r\n} */\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=style&index=1&id=4c071e58&lang=css":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefDetails.vue?vue&type=style&index=1&id=4c071e58&lang=css ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.leaflet-container, #map {\r\n  height: 250px;\r\n  width: 100%;\r\n}\r\n\r\n.leaflet-pane.leaflet-tile-pane {\r\n      filter: grayscale(1);\r\n}\r\n\r\n.mapdivtable tbody > tr > td {\r\n    vertical-align: top;\r\n}\r\n\r\n.clickshowcontent {\r\n    margin-bottom: 20px;\r\n}\r\n\r\n.clickshowcontent .showinnerdiv {\r\n    display: none;\r\n    flex-direction: row;\r\n    width: 100%;\r\n    border-top: 1px solid #e9ebec;\r\n    margin-top: 10px;\r\n    padding-top: 16px;\r\n    position: relative;\r\n}\r\n\r\n.flexVisible {\r\n    display: flex !important;\r\n}\r\n\r\n.clickshowcontent .showinnerdiv p {\r\n    flex: 1 1 0px;\r\n    display: grid;\r\n    color: #687385;\r\n}\r\n\r\n.clickshowcontent .showinnerdiv p strong {\r\n    font-weight: 500;\r\n    color: #414552;\r\n}\r\n\r\n.clickshowcontent a {\r\n    cursor: pointer;\r\n    font-weight: 600;\r\n    font-size: 14px;\r\n}\r\n\r\n.clickshowcontent a i {\r\n    color: #687385;\r\n}\r\n\r\n.detailscontentdiv {\r\n    width: 100%;\r\n    margin-bottom: 20px;\r\n    transition: max-height 0.3s ease-in-out;\r\n    position: relative;\r\n}\r\n\r\n.detailscontentdiv:not(.expanded) > .showMore {\r\n    display: none;\r\n}\r\n.detailscontentdiv.expanded {\r\n    max-height: none;\r\n}\r\n.detailscontentdiv > p {\r\n    color: #687385;\r\n    font-size: 13px;\r\n    margin-bottom: 8px;\r\n}\r\n.detailsSpan {\r\n    display: inline-block;\r\n    margin-top: 1px;\r\n}\r\n.cardLike {\r\n    padding: 0 4px;\r\n    border-radius: 4px;\r\n    background: #f0f2f5;\r\n    border: 1px solid #eee;\r\n}\r\n.detailscontentdiv > p > span {\r\n    color: #414552;\r\n}\r\n.showinnerdiv a {\r\n    font-size: 13px;\r\n    font-weight: 500;\r\n    color: #625afa;\r\n    /* position: absolute;\r\n    bottom: -8px; */\r\n    left: 0;\r\n}\r\n\r\n.purpleLink {\r\n    color: #625afa;\r\n    opacity: 0;\r\n    visibility: hidden;\r\n    transition: all 0.3s;\r\n}\r\n\r\n.showThis {\r\n    opacity: 1;\r\n    visibility: visible;\r\n}\r\n\r\n.customerleftcol {\r\n    top: 0.3rem;\r\n}\r\n\r\n.customerleftcol > a {\r\n    color: #30313d;\r\n    /* color: #625afa; */\r\n    font-size: 14px;\r\n    font-weight: 500;\r\n}\r\n.customerleftcol > h3 {\r\n    font-size: 28px;\r\n    line-height: 1;\r\n    font-weight: 700;\r\n    color: #000;\r\n    margin: 8px 0;\r\n    letter-spacing: -1px;\r\n}\r\n.customerleftcol > p {\r\n    font-size: 14px;\r\n    font-weight: 400;\r\n    color: #6d7785;\r\n    margin-bottom: 30px;\r\n}\r\n\r\n.rotateIcon {\r\n    transform: rotate(90deg);\r\n    transition: transform 0.3s ease; /* Add a smooth transition */\r\n}\r\n\r\n.insight-table > tbody > tr > td{\r\n    white-space: normal;\r\n}\r\n\r\n.sticky-column{\r\n    position: relative;\r\n    top: 0;\r\n    height: -moz-fit-content;\r\n    height: fit-content;\r\n}\r\n\r\n.detailsshowmorebtn{\r\n    position: absolute;\r\n    margin-bottom: -0.5rem;;\r\n}\r\n\r\n.key-column{\r\n    width: 50%;\r\n    color: #687385\r\n}\r\n\r\n.value-column{\r\n    width: 50%;\r\n    padding-left: 15px\r\n}\r\n\r\n/* .green-text {\r\n  color: green;\r\n  font-weight: 600;\r\n}\r\n\r\n.yellow-text {\r\n  color: #ffdc3b;\r\n  font-weight: 600;\r\n}\r\n\r\n.red-text {\r\n  color: red;\r\n  font-weight: 600;\r\n} */\r\n\r\n.long-text {\r\n    display: inline-block;\r\n    max-width: 100%;\r\n    overflow: hidden;\r\n    text-overflow: ellipsis;\r\n}\r\n\r\n.opacity-100{\r\n    opacity: 1;\r\n}\r\n\r\n.grayscale-0{\r\n    filter: grayscale(0%) !important;\r\n}\r\n\r\n.list-container {\r\n    padding-left: 1rem;\r\n}\r\n\r\n.image-list-container{\r\n    display: flex; gap: 0.5rem; flex-wrap: wrap;\r\n}\r\n\r\n\r\n.image-list-item{\r\n    display: flex;\r\n    flex-direction: column;\r\n    align-items: center;\r\n    max-width: -moz-fit-content;\r\n    max-width: fit-content;\r\n    padding: 0.5rem 0;\r\n    margin-bottom: 0.25rem;\r\n}\r\n\r\n.image-list-item > img{\r\n    box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px ;\r\n    height: 5rem;\r\n    width: 8rem;\r\n    border-radius: 0.25rem;\r\n    margin-bottom: 0.25rem;\r\n    opacity: 0.2;\r\n    filter: grayscale(100%);\r\n}\r\n\r\n.purple-border{\r\n    border: 1px solid #625afa;\r\n}\r\n\r\n.insight-row{\r\n    width: 100%;\r\n    display: grid;\r\n    grid-template-columns: 50% 50%;\r\n    gap: 0.5rem;\r\n}\r\n\r\n.insight-chunk{\r\n    display: flex;\r\n    flex-direction: column;\r\n}\r\n\r\n.insight-label{\r\n    color: #687385 !important;\r\n}\r\n\r\n.insight-value{\r\n    color: #414552 !important;\r\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=style&index=0&id=5019318e&scoped=true&lang=css":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/BriefInsights.vue?vue&type=style&index=0&id=5019318e&scoped=true&lang=css ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.mapdiv[data-v-5019318e] {\r\n    padding: 12px;\r\n    border: 1px solid #ebebeb;\n}\n.mapdiv .mapdivtable[data-v-5019318e] {\r\n    margin-top: 18px;\r\n    font-size: 12px;\r\n    width: 100%;\r\n    color: #626568;\n}\n.customerleftcol > a[data-v-5019318e] {\r\n    color: #30313d;\r\n    /* color: #625afa; */\r\n    font-size: 14px;\r\n    font-weight: 500;\n}\n.customerleftcol > h3[data-v-5019318e] {\r\n    font-size: 28px;\r\n    line-height: 1;\r\n    font-weight: 700;\r\n    color: #000;\r\n    margin: 8px 0;\r\n    letter-spacing: -1px;\n}\n.customerleftcol > p[data-v-5019318e] {\r\n    font-size: 14px;\r\n    font-weight: 400;\r\n    color: #6d7785;\r\n    margin-bottom: 30px;\n}\n.sticky-column[data-v-5019318e]{\r\n    position: sticky;\r\n    top: 6rem;\r\n    height: -moz-fit-content;\r\n    height: fit-content;\n}\n.key-column[data-v-5019318e]{\r\n    width: 50%;\r\n    color: #687385\n}\n.value-column[data-v-5019318e]{\r\n    width: 50%;\r\n    padding-left: 15px\n}\n.green-text[data-v-5019318e] {\r\n  color: green !important;\r\n  font-weight: 600 !important;\n}\n.yellow-text[data-v-5019318e] {\r\n  color: #ffdc3b !important;\r\n  font-weight: 600 !important;\n}\n.red-text[data-v-5019318e] {\r\n  color: red !important;\r\n  font-weight: 600 !important;\n}\n.black-text[data-v-5019318e] {\r\n  color: #000000;\r\n  font-weight: 600;\n}\n.leaflet-container[data-v-5019318e], #map[data-v-5019318e] {\r\n  height: 250px;\r\n  width: 100%;\n}\n.leaflet-pane.leaflet-tile-pane[data-v-5019318e] {\r\n      filter: grayscale(1);\n}\n.mapdivtable tbody > tr > td[data-v-5019318e] {\r\n    vertical-align: top;\n}\n.purple-border[data-v-5019318e]{\r\n    border: 1px solid #625afa;\n}\n.insight-row[data-v-5019318e]{\r\n    width: 100%;\r\n    display: grid;\r\n    grid-template-columns: 50% 50%;\r\n    gap: 0.5rem;\n}\n.insight-chunk[data-v-5019318e]{\r\n    display: flex;\r\n    flex-direction: column;\n}\n.insight-label[data-v-5019318e]{\r\n    color: #687385 !important;\n}\n.insight-value[data-v-5019318e]{\r\n    color: #414552 !important;\n}\r\n\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=style&index=0&id=d91abef0&scoped=true&lang=css":
/*!**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/Detail/RelatedBriefs.vue?vue&type=style&index=0&id=d91abef0&scoped=true&lang=css ***!
  \**********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.buttonWithSmallText[data-v-d91abef0]{\r\n    font-size: 12px;\r\n    white-space: nowrap;\r\n    margin-left: -40px;\n}\n.user-image[data-v-d91abef0]{\r\n    height: 2rem;\r\n    width: 2rem;\r\n    border-radius: 100%;\r\n    filter: drop-shadow(0 1px 2px rgb(0 0 0 / 0.1)) drop-shadow(0 1px 1px rgb(0 0 0 / 0.06));\r\n    position: absolute;\r\n    top: 0.25rem;\n}\n.user-image[data-v-d91abef0]:hover{\r\n    z-index: 9 !important;\n}\n.hideTooltip[data-v-d91abef0] {\r\n    display: none;\n}\n.showTooltip[data-v-d91abef0] {\r\n    display: block;\n}\n.custom-tooltip[data-v-d91abef0]{\r\n    z-index: 10 !important;\r\n    position: absolute;\r\n    background-color: rgba(0, 0, 0, 0.75);\r\n    color: white;\r\n    padding: 0.25rem;\r\n    border-radius: 0.25rem;\n}\n.user-tooltip[data-v-d91abef0]{\r\n    bottom: -2rem;\r\n    transform: translateX(-50%);\n}\n.more-user-tooltip[data-v-d91abef0]{\r\n    top: 2.75rem;\r\n    left: 5rem;\r\n    transform: translateX(-40%);\r\n    max-width: 10rem;\r\n    text-wrap: wrap;\n}\n.more-users[data-v-d91abef0]{\r\n    position: absolute;\r\n    left: 4rem;\r\n    top: 0.7rem;\n}\r\n\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=style&index=0&id=8ee637c6&scoped=true&lang=css":
/*!*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivity.vue?vue&type=style&index=0&id=8ee637c6&scoped=true&lang=css ***!
  \*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.bxs-pin[data-v-8ee637c6],\r\n  .pinToTop[data-v-8ee637c6] {\r\n    color: #c83901;\n}\n.bxs-pin[data-v-8ee637c6] {\r\n    transform: rotate(45deg);\n}\r\n  /* Timeline text field CSS Start*/\n#cancelbtn[data-v-8ee637c6] {\r\n    border: 1px solid #b9bec4;\r\n    border-radius: 6px;\r\n    color: #414552;\r\n    font-weight: 600;\r\n    font-size: 13px;\r\n    background: transparent;\r\n    padding: 6px 10px;\r\n    margin-right: 6px;\n}\n#cancelbtn > span[data-v-8ee637c6] {\r\n    background: rgb(235 238 241);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\n#addnotepurple[data-v-8ee637c6] {\r\n    border: 1px solid var(--custom-primary);\r\n    border-radius: 6px;\r\n    color: #fff;\r\n    font-size: 13px;\r\n    font-weight: 600;\r\n    background: var(--custom-primary);\r\n    padding: 6px 10px;\n}\n#addnotepurple > span[data-v-8ee637c6] {\r\n    background: rgb(141 127 250);\r\n    padding: 0 4px;\r\n    border-radius: 4px;\n}\ntextarea[data-v-8ee637c6] {\r\n    resize: none;\n}\r\n  ", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=style&index=0&id=c973a14a&scoped=true&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Brief/RecentActivity/RecentActivityList.vue?vue&type=style&index=0&id=c973a14a&scoped=true&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.bxs-pin[data-v-c973a14a],\r\n  .pinToTop[data-v-c973a14a] {\r\n    color: #c83901;\n}\n.bxs-pin[data-v-c973a14a] {\r\n    transform: rotate(45deg);\n}\n.threedots[data-v-c973a14a] {\r\n    float: right;\r\n    border-radius: 6px;\r\n    padding: 0 10px;\r\n    border: 1px solid transparent;\r\n    color: #414552;\n}\n.highlight-border[data-v-c973a14a] {\r\n    border: 1px solid #d5dbe1; /* You can change the color and style as needed */\n}\n.timeline-details[data-v-c973a14a] {\r\n    position: relative;\n}\n.threedotsclickopen[data-v-c973a14a] {\r\n    position: absolute;\r\n    top: 28px;\r\n    right: -1%;\r\n    width: 14%;\r\n    background: #fff;\r\n    padding: 10px 0px;\r\n    box-shadow: 0 0 0 1px #8898aa1a, 0 15px 35px #31315d1a, 0 5px 15px #00000014;\r\n    border-radius: 6px;\r\n    border: 1px solid #d5dbe1;\r\n    display: none;\r\n    z-index: 1;\n}\n.color-red[data-v-c973a14a] {\r\n    color: #ff0000 !important;\n}\n.threedotsclickopen p > a[data-v-c973a14a] {\r\n    color: #7b5afa;\r\n    font-weight: 600;\n}\n.threedotsclickopen p[data-v-c973a14a] {\r\n    padding: 6px 15px;\n}\n.threedotsclickopen p[data-v-c973a14a]:hover {\r\n    background-color: #f5f5f5;\n}\n.threedotsclickopen p:hover a[data-v-c973a14a] {\r\n    color: #000;\n}\n.bx-check-circle[data-v-c973a14a]:before {\r\n    color: green;\n}\r\n  ", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=style&index=0&id=13cb636a&scoped=true&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=style&index=0&id=13cb636a&scoped=true&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\n.eventlogtabul[data-v-13cb636a] {\r\n  position: relative;\r\n  display: grid;\r\n  margin: 0 28px 0 0;\r\n  gap: 15px 0;\r\n  list-style: none;\r\n  padding: 0;\r\n  border: 0;\n}\n.eventlogtabul[data-v-13cb636a]::before{\r\n  content: '';\r\n  position: absolute;\r\n  top: 10px;\r\n  left: 0;\r\n  height: calc(100% - 57px);\r\n  width: 1px;\r\n  background: #a3acb9;\r\n  transform: translate(-50%, 0);\n}\n.eventlogtabul > li[data-v-13cb636a],\r\n.eventlogtabul > p[data-v-13cb636a] {\r\n  padding-left: 20px;\r\n  position: relative;\r\n  margin: 0;\n}\n.eventlogtabul > li[data-v-13cb636a]::before {\r\n  content: '';\r\n  position: absolute;\r\n  top: 9px;\r\n  left: 0;\r\n  height: 6px;\r\n  width: 6px;\r\n  background: #a3acb9;\r\n  border-radius: 15px;\r\n  transform: translate(-50%, 0);\r\n  box-shadow: 0 0 0px 6px #fff;\n}\n.eventlogtabul > p > i[data-v-13cb636a] {\r\n  position: absolute;\r\n  top: 4px;\r\n  left: 0;\r\n  background: #fff;\r\n  border-radius: 15px;\r\n  transform: translate(-50%, 0);\r\n  box-shadow: 0 0 0px 6px #fff;\n}\n.eventlogtabul > li > .nav-link[data-v-13cb636a]{\r\n    padding: 12px !important;\r\n    background: transparent;\r\n    border: 1px solid #e1e1e1;\r\n    font-size: 12px;\r\n    font-weight: 400;\r\n    border-radius: 4px;\n}\n.eventlogtabul > li > .nav-link > span[data-v-13cb636a]{\r\n    color: #b1b1b1;\n}\n.eventlogtabul > li > .nav-link.active[data-v-13cb636a]{\r\n    border-color: #625afa;\r\n    background: transparent;\n}\n.eventlogtabul > li > .nav-link .tabtags[data-v-13cb636a]{\r\n    color: #267d28;\r\n    background: #d7f7c2;\r\n    border-radius: 4px;\r\n    padding: 2px 8px;\r\n    font-size: 12px;\r\n    font-weight: 600;\n}\n.codesnippet[data-v-13cb636a]{\r\n    height: 350px;\r\n    overflow: hidden;\r\n    color: #625afa;\r\n    font-weight: 700;\r\n    font-size: 13px;\r\n    margin-bottom: 10px;\r\nposition: relative;\n}\n.codesnippet strong[data-v-13cb636a]{\r\n    color: #000;\r\n    font-size: 1.1rem;\n}\n.showMoreBtn[data-v-13cb636a] {\r\n    background: white;\r\n    color: #5a5a5a;\r\n    border: 1px solid #e1e1e1;\r\n    padding: 5px 10px;\r\n    border-radius: 5px;\r\n    position: absolute;\r\n    bottom: 0;\r\n    left: 0;\r\n    font-weight: 900;\n}\n.expanded[data-v-13cb636a]{\r\n    height: 100%;\n}\n.payment-detail-table[data-v-13cb636a]{\r\n    color: #76797b;\n}\npre[data-v-13cb636a] {\r\n    font-size: 13px;\r\n    line-height: .9;\r\n    overflow-x: auto;\r\n    padding: 1.25rem;\n}\npre[class*=language-][data-v-13cb636a]{\r\n    background: #fff !important;\n}\n.code-container[data-v-13cb636a] {\r\n    position: relative;\n}\n.line[data-v-13cb636a] {\r\n    display: flex;\n}\n.line-number[data-v-13cb636a] {\r\n    display: inline-block;\r\n    width: 2em;\r\n    margin-right: 1em;\r\n    text-align: right;\r\n    color: #999;\n}\n.hljs-number[data-v-13cb636a]{\r\n    margin-right: 25px;\n}\n.hljs[data-v-13cb636a] {\r\n    display: block;\r\n    overflow: auto hidden;\r\n    padding: 0 0 15px;\r\n    color: #333;\n}\n.jsonformat > p[data-v-13cb636a]{\r\n    font-size: 12px;\r\n    color: #8992a1;\r\n    font-weight: 400;\n}\n.jsonformat > h4[data-v-13cb636a]{\r\n    color: #000;\r\n    font-size: 16px;\r\n    font-weight: 500;\n}\n.jsonformat > h4 > span[data-v-13cb636a]{\r\n    color: #267d28;\r\n    background: #d7f7c2;\r\n    border-radius: 4px;\r\n    padding: 2px 8px;\r\n    font-size: 12px;\n}\n.jsonformat > a[data-v-13cb636a]{\r\n    color: #625afa;\r\n    font-size: 14px;\r\n    font-weight: 500;\n}\n.jsonformat > h5[data-v-13cb636a]{\r\n    margin-top: 25px;\r\n    color: #404754;\r\n    font-size: 14px;\r\n    font-weight: 500;\n}\n.jsoncodemaindiv[data-v-13cb636a]{\r\n    border: 1px solid #e9ebec;\r\n    padding: 20px 30px;\r\n    max-height: 800px;\r\n    overflow: auto;\n}\n.hljs-attr[data-v-13cb636a]{\r\n    color: #625afa;\n}\n.hljs-string[data-v-13cb636a]{\r\n    color: #267d28;\n}\n.hljs-number[data-v-13cb636a]{\r\n    color: #a3acba;\n}\n.showhidebtnnew[data-v-13cb636a]{\r\n    font-weight: 500;\r\n    font-size: 13px;\r\n    border-radius: 6px;\r\n    padding: 3px 8px;\r\n    border: 1px solid #c7c7c7;\r\n    background: #fff;\r\n    color: #4a4a4a;\r\n    position: sticky;\r\n    bottom: 0;\r\n    left: 50%;\r\n    box-shadow: 1px 1px 66px 60px #fff;\r\n    transform: translate(-50%, 0%);\n}\n.highlight-border[data-v-13cb636a]{\r\n    border: 1px solid #d5dbe1; /* You can change the color and style as needed */\n}\n.jsoncodeContainer[data-v-13cb636a]:not(.showAll) {\r\n  max-height: 551px;\r\n  overflow: hidden;\n}\n.jsoncodeContainer:not(.showAll) .showhidebtnnew span[data-v-13cb636a]:not(.showText),\r\n.jsoncodeContainer.showAll .showhidebtnnew .showText[data-v-13cb636a] {\r\n  display: none;\n}\n.jsoncodediv[data-v-13cb636a]{\r\n    overflow: hidden !important;\r\n    transition: max-height 0.3s ease;\r\n    position: relative;\r\n    margin-bottom: 0px;\n}\n.expanded[data-v-13cb636a] {\r\n    max-height: none; /* Set max-height to none for expanding to 100% */\n}\n.hljs-punctuation[data-v-13cb636a], .hljs-tag[data-v-13cb636a] {\r\n    color: #444a;\n}\n.eventlogtabul > li > .nav-link .tabtags.error[data-v-13cb636a] {\r\n    color: #b3093c;\r\n    background: #ffe7f2;\n}\n.jsonformat > h4 > span.error[data-v-13cb636a]{\r\n    color: #b3093c;\r\n    background: #ffe7f2;\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=style&index=1&id=13cb636a&lang=css":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/EventsLog/EventsLog.vue?vue&type=style&index=1&id=13cb636a&lang=css ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n  .hljs-string {\r\n    color: #625afa;\r\n  }\r\n\r\n  .hljs-string ~ .hljs-string {\r\n    color: #228403;\r\n  }\r\n\r\n  :not(.line-number) > .hljs-number {\r\n    color: #fc526a;\r\n  }\r\n\r\n  .jsoncodediv .line:is(:first-child, :last-child) > .line-number {\r\n    margin-right: 7px;\r\n  }\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=style&index=0&id=88b7d1a2&lang=css":
/*!*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popup.vue?vue&type=style&index=0&id=88b7d1a2&lang=css ***!
  \*************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n.popup-bg {\r\n    z-index: 10000;\r\n    position: fixed;\r\n    top: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n    right: 0;\r\n    background-color: #c1c9d2b3;\r\n}\r\n\r\n.popup-bg:not(.showThis),\r\n.popup-area:not(.showThis) {\r\n    opacity: 0;\r\n    visibility: hidden;\r\n}\r\n\r\n.popup-bg,\r\n.popup-area {\r\n    transition: all 0.3s;\r\n}\r\n.popup-area {\r\n    position: fixed;\r\n    left: 50%;\r\n    top: 50%;\r\n    width: 100%;\r\n    /* max-width: 450px; */\r\n    border-radius: 8px;\r\n    background: #fff;\r\n    transform: translate(-50%, -50%);\r\n    z-index: 10001;\r\n    display: flex;\r\n    flex-direction: column;\r\n    max-height: calc(100vh - 60px);\r\n}\r\n\r\n.popup-head {\r\n    padding: 1rem;\r\n    box-shadow: inset 0 -1px #ebeef1;\r\n    flex: 1 0 auto;\r\n}\r\n\r\n.popup-body {\r\n    background-color: #f6f8fa;\r\n    padding: 20px 20px;\r\n    flex: 1 1 auto;\r\n    overflow: auto;\r\n}\r\n\r\n.popup-details-area > h3 {\r\n    font-size: 15px;\r\n    font-weight: 500;\r\n    color: #1a1b25;\r\n    margin-bottom: 30px;\r\n}\r\n\r\n.popup-details-area a {\r\n    font-weight: 600;\r\n    color: var(--custom-primary) !important;\r\n}\r\n\r\n.popup-details-area > h3 > i {\r\n    font-size: 18px;\r\n    line-height: 0;\r\n    transform: translate(0, 3px);\r\n}\r\n\r\n.popup-details-area > h3.hide > i {\r\n    transform: rotate(180deg) translate(0, -3px);\r\n}\r\n\r\n.popup-details-area + .popup-details-area {\r\n    margin-top: 40px;\r\n}\r\n\r\n.popupToggleArea:not(.show) {\r\n    display: none;\r\n}\r\n\r\n.popupToggleArea {\r\n    padding: 7px 0;\r\n}\r\n\r\n.popup-details-input {\r\n    font-size: 13px;\r\n}\r\n\r\n.popup-details-input + .popup-details-input {\r\n    margin-top: 30px;\r\n}\r\n\r\n.popup-details-input label:not(.checkbox-label) {\r\n    display: block;\r\n    font-weight: 500;\r\n    color: #414552;\r\n    margin-bottom: 10px;\r\n}\r\n\r\n.popup-details-input label.checkbox-label {\r\n    display: flex;\r\n    align-items: center;\r\n    margin: 0;\r\n    padding: 5px 0;\r\n    gap: 10px;\r\n}\r\n.popup-details-input input:not(:is([type=\"checkbox\"], [type=\"radio\"])) {\r\n    border: 1px solid #ccc;\r\n}\r\n\r\n.popup-details-input\r\n    input:not(:is([type=\"checkbox\"], [type=\"radio\"])):focus-visible,\r\n.popup-details-input select:focus-visible,\r\n.popup-details-input textarea:focus-visible {\r\n    outline-color: var(--custom-primary);\r\n}\r\n\r\n.popup-details-input input:not(:is([type=\"checkbox\"], [type=\"radio\"])),\r\n.popup-details-input select,\r\n.popup-details-input textarea {\r\n    width: 100%;\r\n    padding: 3px 10px;\r\n    min-height: 28px;\r\n    border-radius: 6px;\r\n}\r\n\r\n.popup-details-input\r\n    :is(input, select, textarea)\r\n    + :is(input, select, textarea) {\r\n    margin-top: 15px;\r\n}\r\n\r\n.popup-details-input :is(select, textarea) {\r\n    color: #404452;\r\n    background: #fff;\r\n    border: 0;\r\n    outline: 0;\r\n    box-shadow: rgba(0, 0, 0, 0) 0px 0px 0px 0px,\r\n        rgba(0, 0, 0, 0) 0px 0px 0px 0px, rgba(0, 0, 0, 0.12) 0px 1px 1px 0px,\r\n        rgba(64, 68, 82, 0.16) 0px 0px 0px 1px, rgba(0, 0, 0, 0) 0px 0px 0px 0px,\r\n        rgba(0, 0, 0, 0) 0px 0px 0px 0px, rgba(64, 68, 82, 0.08) 0px 2px 5px 0px;\r\n}\r\n\r\n.popup-head > h2 {\r\n    font-size: 1rem;\r\n    margin: 0;\r\n    font-weight: 700;\r\n    color: #1a1b25;\r\n}\r\n\r\n.flex-inputArea {\r\n    display: flex;\r\n    gap: 12px;\r\n    align-items: center;\r\n}\r\n\r\n.flex-inputArea + .flex-inputArea {\r\n    margin-top: 15px;\r\n}\r\n\r\n.flex-inputArea > .popup-details-input {\r\n    margin: 0;\r\n    flex: 1;\r\n}\r\n\r\n.flex-inputArea > .popup-details-input.flex180 {\r\n    flex: 0 0 180px;\r\n}\r\n\r\n.flex-inputArea > .deleteArea {\r\n    color: var(--custom-primary);\r\n    cursor: pointer;\r\n}\r\n\r\n.popup-footer {\r\n    box-shadow: inset 0 1px #ebeef1;\r\n    padding: 15px 20px;\r\n    font-size: 14px;\r\n    display: flex;\r\n    gap: 7px;\r\n    justify-content: flex-end;\r\n    flex: 1 0 auto;\r\n}\r\n\r\n.popup-footer > button,\r\nlabel.popup-file-upload-label > button {\r\n    background: #fff;\r\n    font-size: 13px;\r\n    line-height: 20px;\r\n    min-height: 28px;\r\n    border-radius: 6px;\r\n    box-shadow: 0px 1px 1px 0px rgba(16, 17, 26, 0.16), #d5dbe1 0 0 0 1px,\r\n        0 0 0 0 transparent, 0 0 0 0 transparent;\r\n    padding: 3px 10px;\r\n    font-weight: 500;\r\n    border: 0;\r\n    outline: 0;\r\n}\r\n\r\nlabel.popup-file-upload-label {\r\n    display: flex;\r\n    gap: 10px;\r\n    align-items: center;\r\n    font-weight: 600;\r\n    cursor: pointer;\r\n}\r\n\r\nlabel.popup-file-upload-label > button {\r\n    display: inline-flex;\r\n    align-items: center;\r\n    margin: 0;\r\n    gap: 7px;\r\n    font-weight: 600;\r\n}\r\n\r\nlabel.popup-file-upload-label > button > i {\r\n    font-size: 18px;\r\n    line-height: 0;\r\n}\r\n\r\n.popup-file-upload {\r\n    cursor: pointer;\r\n}\r\n\r\n.popup-file-upload > input {\r\n    display: none;\r\n}\r\n\r\n.popup-footer > button.purpleLinkStyle {\r\n    background: #625afa;\r\n    color: #fff;\r\n}\r\n\r\n.btn-to-start {\r\n    flex: 1;\r\n}\r\n\r\n.btn-to-start > button {\r\n    border: 0;\r\n    background: transparent;\r\n    outline: 0;\r\n    color: var(--custom-primary);\r\n    font-weight: 500;\r\n}\r\n", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=style&index=0&id=77a755ad&lang=css":
/*!***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectDetailLogoPopup.vue?vue&type=style&index=0&id=77a755ad&lang=css ***!
  \***********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);
// Imports

var ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()(function(i){return i[1]});
// Module
___CSS_LOADER_EXPORT___.push([module.id, "\r\n  .vue-tel-input {\r\n      border-radius: 6px !important;\r\n  }\r\n  \r\n  .vue-tel-input input {\r\n      outline: none !important;\r\n      border: none !important;\r\n  }\r\n\r\n  .asterisk{\r\n    color: red;\r\n  }\r\n\r\n  .checkbox_row {\r\n    display: flex;\r\n    align-items: baseline;\r\n    margin: 0.25rem 0;\r\n    gap: 6px;\r\n}\r\n  ", ""]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-loader/dist/cjs.js??clonedRuleSet-9.use[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Admin/Brief/Shared/Components/Popups/BriefEdit/ProjectReqLogoPopup.vue?vue&type=style&index=0&id=27e6ef56&lang=css":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js??clonedRuleSet-9.use[1]!./node_modules/vue-loader/dist/stylePostLoader.js!./node_modules/postcss-l