const stripe = Stripe(document.currentScript.dataset.publickey);
const createPaymentMethod = document.currentScript.dataset.createpaymentmethod;
const checkoutRoute = document.currentScript.dataset.checkoutroute;
const paymentintent = document.currentScript.dataset.paymentintent;

if (stripe !== undefined || !stripe) {
    let paymentData = new Array();
    let loaderBgClass = ".loader-bg";

    function checkInputFilled() {
        const inputs = Array.from(
            document.querySelectorAll(".detailsInput input")
        );
        const selectElements = Array.from(
            document.querySelectorAll(".detailsInput select")
        );

        inputs.splice(6, 0, ...selectElements);

        let firstEmptyInput = null;
        let firstValInput = null;

        for (let i = 0; i < inputs.length; i++) {
            const input = inputs[i];

            let id = input.getAttribute("id");
            var x = document.querySelector(`#${id}`).closest(".detailsInput");
            let xChild = x.querySelector("#form-error-box");
            xChild.innerHTML = "";
            xChild.style.display = "";

            if (!input.value) {
                if (!firstEmptyInput) {
                    firstEmptyInput = input;
                }
            } else {
                if (!firstValInput) {
                    if (inputErrorHandler(input)) {
                        firstValInput = input;
                    }
                }
            }
        }

        if (firstValInput) {
            firstValInput.focus();
            return false;
        }

        if (firstEmptyInput) {
            let id = firstEmptyInput.getAttribute("id");
            var x = document.querySelector(`#${id}`).closest(".detailsInput");
            let xChild = x.querySelector("#form-error-box");
            xChild.innerHTML = "<p>This field is required</p>";
            xChild.style.display = "block";
            firstEmptyInput.focus();
            return false;
        }

        return true;
    }

    function checkInputFilledValidation() {
        const inputs = Array.from(
            document.querySelectorAll(".detailsInput input")
        );

        let firstEmptyInputVal = null;

        for (let i = 0; i < inputs.length; i++) {
            const input = inputs[i];

            if (!firstEmptyInputVal) {
                if (inputErrorHandler(input)) {
                    firstEmptyInputVal = input;
                }
            }
        }

        if (firstEmptyInputVal) {
            return false;
        }

        return true;
    }

    $(document).on("submit", "#payment-form", function (e) {
        e.preventDefault();

        const fieldsCheck = checkInputFilled();

        if (!fieldsCheck) {
            return false;
        }

        const cardInputArea = document.getElementById("cardInputArea");
        const creditCardNumberInput = document.getElementById("cardnumber");
        const firstNameInput = document.getElementById("firstname");
        const lastNameInput = document.getElementById("lastname");
        const stateNameInput = document.getElementById("statename");
        const cityInput = document.getElementById("city");
        const phoneInput = document.getElementById("phone");

        if (!validateCardNumber(creditCardNumberInput.value)) {
            cardInputArea.style.borderColor = "#FF0000";
            creditCardNumberInput.style.color = "#FF0000";
        } else {
            creditCardNumberInput.style.color = "";
            cardInputArea.style.borderColor = "";
        }

        $(document).find(loaderBgClass).addClass("show-bg");

        const paymentData = $(this).serializeArray();
        const paymentDataSanitize = paymentData.map(function (element, index) {
            if (element.name == "clientemail") {
                element.value = sanitizeInput(element.value, "email");
            } else {
                element.value = sanitizeInput(element.value);
            }

            return element;
        });

        // Sanitize values
        formatAlphanumericInput(firstNameInput);
        formatAlphanumericInput(lastNameInput);
        formatAlphanumericInput(stateNameInput);
        formatAlphanumericInput(cityInput);
        removePlusSign(phoneInput);

        axios({
            url: createPaymentMethod,
            method: "POST",
            headers: {
                Accept: "application/json",
                "Content-Type": "application/json;charset=UTF-8",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            data: paymentDataSanitize,
        })
            .then(function (response) {
                $(document).find(loaderBgClass).removeClass("show-bg");
                $(document).find(".card-errors").html("");
                $(document).find(".alert-div").html("");
                $(document).find(".alert-div").css("display", "none");
                $(document).find(".validation-error").html("");
                $(document).find("#payment_id").val(response.data?.payment_id);
                console.log(response.data);
                if (response.data?.validation_errors) {
                    let errors = "<ul>";
                    let validations = response.data.validation_errors;

                    for (const [key, value] of Object.entries(validations)) {
                        if ([
                                "cvc",
                                "cardNo",
                                "year",
                                "month",
                                "cardValidity",
                            ].includes(key)
                        ) {
                            if (["year", "month"].includes(key)) {
                                document.getElementsByClassName("exp-date")[0].style.color = "#FF0000";
                            } else if (key == "cardValidity") {
                                document.getElementsByClassName("cardNo")[0].style.color = "#FF0000";
                            } else {
                                document.getElementsByClassName(key)[0].style.color = "#FF0000";
                            }
                            cardInputArea.style.borderColor = "#FF0000";

                            $(".card-errors").html("<ul><li>" + value + "</li></ul>");
                        } else {
                            let errorMessage = $("#" + key).closest(".detailsInput");
                            if (errorMessage.find(".alert-div").length > 0) {
                                errorMessage.find(".alert-div").html(value[0]);
                                errorMessage.find(".alert-div").css("display", "block");
                            } else {
                                errorMessage.parent().find(".alert-div").html(value[0]);
                                errorMessage.parent().find(".alert-div").css("display", "block");
                            }
                        }
                        return false;
                    }

                    $(document).find(".card-errors").css("display", "block");
                }

                $(document).find("#card-button").attr("disabled", false);
                $(document).find("#card-button").html("Pay Now");

                if (response.data.errors) {
                    $(document).find(".card-errors").html("");
                    $(document).find(".card-errors").html("<ul>" + response.data.errors + "</ul>");
                    $(document).find(loaderBgClass).removeClass("show-bg");
                } else if (response.data.message || response.data.code) {
                    //  error messages
                    $(document).find("#payment_error").val(response.data.code);
                    $(document).find("#payment_message").val(response.data.message);
                    $(document).find("#payment_response").val(JSON.stringify(response.data));

                    //  Call Payment Store
                    var paymentDBData = $(document).find("#payment-form").serializeArray();
                    storePaymentApi(paymentDBData, checkoutRoute);
                } else {
                    handleServerResponse(response);
                }
            })
            .catch(function (error) {
                if (error.response?.data?.errors) {
                    console.log(error.response?.data?.errors);
                    let errors = "<ul>";
                    let validations = error.response.data.errors;

                    for (const [key, value] of Object.entries(validations)) {
                        if ([
                                "cvc",
                                "cardNo",
                                "year",
                                "month",
                                "cardValidity",
                            ].includes(key)
                        ) {
                            if (["year", "month"].includes(key)) {
                                document.getElementsByClassName("exp-date")[0].style.color = "#FF0000";
                            } else if (key == "cardValidity") {
                                document.getElementsByClassName("cardNo")[0].style.color = "#FF0000";
                            } else {
                                document.getElementsByClassName(key)[0].style.color = "#FF0000";
                            }
                            cardInputArea.style.borderColor = "#FF0000";

                            $(".card-errors").html("<ul><li>" + value + "</li></ul>");
                        } else {
                            let errorMessage = $("#" + key).closest(".detailsInput");
                            if (errorMessage.find(".alert-div").length > 0) {
                                errorMessage.find(".alert-div").html(value[0]);
                                errorMessage.find(".alert-div").css("display", "block");
                            } else {
                                errorMessage.parent().find(".alert-div").html(value[0]);
                                errorMessage.parent().find(".alert-div").css("display", "block");
                            }
                        }

                        $(document).find(loaderBgClass).removeClass("show-bg");
                        
                        return false;
                    }

                    $(document).find(".card-errors").css("display", "block");
                    $(document).find("#card-button").attr("disabled", false);
                    $(document).find("#card-button").html("Pay Now");
    
                    $(document).find(".card-errors").html("");
                    $(document).find(".card-errors").html("<ul>" + error.response.data.errors + "</ul>");
                    $(document).find(loaderBgClass).removeClass("show-bg");
                    console.log($(document).find(loaderBgClass));
                }


                $(document).find("#payment_error").val(error.code);
                $(document).find("#payment_message").val(error.message);
                // Call Payment Store
                var paymentDBData = $(document).find("#payment-form").serializeArray();
                //storePaymentApi(paymentDBData, checkoutRoute);
                console.log(error);
            });

        function handleServerResponse(response) {
            if (response.data.success) {
                //  Call Payment Store
                var paymentDBData = $(document).find("#payment-form").serializeArray();
                storePaymentApi(paymentDBData, checkoutRoute);
            } else if (response.data.message) {
                console.log("error2");

                //error messages
                $(document).find("#payment_error").val(response.data.code);
                $(document).find("#payment_message").val(response.data.message);
                $(document).find("#payment_response").val(JSON.stringify(response.data));

                var paymentDBData = $(document).find("#payment-form").serializeArray();
                storePaymentApi(paymentDBData, checkoutRoute);
            } else if (response.data.requires_action) {
                // Use Stripe.js to handle required card action
                var action = response.data.next_action;
                if (action && action.type === "redirect_to_url") {
                    window.location = action.redirect_to_url.url;
                }
                stripe.confirmCardPayment(response.data.payment_intent_client_secret, {
                    payment_method: response.data.payment_method_id
                })
                    .then(function (result) {
                        $(document).find(loaderBgClass).addClass("show-bg");
                        $(document).find("#3DSecure_Popup").val(1);
                        if (result.error) {
                            console.log("error3");
                            
                            $(document).find("#payment_error").val(result.error.code);
                            $(document).find("#payment_decline_code").val(result.error.decline_code);
                            $(document).find("#payment_message").val(result.error.message);

                            // Call Payment Store
                            var paymentDBData = $(document).find("#payment-form").serializeArray();
                            storePaymentApi(paymentDBData, checkoutRoute);
                        } else {
                            paymentData.push({name: "payment_intent_id", value: result.paymentIntent.id});

                            // The card action has been handled
                            // The PaymentIntent can be confirmed again on the server
                            axios({
                                url: paymentintent,
                                method: "POST",
                                headers: {
                                    Accept: "application/json",
                                    "Content-Type": "application/json;charset=UTF-8",
                                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                                },
                                data: paymentData,
                            }).then(handleServerResponse);
                        }
                    });
            } else {
                $(document).find("#payment_error").val("");
                $(document).find("#payment_message").val("");
            }
        }
    });
} else {
    console.log("Need stripe public key for payment.");
}
