<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class StaffPermissions extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //Team Permissions
        $teamCreate = Permission::create(['name' => 'Team-Create','guard_name' => 'web']);
        $teamEdit = Permission::create(['name' => 'Team-Edit','guard_name' => 'web']);
        $teamView = Permission::create(['name' => 'Team-View','guard_name' => 'web']);
        $teamDelete = Permission::create(['name' => 'Team-Delete','guard_name' => 'web']);

        //Invoice Permissions
        $invoiceCreate = Permission::create(['name' => 'Invoice-Create','guard_name' => 'web']);
        $invoiceEdit = Permission::create(['name' => 'Invoice-Edit','guard_name' => 'web']);
        $invoiceView = Permission::create(['name' => 'Invoice-View','guard_name' => 'web']);
        $invoiceDelete = Permission::create(['name' => 'Invoice-Delete','guard_name' => 'web']);

        //Invoice Permissions
        $gatewayCreate = Permission::create(['name' => 'Gateway-Create','guard_name' => 'web']);
        $gatewayEdit = Permission::create(['name' => 'Gateway-Edit','guard_name' => 'web']);
        $gatewayView = Permission::create(['name' => 'Gateway-View','guard_name' => 'web']);
        $gatewayDelete = Permission::create(['name' => 'Gateway-Delete','guard_name' => 'web']);

        //Team Permissions
        $settingsCreate = Permission::create(['name' => 'Settings-Create','guard_name' => 'web']);
        $settingsEdit = Permission::create(['name' => 'Settings-Edit','guard_name' => 'web']);
        $settingsView = Permission::create(['name' => 'Settings-View','guard_name' => 'web']);
        $settingsDelete = Permission::create(['name' => 'Settings-Delete','guard_name' => 'web']);

        // BriefForm permissions
        $briefFormGlobal = Permission::create(['name' => 'BriefForm-Global','guard_name' => 'web']);

        //BriefLink Permissions
        $briefLinkGlobal = Permission::create(['name' => 'BriefLink-Global','guard_name' => 'web']);
        $briefLinkCreate = Permission::create(['name' => 'BriefLink-Create','guard_name' => 'web']);
        $briefLinkEdit = Permission::create(['name' => 'BriefLink-Edit','guard_name' => 'web']);
        $briefLinkView = Permission::create(['name' => 'BriefLink-View','guard_name' => 'web']);
        $briefLinkDelete = Permission::create(['name' => 'BriefLink-Delete','guard_name' => 'web']);

        // BriefLink permissions
        $briefLinkGlobal = Permission::findByName('BriefLink-Global');
        $briefLinkCreate = Permission::findByName('BriefLink-Create');
        $briefLinkEdit = Permission::findByName('BriefLink-Edit');
        $briefLinkView = Permission::findByName('BriefLink-View');
        $briefLinkDelete = Permission::findByName('BriefLink-Delete');

        // Team permissions
        $teamCreate = Permission::findByName('Team-Create');
        $teamEdit = Permission::findByName('Team-Edit');
        $teamView = Permission::findByName('Team-View');
        $teamDelete = Permission::findByName('Team-Delete');

        // Invoice permissions
        $invoiceCreate = Permission::findByName('Invoice-Create');
        $invoiceEdit = Permission::findByName('Invoice-Edit');
        $invoiceView = Permission::findByName('Invoice-View');
        $invoiceDelete = Permission::findByName('Invoice-Delete');
        
        // Gateway permissions
        $gatewayCreate = Permission::findByName('Gateway-Create');
        $gatewayEdit = Permission::findByName('Gateway-Edit');
        $gatewayView = Permission::findByName('Gateway-View');
        $gatewayDelete = Permission::findByName('Gateway-Delete');
        
        // Settings permissions
        $settingsCreate = Permission::findByName('Settings-Create');
        $settingsEdit = Permission::findByName('Settings-Edit');
        $settingsView = Permission::findByName('Settings-View');
        $settingsDelete = Permission::findByName('Settings-Delete');

        // User permissions
        $userCreate = Permission::findByName('User-Create');
        $userEdit = Permission::findByName('User-Edit');
        $userView = Permission::findByName('User-View');
        $userDelete = Permission::findByName('User-Delete');

        // Customer permissions
        $customerCreate = Permission::findByName('Customer-Create');
        $customerEdit = Permission::findByName('Customer-Edit');
        $customerView = Permission::findByName('Customer-View');
        $customerDelete = Permission::findByName('Customer-Delete');

        // Coupon permissions
        $couponCreate = Permission::findByName('Coupon-Create');
        $couponEdit = Permission::findByName('Coupon-Edit');
        $couponView = Permission::findByName('Coupon-View');
        $couponDelete = Permission::findByName('Coupon-Delete');

        // Product permissions
        $productCreate = Permission::findByName('Product-Create');
        $productEdit = Permission::findByName('Product-Edit');
        $productView = Permission::findByName('Product-View');
        $productDelete = Permission::findByName('Product-Delete');

        // Payment permissions
        $paymentCreate = Permission::findByName('Payment-Create');
        $paymentEdit = Permission::findByName('Payment-Edit');
        $paymentView = Permission::findByName('Payment-View');
        $paymentDelete = Permission::findByName('Payment-Delete');

        // PaymentLinkGenerator permissions
        $PaymentLinkGeneratorCreate = Permission::findByName('PaymentLinkGenerator-Create');
        $PaymentLinkGeneratorEdit = Permission::findByName('PaymentLinkGenerator-Edit');
        $PaymentLinkGeneratorView = Permission::findByName('PaymentLinkGenerator-View');
        $PaymentLinkGeneratorDelete = Permission::findByName('PaymentLinkGenerator-Delete');

        $briefFormGlobal = Permission::findByName('BriefForm-Global');

        // Import & Export Settings
        $importExportCreate = Permission::create(['name' => 'ImportExport-Create','guard_name' => 'web']);

        // Notes Settings
        $notesCreate = Permission::create(['name' => 'Notes-Create','guard_name' => 'web']);
        $notesEdit = Permission::create(['name' => 'Notes-Edit','guard_name' => 'web']);
        $notesView = Permission::create(['name' => 'Notes-View','guard_name' => 'web']);
        $notesDelete = Permission::create(['name' => 'Notes-Delete','guard_name' => 'web']);

        // Refund Settings
        $refundCreate = Permission::create(['name' => 'Refund-Create','guard_name' => 'web']);
        $refundView = Permission::create(['name' => 'Refund-View','guard_name' => 'web']);
        
        // BlockList Settings
        $BlockListCreate = Permission::create(['name' => 'BlockList-Create','guard_name' => 'web']);
        $BlockListEdit = Permission::create(['name' => 'BlockList-Edit','guard_name' => 'web']);
        $BlockListView = Permission::create(['name' => 'BlockList-View','guard_name' => 'web']);
        $BlockListDelete = Permission::create(['name' => 'BlockList-Delete','guard_name' => 'web']);

        // Two-Step Settings
        $TwoStepCreate = Permission::create(['name' => 'TwoStep-Create','guard_name' => 'web']);
        $TwoStepEdit = Permission::create(['name' => 'TwoStep-Edit','guard_name' => 'web']);
        
        $userGlobal = Permission::create(['name' => 'User-Global','guard_name' => 'web']);
        $customerGlobal = Permission::create(['name' => 'Customer-Global','guard_name' => 'web']);
        $couponGlobal = Permission::create(['name' => 'Coupon-Global','guard_name' => 'web']);
        $paymentGlobal = Permission::create(['name' => 'Payment-Global','guard_name' => 'web']);
        $PaymentLinkGeneratorGlobal = Permission::create(['name' => 'PaymentLinkGenerator-Global','guard_name' => 'web']);
        $invoiceGlobal = Permission::create(['name' => 'Invoice-Global','guard_name' => 'web']);
        $settingsGlobal = Permission::create(['name' => 'Settings-Global','guard_name' => 'web']);
        $notificationGlobal = Permission::create(['name' => 'Notification-Global','guard_name' => 'web']);
    

        // Roles to assign permissions
        $admin = Role::findByName('Admin');
        $superAdmin = Role::findByName('Super Admin');
        $brandManager = Role::findByName('Brand Manager');
        $salesperson = Role::findByName('Salesperson');
        $qualityAssurance = Role::findByName('Quality Assurance');
       
        // Add Permissions to role `super admin`
        $superAdmin->givePermissionTo([$couponGlobal, $couponCreate, $couponView, $couponEdit, $couponDelete]);
        $superAdmin->givePermissionTo([$customerGlobal, $customerCreate, $customerView, $customerEdit, $customerDelete]);
        $superAdmin->givePermissionTo([$paymentGlobal, $paymentCreate, $paymentView, $paymentEdit, $paymentDelete]);
        $superAdmin->givePermissionTo([$PaymentLinkGeneratorGlobal, $PaymentLinkGeneratorCreate, $PaymentLinkGeneratorView, $PaymentLinkGeneratorEdit, $PaymentLinkGeneratorDelete]);
        $superAdmin->givePermissionTo([$productCreate, $productView, $productEdit, $productDelete]);
        $superAdmin->givePermissionTo([$userGlobal, $userCreate, $userView, $userEdit, $userDelete]);
        $superAdmin->givePermissionTo([$teamCreate, $teamView, $teamEdit, $teamDelete]);
        $superAdmin->givePermissionTo([$invoiceGlobal, $invoiceCreate, $invoiceView, $invoiceEdit, $invoiceDelete]);
        $superAdmin->givePermissionTo([$settingsGlobal, $settingsCreate, $settingsView, $settingsEdit, $settingsDelete]);
        $superAdmin->givePermissionTo([$gatewayCreate, $gatewayView, $gatewayEdit, $gatewayDelete]);
        $superAdmin->givePermissionTo([$importExportCreate]);
        $superAdmin->givePermissionTo([$notesCreate, $notesView, $notesEdit, $notesDelete]);
        $superAdmin->givePermissionTo([$refundCreate, $refundView]);
        $superAdmin->givePermissionTo([$BlockListView, $BlockListEdit]);
        $superAdmin->givePermissionTo([$TwoStepCreate, $TwoStepEdit]);
        $superAdmin->givePermissionTo([$notificationGlobal]);
        $superAdmin->givePermissionTo([$briefFormGlobal]);
        $superAdmin->givePermissionTo([$briefLinkGlobal, $briefLinkCreate, $briefLinkView, $briefLinkEdit, $briefLinkDelete]);
        $superAdmin->save();

        // Add Permissions to role `admin`
        $admin->givePermissionTo([$couponGlobal, $couponCreate, $couponView, $couponEdit, $couponDelete]);
        $admin->givePermissionTo([$customerGlobal, $customerCreate, $customerView, $customerEdit, $customerDelete]);
        $admin->givePermissionTo([$paymentGlobal, $paymentCreate, $paymentView, $paymentEdit, $paymentDelete]);
        $admin->givePermissionTo([$PaymentLinkGeneratorGlobal, $PaymentLinkGeneratorCreate, $PaymentLinkGeneratorView, $PaymentLinkGeneratorEdit, $PaymentLinkGeneratorDelete]);
        $admin->givePermissionTo([$productCreate, $productView, $productEdit, $productDelete]);
        $admin->givePermissionTo([$userGlobal, $userCreate, $userView, $userEdit, $userDelete]);
        $admin->givePermissionTo([$teamCreate, $teamView, $teamEdit, $teamDelete]);
        $admin->givePermissionTo([$invoiceGlobal, $invoiceCreate, $invoiceView, $invoiceEdit, $invoiceDelete]);
        $admin->givePermissionTo([$settingsGlobal, $settingsCreate, $settingsView, $settingsEdit, $settingsDelete]);
        $admin->givePermissionTo([$gatewayCreate, $gatewayView, $gatewayEdit, $gatewayDelete]);
        $admin->givePermissionTo([$importExportCreate]);
        $admin->givePermissionTo([$notesCreate, $notesView, $notesEdit, $notesDelete]);
        $admin->givePermissionTo([$BlockListView, $BlockListEdit]);
        $admin->givePermissionTo([$TwoStepCreate, $TwoStepEdit]);
        $admin->givePermissionTo([$notificationGlobal]);
        $admin->givePermissionTo([$briefFormGlobal]);
        $admin->givePermissionTo([$briefLinkGlobal, $briefLinkCreate, $briefLinkView, $briefLinkEdit, $briefLinkDelete]);
        $admin->save();

        // Add Permissions to role `quality assurance`
        $qualityAssurance->givePermissionTo([$couponGlobal, $couponCreate, $couponView, $couponEdit, $couponDelete]);
        $qualityAssurance->givePermissionTo([$customerGlobal, $customerCreate, $customerView, $customerEdit, $customerDelete]);
        $qualityAssurance->givePermissionTo([$paymentGlobal, $paymentCreate, $paymentView, $paymentEdit, $paymentDelete]);
        $qualityAssurance->givePermissionTo([$PaymentLinkGeneratorGlobal, $PaymentLinkGeneratorCreate, $PaymentLinkGeneratorView, $PaymentLinkGeneratorEdit, $PaymentLinkGeneratorDelete]);
        $qualityAssurance->givePermissionTo([$productCreate, $productView, $productEdit, $productDelete]);
        $qualityAssurance->givePermissionTo([$userGlobal, $userCreate, $userView, $userEdit, $userDelete]);
        $qualityAssurance->givePermissionTo([$teamCreate, $teamView, $teamEdit, $teamDelete]);
        $qualityAssurance->givePermissionTo([$invoiceGlobal, $invoiceCreate, $invoiceView, $invoiceEdit, $invoiceDelete]);
        $qualityAssurance->givePermissionTo([$settingsGlobal, $settingsCreate, $settingsView, $settingsEdit, $settingsDelete]);
        $qualityAssurance->givePermissionTo([$gatewayCreate, $gatewayView, $gatewayEdit, $gatewayDelete]);
        $qualityAssurance->givePermissionTo([$importExportCreate]);
        $qualityAssurance->givePermissionTo([$notesCreate, $notesView, $notesEdit, $notesDelete]);
        $qualityAssurance->givePermissionTo([$BlockListView, $BlockListEdit]);
        $qualityAssurance->givePermissionTo([$TwoStepCreate, $TwoStepEdit]);
        $qualityAssurance->givePermissionTo([$notificationGlobal]);
        $qualityAssurance->save();

        // Add Permissions to role `Brand Manager`
        $brandManager->givePermissionTo([$couponCreate, $couponView, $couponEdit, $couponDelete]);
        $brandManager->givePermissionTo([$customerCreate, $customerView, $customerEdit, $customerDelete]);
        $brandManager->givePermissionTo([$paymentCreate, $paymentView, $paymentEdit, $paymentDelete]);
        $brandManager->givePermissionTo([$PaymentLinkGeneratorCreate, $PaymentLinkGeneratorView, $PaymentLinkGeneratorEdit, $PaymentLinkGeneratorDelete]);
        $brandManager->givePermissionTo([$productCreate, $productView, $productEdit, $productDelete]);
        $brandManager->givePermissionTo([$userCreate, $userView, $userEdit, $userDelete]);
        $brandManager->givePermissionTo([$teamCreate, $teamView, $teamEdit, $teamDelete]);
        $brandManager->givePermissionTo([$invoiceCreate, $invoiceView, $invoiceEdit, $invoiceDelete]);
        $brandManager->givePermissionTo([$importExportCreate]);
        $brandManager->givePermissionTo([$notesCreate, $notesView, $notesEdit, $notesDelete]);
        $brandManager->givePermissionTo([$BlockListView, $BlockListEdit]);
        $brandManager->givePermissionTo([$TwoStepCreate, $TwoStepEdit]);
        $brandManager->save();

        // Add Permissions to role `Salesperson`
        $salesperson->givePermissionTo([$couponCreate, $couponView, $couponEdit]);
        $salesperson->givePermissionTo([$customerCreate, $customerView, $customerEdit]);
        $salesperson->givePermissionTo([$paymentCreate, $paymentView, $paymentEdit]);
        $salesperson->givePermissionTo([$PaymentLinkGeneratorCreate, $PaymentLinkGeneratorView, $PaymentLinkGeneratorEdit]);
        $salesperson->givePermissionTo([$invoiceCreate, $invoiceView, $invoiceEdit]);
        $salesperson->givePermissionTo([$importExportCreate]);
        $salesperson->givePermissionTo([$notesCreate, $notesView, $notesEdit]);
        $salesperson->givePermissionTo([$BlockListCreate, $BlockListView]);
        $salesperson->givePermissionTo([$TwoStepCreate, $TwoStepEdit]);
        $salesperson->save();
    }
}
