<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSemBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sem_briefs', function (Blueprint $table) {
            $table->id();
            $table->string('encoded_id')->nullable()->unique();
            $table->unsignedBigInteger('brief_link_id')->nullable()->index();
            $table->unsignedBigInteger('customer_id')->nullable()->index();

            $table->foreign('brief_link_id')->references('id')->on('brief_links')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->text('device')->nullable();
            $table->text('location')->nullable();
            $table->string('email', 255)->nullable();
            $table->string('name', 255)->nullable();
            $table->string('designation', 255)->nullable();
            $table->string('phone', 40)->nullable()->nullable();
            $table->string('business_name', 400)->nullable();
            $table->string('business_idea', 400)->nullable();
            $table->string('competitors', 400)->nullable();
            $table->string('product_strengths', 400)->nullable();
            $table->string('product_weaknesses', 400)->nullable();
            $table->string('actions', 400)->nullable();
            $table->string('campaign_purpose', 255)->nullable();
            $table->text('landing_pages')->nullable();
            $table->string('u_s_p', 400)->nullable();
            $table->text('target_places')->nullable();
            $table->text('budget')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sem_briefs');
    }
}
