<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmmBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smm_briefs', function (Blueprint $table) {
            $table->id();
            $table->string('encoded_id')->nullable()->unique();
            $table->unsignedBigInteger('brief_link_id')->nullable()->index();
            $table->unsignedBigInteger('customer_id')->nullable()->index();

            $table->foreign('brief_link_id')->references('id')->on('brief_links')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->text('device')->nullable();
            $table->text('location')->nullable();
            $table->string('email', 255);
            $table->string('business_name', 400);
            $table->string('name', 255);
            $table->string('industry', 100)->nullable();
            $table->string('business_email', 255)->nullable();
            $table->string('phone', 40)->nullable();
            $table->text('services')->nullable();
            $table->string('business_goal', 400)->nullable();
            $table->string('slogan', 400)->nullable();
            $table->string('company_address', 400)->nullable();
            $table->text('unique_service')->nullable();
            $table->text('audience')->nullable();
            $table->string('website_link', 400)->nullable();
            $table->string('website_hosting', 400)->nullable();
            $table->text('competitors_website')->nullable();
            $table->string('facebook_link', 400)->nullable();
            $table->string('instagram_link', 400)->nullable();
            $table->string('pinterest_link', 400)->nullable();
            $table->text('social_media_competitors')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smm_briefs');
    }
}
