<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateBriefLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('brief_logs', function (Blueprint $table) {
            $table->text('request')->nullable()->after('type');
            $table->text('response')->nullable()->after('request');
            $table->boolean('pin')->default(0)->nullable()->after('response');
            $table->unsignedSmallInteger('code')->default(200)->after('pin');
            $table->boolean('event')->default(0)->after('code');
            $table->unsignedBigInteger('created_by')->nullable()->after('event');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brief_logs', function (Blueprint $table) {
            $table->dropColumn('request');
            $table->dropColumn('response');
            $table->dropColumn('pin');
            $table->dropColumn('code');
            $table->dropColumn('event');
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');
        });
    }
}
