<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddBriefLinkIdWebBrief extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('web_briefs', function (Blueprint $table) {
            $table->unsignedBigInteger('brief_link_id')->nullable()->index()->after('encoded_id');
            $table->unsignedBigInteger('customer_id')->nullable()->index()->after('brief_link_id');

            $table->foreign('brief_link_id')->references('id')->on('brief_links')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('web_briefs', function (Blueprint $table) {
            $table->dropColumn('brief_link_id');
            $table->dropColumn('customer_id');
        });
    }
}
