<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBriefsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('briefs', function (Blueprint $table) {
            $table->id();
            $table->string('encoded_id')->nullable()->unique();

            $table->string('email', 255);
            $table->string('name', 255);
            $table->string('designation', 100)->nullable();
            $table->string('phone', 20)->nullable();
            $table->string('business_name', 255);
            $table->string('slogan', 255)->nullable();
            $table->string('industry', 100)->nullable();
            $table->text('business_description')->nullable();
            $table->text('services')->nullable();
            $table->text('audience')->nullable();
            $table->string('website', 255)->nullable();
            $table->string('competitor', 255)->nullable();
            $table->text('logo_title')->nullable();
            $table->text('logo_idea')->nullable();
            $table->text('logo_message')->nullable();
            $table->text('logo_graphical_element')->nullable();
            $table->text('logo_customer_likes')->nullable();
            $table->text('logo_customer_dont_likes')->nullable();
            $table->text('font_base_logo')->nullable();
            $table->text('graphic_base_logo')->nullable();
            $table->string('logo_color', 50)->nullable();
            $table->string('logo_avoid_color', 50)->nullable();
            $table->string('logo_font', 100)->nullable();
            $table->string('logo_look', 100)->nullable();
            $table->text('logo_use')->nullable();
            $table->text('business_growth')->nullable();
            $table->string('logo_budget', 50)->nullable();
            $table->string('contact_time', 50)->nullable();
            $table->text('anything_else')->nullable();
            $table->date('completion_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('briefs');
    }
}
