<?php

namespace App\Services;

use App\Models\PaymentLink;
use App\Models\PaymentlinkCategory;
use App\Models\PaymentlinkCustomer;
use App\Repositories\Payment\Token\TokenInterface;
use App\Repositories\Payment\TokenCustomer\TokenCustomerInterface;
use Exception;

class TokenService
{
    private $tokenRepository, $paymentlinkCategoryModel, $tokenCustomer;

    public function __construct(TokenInterface $tokenRepository, PaymentlinkCategory $paymentlinkCategory, TokenCustomerInterface $tokenCustomer)
    {
        $this->tokenRepository = $tokenRepository;
        $this->paymentlinkCategoryModel = $paymentlinkCategory;
        $this->tokenCustomer = $tokenCustomer;
    }

    public function create($tokenDetails)
    {
        try {
            $categoryLinks = $tokenDetails['category'];
            $customerInfo = array();

            if (isset($tokenDetails) && (!empty($tokenDetails['cname']) || !empty($tokenDetails['cemail']) || !empty($tokenDetails['ccompany']) || !empty($tokenDetails['cnumber']))) {
                $customerInfo = array(
                    'name' => $tokenDetails['cname'],
                    'phone' => $tokenDetails['cnumber'] ?? '',
                    'email' => $tokenDetails['cemail'],
                    'address' => $tokenDetails['caddress'] ?? '',
                    'created_by' => $tokenDetails['created_by'],
                    'company_name' => $tokenDetails['ccompany']
                );
                unset($tokenDetails['category']);
                unset($tokenDetails['cname']);
                unset($tokenDetails['cnumber']);
                unset($tokenDetails['cemail']);
                unset($tokenDetails['caddress']);
                unset($tokenDetails['ccompany']);
            }

            $paymentLink = $this->tokenRepository->generate($tokenDetails);
            $tokenCategories = $this->tokenRepository->categories($paymentLink->id, $categoryLinks, $tokenDetails['created_by']);

            $this->paymentlinkCategoryModel->insert($tokenCategories);

            if (isset($customerInfo) && !empty($customerInfo)) {
                $tokenCustomer = $this->tokenCustomer->create($paymentLink->id, $customerInfo);
            }

            return $paymentLink->id;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function update($tokenDetails, $id, $token)
    {
        try {
            $categoryLinks = $tokenDetails['category'];
            $customerInfo = array();

            if (isset($tokenDetails) && (!empty($tokenDetails['cname']) || !empty($tokenDetails['cemail']) || !empty($tokenDetails['ccompany']) || !empty($tokenDetails['cnumber']))) {
                $customerInfo = array(
                    'id' => $tokenDetails['cid'] ?? null,
                    'name' => $tokenDetails['cname'],
                    'phone' => $tokenDetails['cnumber'] ?? '',
                    'email' => $tokenDetails['cemail'],
                    'address' => $tokenDetails['caddress'] ?? '',
                    'created_by' => $tokenDetails['created_by'],
                    'company_name' => $tokenDetails['ccompany']
                );
                // unset($tokenDetails['category']);
                // unset($tokenDetails['cid']);
                // unset($tokenDetails['cname']);
                // unset($tokenDetails['cnumber']);
                // unset($tokenDetails['cemail']);
                // unset($tokenDetails['caddress']);
                // unset($tokenDetails['ccompany']);
                unset($tokenDetails['category'],
                 $tokenDetails['cid'],
                 $tokenDetails['cname'],
                 $tokenDetails['cnumber'],
                 $tokenDetails['cemail'],
                 $tokenDetails['caddress'],
                 $tokenDetails['ccompany']);

                }
            
            $tokenDetails['token'] = $token;

            $this->paymentlinkCategoryModel->where('paymentlink_id', $id)->delete();

            $paymentLink = $this->tokenRepository->update($tokenDetails, $id);

            $tokenCategories = $this->tokenRepository->categories($paymentLink->id, $categoryLinks, $tokenDetails['created_by']);

            $this->paymentlinkCategoryModel->delete($tokenCategories);
            $this->paymentlinkCategoryModel->insert($tokenCategories);
            // dd($customerInfo['id'],$paymentLink);

            if (isset($customerInfo) && !empty($customerInfo)) {
                if (!empty($customerInfo['id'])) {
                    // $paymentListCustomerId = $paymentLink->with('paymentLinkCustomer')->whereId($id)->first()->paymentLinkCustomer->id;
                    // $tokenCustomer = $this->tokenCustomer->update($paymentListCustomerId, $customerInfo);

                    $tokenCustomer = $this->tokenCustomer->update($customerInfo['id'], $customerInfo);
                } else {
                    $tokenCustomer = $this->tokenCustomer->create($paymentLink->id, $customerInfo);
                }
            }

            return $paymentLink->id;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetch()
    {
    }
}
