<?php

namespace App\Services;

use App\Models\Setting;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Cache;

class SettingService {
  protected $cacheDuration = 60 * 60; // Cache duration in seconds (1 hour)

  public function get()
  {
    return Cache::remember('settings', $this->cacheDuration, function () {
      $arr = array('logo','logo_white','company_name','company_phone','company_email','company_address','favicon','primary_color','secondary_color','ternary_color','company_url');
      return Arr::pluck(Setting::select('key','value')->whereIn('key',$arr)->get(), 'value', 'key');
    });
  }

  public function getSetting($key)
  {
      $settings = $this->get();
      return $settings[$key] ?? null;
  }
}