<?php 

namespace App\Services;

use App\Repositories\Product\ProductInterface;
use Exception;

class ProductService {
  private $productRepository;

  public function __construct(ProductInterface $productRepository)
  {
    $this->productRepository = $productRepository;

  }

  public function create($productDetails) {
    try {
      $product = $this->productRepository->addOrUpdate($productDetails);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }

  public function getProductById($productID) {
    try {
      $product = $this->productRepository->product($productID);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }
  public function updateProduct($productDetails) {
    try {
      $product = $this->productRepository->addOrUpdate($productDetails);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }
  public function archiveProduct($productID) {
    try {
      $product = $this->productRepository->softDeleteProduct($productID);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }

  public function deleteProduct($productID) {
    try {
      $product = $this->productRepository->forceDeleteProduct($productID);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }

  public function restoreProduct($productID) {
    try {
      $product = $this->productRepository->restoreProduct($productID);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }

  public function updateProductMetadata($productDetails) {
    try {
      $product = $this->productRepository->updateProductMetadata($productDetails);
      return $product;
    } catch(Exception $ex) {
      throw $ex;
    }
  }

}