<?php

namespace App\Services;

use App\Models\LoginHistory;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jenssegers\Agent\Agent;

class LoginHistoryService
{
    private $loginHistory;

    public function __construct()
    {
        $this->loginHistory = new LoginHistory();
    }

    public function getAllLogins($request)
    {
        try {
            return $this->loginHistory->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function getLoginHistory($id)
    {
        try {
            return $this->loginHistory->where('user_id', $id)->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function create($ip, $user_id, $user_agent, $activity)
    {
        try {
            $session_id= Session::getId();

            $agent = new Agent();
            $agent->setUserAgent($user_agent);
            $ipInfo = (new BinApiService)->ipInfo($ip);
            
            $country = $ipInfo['country'] ?? '';

            return $this->loginHistory->create([
                'session_id' => $session_id,
                'user_id' => $user_id,
                'activity' => $activity,
                'ip_address' => $ip,
                'device' => $agent->device(),
                'device_type' => $agent->deviceType(),
                'platform' => $agent->platform(),
                'country' => $country,
                'browser' => $agent->browser(),
            ]);
        } catch (Exception $ex) {
            throw $ex;
        }
    }


    public function update($user_id, $session_id)
    {
        try {

            $loginHistoryRecord = $this->loginHistory->where('session_id', $session_id)
            ->where('user_id', $user_id)
            ->first();

            if ($loginHistoryRecord) {

                $currentTime = now();
                $createdTime = Carbon::parse($loginHistoryRecord->created_at);
    
                $durationInSeconds = $currentTime->diffInSeconds($createdTime);
                $hours = floor($durationInSeconds / 3600);
                $minutes = floor(($durationInSeconds % 3600) / 60);
                $seconds = $durationInSeconds % 60;
    
                if ($hours > 0) {
                    $formattedDuration = $hours . ($hours == 1 ? ' hour' : ' hours');
                    if ($minutes > 0) {
                        $formattedDuration .= ', ' . $minutes . ' minutes';
                    }
                } elseif ($minutes > 0) {
                    $formattedDuration = $minutes . ' minutes';
                } else {
                    $formattedDuration = $seconds . ' seconds';
                }
                   
                $loginHistoryRecord->duration = $formattedDuration;
                $loginHistoryRecord->save();
    
                return true;
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}
