<?php

namespace App\Services;

use App\Models\Lead;
use App\Repositories\Lead\LeadRepository;
use Exception;

class LeadService
{
    private $lead, $leadRepository;

    function __construct(Lead $lead, LeadRepository $leadRepository)
    {
        $this->lead = $lead;
        $this->leadRepository = $leadRepository;
    }

    public function getLeads($request)
    {
        try {
            return $this->leadRepository->getLeads($request);
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function getLead($id)
    {
        try {
            return $this->leadRepository->getLead($id);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function create($request)
    {
        try {
            return $this->leadRepository->create($request);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function update($request)
    {
        try {
            return $this->leadRepository->update($request);
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function delete($id)
    {
        try {
            return $this->leadRepository->delete($id);
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    
    public function getLeadCount($status){
        try{
            return $this->leadRepository->getLeadCount($status);
        }catch (Exception $ex) {
            throw $ex;
        }
    }
}
