<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use Exception;

class IpGeoLocationService {
  private $apiKey, $url;

  function __construct($api_key="")
  {
    $this->apiKey = $api_key !="" ? $api_key : env('IP_GEO_LOCATION_KEY');  
    $this->url = 'https://api.ipgeolocation.io/';
  }

  function ipLocation($ip) {
    try {
      $userAgent = Http::async()->get("{$this->url}ipgeo?apiKey={$this->apiKey}&ip={$ip}");
      
      return $userAgent->wait();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }
  
  public function getDevice($userAgent="") {
    try {
        if($userAgent != "") {
            $userAgent = $_SERVER["HTTP_USER_AGENT"];
        }
      $userAgent = Http::async()->withUserAgent($userAgent)->get("{$this->url}user-agent?apiKey=$this->apiKey");

      return $userAgent->wait();
    } catch(Exception $ex) {
      return response()->json([
        "code" => $ex->getCode(),
        "message" => $ex->getMessage()
      ]);
    }
  }
}