<?php 
namespace App\Services\Export;

use App\Models\Invoice;
use App\Repositories\Export\ExportRepository;
use Exception;

class InvoiceExport {
  protected $exportRepository;

  public function __construct(ExportRepository $exportRepository) {
    $this->exportRepository = $exportRepository;
  }

  public function columns() {
    $exportColumns = array(
      'key' => 'invoice',
      'text' => 'Invoice Details',
      'columns' => array(
        array('key' => 'customer.id', 'text' => 'customer_id', 'default' => true),
        array('key' => 'customer.first_name', 'text' => 'customer_first_name', 'default' => true),
        array('key' => 'customer.last_name', 'text' => 'customer_last_name', 'default' => true),
        array('key' => 'customer.email', 'text' => 'customer_email', 'default' => true),
        array('key' => 'customer.phone', 'text' => 'customer_phone', 'default' => true),
        array('key' => 'customer.address', 'text' => 'customer_address', 'default' => true),
        array('key' => 'customer.company', 'text' => 'customer_company_name', 'default' => true),
        array('key' => 'customer.city', 'text' => 'customer_city', 'default' => true),
        array('key' => 'customer.state', 'text' => 'customer_state', 'default' => true),
        array('key' => 'customer.zipcode', 'text' => 'customer_zip', 'default' => true),
        array('key' => 'customer.country', 'text' => 'customer_country', 'default' => true),
        array('key' => 'created_at', 'text' => 'datetime', 'default' => true),
        array('key' => 'custom_id', 'text' => 'invoice_id'),
        array('key' => 'invoice_no', 'text' => 'invoice_no'),
        array('key' => 'payment.card.brand', 'text' => 'card'),
        array('key' => 'stripe_payment_method.card.exp_month', 'text' => 'exp_month'),
        array('key' => 'stripe_payment_method.card.exp_year', 'text' => 'exp_year'),
        array('key' => 'stripe_payment_method.card.last4', 'text' => 'last4'),

      ),
    );

    $this->exportRepository->headings($exportColumns);

    return $exportColumns; 
  }

  public function export($data) {
    try {
      $customersData = Invoice::with([
        'customer' => function($customer) {
          $customer->select('id','first_name','last_name','email','password','phone','city','company','address','state','zipcode','country','stripe_customer_id','stripe_pm_id','stripe_payment_method');
        },
        'payment' => function($payment) {
          $payment->select('id','customer_id','payment_link_id','price','discount','currency','ip','intent_id','charge_id','last_four','comment','gateway_message','status','created_at');
        },
      ]);

      if(!empty($data['dateRange']) && !empty($data['dateRange']['start']) && !empty($data['dateRange']['end'])) {
        $customersData = $customersData->whereBetween('created_at', [$data['dateRange']['start'], $data['dateRange']['end']]);
      }
      $customers = $customersData->get();
  
      $customersExport = $this->exportRepository->process($customers, $data);
  
      $customersExport = $this->exportRepository->export();
  
      return $customersExport;
    } catch(Exception $e) {
      throw new $e;
    }
  }
}