<?php 

namespace App\Services;

use App\Models\CountryCurrencies;
use Illuminate\Support\Facades\Cache;

class CurrencyService {
  public function getCountriesCurrency()
  {
    return Cache::remember('country_currencies', 60 * 60, function () {
        return CountryCurrencies::select('id', 'aplha_code2', 'aplha_code3', 'country', 'currency', 'code', 'symbol')
            ->orderBy('country', 'ASC')
            ->get();
    });
  }

  public function getCurrencies()
  {
    return Cache::remember('currencies', 60 * 60, function () {
        return CountryCurrencies::select('id', 'aplha_code2', 'code', 'symbol')
            ->groupBy('aplha_code2')
            ->get();
    });
  }
}