<?php

namespace App\Services;

use App\Repositories\Brief\BriefRepository;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BriefService
{

    private $briefRepository, $streakService;

    public function __construct(BriefRepository $briefRepository, StreakService $streakService)
    {
        $this->briefRepository = $briefRepository;
        $this->streakService = $streakService;

    }

    public function create($briefDetails)
    {
        try {
            $brief = $this->briefRepository->createBrief($briefDetails);

            $this->streakService->createBox([
                "name" => $brief['name'] ?? '',
                "company_name" => $brief['business_name'] ?? '',
                "phone_number" => $brief['phone_number'] ?? '',
                "industry" => $brief['industry'] ?? '',
                "brief_url" => !empty($brief['encoded_id']) ? route('frontend.brief.view', $brief['encoded_id']) : '',
                "email" => $brief['email'] ?? '',
            ]);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function list(Request $request)
    {
        try {
            $briefs = $this->briefRepository->getAllBriefs($request);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function getBrief($id)
    {
        try {
            $briefs = $this->briefRepository->getBrief($id);
            return $briefs;
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function fetchByEncodedID($briefID, $authenticated = false)
    {
        try {
            $brief = $this->briefRepository->getByEncodedID($briefID, $authenticated);
            return $brief;
        } catch (Exception $ex) {
            throw $ex;
        }
    }
}
