<?php

namespace App\Services;

use App\Models\BriefLinkHistory;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jenssegers\Agent\Agent;

class BriefLinkHistoryService
{
    private $briefLinkHistory;

    public function __construct()
    {
        $this->briefLinkHistory = new BriefLinkHistory();
    }

    public function getAllBriefLinkHistory($request)
    {
        try {
            return $this->briefLinkHistory->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }
    public function getBriefLinkHistory($id)
    {
        try {
            return $this->briefLinkHistory->where('brief_link_id', $id)->get();
        } catch (Exception $ex) {
            throw $ex;
        }
    }

    public function create($brief_link_id, $ip, $user_id, $user_agent, $activity)
    {
        try {
            $session_id= Session::getId();

            $agent = new Agent();
            $agent->setUserAgent($user_agent);
            $ipInfo = (new BinApiService)->ipInfo($ip);
            
            $country = $ipInfo['country'] ?? '';

            return $this->briefLinkHistory->create([
                'brief_link_id' => $brief_link_id,
                'activity' => $activity,
                'ip_address' => $ip,
                'device' => $agent->device(),
                'device_type' => $agent->deviceType(),
                'platform' => $agent->platform(),
                'country' => $country,
                'browser' => $agent->browser(),
            ]);
        } catch (Exception $ex) {
            throw $ex;
        }
    }


    public function update($user_id, $session_id)
    {
        try {

            $loginHistoryRecord = $this->briefLinkHistory->where('session_id', $session_id)
            ->where('user_id', $user_id)
            ->first();

            if ($loginHistoryRecord) {

                $currentTime = now();
                $createdTime = Carbon::parse($loginHistoryRecord->created_at);
    
                $durationInSeconds = $currentTime->diffInSeconds($createdTime);
                $hours = floor($durationInSeconds / 3600);
                $minutes = floor(($durationInSeconds % 3600) / 60);
                $seconds = $durationInSeconds % 60;
    
                if ($hours > 0) {
                    $formattedDuration = $hours . ($hours == 1 ? ' hour' : ' hours');
                    if ($minutes > 0) {
                        $formattedDuration .= ', ' . $minutes . ' minutes';
                    }
                } elseif ($minutes > 0) {
                    $formattedDuration = $minutes . ' minutes';
                } else {
                    $formattedDuration = $seconds . ' seconds';
                }
                   
                $loginHistoryRecord->duration = $formattedDuration;
                $loginHistoryRecord->save();
    
                return true;
            }
        } catch (Exception $ex) {
            throw $ex;
        }
    }

}
