<?php

namespace App\Repositories\Payment\Token;

use App\Models\PaymentLink;
use App\Models\PaymentlinkCategory;
use Carbon\Carbon;

class TokenRepository implements TokenInterface
{
    private $paymentLink;

    public function __construct(PaymentLink $paymentLink)
    {
        $this->paymentLink = $paymentLink;
    }

    public function discount($price = 0.0, $discount = 0.0, $discountType)
    {

        if ($discountType === 'percent') {
            $discountedPrice = (float) $discount;
            $discounted = $price * ((float) $discount / 100);
            $discountAmount = ceil($price - $discounted);
            $discountType = 'percentage';
        } else {
            $discountAmount = ceil($discount);
            $discountAmount = $price - $discountAmount;
            $discountedPrice = $discount ?? 0;
            $discountType = 'flat';
        }

        return [
            "discount" => $discountAmount,
            "discountedAmount" => $discountedPrice,
            "discountType" => $discountType,
        ];
    }


    public function formatToken($data)
    {
        $token["token"] = sha1(uniqid(Carbon::now()->toDateTimeString(), true));
        $token['customer_id'] = $data['customer_id'] ?? null;
        $token['item_name'] = $data['item_name'];
        $token['original_price'] = $data['item_price'];
        $data['discount'] = $data['discount'] ?? 0;
        $discount = $this->discount($data['item_price'], $data['discount'], $data['discountType']);
        $token['discount'] = $discount['discountedAmount'];
        $token['discount_type'] = $discount['discountType'];
        $token['price'] = $discount['discount'];

        $token['item_description'] = $data['item_description'] ?? null;
        $token['sale_type'] = $data['saleType'] ?? 'fresh_sales';
        $token['currency'] = $data['currency'];
        $token['comment'] = $data['comment'] ?? null;
        $token['team'] = $data['team'];
        $token['payment_type'] = $data['payment_type'] ??  'straight';
        $token['payment_gateway'] = $data['paymentGateway'] ?? 1;
        $token['show_coupon'] = $data['showCoupon'] ?? false;
        $token['valid_till'] = Carbon::now()->addHours(48)->timestamp;
        $token['created_by'] = $data['created_by'];

        return $token;
    }

    public function generate($data = [])
    {
        $token = $this->formatToken($data);

        return $this->paymentLink->create($token);
    }


    public function update($data = [], $id)
    {
        $token = $this->formatToken($data);

        if (!empty($data['token'])) {
            $token['token'] = $data['token'];
        }

        $updatedRecord = $this->paymentLink->where('id', $id);
        $updatedRecord->update($token);

        return $updatedRecord->first()->refresh();
    }

    public function categories($paymentLinkID, $categories, $createdBy)
    {
        $paymentLinkCategory = array();

        foreach ($categories as $category) {
            $paymentLinkCategory[] = array(
                "paymentlink_id" => $paymentLinkID,
                "category_id" => $category,
                "created_by" => $createdBy
            );
        }

        return $paymentLinkCategory;
    }

    public function compareCategories($paymentLinkID, $newCategories, $existingCategories)
    {
        $categoriesToAdd = array_diff($newCategories, $existingCategories);
        $categoriesToRemove = array_diff($existingCategories, $newCategories);

        return [
            'categoriesToAdd' => $categoriesToAdd,
            'categoriesToRemove' => $categoriesToRemove
        ];
    }

    public function deleteCategoriesToRemove($paymentLinkId, $categoriesToRemove)
    {
        PaymentlinkCategory::where('paymentlink_id', $paymentLinkId)
            ->whereIn('category_id', $categoriesToRemove)
            ->delete();
    }
}
