<?php

namespace App\Repositories\Payment\Errors;

class ErrorsRepository implements ErrorsInterface
{
  protected $filePath;

  public function __construct()
  {
    // Get the directory path of the repository class
    $directory = __DIR__;

    // Construct the file path
    $this->filePath = $directory . '/errors.json';
  }

  public function getMessage($errorCode)
  {
    if($errorCode != '') {
      $errors = json_decode(file_get_contents($this->filePath), true);
  
      foreach ($errors as $item) {
        if ($item['code'] === $errorCode) {
          // Code found, do something with it
          return $item;
          break;
        }
      }
    }
    
    return false;
  }
}
