<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Stripe\Customer;

class PaymentLink extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['customer_id', 'token', 'valid_till', 'item_name', 'price', 'discount_type', 'discount', 'original_price', 'item_description', 'currency', 'coupon_id', 'sale_type', 'team', 'payment_gateway', 'payment_type', 'payment_cycle', 'remaining_amount', 'balance', 'comment', 'show_coupon', 'created_by'];
    // protected $appends = ['visited'];

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'paymentlink_categories', 'paymentlink_id', 'category_id');
    }

    public function paymentLogs()
    {
        return $this->morphMany(PaymentLog::class, 'loggable');
    }

    public function currencyCountry()
    {
        return $this->hasOne(CountryCurrencies::class, 'id', 'currency');
    }

    public function gateway()
    {
        return $this->hasOne(PaymentGateway::class, 'id', 'payment_gateway');
    }

    public function teamWise()
    {
        return $this->hasOne(Team::class, 'id', 'team');
    }

    public function paymentLinkCustomer()
    {
        return $this->belongsTo(PaymentlinkCustomer::class, 'id', 'paymentlink_id');
    }

    public function creator()
    {
        return $this->hasOne(User::class, 'id', 'created_by');
    }

    public function payments()
    {
        return $this->belongsTo(Payment::class, 'id', 'payment_link_id');
    }

    public function visitedLinks()
    {
        return $this->hasMany(VisitedPaymentLink::class, 'payment_link_id', 'id');
    }

    public function getVisitedAttribute()
    {
        return $this->visitedLinks()->count() > 0 ? 1 : 0;
    }

    public function getUpSellAndFreshSellData($startDate = null, $endDate = null, $ids = null)
    {
        $query = self::selectRaw('sale_type as sales_type, COUNT(DISTINCT(id)) as total_records, SUM(price) as total_price')
            ->groupBy('sale_type');

        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate]);
        }

        if($ids) {
            $query->whereIn('id', $ids);
        }
        return $query->get();
    }
}
