<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class Category extends Model
{
    use HasFactory, SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = ['id', 'custom_id', 'name', 'image', 'description', 'created_by', 'created_at', 'updated_by', 'updated_at'];

    public function productlogs() {
        return $this->hasMany(ProductLog::class, 'product_id', 'id');
    }

    public static function statusCount($statuses) {
        $statusCounts = [];
    
    foreach ($statuses as $status) {
        switch ($status) {
            case 'all':
                // Count products with both statuses 1 and 2
                $statusCounts['available'] = self::where('status', 1)->count() + self::onlyTrashed()->count();
                break;
            case 'archived':
                // Count products with status 2
                $statusCounts['archived'] = self::onlyTrashed()->count();
                break;
            case 'available':
                // Count products with status 1
                $statusCounts['all'] = self::where('status', 1)->count();
                break;
            default:
                break;
        }
    }
    
    return $statusCounts;
    }
}
