<?php

namespace App\Models;

use App\Helper\EncodeHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;

class Brief extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'encoded_id',
        'brief_link_id',
        'location',
        'device',
        'email',
        'name',
        'designation',
        'phone',
        'business_name',
        'slogan',
        'industry',
        'business_description',
        'services',
        'audience',
        'website',
        'competitor',
        'logo_title',
        'logo_idea',
        'logo_message',
        'logo_graphical_element',
        'logo_customer_likes',
        'logo_customer_dont_likes',
        'font_base_logo',
        'graphic_base_logo',
        'logo_color',
        'logo_avoid_color',
        'logo_font',
        'logo_look',
        'logo_use',
        'business_growth',
        'logo_budget',
        'contact_time',
        'anything_else',
        'completion_date'
    ];

    // protected $casts = [
    // 'logo_title' => 'array',
    // 'font_base_logo' => 'array',
    // 'graphic_base_logo' => 'array',
    // 'logo_use' => 'array',
    // 'business_growth' => 'array',
    // ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($brief) {
            $brief->encoded_id = EncodeHelper::base64url_encode(md5($brief->id, true));
            $brief->save();
        });
    }

    public function scopeExcludeColumns($query, array $exclude)
    {
        // Get all columns from the table
        $columns = Schema::getColumnListing($this->getTable());

        // Filter out the excluded columns
        $selectedColumns = array_diff($columns, $exclude);

        // Return the query with the selected columns
        return $query->select($selectedColumns);
    }

    public function briefLogs()
    {
        return $this->morphMany(BriefLog::class, 'brief');
    }

    public function briefLink()
    {
        return $this->belongsTo(BriefLink::class, 'brief_link_id');
    }

    public function customer()
    {
        return $this->hasOne(User::class, 'id', 'customer_id');
    }

    public function briefData()
    {
        return $this->morphMany(BriefData::class, 'model');
    }
}
