<?php

namespace App\Jobs;

use App\Classes\Refund as ClassesRefund;
use App\Helper\Helper\NotificationHelper;
use App\Models\Payment;
use App\Repositories\Payment\Refund\RefundInterface;
use App\Services\LogService;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Stripe\Refund;
use Stripe\Stripe;

class RefundPayment implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $paymentID, $reason, $amount, $refundStatus, $refundRepo, $log, $createdBy;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($paymentID, $reason, $amount, $refundStatus, $createdBy, RefundInterface $refundRepo, LogService $log)
    {
        $this->paymentID = $paymentID;
        $this->reason = $reason;
        $this->amount = $amount;
        $this->refundStatus = $refundStatus;
        $this->refundRepo = $refundRepo;
        $this->createdBy = $createdBy;
        $this->log = $log;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $payment = Payment::select('id', 'payment_link_id')
            ->with([
                'paymentLink' => function ($query) {
                    $query->select('id', 'payment_gateway');
                    $query->with('gateway');
                }
            ])
            ->where('id', $this->paymentID)
            ->first();
        if ($payment->paymentLink->gateway->gateway == 'paypal' || $payment->paymentLink->gateway->gateway == 'paypal_creditcard') {
            $refund = new ClassesRefund($this->refundRepo, $this->log);
            $refund->singleRefundForPaypal($this->paymentID, $this->reason, $this->amount, $this->refundStatus, $this->createdBy);
        } else {
            $refund = new ClassesRefund($this->refundRepo, $this->log);
            $refund->singleRefund($this->paymentID, $this->reason, $this->amount * 100, $this->refundStatus, $this->createdBy);
        }
    }

}
