<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PaymentLinkResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'token' => $this->token,
            'item_name' => $this->item_name,
            'price' => $this->price,
            'discount' => $this->discount,
            'discount_type' => $this->discount_type,
            'original_price' => $this->original_price,
            'item_description' => $this->item_description,
            'currency' => CountryCurrencyResource::collection($this->whenLoaded('currencyCountry')),
            'sale_type' => $this->sale_type,
            'customer' => $this->currency,
            'gateway' => GatewayResource::collection($this->whenLoaded('gateway')),
        ];
    }
}
