<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class PaymentMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Card Expiry Date
        $expDate = $request->card_date;

        $cardNumber = str_replace(' ', '', $request->cardNo);
        $request->merge(['cardNo' => $cardNumber]);
        $request->merge(['cardValidity' => $this->validateCardNumber($cardNumber)]);

        if (str_contains($expDate, '/')) {
            $expDate = explode("/", $expDate);
            $request->merge(['month' => $expDate[0]]);
            $request->merge(['year' => $expDate[1]]);
        } else {
            $request->merge(['month' => substr($expDate, 0, 2)]);
            $request->merge(['year' => substr($expDate, 2, 4)]);
        }

        return $next($request);
    }

    function validateCardNumber($cardNumber)
    {
        // Remove any non-digit characters from the card number
        $cleanedCardNumber = preg_replace('/\D/', '', $cardNumber);

        // Convert the card number to an array of digits
        $digits = str_split($cleanedCardNumber);

        // Double every second digit starting from the right
        for ($i = count($digits) - 2; $i >= 0; $i -= 2) {
            $digits[$i] *= 2;
            if ($digits[$i] > 9) {
                $digits[$i] -= 9;
            }
        }

        // Sum all the digits
        $sum = array_sum($digits);

        // Check if the sum is divisible by 10
        return $sum % 10 === 0;
    }
}
