<?php

namespace App\Http\Controllers\Payment;

use App\Classes\SmtpConfig;
use App\Http\Controllers\Controller;
use App\Http\Controllers\InvoiceController;
use App\Mail\ReceiptMail;
use App\Models\BrandSettings;
use App\Models\Category;
use App\Models\CountryCurrencies;
use App\Models\Coupon;
use App\Models\Invoice;
use App\Models\PaymentGateway;
use App\Models\PaymentLink;
use App\Models\PaymentlinkCategory;
use App\Models\Payments;
use App\Models\Setting;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Inertia\Inertia;

class PaymentController extends Controller
{
    public function success(Request $request)
    {
        if (Session()->get('success_data')) {
            $payment = PaymentLink::select('id', 'token')->where('token', Session()->get('success_data')["token"])->first();
            // $category = Categories::where('id',Session()->get('success_data')["category_id"])->first()->toArray();
            // $sale_type = PaymentSaleTypeModel::where('id',Session()->get('success_data')["sale_type_id"])->first()->toArray();

            $gtag_script = "";

            /* $script = "<script async src='https://www.googletagmanager.com/gtag/js?id=UA-133648676-2'></script><script> window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'UA-133648676-2'); </script>";
            if($category["title"]=="Logo Design") {
                $data["brief_form"]=0;
                $logoDesign = '<script> gtag("event", "purchase", { "send_to": "UA-133648676-2","transaction_id": "'.Session()->get('success_data')["invoice_id"]. '","affiliation": "'.$sale_type["name"]. '","value": '.Session()->get('success_data')["itemprice"]. ', "currency": "USD","items": [{"id": "'.Session()->get('success_data')["invoice_id"]. '", "name": "'.Session()->get('success_data')["itemname"]. '","category": "Logo Design","quantity": 1, "price": "'.Session()->get('success_data')["itemprice"]. '"},]});</script>';
                $gtag_script = $script.$logoDesign;
            }
            */

            return view('frontend.payments.success', ["data" => Session()->get('success_data'), "payment" => $payment, "gtag_script" => $gtag_script]);
        } else {
            return redirect()->route('payment.expired');
        }
    }

    public function failed(Request $request, $data = "")
    {
        if (Session()->get('failed_data')) {
            /* $path = 'data/'.Session()->get('failed_data')["token"].'.json';
            $retriveFile = file_get_contents($path);
            $json=str_replace('},

            ]',"}

            ]",$retriveFile);
            $customerInfo = json_decode($json); */

            return view('frontend.payments.failed', ["data" => Session()->get('failed_data')]);
        } else {
            return redirect()->route('payment.expired');
        }
    }

    public function expired(Request $request)
    {
        $failedData = Session()->get('failed_data');

        if (!empty($failedData["token"])) {
            $payment = PaymentLink::where('token', $failedData["token"])->with('currencyCountry');

            $payment = $payment->exists() ? $payment->first()->toArray() : "";
        } else {
            $payment = "";
        }

        $failedData['title'] = 'Link Expired' . (isset($failedData["token"]) && !empty($failedData["token"]) ? ' | ' . $failedData["token"] : '');

        $failedData['message'] = [
            'title' => 'Link Expired',
            'code' => 'code',
            'chat_agent' => 'testing',
            'customer' => 'Sorry! Token is Expired. Kindly chat with our sales team in this regard.',
        ];

        Session::flash("failed_data", $failedData);

        Session::reflash();

        $brandSettings = Arr::pluck(Setting::get(), 'value', 'key');

        return Inertia::render('Payment/Error', [
            'brand_settings' => $brandSettings,
            "data" => $failedData,
            "payment" => $payment
        ]);

        // return view('frontend.payments.token-expired', [
        //     'current_time' => Carbon::now()->timestamp,
        //     'failed_data' => Session()->get('failed_data'),
        //     "data" => $payment
        // ]);
    }

    public function storePaymentApi(Request $request)
    {
        $formData = Arr::pluck($request->all(), 'value', 'name');
        $formData = array_map(function ($v) {
            return trim(strip_tags($v));
        }, $formData);

        try {
            if (!empty($formData)) {
                $formData["payment_status"] = 0;
                $formData["email_status"] = 0;
                $formData["email_error"] = "";
                $formData["db_status"] = 0;
                $formData["db_error"] = "";
                $maskedCard = $this->formatAndMaskCard($formData["cardNo"]);
                $formData["cardNo"] = $maskedCard;
                $path = 'data/' . $formData["ptoken"] . '.json';
                $jsonString = json_encode($formData, JSON_PRETTY_PRINT);
                /* $fp = fopen($path, 'w');
                fwrite($fp, $jsonString);
                fclose($fp); */
                //$retriveFile = file_get_contents($path);

                Log::info('Making new directory');
                Log::info(json_encode($formData));

                $customer = User::where("email", "=", $formData["clientemail"]);
                $paymentLink = PaymentLink::where("token", "=", $formData["ptoken"])->first();
                $paymentLink = $paymentLink->toArray();

                if ($customer->exists()) {
                    $customerData = $customer->first();
                    $customer_id = $customerData->id;
                } else {
                    $customer = new User();
                    $customer->first_name = $formData["firstname"];
                    $customer->last_name = $formData["lastname"];
                    $customer->email = $formData["clientemail"];
                    $customer->phone_number = $formData["phonenum"];
                    $customer->company_name = $formData["companyname"];
                    $customer->address = $formData["address"];
                    $customer->city = $formData["city"];
                    $customer->state = $formData["statename"];
                    $customer->zipcode = $formData["zipcode"];
                    $customer->country = $formData["country"];
                    $customer->created_by = $paymentLink["created_by"];
                    $customer->created_at = Carbon::now();
                    $default_customer_password = Setting::where('key', '=', 'default_customer_password')->first();
                    $password = (!empty($default_customer_password->key_value)) ? $default_customer_password->key_value : "12345678";
                    $customer->password = Hash::make($password);
                    $customer->save();
                    $customer_id = $customer->id;
                    $roles = "Customer";
                    $customer->assignRole($roles);
                }

                $payments = new Payments();
                $payments->customer_id = $customer_id;

                $payments->Item_name = $formData['itemname'];
                $payments->price = $formData['itemprice'];
                $payments->discount = (!empty($formData['discount']) ? $formData['discount'] : 0);
                $payments->original_price = $paymentLink['original_price'];
                $payments->currency = $paymentLink['currency'];
                // $payments->category_id = $paymentLink['category_id'];
                // $payments->sale_type_id = $paymentLink['sale_type_id'];
                $payments->payment_gateway = $paymentLink['payment_gateway'];
                $payments->payment_type = $paymentLink['payment_type'];
                $payments->token = $formData['ptoken'];
                $payments->item_description = $paymentLink['item_description'];

                if (!empty($formData["payment_error"]) || !empty($formData["payment_message"])) {
                    $error_message = array(
                        "error" => $formData["payment_error"],
                        "message" => $formData["payment_message"],
                    );
                    $payments->comment = $formData["payment_message"];
                    $payments->message = json_encode($error_message);
                    $payments->status = 2;
                } else {
                    $payments->comment = "";
                    $payments->message = "";
                    $payments->status = 1;
                }

                $payments->payment_on = Carbon::now()->format('Y-m-d');
                $payments->created_by = (!empty($paymentLink['created_by']) ? $paymentLink['created_by'] : NULL);
                $payments->save();

                if (!empty($formData["payment_error"]) || !empty($formData["payment_message"])) {
                    $sessional_time = Carbon::now()->addMinutes(10)->timestamp;

                    $failed_data = array(
                        "token" => $formData["ptoken"],
                        'current_time' => Carbon::now()->timestamp,
                        'session' => $sessional_time,
                        'currency' => $formData['currency'],
                        'itemprice' => $formData['itemprice'],
                        'itemname' => $formData['itemname'],
                        'title' => 'Payment Failed | ' . $formData['currency'] . $formData['itemname'] . ' | Message:' . $formData["payment_message"],
                        'heading' => 'Payment Failed',
                        'message' => $formData["payment_message"]
                    );

                    Session::flash("failed_data", $failed_data);
                    return response()->json(['failed' => true, 'route' => route('payment.failed', ["token" => $formData["ptoken"]])], 200);
                } else {
                    $payment_id = $payments->id;

                    InvoiceController::create($payment_id);
                    $invoice_data = Invoice::where('payment_id', $payment_id)->first();

                    if (!empty($formData['coupon_id'])) {
                        $coupon = Coupon::find($formData['coupon_id']);
                        $coupon->quantity = $coupon->quantity - 1;
                        $coupon->utilized = $coupon->utilized + 1;
                        $coupon->save();
                    }

                    if ($this->paymentLinkStatus($paymentLink['id'], 2)) {
                        $path = 'data/' . $formData["ptoken"] . '.json';
                        $file_content = file_get_contents($path);
                        $content = json_decode($file_content, true);
                        $formData["payment_status"] = 1;

                        $payment_status = array_merge($content, $formData);
                        $jsonString = json_encode($payment_status, JSON_PRETTY_PRINT);
                        file_put_contents($path, $jsonString);
                        Log::info("Updated - Token: " . $formData["ptoken"] . " has payment_status: 1");

                        $success_data = array(
                            "token" => $formData["ptoken"],
                            "original_price" => $paymentLink['original_price'],
                            "itemname" => $formData['itemname'],
                            "itemprice" => $formData['itemprice'],
                            "currency" => $formData['currency'],
                            "invoice_id" => $invoice_data->invoice_no,
                            "payment_id" => $payment_id,
                            "discount" => (!empty($formData['discount']) ? $formData['discount'] : 0),
                            "coupon_id" => $formData['coupon_id'],
                            // "category_id" => $paymentLink['category_id'],
                            // "sale_type_id" => $paymentLink['sale_type_id'],
                        );

                        // InvoiceController::email_sent($customer_id);

                        Session::flash("success_data", $success_data);
                        return response()->json(['success' => true, 'route' => route('payment.success', ["token" => $formData["ptoken"]])], 200);
                    }
                }
            } else {
                $failed_data = array(
                    'token' => $formData["ptoken"],
                    'current_time' => Carbon::now()->timestamp,
                    'currency' => $formData['currency'],
                    'itemprice' => $formData['itemprice'],
                    'itemname' => $formData['itemname'],
                    'title' => 'Payment Failed | ' . $formData['currency'] . $formData['itemname'] . ' | Message:' . $formData["payment_message"],
                    'heading' => 'Payment Failed',
                    'message' => $formData["payment_message"]
                );

                Session::flash("failed_data", $failed_data);

                return response()->json(['failed' => true, 'route' => route('payment.failed', ["token" => $formData["ptoken"]])], 200);
            }
        } catch (Exception $e) {
            report($e);
            Log::error("Token: " . $formData["ptoken"] . " has an exception on Storing Payment. Message: " . $e->getMessage());

            $failed_data = array(
                "token" => $formData["ptoken"],
                'current_time' => Carbon::now()->timestamp,
                'currency' => $formData['currency'],
                'itemprice' => $formData['itemprice'],
                'itemname' => $formData['itemname'],
                'title' => 'Payment Failed | ' . $formData['currency'] . $formData['itemname'] . ' | Message: ' . $e->getMessage(),
                'heading' => 'Payment Failed',
                'message' => $e->getMessage()
            );

            Session::flash("failed_data", $failed_data);

            return response()->json(['failed' => true, 'route' => route('payment.failed', ["token" => $formData["ptoken"]])], 200);
            //return redirect()->back()->with(["error"=> $e->getCode(), "message"=> $e->getMessage()]);
        }
    }

    protected function paymentLinkStatus($paymentLink_id, $status)
    {
        $paymentLink = PaymentLink::find($paymentLink_id);
        $paymentLink->status = $status;

        if ($paymentLink->save()) {
            return true;
        } else {
            return false;
        }
    }

    protected function redeemCoupon(Request $request)
    {
        $data = array();
        $json = array();

        if (!empty($request->coupon)) {
            $retrieve = Coupon::where('coupon_name', $request->coupon)->first();
            if (!empty($retrieve) && $retrieve != NULL) {
                date_default_timezone_set('America/New_York');
                $now = date('Y-m-d');

                if (($retrieve->date_from < $now) && ($retrieve->date_to > $now)) {
                    if ($retrieve->quantity > 0) {
                        $json[] = array("coupon_id" => $retrieve->id, "coupon" => $retrieve->coupon_name, "discount" => $retrieve->discount, "discount_type" => $retrieve->discount_type, "message" => "Coupon Applied Successfully.", "message_type" => "success");
                        $data['data'] = $json;
                    } else {
                        $json[] = array("coupon_id" => $retrieve->id, "coupon" => $retrieve->coupon_name, "discount" => $retrieve->discount, "discount_type" => $retrieve->discount_type, "message" => "Expired coupon", "message_type" => "error");
                        $data['data'] = $json;
                    }
                } else {
                    $json[] = array("message" => "Coupon expired.", "message_type" => "error");
                    $data['data'] = $json;
                }

                echo json_encode($data);
            } else {
                $json[] = array("message" => "Enter a valid coupon.", "message_type" => "error");
                $data['data'] = $json;
                echo json_encode($data);
            }
        } else {
            $json[] = array("message" => "Enter a valid coupon.", "message_type" => "error");
            $data['data'] = $json;
            echo json_encode($data);
        }
    }

    public function sendEmailToClient(Request $request)
    {
        $invoice_data = Invoice::where('invoice_no', $request['invoice_id'])->first();
        $customer_id = $invoice_data->customer_id;
        $this->sendreceipt($customer_id);
        return InvoiceController::email_sent($customer_id);
    }

    public function previousData(Request $request)
    {
        $path = 'data/' . $request->token . '.json';
        $file_content = file_get_contents($path);
        $oldInput = json_decode($file_content, true);

        $item_detail = PaymentLink::where("token", "=", $request->token)->first();
        $country_currency = CountryCurrencies::find($item_detail->currency);
        $finishTime = Carbon::now()->timestamp($item_detail->valid_till);
        $currentTime =  Carbon::now();

        $gateway_setting = BrandSettings::where("key_name", "=", $item_detail->payment_gateway)->first();
        $payment_gateway = json_decode($gateway_setting->key_value);

        Session()->put('payment_gateway', $payment_gateway);


        $countries = CountryCurrencies::orderBy('country_name', 'ASC')->get();

        $gateway_name = explode("_", $item_detail->payment_gateway);
        if ($gateway_name[3] == "three") {
            return view('frontend.payments.three_step', compact('item_detail', 'countries', 'country_currency', 'payment_gateway', 'oldInput'));
        } else {
            return view('frontend.payments.pay-page', compact('item_detail', 'countries', 'country_currency', 'payment_gateway', 'oldInput'));
        }
    }

    protected function sendreceipt($customer_id)
    {
        $customer = User::find($customer_id);
        $user_invoice = Invoice::where('customer_id', $customer_id)->latest('id')->first()->toArray();
        $customer_info = User::find($user_invoice['customer_id'])->toArray();
        $payment_info = Payments::find($user_invoice['payment_id'])->toArray();
        $brandSettings = Arr::pluck(Setting::get(), 'key', 'value');
        $currency_info = CountryCurrencies::find($payment_info['currency'])->toArray();

        $gateway_name = str_replace("payment_gateway_", "", $payment_info['payment_gateway']);
        $gateway_name = str_replace("_", " ", $gateway_name);
        $gateway_name = Str::upper($gateway_name);

        $fullname = $customer_info["first_name"] . " " . $customer_info["last_name"]; // put here client's firstname and last name

        $curreny_symbol = (isset($currency_info["currency_symbol"]) ? $currency_info["currency_symbol"] . " " : "");
        $content = "New payment was successfully received through Stripe.com" . "<br>" . "Customer Email: " . $customer_info['email'] . "<br>Payment total is: $" . $payment_info['price'] . "." . "00<br><br>Billing information:<br>Item name: " . $payment_info['item_name'] . "<br>Full name: " . $customer_info["first_name"] . " " . $customer_info["last_name"] . "<br>Email: " . $customer_info['email'] . "<br>Phone: " . $customer_info['phone_number'] . "<br>Company: " . $customer_info['company_name'] . "<br>State: " . $customer_info['state'] . "<br>City : " . $customer_info['city'] . "<br>Address: " . $customer_info['address'] . "<br>Post code: " . $customer_info['zipcode'] . "<br>Country: " . $customer_info['country'] . "<br>Payment Gateway: " . $gateway_name . "<br>Payment Type: This is a custom payment.";
        $data = array(
            "curreny_symbol" => !empty($curreny_symbol) ? $curreny_symbol : '',
            "price" => !empty($payment_info['price']) ? $payment_info['price'] : '',
            "content" => !empty($content) ? $content : '',
        );

        $setSMTP = new SmtpConfig('billing', 'billing@logura.com');

        if (!empty($customer_info['email'])) {
            Mail::to('billing@logura.com')->send(new ReceiptMail($data));
            return true;
        } else {
            return response()->json(['status' => false, "message" => "Invoice not sent."]);
        }
    }

    protected function formatAndMaskCard($cardNumber)
    {
        // Break into segments
        $segments = explode(' ', $cardNumber);

        // Number of digits that should remain visible
        $visibleDigits = 4;

        // Go through the segments from the end
        for ($i = count($segments) - 1; $i >= 0; $i--) {
            $segment = $segments[$i];
            for ($j = strlen($segment) - 1; $j >= 0; $j--) {
                if ($visibleDigits > 0) {
                    // Decrement our counter
                    $visibleDigits--;
                } else {
                    $segment[$j] = '*';
                }
            }
            // Replace original segment with the masked one
            $segments[$i] = $segment;
        }

        return implode(' ', $segments);
    }

    public function checkout(Request $request)
    {
        $countries = CountryCurrencies::all();

        return Inertia::render('CheckOutTesting', [
            'countries' => $countries
        ]);
    }

    public function paynow(Request $request)
    {
        $current_date_time = sha1(uniqid(Carbon::now()->toDateTimeString(), true));
        $token = sha1(uniqid($current_date_time, true));
        $item = urldecode($request['item']);
        $category = urldecode($request['category']);
        $currency_code = (!empty($request['currency_code']) ? $request['currency_code'] : 'USD');
        $currency_info = CountryCurrencies::where('code', $currency_code)->first();
        $default_payment_gateway = Setting::where("key", '=', "default_payment_gateway")->first();

        $paymentGateway = PaymentGateway::where('name', $default_payment_gateway->value)->first();

        $user = User::where('email', 'alex.logoorbit@gmail.com')
            ->whereHas('roles', function ($query) {
                $query->where('name', 'Super Admin');
            })
            ->latest('id')
            ->first();

        $paymentlink = new PaymentLink();
        $paymentlink->valid_till = Carbon::now()->addHours(48)->timestamp;
        $paymentlink->item_name = $item;
        $paymentlink->price = $request['amount'];
        $paymentlink->original_price = $request['amount'];
        $paymentlink->discount = 0;
        $paymentlink->discount_type = 'flat';
        $paymentlink->sale_type = 'fresh_sales';
        $paymentlink->currency = $currency_info->id;
        $paymentlink->payment_type = "straight";
        $paymentlink->token = $token;
        $paymentlink->team = 1;
        $paymentlink->payment_gateway = $paymentGateway->id;
        $paymentlink->show_coupon = 0;
        $paymentlink->created_by = $user->id;
        $paymentlink->save();

        $categories = explode("plus", $category);
        foreach ($categories as $item) {
            $item_name = trim($item);
            $category_info = Category::where('name', $item_name)->first();
            $category = new PaymentlinkCategory();
            $category->paymentlink_id = $paymentlink->id;
            $category->category_id = $category_info->id;
            $category->created_by = $user->id;
            $category->save();
        }

        $link = route('paynow.stripe', ['token' => $token]);

        // return response()->json(['success' => true, 'route' => $link], 200);
        return redirect($link);
    }
}
