<?php

namespace App\Http\Controllers\Admin;

use App\Helper\Helper\NotificationHelper;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Inertia\Inertia;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Helper\ActivityLogHelper;

class TwoFactorAuthController extends Controller
{
    public function show2faForm()
    {
        $user = auth()->user();
        if (!$user) {
            return redirect()->route('login');
        }

        $brand_settings = Arr::pluck(Setting::get(), 'value', 'key');


        if ($user && $user->two_step == 1 && $user->google2fa_secret === null && $user->two_step_checked === null) {
            return Inertia::render('TwoStep', ['phoneNumber' => $user->phone, 'email' => $user->email, 'brand_settings' => $brand_settings]);
        } else if ($user && $user->two_step == 1 && $user->google2fa_secret === null && Carbon::parse($user->two_step_checked)->lessThan(Carbon::now()->subWeek())) {
            return Inertia::render('TwoStep', ['phoneNumber' => $user->phone, 'email' => $user->email, 'brand_settings' => $brand_settings]);
        } else {
            return redirect()->route('admin.dashboard');
        }

    }

    public function sendVerificationCodes(Request $request)
    {
        $user = auth()->user();
        if (!$user) {
            return redirect()->route('login')->withErrors('You must be logged in to perform this action.');
        }
        $verificationCode = $request->input('verificationCode');
        if (!$verificationCode) {
            Session::flash('success', false);
            Session::flash('message', 'Verification code is required.');
            return redirect()->back();
        }
        $user->google2fa_secret = $verificationCode;
        $user->two_step_checked = Carbon::now();
        $userUpdated = $user->save();

        // Log the activity before logging out
        // ActivityLogHelper::staticLogActivity(
        //     '2fa-verification ',
        //     '2FA Verification successfully'
        // );

        if ($userUpdated) {
            $data['success'] = true;
            $data['message'] = 'Verification successfully.';
        } else {
            $data['success'] = false;
            $data['message'] = 'Failed to verify OTP. Please try again.';
        }

        return response()->json($data);
    }


    public function twoStepAuthenticationEnable(Request $request)
    {
        $userData = $request->userData;
        $user = User::findOrNew($userData['id']);

        if (!$user) {
            return redirect()->route('admin.staff.list', ['id' => $userData['id']])->with('message', 'User Not Found.');
        }
        $verificationCode = $request->input('verificationCode');

        $user->google2fa_secret = $verificationCode;
        $user->phone = $request->phoneNumber;
        $user->two_step = 1;
        $user->two_step_created = Carbon::now();
        $userUpdated = $user->save();
        if ($userUpdated) {
            $data['success'] = true;
            $data['message'] = 'OTP verified successfully.';
        } else {
            $data['success'] = false;
            $data['message'] = 'Failed to verify OTP. Please try again.';
        }
        return response()->json($data);
    }

    public function verifyPassword(Request $request)
    {

        $rules = [
            'password' => 'required|string|min:8',
        ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
            ]);
        } else {
            $authUser = Auth::user();
            $user = User::find($authUser->id);
            if (Hash::check($request->password, $user->password)) {
                return $this->disable($request->id);

            } else {
                return response()->json(['errors' => ['password' => ['Incorrect password.']]]);
            }
        }

    }


    public function disable($userID)
    {
        $user = User::find($userID);
        $user->two_step = 0;
        $userUpdated = $user->save();

        if ($userUpdated) {
            $data['success'] = true;
            $data['message'] = 'Two Step Authentication Removed.';
        } else {
            $data['success'] = false;
            $data['message'] = 'Failed to Disable Authentication. Please try again.';
        }

        return response()->json($data);
    }
}
