<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CountryCurrencies;
use App\Models\Payment;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Inertia\Inertia;
use Jenssegers\Agent\Agent;

class ProfileController extends Controller
{
    public function profile(Request $request)
    {
        $user = User::select('id', 'first_name', 'last_name', 'email', 'phone', 'image', 'address', 'company', 'country', 'state', 'city', 'zipcode', 'facebook', 'instagram', 'linkedin', 'created_by', 'created_at')->find($request->user()->id);

        $userRole = $user->roles->first()->name;

        $dateFrom = Carbon::now()->subDays(7)->format('Y-m-d');
        $dateTo = Carbon::now()->format('Y-m-d');

        $graphPayments = [
            'payments' => 0,
            'failedpayments' => 0,
            'customers' => 0,
            'spendpercustomer' => 0,
        ];

        $allPayments = Payment::select('id', 'payment_link_id', 'price', 'status')->whereHas('link', function ($link) use ($request) {
            $link->where('created_by', $request->user()->id);
        })->whereDate('created_at', '>=', $dateFrom)->whereDate('created_at', '<=', $dateTo)->get();

        $spendpercustomer = Payment::select('id', 'payment_link_id', 'price', 'status')->whereHas('link', function ($link) use ($request) {
            $link->where('created_by', $request->user()->id);
            $link->where('status', 2);
        })->where('status', 1)->whereDate('created_at', '>=', $dateFrom)->whereDate('created_at', '<=', $dateTo)->get();

        $graphPayments['payments'] = number_format($allPayments->where('status', 1)->sum('price'));
        $graphPayments['failedpayments'] = number_format($allPayments->where('status', 2)->sum('price'));
        $graphPayments['customers'] = number_format($allPayments->count('price'));
        $graphPayments['spendpercustomer'] = number_format($spendpercustomer->count() > 0 ? $spendpercustomer->sum('price') / $spendpercustomer->count() : 0);

        $payments = Payment::select('id', 'payment_link_id', 'price')->whereHas('link', function ($link) use ($request) {
            $link->where('created_by', $request->user()->id);
        })->where('status', 1);
        $balanceAmount = number_format($payments->sum('price'));
        $monthlyBalanceAmount = number_format($payments->whereMonth('created_at', Carbon::today())->sum('price'));
        $dailyBalanceAmount = number_format($payments->whereDate('created_at', Carbon::today())->sum('price'));

        $userBalance = [
            'totalBalance' => $balanceAmount,
            'monthBalance' => $monthlyBalanceAmount,
            'dayBalance' => $dailyBalanceAmount
        ];

        $userSession = [];
        $sessionData = DB::table('sessions')->select('id', 'user_id', 'ip_address', 'user_agent', 'payload', 'last_activity')->where('user_id', $request->user()->id)->get();
        $sessionData->map(function ($session) use (&$userSession) {
            $agent = new Agent();
            $agent->setUserAgent($session->user_agent);
            $data = unserialize(base64_decode($session->payload));
            $userSession[] = [
                'id' => $session->id,
                'user_id' => $session->user_id,
                'ip_address' => $session->ip_address,
                'country' => (!empty($data['country']) ? $data['country'] : ''),
                'user_agent' => $session->user_agent,
                'device' => $agent->device(),
                'platform' => $agent->platform(),
                'isMobile' => $agent->isPhone(),
                'isDesktop' => $agent->isDesktop(),
                'browser' => $agent->browser(),
                'last_activity' => $session->last_activity,
                'current_session' => Session::getId() == $session->id
            ];
        });

        $countries = CountryCurrencies::select('id', 'aplha_code3', 'currency', 'code', 'symbol', 'country')
            ->orderBy('currency', 'ASC')
            ->get();

        return Inertia::render('Admin/Profile/Profile', [
            'user' => $user,
            'userRole' => $userRole,
            'userBalance' => $userBalance,
            'graphPayments' => $graphPayments,
            'sessionData' => $userSession,
            'countries' => $countries
        ]);
    }

    public function update(Request $request)
    {

        // dd($request->all());

        $rules = [
            'image'  => 'nullable|image|mimes:jpeg,jpg,png|max:2048',
            'first_name' => 'nullable|string',
            'last_name' => 'nullable|string',
            'phone' => 'nullable|string',
            'company' => 'nullable|string',
            'address' => 'nullable|string',
            'city' => 'nullable|string',
            'state' => 'nullable|string',
            'zipcode' => 'nullable|string'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()->first(),
            ]);
        } else {

            $user = User::find($request->user()->id);

            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $timestamp = str_replace([' ', ':'], '-', Carbon::now()->toDateTimeString());
                $imageName = $timestamp . '-' . str_replace([' ', ':'], '-', $file->getClientOriginalName());
                $file->move(public_path('images/user'), $imageName);
                $imageUrl = asset('images/user/' . $imageName);
                $admin['image'] = $imageUrl;
            }

            if ($request->filled('first_name')) {
                $user->first_name = $request->input('first_name');
            }

            if ($request->filled('last_name')) {
                $user->last_name = $request->input('last_name');
            }

            if ($request->filled('phone')) {
                $user->phone = $request->input('phone');
            }

            if ($request->filled('company')) {
                $user->company = $request->input('company');
            }

            if ($request->filled('address')) {
                $user->address = $request->input('address');
            }

            if ($request->filled('city')) {
                $user->city = $request->input('city');
            }

            if ($request->filled('state')) {
                $user->state = $request->input('state');
            }

            if ($request->filled('zipcode')) {
                $user->zipcode = $request->input('zipcode');
            }

            $user->save();

            return Redirect::route('admin.profile');
        }
    }
}
