<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PaymentLink;
use App\Models\PaymentLog;
use App\Services\LogService;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Inertia\Inertia;

class PaymentLogController extends Controller
{
    private $logger;

    function __construct(LogService $logger)
    {
        $this->logger = $logger;
    }

    public function logDetail(Request $request, $id)
    {
        $logDetail = PaymentLog::where("id", $id)->first();

        return Inertia::render('Admin/Logs/Detail', [
            'logDetail' => $logDetail,
        ]);
    }

    public function eventDetail(Request $request, $id)
    {
        $eventDetail = PaymentLog::where("id", $id)->first();

        return Inertia::render('Admin/Events/Detail', [
            'eventDetail' => $eventDetail,
        ]);
    }

    public function getLog($id)
    {
        $data['success'] = true;
        try {
            $data['data'] = $this->logger->getLogsByPaymentId($id);

            Redirect::route('');
        } catch (Exception $ex) {
        }
    }

    public function create(Request $request, $id)
    {
        try {
            $log = $request->only(['activity', 'type', 'request', 'response', 'log_type', 'routeTo']);
            $log['loggable_id'] = $id;
            $log['created_by'] = Auth::id();
            $log = $this->logger->log($log['log_type'], $log, $log['routeTo'] ?? "");

            return Redirect::route($log['route'], ['id' => $id]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function update(Request $request, $id, $logID)
    {
        try {

            $log = $request->only(['activity', 'pin', 'log_type', 'routeTo']);

            if (isset($log['activity']) && !empty($log['activity'])) {
                $data['loggable_id'] = $id;
                $data['log_type'] = $log['log_type'];
                $data['created_by'] = Auth::id();
                $data['activity'] = $log['activity'];
                $data = $this->logger->update($logID, $data, $log['routeTo'] ?? '');
            }

            if (isset($log['pin'])) {
                $data = $this->logger->pinLog($logID, $id, $log['log_type'], $log['pin'], $log['routeTo'] ?? '');
            }

            return Redirect::route($data['route'], ['id' => $id]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
    }

    public function delete(Request $request, $id, $logID)
    {
        try {
            $log = $request->only(['log_type', 'routeTo']);
            $log = $this->logger->delete($logID, $log['log_type'], $log['routeTo'] ?? '');

            return Redirect::route($log['route'], ['id' => $id]);
        } catch (Exception $ex) {
            dd($ex->getMessage());
        }
    }
}
