<?php

namespace App\Http\Controllers\Admin;

use App\Helper\Helper\NotificationHelper;
use App\Http\Controllers\Controller;
use App\Models\CountryCurrencies;
use App\Models\Notification;
use App\Models\User;
use App\Repositories\Customer\CustomerInterface;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Inertia\Inertia;


class NotificationController extends Controller
{
    public function list(Request $request, $id = null)
    {
        // dd($request);
        $user = $request->user();
        $page["title"] = "Customers - NotificationModule";
        $columns = array(
            array("key" => "type", "component" => 'NameColumn', "text" => "Notification", "visible" => true, "fixed" => true),
            array("key" => "date", "component" => 'DateColumn', "text" => "Date", "visible" => true),
        );

        $statuses = ['Unread', 'All'];
        $notificationsQuery = Notification::query()
            ->select('id', 'type', 'notifiable_type', 'notifiable_id', 'data', 'read_at', 'created_at',)
            ->latest('created_at');
        if (!empty($request->id)) {
            // Filter by specific ID
            // $statuses = ['Unread'];
            $notificationsQuery->where('id', $request->id);

            // $this->markOneRead($request->id);
        } else {
            // $statuses = ['Unread', 'All'];
            $notificationsQuery->when(!empty($request->type && array_search($request->status_all, $statuses)), function ($query) use ($request, $statuses) {
                if ($request->status_all != 'All') {
                    $query->whereNull('read_at');
                }
            })
                ->when((!empty($request->date) && !empty($request->dateSearchBy) && !empty($request->durationType)), function ($query) use ($request) {
                    if ($request->dateSearchBy == '=') {
                        $query->whereDate('created_at', $request->date);
                    } else {
                        $date = Carbon::today();
                        if ($request->durationType == 'days') {
                            $date->modify(($request->dateSearchBy == '<' ? '-' : '+') . $request->date . ' days');
                        } elseif ($request->durationType == 'months') {
                            $date->modify(($request->dateSearchBy == '<' ? '-' : '+') . $request->date . ' months');
                        }
                        $comparisonOperator = $request->dateSearchBy == '<' ? '>' : '<';
                        $formattedDate = $date->format('Y-m-d H:i:s');
                        $startDate = $comparisonOperator == '>' ? $formattedDate : Carbon::today()->format('Y-m-d H:i:s');
                        $endDate = $comparisonOperator == '<' ? $formattedDate : Carbon::today()->format('Y-m-d H:i:s');
                        $query->whereBetween('created_at', [$startDate, $endDate]);
                    }
                })
                ->when(!empty($request->status_all && array_search($request->status_all, $statuses)), function ($query) use ($request, $statuses) {
                    if ($request->status_all != 'All') {
                        $query->whereNull('read_at');
                    }
                })
                ->when(!empty($request->type), function ($query) use ($request) {
                    $query->whereJsonContains('data->type', $request->type);
            });
        }
        // dd($notificationsQuery);
        $notifications = $notificationsQuery
            ->where('notifiable_id', Auth::id())
            ->latest('created_at')
            ->paginate(20)
            ->withQueryString();
        $notifications->getCollection()->transform(function ($notification) {
            $notification->data = json_decode($notification->data);
            return $notification;
        });
        $notificationTypes = [];

        foreach ($notifications as $noti) {
            $notificationTypes[] = $noti->data->title;
        }
        $uniqueNotificationTypes = array_values(array_unique($notificationTypes));
        // dd($uniqueNotificationTypes);

        return Inertia::render('Admin/Notification/List', [
            'columns' => $columns,
            'statuses' => $statuses,
            'page' => $page,
            'notifications' => $notifications,
            'notificationTypes' => $uniqueNotificationTypes,
        ]);
    }

    public function markAllRead(Request $request)
    {
        try {
            Auth::user()->unreadNotifications->markAsRead();
            $data['success'] = true;
            $data['message'] = "Notification Read Successfully";
        } catch(Exception $e) {
            $data['success'] = false;
            $data['message'] = $e->getMessage();
        }

        return response()->json($data);
        // return redirect()->route('admin.notification');
    }
    public function markOneRead($id)
    {
        $notification = Notification::find($id);
        if ($notification) {
            $notification->read_at = now();
            $notification->save();
        }
        return Redirect::route('admin.notification');
    }
    public function popup(Request $request)
    {
        $notifications = Notification::orderBy('created_at', 'desc')
            ->where('notifiable_id', Auth::id())
            ->latest('id')->get();
        return response()->json($notifications);
    }

    public function newFeatures(Request $request)
    {
        NotificationHelper::notify('role-feature', 'Super admins can now create multiple roles.', [
            'request' => response()->json('New User Role Feature Added Successful')->content(),
            'message' => 'New User Role Feature Added Successful',
        ], Auth::user()->id);

        NotificationHelper::notify('coupon-feature', 'You can create and manage coupon codes in checkout while creating payment links, and you can hide or show the coupon code field through single click.', [
            'request' => response()->json('New User Role Feature Added Successful')->content(),
            'message' => 'New User Role Feature Added Successful',
        ], Auth::user()->id);

        NotificationHelper::notify('activitieslog-feature', 'Logs and activities have been explained in more detail so that every customer activity can be tracked.', [
            'request' => response()->json('New User Role Feature Added Successful')->content(),
            'message' => 'New User Role Feature Added Successful',
        ], Auth::user()->id);
    }
}
