<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\CountryCurrencies;

class CountryCurrenciesController extends Controller
{
    public function list(Request $request) {
        $data['success'] = true;
        try {
            $countries = CountryCurrencies::select('id','aplha_code3','currency','code','symbol','country')
                        ->orderBy('currency','ASC')
                        ->get();

            $data['data'] = $countries;
        } catch (\Exception $e) {
            $data['message'] = $e->getMessage();
        }
        return response()->json($data);
    }
}
