<?php

namespace App\Helper\Helper;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class StripeHelper
{
  // Generating unique id like in stripe
  public static function generateUniqueID($prefix, $length)
  {
    $uniqueId = Str::random($length) . uniqid();
    return $prefix . '_' . $uniqueId;
  }

  // create file for the data against token
  public static function createFile($token, $data)
  {
    // Encrypt the data
    $dataToEncrypt = json_encode($data);
    $encryptedData = encrypt($dataToEncrypt);

    $filePath = "links/$token.txt"; // Define the path to your text file

    Storage::put($filePath, $encryptedData);

    return true;
  }

  public static function readFile($token)
  {
    $data['success'] = true;

    $filePath = "links/$token.txt";

    if (Storage::exists($filePath)) {
      // File exists, read its contents
      $contents = Storage::get($filePath);
      $decryptedData = decrypt($contents);
      $decodedData = json_decode($decryptedData, true);
      $data['data'] = $decodedData;
    } else {
      $data['code'] = 404;
      $data['success'] = false;
      $data['message'] = 'File does not exist';
    }

    return $data;
  }

  public static function maskNumber($number)
  {
    // Mask all but the last 4 digits
    $maskedNumber = str_repeat('*', strlen($number) - 4) . substr($number, -4);

    return $maskedNumber;
  }

  public static function removeKey($obj, $key)
  {
    if (isset($obj->{$key})) {
      unset($obj->{$key});
      return true;
    }

    return false;
  }

  public static function paymentStatuses()
  {
    return ['all', 'succeeded', 'failed', 'incomplete', 'processing', 'canceled', 'blocked', 'disputed', 'early_fraud_warning', 'partially_refunded', 'refund_pending', 'refunded', 'uncaptured', 'draft_invoice', 'already_refunded', 'manual'];
  }


  public static function getStatuses(array $indices)
  {
    $statuses = self::paymentStatuses();
    $selectedStatuses = [];

    foreach ($indices as $index) {
      if (isset($statuses[$index])) {
        $selectedStatuses[$statuses[$index]] = $index;
      }
    }

    return $selectedStatuses;
  }

  public static function getStatusByValue($value)
  {
    $statuses = self::paymentStatuses();
    $key = 0;

    if (isset($statuses) && !empty($statuses)) {
      foreach ($statuses as $index => $status) {
        if ($status == $value) {
          $key = $index;
          return $key;
        }
      }
    }

    return false;
  }
}
