<?php

namespace App\Helper;

use App\Services\LogsService;

class LogsHelper {
    public static function getAllLogs($id, $folder = null) {
        $logsService = new LogsService('logs' . '/' . lcfirst($folder) . 'Logs');
        return $logsService->getAllLogs($id);
    }

    public static function log($data, $folder = null) {
        $logsService = new LogsService('logs' . '/' . lcfirst($folder) . 'Logs');
        return $logsService->log($data);
    }

    public static function updateLog($logId, $classID, $data, $folder = null) {
        $logsService = new LogsService('logs' . '/' . lcfirst($folder) . 'Logs');
        return $logsService->updateLog($logId, $classID, $data);
    }

    public static function deleteLog($logId, $classID, $folder = null) {
        $logsService = new LogsService('logs' . '/' . lcfirst($folder) . 'Logs');
        return $logsService->deleteLog($logId, $classID);
    }

    public static function pinUnpinLog($logId, $classID, $pin, $folder = null) {
        $logsService = new LogsService('logs' . '/' . lcfirst($folder) . 'Logs');
        return $logsService->pinUnpinLog($logId, $classID, $pin);
    }

    public static function quoteClasses($class)
    {
        $commentable = [
            'mobile_app_brief' => [
                'route' => 'app.brief-detail.detail',
                'class' => 'App\Models\MobileAppBrief'
            ],
            'smm_brief' => [
                'route' => 'smm.brief-detail.detail',
                'class' => 'App\Models\SmmBrief'
            ],
            'sem_brief' => [
                'route' => 'sem.brief-detail.detail',
                'class' => 'App\Models\SemBrief'
            ],
            'web_brief' => [
                'route' => 'web.brief-detail.detail',
                'class' => 'App\Models\WebBrief'
            ],
            'brief_link' => [
                'route' => 'brief.link.detail',
                'class' => 'App\Models\BriefLink'
            ],
            'brief' => [
                'route' => 'brief-detail.detail',
                'class' => 'App\Models\Brief'
            ],
            'video_brief' => [
                'route' => 'video.brief-detail.detail',
                'class' => 'App\Models\VideoBrief'
            ],
        ];

        return $commentable[self::formatToSnake($class)];
    }


    private static function formatToSnake($value) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $value));
    }
}
