<?php

namespace App\Console\Commands;

use App\Models\LoginHistory;
use App\Services\LoginHistoryService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class CheckExpiredSessions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sessions:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check for expired sessions and log out users if necessary.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $cutoffTime = Carbon::now()->subHours(12);

        $expiredSessions = LoginHistory::with('user')
            ->whereNull('duration')
            ->where('created_at', '<', $cutoffTime)
            ->get();

        foreach ($expiredSessions as $loginHistory) {
            $user = $loginHistory->user;

            if ($user) {
                // Update logout history
                $createLogoutHistory = (new LoginHistoryService)->update($user->id, $loginHistory->session_id);

                $sessionHandler = Session::getHandler();
                $sessionHandler->destroy($loginHistory->session_id);
            }
        }

        $this->info('Expired sessions check completed.');
    }
}
