<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 100%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    vertical-align: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}
.checkbox-description span{
    vertical-align: 5px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}


.radio_text{
    margin-left: 0.5rem;
    cursor: pointer;
}

.radio_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.radio_row label{
    margin-bottom: 0;
    vertical-align: 3px;
}

@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}
  </style>
</head>

<body>
    
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">Brand 10X Brief Form</h1>
                <p class="header-description description"></p>
                <p class="header-description description"></p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_name" class="input-label mb-2">Business Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Name" name="business_name" class="input business-email-input" value="{{ $formData["business_name"] }}" >
                        </fieldset>
                    </section>

                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Owner's Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif

                    @php
                    // Remove underscores and capitalize first word
                    $industry = ucwords(str_replace('_', ' ', $formData['industry']));
                    @endphp
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="industry" class="input-label mb-2">Business Industry <span class="asterisk">*</span></label>
                            <select name="industry" class="input">
                                <option value="{{ $formData['industry'] }}" selected>{{ $industry }}</option>
                            </select>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_email" class="input-label mb-2">Business Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Email" name="business_email" class="input business-email-input" value="{{ $formData["business_email"] }}" >
                        </fieldset>
                    </section>
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Business Contact Number <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Contact Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="services" class="input-label mb-2">Business Product / Services: (Compulsory) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Services" name="services" class="input services-input" value="{{ $formData["services"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_goal" class="input-label mb-2">Business Goal: (Compulsory) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Business Goal" name="business_goal" class="input business-goal-input" value="{{ $formData["business_goal"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="slogan" class="input-label mb-2">Brand Slogan or Tagline or Brand Promise: (Compulsory) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Business's Slogan" name="slogan" class="input slogan-input" value="{{ $formData["slogan"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="company_address" class="input-label mb-2">Registered Company Address: (Compulsory) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Company Address" name="company_address" class="input company-address-input" value="{{ $formData["company_address"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="unique_service" class="input-label mb-2">Why do you think your product/service is unique? What makes you different? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Answer" name="unique_service" class="input unique-service-input" value="{{ $formData["unique_service"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="audience" class="input-label mb-2">Target Audience <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Targeted Audience" name="audience" class="input audience-input" value="{{ $formData["audience"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_link" class="input-label mb-2">Website Link <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Website Link" name="website_link" class="input website-link-input" value="{{ $formData["website_link"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website_hosting" class="input-label mb-2">Website Hosting Provider <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Website Hosting" name="website_hosting" class="input website-hosting-input" value="{{ $formData["website_hosting"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="competitors_website" class="input-label mb-2">Competitors website links which are similar with your business <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Answer" name="competitors_website" class="input competitors-website-input" value="{{ $formData["competitors_website"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="facebook_link" class="input-label mb-2">Facebook Page Link (If they exist) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Facebook Page Link" name="facebook_link" class="input facebook-link-input" value="{{ $formData["facebook_link"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="instagram_link" class="input-label mb-2">Instagram Account Link (If they exist) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Instagram Account Link" name="instagram_link" class="input instagram-link-input" value="{{ $formData["instagram_link"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="pinterest_link" class="input-label mb-2">Pinterest Account Link (If they exist) <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Pinterest Account Link" name="pinterest_link" class="input pinterest-link-input" value="{{ $formData["pinterest_link"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="social_media_competitors" class="input-label mb-2">Social Media Competitors links which are similar with your business <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Answer" name="social_media_competitors" class="input social-media-competitors-input" value="{{ $formData["social_media_competitors"] }}" >
                        </fieldset>
                    </section>
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>
  
  <script src="{{ asset(mix('js/app.js')) }}"></script>