<!DOCTYPE html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable" data-sidebar-visibility="show" data-layout-style="default" data-layout-mode="light" data-layout-width="fluid" data-layout-position="fixed">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

  <!-- App favicon -->
  <link rel="shortcut icon" href="assets/images/favicon.ico" />

  <!-- Layout config Js -->
  <script src="{{ asset('backend/js/layout.js') }}"></script>
  <!-- Bootstrap Css -->
  <link href="{{ asset('backend/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- Icons Css -->
  <link href="{{ asset('backend/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
  <link href="{{ asset('backend/fonts/SegoeUI/style.css') }}" rel="stylesheet" type="text/css" />
  <!-- App Css-->
  <link href="{{ asset('backend/css/app.min.css') }}" rel="stylesheet" type="text/css" />
  <!-- custom Css-->
  <link href="{{ asset('backend/css/custom.min.css') }}" rel="stylesheet" type="text/css" />
  <style>
    body {
        font-family: apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif, 'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    }
   .main-div{
    background-color: #ebebeb;
    height: 100%;
    width: 100%;
    padding: 2.5rem 1rem;
}

.sections-div{
    margin: auto;
    max-width: 50rem;
}

.border-top{
    border: none;
    padding: 0;
    height: 1.45rem;
    background-color: #625afa;
    margin-top: -31px;
    width: 800px;
    margin-left: -16px;
}
.section{
    background-color: white;
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 0.5rem;
    /* overflow: hidden; */
    }
.break-page {
    page-break-inside: avoid;
}
.header-section{
    padding-top: 2rem;
    overflow: hidden;
}

.heading{
    font-weight: 600;
    color: #525252;
    margin-bottom: 0;
}

 .header-heading{
    margin-bottom: 1rem;
}

.header-description{
    margin: 10px 0;
}

.description{
    font-size: 14px;
    color: #666;
    line-height: 0.75rem;
}

.input-fieldset{
    margin-bottom: 1rem;
    display: flex;
    flex-direction: column;
    width: 100%;
    flex-basis: 50%;
    border: 1px solid rgba(0, 0, 0, 0);
}

.input-label{
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 0;
}

.label-description{
    font-size: 12px;
    color: #666;
    margin-top: -0.25rem;
}

.mb-2{
    margin-bottom: 0.5rem;
}

.input{
    min-height: 15px;
    height: auto;
    padding: 0.6rem;
    border-radius: 6px;
    border: 0;
    font-size: 12px;
    border: 2px solid #e5e5e5;
    width: 94%;
    margin-top: 0.3rem;
}

.input:focus{
    outline: none;
}

.checkbox_label{
    margin-left: 0.5rem;
    cursor: pointer;
}

.checkbox_row{
    display: flex;
    align-items: center;
    margin: 0.25rem 0;
}

.checkbox_row label{
    margin-bottom: 0;
    vertical-align: 5px;
}
.checkbox-grid{
    display: flex;
    flex-wrap: wrap;
    width: 40rem;
}

.checkbox-image-container{
    text-align: left;
    width: 100%;
}

.checkbox_image_label{
    display: inline-block;
    width: 45%;
    box-sizing: border-box;
    padding: 0.6rem;
    vertical-align: top;
    text-align: center;
    margin-bottom: 1rem;
}

.checkbox-image-option{
    width: 100%;
    height: auto;
}

.checkbox_image_label:has( input:checked) > .checkbox-image-option {
    border-color: #625afa;
}

.checkbox-description{
    text-align: left;
}

.checkbox-image-input {
    margin-right: 0.2rem;
}

.checkbox-image-input{
    align-self: self-start;
    margin-top: 0.25rem;
    scale: 1.25;
}

.checked-img {
    opacity: 1;
}
.unchecked-img {
    opacity: 0.2;
}
.checkbox-description span{
    vertical-align: 5px;
}
.submit-btn{
    display: block;
    width: 100%;
    background-color: #625afa;
    border: none;
    color: white;
    border-radius: 0.25rem;
    padding: 0.5rem 0;
    font-weight: 600;
}

.text-red{
    color: red;
}

.asterisk{
    color: red;
    font-size: 1.25rem;
}

.grayscale-text {
    --vz-text-opacity: 1;
    color: #878a99;
}

@media (max-width: 576px) {
    .checkbox_image_label {
        flex-basis: 100%;
    }
}
  </style>
</head>

<body>
    <?php
        function generateGrayscaleImage($imagePath) {
            $image = imagecreatefromjpeg($imagePath);
            imagefilter($image, IMG_FILTER_GRAYSCALE);
            ob_start();
            imagejpeg($image);
            $grayscaleImage = ob_get_contents();
            ob_end_clean();
            return 'data:image/jpeg;base64,' . base64_encode($grayscaleImage);
        }
    ?>
    
    <div class="main-div">
        <div class="sections-div">
            <section class="section header-section">
                <div class="border-top"></div>
                <h1 class="header-heading heading">Logo Brief Questionnaire</h1>
                <p class="header-description description">Please take your time on the submission below. The more detailed, accurate and extensive information provided, the higher quality logo design concepts you will receive.</p>
                <p class="header-description description">We will be needing your contact details to deliver your completed Logo work and/or contact you if we have any questions about your new logo concepts.</p>
                <p class="header-description description">
                    <b>NOTE:
                        <ul>
                            <li>
                                Your contact information is safe with us and are never shared with any third party.
                            </li>
                            <li>
                                <span class="asterisk">*</span> Indicates required question.
                            </li>
                        </ul>
                    </b>
                </p>
            </section>

            <form class="form">
                    @if($formData["email"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="email" class="input-label">Email <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Email" name="email" class="input email-input" value="{{ $formData["email"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    @if($formData["name"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="name" class="input-label">Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Name" name="name" class="input name-input" value="{{ $formData["name"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="designation" class="input-label">Designation <span class="asterisk">*</span></label>
                            <span class="label-description mb-2">for example, Owner, CEO, Manager, Director, etc</span>
                            <input type="text" placeholder="Enter Your Designation" name="designation" class="input designation-input" value="{{ $formData["designation"] }}" >
                        </fieldset>
                    </section>
                    @if($formData["phone"])
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="phone" class="input-label">Mobile No <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Mobile Number" name="phone" class="input phone-input" value="{{ $formData["phone"] }}" >
                        </fieldset>
                    </section>
                    @endif
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_name" class="input-label mb-2">Exact Logo Wording / Business Name <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Business Name" name="business_name" class="input business-name-input" value="{{ $formData["business_name"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="slogan" class="input-label mb-2">Tagline / Slogan (optional)</label>
                            <input type="text" placeholder="Enter Business's Slogan" name="slogan" class="input slogan-input" value="{{ $formData["slogan"] }}" >
                        </fieldset>
                    </section>
                    @php
                    // Remove underscores and capitalize first word
                    $industry = ucwords(str_replace('_', ' ', $formData['industry']));
                    @endphp
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="industry" class="input-label mb-2">Business Nature / Industry <span class="asterisk">*</span></label>
                            <select name="industry" class="input">
                                <option value="{{ $formData['industry'] }}" selected>{{ $industry }}</option>
                            </select>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="business_description" class="input-label mb-2">Business Description <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Business Description" name="business_description" class="input business-descripiton-input" value="{{ $formData["business_description"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="services" class="input-label mb-2">Business Products / Services <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Services" name="services" class="input services-input" value="{{ $formData["services"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="audience" class="input-label mb-2">Target Audience or Customers your want to target?</label>
                            <input type="text" placeholder="Enter Targeted Audience" name="audience" class="input services-input" value="{{ $formData["audience"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="website" class="input-label mb-2">Business Website</label>
                            <input type="text" placeholder="Enter Targeted Audience" name="website" class="input website-input" value="{{ $formData["website"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="competitor" class="input-label mb-2">Competitors or Similar Businesses (for reference purpose)</label>
                            <input type="text" placeholder="Enter Competitors' Name" name="competitor" class="input competitor-input" value="{{ $formData["competitor"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <div>
                            <h4 class="heading" style="margin-bottom: 0.4rem;">Logo Design Requirement</h4>
                            <span style="margin-top: 0;" class="description">To create your logo concepts, our designers want to know your thoughts on the ideal logo. Please be specific, as to ensure we have everything possible to design your perfect logo.</span>
                        </div>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">How do you want your logo to be written?</legend>
                            <div class="checkbox_row">
                                <input type="checkbox" id="as_it_is" name="logo_title[]" value="as_it_is" {{ in_array('as_it_is', $formData["logo_title"]) ? 'checked' : '' }}>
                                <label for="as_it_is" class="checkbox_label">As it is (as shared above)</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="capital_letters" name="logo_title[]" value="capital_letters" {{ in_array('capital_letters', $formData["logo_title"]) ? 'checked' : '' }}>
                                <label for="capital_letters" class="checkbox_label">In CAPITAL LETTERS</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="small_letters" name="logo_title[]" value="small_letters" {{ in_array('small_letters', $formData["logo_title"]) ? 'checked' : '' }}>
                                <label for="small_letters" class="checkbox_label">In small letters</label>
                            </div>
                            <div class="checkbox_row">
                                <input type="checkbox" id="open_to_ideas" name="logo_title[]" value="open_to_ideas" {{ in_array('open_to_ideas', $formData["logo_title"]) ? 'checked' : '' }}>
                                <label for="open_to_ideas" class="checkbox_label">Open to ideas</label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_idea" class="input-label mb-2">Please share if you already have an idea or concept of how you want your logo to be designed</label>
                            <input type="text" placeholder="Enter Logo's concept" name="logo_idea" class="input logo-idea-input" value="{{ $formData["logo_idea"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_message" class="input-label mb-2">Message, which should be communicated through your Logo?</label>
                            <input type="text" placeholder="Enter Logo's Message" name="logo_message" class="input logo-message-input" value="{{ $formData["logo_message"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_graphical_element" class="input-label mb-2">Any specific type of graphical element would you want to see in your logo?</label>
                            <input type="text" placeholder="Enter Logo's Graphical Element" name="logo_graphical_element" class="input logo-graphical-element-input" value="{{ $formData["logo_graphical_element"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_customer_likes" class="input-label mb-2">Logos & Elements, The customer likes (Do´s)</label>
                            <input type="text" placeholder="Enter Your Answer" name="logo_customer_likes" class="input logo-customer-likes-input" value="{{ $formData["logo_customer_likes"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_customer_dont_likes" class="input-label mb-2">Logos & Elements, The customer don't likes (Dont´s)</label>
                            <input type="text" placeholder="Enter Your Answer" name="logo_customer_dont_likes" class="input logo-customer-dont-likes-input" value="{{ $formData["logo_customer_dont_likes"] }}" >
                        </fieldset>
                    </section>
                  
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Font Based Logo (Select your preference)</legend>
                            <div class="checkbox-image-container">
                                <label for="just_font" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('just_font', $formData["font_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('just_font', $formData["font_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-1.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-1.jpg') }}" alt="">
                                    <div class="checkbox-description" >
                                        @if(in_array('just_font', $formData["font_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="just_font" name="font_base_logo[]" value="just_font" {{ in_array('just_font', $formData["font_base_logo"]) ? 'checked' : '' }} >
                                        @endif
                                        <span class="{{ in_array('just_font', $formData["font_base_logo"]) ? '' : 'grayscale-text' }}">Just font (Just font without any symbolic intervention).</span>
                                    </div>
                                </label>
                                <label for="handmade" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('handmade', $formData["font_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('handmade', $formData["font_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-2.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-2.jpg') }}"  alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('handmade', $formData["font_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="handmade" name="font_base_logo[]" value="handmade" {{ in_array('handmade', $formData["font_base_logo"]) ? 'checked' : '' }}>
                                        @endif
                                        <span class="{{ in_array('handmade', $formData["font_base_logo"]) ? '' : 'grayscale-text' }}">Handmade (A calligraphic, handwritten or script font).</span>
                                    </div>
                                </label>
                                <label for="initials" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('initials', $formData["font_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('initials', $formData["font_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-3.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-3.jpg') }}" alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('initials', $formData["font_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="initials" name="font_base_logo[]" value="initials" {{ in_array('initials', $formData["font_base_logo"]) ? 'checked' : '' }}>
                                        @endif
                                        <span class="{{ in_array('initials', $formData["font_base_logo"]) ? '' : 'grayscale-text' }}">Initials (Monogram with company name initials).</span>
                                    </div>
                                </label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <legend class="input-label mb-2">Font Based Logo (Select your preference)</legend>
                            <div class="checkbox-image-container">
                                <label for="abstract_graphic" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('abstract_graphic', $formData["graphic_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('abstract_graphic', $formData["graphic_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-4.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-4.jpg') }}" alt="">
                                    <div class="checkbox-description" >
                                        @if(in_array('abstract_graphic', $formData["graphic_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="abstract_graphic" name="graphic_base_logo[]" value="abstract_graphic" {{ in_array('abstract_graphic', $formData["graphic_base_logo"]) ? 'checked' : '' }}>
                                        @endif
                                        <span class="{{ in_array('abstract_graphic', $formData["graphic_base_logo"]) ? '' : 'grayscale-text' }}">Abstract graphic (A synthetic symbol that represents your Company in a subtle way).</span>
                                    </div>
                                </label>
                                <label for="silhouette" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('silhouette', $formData["graphic_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('silhouette', $formData["graphic_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-5.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-5.jpg') }}" alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('silhouette', $formData["graphic_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="silhouette" name="graphic_base_logo[]" value="silhouette" {{ in_array('silhouette', $formData["graphic_base_logo"]) ? 'checked' : '' }} >
                                        @endif
                                        <span class="{{ in_array('silhouette', $formData["graphic_base_logo"]) ? '' : 'grayscale-text' }}">Silhouette (A detailed illustrated silhouette).</span>
                                    </div>
                                </label>
                                <label for="illustrated_symbol" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('illustrated_symbol', $formData["graphic_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('illustrated_symbol', $formData["graphic_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-6.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-6.jpg') }}" alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('illustrated_symbol', $formData["graphic_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="illustrated_symbol" name="graphic_base_logo[]" value="illustrated_symbol" {{ in_array('illustrated_symbol', $formData["graphic_base_logo"]) ? 'checked' : '' }} >
                                        @endif
                                        <span class="{{ in_array('illustrated_symbol', $formData["graphic_base_logo"]) ? '' : 'grayscale-text' }}">Illustrated symbol (An illustrated symbol that clearly represents an element).</span>
                                    </div>
                                </label>
                                <label for="emblem_crests" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('emblem_crests', $formData["graphic_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('emblem_crests', $formData["graphic_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-7.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-7.jpg') }}" alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('emblem_crests', $formData["graphic_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="emblem_crests" name="graphic_base_logo[]" value="emblem_crests"  {{ in_array('emblem_crests', $formData["graphic_base_logo"]) ? 'checked' : '' }}>
                                        @endif
                                        <span class="{{ in_array('emblem_crests', $formData["graphic_base_logo"]) ? '' : 'grayscale-text' }}">Emblem and Crests (Enclosed logo with just text or including graphics).</span>
                                    </div>
                                </label>
                                <label for="mascot" class="checkbox_image_label">
                                    <img class="checkbox-image-option {{ in_array('mascot', $formData["graphic_base_logo"]) ? 'checked-img' : 'unchecked-img' }}" src="{{ in_array('mascot', $formData["graphic_base_logo"]) ? 'data:image/jpeg;base64,' . base64_encode(file_get_contents('backend/images/design-brief/image-8.jpg')) : generateGrayscaleImage('backend/images/design-brief/image-8.jpg') }}" alt="">
                                    <div class="checkbox-description">
                                        @if(in_array('mascot', $formData["graphic_base_logo"]))
                                            <input class="checkbox-image-input" type="checkbox" id="mascot" name="graphic_base_logo[]" value="mascot"  {{ in_array('mascot', $formData["graphic_base_logo"]) ? 'checked' : '' }}>
                                        @endif
                                        <span class="{{ in_array('mascot', $formData["graphic_base_logo"]) ? '' : 'grayscale-text' }}">Mascot (A character representing your Company).</span>
                                    </div>
                                </label>
                            </div>
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_color" class="input-label mb-2">Any specific type of color would you want to see in your Logo? <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Eg: Red, Yellow, Black, etc. " name="logo_color" class="input logo-color-input" value="{{ $formData["logo_color"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_avoid_color" class="input-label mb-2">Avoid these colors</label>
                            <input type="text" placeholder="Eg: Red, Yellow, Black, etc. " name="logo_avoid_color" class="input logo-avoid-color-input" value="{{ $formData["logo_avoid_color"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_font" class="input-label mb-2">What type of FONT style you want to see in your Logo?</label>
                            <input type="text" placeholder="Eg: Bold, Fancy, Signature, etc. " name="" class="input logo-font-input" value="{{ $formData["logo_font"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_look" class="input-label mb-2">Look and Feel of your Logo</label>
                            <input type="text" placeholder="Enter Your Answer" name="logo_look" class="input logo-look-input" value="{{ $formData["logo_look"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                        <legend class="input-label mb-2">Where will you use your Logo? <span class="asterisk">*</span></legend>
                        <div class="checkbox_row" style="margin-top: 0.5rem">
                            <input type="checkbox" id="websites" name="logo_use[]" value="websites"  {{ in_array('websites', $formData["logo_use"]) ? 'checked' : '' }} >
                            <label for="websites" class="checkbox_label">Websites</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="business_stationery_printing" name="logo_use[]" value="business_stationery_printing" {{ in_array('business_stationery_printing', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="business_stationery_printing" class="checkbox_label">Business Stationery Printing</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="signage" name="logo_use[]" value="signage" {{ in_array('signage', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="signage" class="checkbox_label">Signage / Billboards / Advertisement</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="social_media" name="logo_use[]" value="social_media"  {{ in_array('social_media', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="social_media" class="checkbox_label">Online Social Media</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="tshirt_printing" name="logo_use[]" value="tshirt_printing" {{ in_array('tshirt_printing', $formData["logo_use"]) ? 'checked' : '' }} >
                            <label for="tshirt_printing" class="checkbox_label">T-Shirt Printing</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="car_wrap" name="logo_use[]" value="car_wrap" {{ in_array('car_wrap', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="car_wrap" class="checkbox_label">Car Wrap / Vinyls</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="embroidery" name="logo_use[]" value="embroidery" {{ in_array('embroidery', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="embroidery" class="checkbox_label">Embroidery</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="packaging" name="logo_use[]" value="packaging"  {{ in_array('packaging', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="packaging" class="checkbox_label">Packaging</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="app_icon" name="logo_use[]" value="app_icon" {{ in_array('app_icon', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="app_icon" class="checkbox_label">App Icon</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="flyer_brochure" name="logo_use[]" value="flyer_brochure"  {{ in_array('flyer_brochure', $formData["logo_use"]) ? 'checked' : '' }}>
                            <label for="flyer_brochure" class="checkbox_label">Flyer / Brochure</label>
                        </div>
                        </fieldset>
                    </section>
                    
                  <section class="section break-page">
                    <fieldset class="input-fieldset">
                        <legend class="input-label mb-2">How do you want to grow your business? (MCQ)</legend>
                        <div class="checkbox_row">
                            <input type="checkbox" id="branding_design" name="business_growth[]" value="branding_design" {{ in_array('branding_design', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="branding_design" class="checkbox_label">Branding design and their printing like business cards, letterheads, etc</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="website" name="business_growth[]" value="website" {{ in_array('website', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="website" class="checkbox_label">Get a website for your business</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="mobile_app" name="business_growth[]" value="mobile_app" {{ in_array('mobile_app', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="mobile_app" class="checkbox_label">Get a mobile app for your business</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="digital_marketing" name="business_growth[]" value="digital_marketing" {{ in_array('digital_marketing', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="digital_marketing" class="checkbox_label">Grow your business from digital marketing</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="telesales_support" name="business_growth[]" value="telesales_support" {{ in_array('telesales_support', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="telesales_support" class="checkbox_label">Get a service of telesales and support professional via chat, call and email for your business</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="print_ad" name="business_growth[]" value="print_ad" {{ in_array('print_ad', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="print_ad" class="checkbox_label">Put an ad on magazine and other print media</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="tradeshow_marketing" name="business_growth[]" value="tradeshow_marketing" {{ in_array('tradeshow_marketing', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="tradeshow_marketing" class="checkbox_label">Get marketing support for tradeshows</label>
                        </div>
                        <div class="checkbox_row">
                            <input type="checkbox" id="other" name="business_growth[]" value="other" {{ in_array('other', $formData["business_growth"]) ? 'checked' : '' }}>
                            <label for="other" class="checkbox_label">Other</label>
                        </div>
                    </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="logo_budget" class="input-label mb-2">Your budget for all the things you have selected above: (Numeric Text)</label>
                            <input type="text" placeholder="Enter Your Answer" name="logo_budget" class="input logo-budget-input" value="{{ $formData["logo_budget"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="contact_time" class="input-label mb-2">What time would be convenient to contact you on call? Mention your time zone as well</label>
                            <input type="text" placeholder="Enter Your Answer" name="contact_time" class="input contact-time-input"  value="{{ $formData["contact_time"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                            <h4 class="heading" style="margin-bottom: 0.4rem;">We want to make sure you have taken time to fill out this logo submission completely with detailed, accurate & extensive information</h4>
                            <span style="margin-top: 0;" class="description">Our designers create the highest quality logo masterpieces for clients that are serious about having a professional logo designed. When we see a submission form that has been rushed, this shows us that a client is not seriously interested and we only provide them with a simple and basic logo.</span>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="anything_else" class="input-label mb-2">Anything else to tell our Designers?</label>
                            <input type="text" placeholder="Enter Your Answer" name="anything_else" class="input anything-else-input"  value="{{ $formData["anything_else"] }}" >
                        </fieldset>
                    </section>
                    <section class="section break-page">
                        <fieldset class="input-fieldset">
                            <label for="completion_date" class="input-label mb-2">Desired project completion date: <span class="asterisk">*</span></label>
                            <input type="text" placeholder="Enter Your Answer" name="completion_date" class="input completion-date-input" value="{{ $formData["completion_date"] }}" >
                        </fieldset>
                    </section>

               
            </form>
        </div>
    </div>

  <!-- JAVASCRIPT -->
  <script src="{{ asset('backend/libs/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('backend/libs/simplebar/simplebar.min.js') }}"></script>
  <script src="{{ asset('backend/libs/node-waves/waves.min.js') }}"></script>
  <script src="{{ asset('backend/libs/feather-icons/feather.min.js') }}"></script>
  
  <script src="{{ asset(mix('js/app.js')) }}"></script>