import axios from "axios";

export const downloadFile = async (route, fileName) => {
    try {
        const response = await axios.get(route, {
            responseType: "blob",
        });
        const url = window.URL.createObjectURL(new Blob([response.data]));
        const link = document.createElement("a");
        link.href = url;
        link.setAttribute("download", fileName + ".pdf");
        document.body.appendChild(link);
        link.click();

        return {
            fileName: fileName + ".pdf",
            success: true,
        };
    } catch (error) {
        console.error("Error downloading PDF:", error);
        error.fileName = fileName + ".pdf";

        throw error;
    }
};
