import { usePage } from "@inertiajs/vue3";

export const permit = (modules) => {
  const permissions = usePage().props.permissions;
  const allowed = permissions.find(permission => permission == modules);

  if(allowed!='' && typeof allowed !== "undefined") { 
    return true;
  }
  
  return false;
};

export const modulePermission = (module, type) => {
  const permissions = usePage().props.permissions;
  const allowed = permissions.find(permission => permission.toLowerCase() == module.toLowerCase() + '-' + type.toLowerCase());

  if(allowed!='' && typeof allowed !== "undefined") {
    return true;
  }

  return false;
};

export const userRole = (roles) => {
  const authorizedRoles = usePage().props.roles;
  const allowed = authorizedRoles.find(role => role == roles);

  if(allowed!='' && typeof allowed !== "undefined") {
    return true;
  }

  return false;
};