"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_Pages_Shared_Components_Payment_StripeCard_vue"],{

/***/ "./node_modules/@stripe/stripe-js/dist/stripe.esm.js":
/*!***********************************************************!*\
  !*** ./node_modules/@stripe/stripe-js/dist/stripe.esm.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   loadStripe: () => (/* binding */ loadStripe)
/* harmony export */ });
var V3_URL = 'https://js.stripe.com/v3';
var V3_URL_REGEX = /^https:\/\/js\.stripe\.com\/v3\/?(\?.*)?$/;
var EXISTING_SCRIPT_MESSAGE = 'loadStripe.setLoadParameters was called but an existing Stripe.js script already exists in the document; existing script parameters will be used';
var findScript = function findScript() {
  var scripts = document.querySelectorAll("script[src^=\"".concat(V3_URL, "\"]"));

  for (var i = 0; i < scripts.length; i++) {
    var script = scripts[i];

    if (!V3_URL_REGEX.test(script.src)) {
      continue;
    }

    return script;
  }

  return null;
};

var injectScript = function injectScript(params) {
  var queryString = params && !params.advancedFraudSignals ? '?advancedFraudSignals=false' : '';
  var script = document.createElement('script');
  script.src = "".concat(V3_URL).concat(queryString);
  var headOrBody = document.head || document.body;

  if (!headOrBody) {
    throw new Error('Expected document.body not to be null. Stripe.js requires a <body> element.');
  }

  headOrBody.appendChild(script);
  return script;
};

var registerWrapper = function registerWrapper(stripe, startTime) {
  if (!stripe || !stripe._registerWrapper) {
    return;
  }

  stripe._registerWrapper({
    name: 'stripe-js',
    version: "2.1.11",
    startTime: startTime
  });
};

var stripePromise = null;
var loadScript = function loadScript(params) {
  // Ensure that we only attempt to load Stripe.js at most once
  if (stripePromise !== null) {
    return stripePromise;
  }

  stripePromise = new Promise(function (resolve, reject) {
    if (typeof window === 'undefined' || typeof document === 'undefined') {
      // Resolve to null when imported server side. This makes the module
      // safe to import in an isomorphic code base.
      resolve(null);
      return;
    }

    if (window.Stripe && params) {
      console.warn(EXISTING_SCRIPT_MESSAGE);
    }

    if (window.Stripe) {
      resolve(window.Stripe);
      return;
    }

    try {
      var script = findScript();

      if (script && params) {
        console.warn(EXISTING_SCRIPT_MESSAGE);
      } else if (!script) {
        script = injectScript(params);
      }

      script.addEventListener('load', function () {
        if (window.Stripe) {
          resolve(window.Stripe);
        } else {
          reject(new Error('Stripe.js not available'));
        }
      });
      script.addEventListener('error', function () {
        reject(new Error('Failed to load Stripe.js'));
      });
    } catch (error) {
      reject(error);
      return;
    }
  });
  return stripePromise;
};
var initStripe = function initStripe(maybeStripe, args, startTime) {
  if (maybeStripe === null) {
    return null;
  }

  var stripe = maybeStripe.apply(undefined, args);
  registerWrapper(stripe, startTime);
  return stripe;
}; // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types

// own script injection.

var stripePromise$1 = Promise.resolve().then(function () {
  return loadScript(null);
});
var loadCalled = false;
stripePromise$1["catch"](function (err) {
  if (!loadCalled) {
    console.warn(err);
  }
});
var loadStripe = function loadStripe() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  loadCalled = true;
  var startTime = Date.now();
  return stripePromise$1.then(function (maybeStripe) {
    return initStripe(maybeStripe, args, startTime);
  });
};




/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js":
/*!***************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js ***!
  \***************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue_stripe_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue-stripe-js */ "./node_modules/vue-stripe-js/dist/vue-stripe.es.js");
/* harmony import */ var _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @stripe/stripe-js */ "./node_modules/@stripe/stripe-js/dist/stripe.esm.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator["return"] && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, "catch": function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __name: 'StripeCard',
  props: {
    client_secret: String,
    userName: String,
    email: String,
    gateway: Object,
    paymentForm: Object
  },
  setup: function setup(__props, _ref) {
    var __expose = _ref.expose;
    var props = __props;
    var userName = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)(props.userName);
    var cardNumberOptions = {
      showIcon: true,
      style: {
        base: {
          padding: "10px",
          fontSize: "16px"
        }
      },
      classes: {
        base: "cardnumberarea detailsInput m-0"
      }
    };
    var postalCodeOptions = {
      classes: {
        base: "exp-datearea detailsInput m-0"
      }
    };
    var stripeKey = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)(props.gateway.public_key);
    var instanceOptions = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)({
      // https://stripe.com/docs/js/initializing#init_stripe_js-options
    });
    var elementsOptions = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)({
      // https://stripe.com/docs/js/elements_object/create#stripe_elements-options
      /* mode: 'payment',
      currency: 'usd',
      amount: 1099, */
      clientSecret: props.client_secret
    });
    var cardOptions = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)({
      // https://stripe.com/docs/stripe.js#element-options
      hidePostalCode: true,
      style: {
        base: {
          /* iconColor: '#666EE8',
          color: '#31325F', */
          padding: "10px",
          lineHeight: "40px",
          fontWeight: 300,
          fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
          fontSize: "16px",
          "::placeholder": {
            /* color: '#CFD7E0', */
          }
        }
      }
    });
    var stripeLoaded = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)(false);
    var card = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)(null);
    var elms = (0,vue__WEBPACK_IMPORTED_MODULE_2__.ref)(null);
    (0,vue__WEBPACK_IMPORTED_MODULE_2__.onBeforeMount)(function () {
      var stripePromise = (0,_stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__.loadStripe)(stripeKey.value);
      stripePromise.then(function () {
        stripeLoaded.value = true;
      });
    });
    var cardBtn = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var stripeData, cardElement;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              console.log(props.userName);
              stripeData = (0,vue__WEBPACK_IMPORTED_MODULE_2__.reactive)({
                token: null,
                paymentMethod: null
              }); // Get stripe element
              cardElement = card.value.stripeElement;
              return _context.abrupt("return", new Promise(function (resolve, reject) {
                // Access instance methods, e.g. createToken()
                elms.value.instance.createPaymentMethod({
                  type: 'card',
                  card: cardElement,
                  billing_details: {
                    name: props.userName,
                    email: props.email,
                    phone: props.paymentForm.phone,
                    address: {
                      "city": props.paymentForm.city,
                      "line1": props.paymentForm.address,
                      "postal_code": props.paymentForm.zipcode,
                      "state": props.paymentForm.state
                    }
                  }
                }).then(function (result) {
                  console.log(result);
                  stripeData.paymentMethod = result;
                  resolve(stripeData);
                })["catch"](function (error) {
                  reject(error);
                });
              }));
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function cardBtn() {
        return _ref2.apply(this, arguments);
      };
    }();
    __expose({
      cardBtn: cardBtn
    });
    var __returned__ = {
      props: props,
      userName: userName,
      cardNumberOptions: cardNumberOptions,
      postalCodeOptions: postalCodeOptions,
      stripeKey: stripeKey,
      instanceOptions: instanceOptions,
      elementsOptions: elementsOptions,
      cardOptions: cardOptions,
      stripeLoaded: stripeLoaded,
      card: card,
      elms: elms,
      cardBtn: cardBtn,
      get StripeElements() {
        return vue_stripe_js__WEBPACK_IMPORTED_MODULE_0__.StripeElements;
      },
      get StripeElement() {
        return vue_stripe_js__WEBPACK_IMPORTED_MODULE_0__.StripeElement;
      },
      get loadStripe() {
        return _stripe_stripe_js__WEBPACK_IMPORTED_MODULE_1__.loadStripe;
      },
      ref: vue__WEBPACK_IMPORTED_MODULE_2__.ref,
      onBeforeMount: vue__WEBPACK_IMPORTED_MODULE_2__.onBeforeMount,
      reactive: vue__WEBPACK_IMPORTED_MODULE_2__.reactive
    };
    Object.defineProperty(__returned__, '__isScriptSetup', {
      enumerable: false,
      value: true
    });
    return __returned__;
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644 ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

function render(_ctx, _cache, $props, $setup, $data, $options) {
  return $setup.stripeLoaded ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)($setup["StripeElements"], {
    key: 0,
    ref: "elms",
    "stripe-key": $setup.stripeKey,
    "instance-options": $setup.instanceOptions,
    "elements-options": $setup.elementsOptions
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function (_ref) {
      var elements = _ref.elements,
        instance = _ref.instance;
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)($setup["StripeElement"], {
        ref: "card",
        elements: elements,
        options: $setup.cardOptions
      }, null, 8 /* PROPS */, ["elements", "options"])];
    }),
    _: 1 /* STABLE */
  }, 8 /* PROPS */, ["stripe-key", "instance-options", "elements-options"])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true);
}

/***/ }),

/***/ "./resources/js/Pages/Shared/Components/Payment/StripeCard.vue":
/*!*********************************************************************!*\
  !*** ./resources/js/Pages/Shared/Components/Payment/StripeCard.vue ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _StripeCard_vue_vue_type_template_id_4c76b644__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StripeCard.vue?vue&type=template&id=4c76b644 */ "./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644");
/* harmony import */ var _StripeCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./StripeCard.vue?vue&type=script&setup=true&lang=js */ "./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_StripeCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_StripeCard_vue_vue_type_template_id_4c76b644__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/Pages/Shared/Components/Payment/StripeCard.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js":
/*!********************************************************************************************************!*\
  !*** ./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_node_modules_unplugin_dist_webpack_loaders_transform_js_unpluginName_unplugin_vue_define_options_StripeCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_node_modules_unplugin_dist_webpack_loaders_transform_js_unpluginName_unplugin_vue_define_options_StripeCard_vue_vue_type_script_setup_true_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!../../../../../../node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./StripeCard.vue?vue&type=script&setup=true&lang=js */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./node_modules/unplugin/dist/webpack/loaders/transform.js?unpluginName=unplugin-vue-define-options!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=script&setup=true&lang=js");
 

/***/ }),

/***/ "./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644":
/*!***************************************************************************************************!*\
  !*** ./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644 ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_3_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_StripeCard_vue_vue_type_template_id_4c76b644__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_3_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_StripeCard_vue_vue_type_template_id_4c76b644__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./StripeCard.vue?vue&type=template&id=4c76b644 */ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[3]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/Pages/Shared/Components/Payment/StripeCard.vue?vue&type=template&id=4c76b644");


/***/ }),

/***/ "./node_modules/vue-stripe-js/dist/vue-stripe.es.js":
/*!**********************************************************!*\
  !*** ./node_modules/vue-stripe-js/dist/vue-stripe.es.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StripeElement: () => (/* binding */ StripeElement),
/* harmony export */   StripeElements: () => (/* binding */ StripeElements),
/* harmony export */   createElement: () => (/* binding */ createElement),
/* harmony export */   createElements: () => (/* binding */ createElements),
/* harmony export */   initStripe: () => (/* binding */ initStripe)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

const ERRORS = {
  STRIPE_NOT_LOADED: "Stripe v3 library is not loaded",
  INSTANCE_NOT_DEFINED: "Instance object is not defined. Make sure you initialized Stripe before creating elements",
  ELEMENTS_NOT_DEFINED: "Elements object is not defined. You can't create stripe element without it",
  ELEMENT_TYPE_NOT_DEFINED: "elementType is required. You can't create stripe element without it"
};
const initStripe = (key, options) => {
  try {
    if (!window.Stripe) {
      throw new Error(ERRORS.STRIPE_NOT_LOADED);
    }
    const stripeInstance = window.Stripe(key, options);
    return stripeInstance;
  } catch (error) {
    console.error(error);
    return error;
  }
};
const createElements = (instance, options) => {
  try {
    if (!instance) {
      throw new Error(ERRORS.INSTANCE_NOT_DEFINED);
    }
    const elements = instance.elements(options);
    return elements;
  } catch (error) {
    console.error(error);
    return error;
  }
};
const createElement = (elements, elementType, options) => {
  try {
    if (!elements) {
      throw new Error(ERRORS.ELEMENTS_NOT_DEFINED);
    }
    if (!elementType) {
      throw new Error(ERRORS.ELEMENT_TYPE_NOT_DEFINED);
    }
    const element = elements.create(elementType, options);
    return element;
  } catch (error) {
    console.error(error);
    return error;
  }
};
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main$1 = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "StripeElement",
  props: {
    elements: {
      type: Object,
      required: true
    },
    type: {
      type: String,
      default: () => "card"
    },
    options: {
      type: Object,
      default: () => ({})
    }
  },
  setup(props, { emit }) {
    const domElement = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(document.createElement("div"));
    const stripeElement = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    const mountPoint = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    const { elements, type, options } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRefs)(props);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      const mountElement = () => {
        stripeElement.value = createElement(elements.value, type.value, options.value);
        stripeElement.value.mount(domElement.value);
        mountPoint.value.appendChild(domElement.value);
      };
      const wrapperFn = (t, e) => {
        emit(t, e);
      };
      const handleEvents = () => {
        const eventTypes = [
          "change",
          "ready",
          "focus",
          "blur",
          "click",
          "escape"
        ];
        eventTypes.forEach((t) => {
          stripeElement.value.on(t, wrapperFn.bind(null, t));
        });
      };
      try {
        mountElement();
        handleEvents();
      } catch (error) {
        console.error(error);
      }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
      var _a, _b;
      (_a = stripeElement.value) == null ? void 0 : _a.unmount();
      (_b = stripeElement.value) == null ? void 0 : _b.destroy();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(options, () => {
      var _a;
      (_a = stripeElement.value) == null ? void 0 : _a.update(props.options);
    });
    return {
      stripeElement,
      domElement,
      mountPoint
    };
  }
});
const _hoisted_1$1 = { ref: "mountPoint" };
function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1$1, null, 512);
}
var StripeElement = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render$1]]);
const _sfc_main = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: "StripeElements",
  props: {
    stripeKey: {
      type: String,
      required: true
    },
    instanceOptions: {
      type: Object,
      default: () => ({})
    },
    elementsOptions: {
      type: Object,
      default: () => ({})
    }
  },
  setup(props) {
    const { stripeKey, instanceOptions, elementsOptions } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRefs)(props);
    const instance = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    const elements = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    const elementsUsable = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
      return elements.value ? Object.keys(elements.value).length > 0 : false;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
      instance.value = initStripe(stripeKey.value, instanceOptions.value);
      elements.value = createElements(instance.value, elementsOptions.value);
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(elementsOptions, () => {
      var _a;
      (_a = elements.value) == null ? void 0 : _a.update(elementsOptions.value);
    });
    return {
      elements,
      instance,
      elementsUsable
    };
  }
});
const _hoisted_1 = { key: 0 };
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.elementsUsable ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(_ctx.$slots, "default", {
      instance: _ctx.instance,
      elements: _ctx.elements
    })
  ])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("", true);
}
var StripeElements = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);



/***/ })

}]);