const stripe = Stripe(document.currentScript.dataset.publickey);
const create3dPaymentMethod = document.currentScript.dataset.create3dpaymentmethod;
const checkoutRoute = document.currentScript.dataset.checkoutroute;
const paymentintent3d = document.currentScript.dataset.paymentintent3d;
const PaymentIntentSucceeded = document.currentScript.dataset.paymentintentsucceeded;

if (stripe !== undefined || !stripe) {
    let paymentData = new Array();
    let paymentMessages = new Array();
    let loaderBgClass = ".loader-bg";

    function checkInputFilled() {
        const inputs = Array.from(
            document.querySelectorAll(".detailsInput input")
        );
        const selectElements = Array.from(
            document.querySelectorAll(".detailsInput select")
        );

        inputs.splice(6, 0, ...selectElements);

        let firstEmptyInput = null;
        let firstValInput = null;

        for (let i = 0; i < inputs.length; i++) {
            const input = inputs[i];

            let id = input.getAttribute("id");
            var x = document.querySelector(`#${id}`).closest(".detailsInput");
            let xChild = x.querySelector("#form-error-box");
            xChild.innerHTML = "";
            xChild.style.display = "";

            if (!input.value) {
                if (!firstEmptyInput) {
                    firstEmptyInput = input;
                }
            } else {
                if (!firstValInput) {
                    if (inputErrorHandler(input)) {
                        firstValInput = input;
                    }
                }
            }
        }

        if (firstValInput) {
            firstValInput.focus();
            return false;
        }

        if (firstEmptyInput) {
            let id = firstEmptyInput.getAttribute("id");
            var x = document.querySelector(`#${id}`).closest(".detailsInput");
            let xChild = x.querySelector("#form-error-box");
            xChild.innerHTML = "<p>This field is required</p>";
            xChild.style.display = "block";
            firstEmptyInput.focus();
            return false;
        }

        return true;
    }

    function checkInputFilledValidation() {
        const inputs = Array.from(
            document.querySelectorAll(".detailsInput input")
        );

        let firstEmptyInputVal = null;

        for (let i = 0; i < inputs.length; i++) {
            const input = inputs[i];

            if (!firstEmptyInputVal) {
                if (inputErrorHandler(input)) {
                    firstEmptyInputVal = input;
                }
            }
        }

        if (firstEmptyInputVal) {
            return false;
        }

        return true;
    }

    $(document).on("submit", "#payment-form", function (e) {
        e.preventDefault();

        const fieldsCheck = checkInputFilled();

        if (!fieldsCheck) {
            return false;
        }

        const cardInputArea = document.getElementById("cardInputArea");
        const creditCardNumberInput = document.getElementById("cardnumber");
        const firstNameInput = document.getElementById("firstname");
        const lastNameInput = document.getElementById("lastname");
        const stateNameInput = document.getElementById("statename");
        const cityInput = document.getElementById("city");
        const phoneInput = document.getElementById("phone");

        if (!validateCardNumber(creditCardNumberInput.value)) {
            cardInputArea.style.borderColor = "#FF0000";
            creditCardNumberInput.style.color = "#FF0000";
        } else {
            creditCardNumberInput.style.color = "";
            cardInputArea.style.borderColor = "";
        }

        $(loaderBgClass).addClass("show-bg");

        const paymentData = $(this).serializeArray();
        const paymentDataSanitize = paymentData.map(function (element, index) {
            if (element.name == "clientemail") {
                element.value = sanitizeInput(element.value, "email");
            } else {
                //console.log(element.value);
                element.value = sanitizeInput(element.value);
            }

            return element;
        });

        // Sanitize values
        formatAlphanumericInput(firstNameInput);
        formatAlphanumericInput(lastNameInput);
        formatAlphanumericInput(stateNameInput);
        formatAlphanumericInput(cityInput);
        removePlusSign(phoneInput);

        axios({
            url: create3dPaymentMethod,
            method: "POST",
            headers: {
                Accept: "application/json",
                "Content-Type": "application/json;charset=UTF-8",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            data: paymentDataSanitize,
        })
            .then(function (response) {
                // Disable the default next action handling.
                {
                    handleActions: false;
                }
                customer_id = response.data.customer;
                clientSecret = response.data.client_secret;

                $(loaderBgClass).removeClass("show-bg");
                $(document).find(".card-errors").html("");
                $(document).find(".alert-div").html("");
                $(document).find(".alert-div").css("display", "none");
                $(document).find(".validation-error").html("");

                if (response.data?.validation_errors) {
                    let errors = "<ul>";
                    let validations = response.data.validation_errors;

                    for (const [key, value] of Object.entries(validations)) {
                        if (
                            [
                                "cvc",
                                "cardNo",
                                "year",
                                "month",
                                "cardValidity",
                            ].includes(key)
                        ) {
                            // console.log(
                            //     document.getElementsByClassName(key)[0]
                            // );
                            if (["year", "month"].includes(key)) {
                                document.getElementsByClassName(
                                    "exp-date"
                                )[0].style.color = "#FF0000";
                            } else if (key == "cardValidity") {
                                document.getElementsByClassName(
                                    "cardNo"
                                )[0].style.color = "#FF0000";
                            } else {
                                document.getElementsByClassName(
                                    key
                                )[0].style.color = "#FF0000";
                            }
                            cardInputArea.style.borderColor = "#FF0000";

                            $(document)
                                .find(".card-errors")
                                .html("<ul><li>" + value + "</li></ul>");
                            //errors += "<li>"+value+"</li>";
                            //console.log(`${key}: ${value}`);
                        } else {
                            //console.log(key + " - " + value[0]);
                            let errorMessage = $(document)
                                .find("#" + key)
                                .closest(".detailsInput");
                            if (errorMessage.find(".alert-div").length > 0) {
                                errorMessage.find(".alert-div").html(value[0]);
                                errorMessage
                                    .find(".alert-div")
                                    .css("display", "block");
                            } else {
                                errorMessage
                                    .parent()
                                    .find(".alert-div")
                                    .html(value[0]);
                                errorMessage
                                    .parent()
                                    .find(".alert-div")
                                    .css("display", "block");
                            }
                        }
                        return false;
                    }

                    //errors += "</ul>";
                    //$(document).find(".card-errors").html(errors);
                    $(document).find(".card-errors").css("display", "block");
                }

                $(document).find("#card-button").attr("disabled", false);
                $(document).find("#card-button").html("Pay Now");

                if (response.data.errors) {
                    $(document).find(".card-errors").html("");
                    $(document)
                        .find(".card-errors")
                        .html("<ul>" + response.data.errors + "</ul>");
                    $(loaderBgClass).removeClass("show-bg");
                    //console.log(response.data.errors);
                } else if (response.data.error || response.data.code) {
                    //error messages
                    $(document).find("#payment_error").val(response.data.code);
                    $(document)
                        .find("#payment_message")
                        .val(response.data.error);
                    $(document)
                        .find("#payment_response")
                        .val(JSON.stringify(response.data));

                    // Call Payment Store
                    var paymentDBData = $(document)
                        .find("#payment-form")
                        .serializeArray();
                    storePaymentApi(paymentDBData, checkoutRoute);
                    //e.currentTarget.submit();
                    //console.log(response.data.error);
                } else {
                    handleServerResponse(response);
                }
            })
            .catch(function (error) {
                //console.log(error);
                $(document).find("#payment_error").val(error.code);
                $(document).find("#payment_message").val(error.message);
                // Call Payment Store
                var paymentDBData = $(document)
                    .find("#payment-form")
                    .serializeArray();
                storePaymentApi(paymentDBData, checkoutRoute);
                //e.currentTarget.submit();
            });

        function handleServerResponse(response) {
            //console.log(response);
            //console.log("handleServerResponse: " + JSON.stringify(response));
            if (
                response.data?.success ||
                response.data?.status === "succeeded"
            ) {
                $(loaderBgClass).addClass("show-bg");
                axios({
                    url: PaymentIntentSucceeded,
                    method: "POST",
                    headers: {
                        Accept: "application/json",
                        "Content-Type": "application/json;charset=UTF-8",
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                            "content"
                        ),
                    },
                    data: {
                        remainingPay: "yes",
                        payment_intent_id: response.data.id,
                        payment_method_id: response.data.payment_method,
                        customer_id: response.data.customer,
                        paymentData: paymentDataSanitize,
                    },
                }).then(function (response) {
                    //console.log(response);
                    if (response.data.error || response.data.code) {
                        //error messages
                        $(document)
                            .find("#payment_error")
                            .val(response.data.code);
                        $(document)
                            .find("#payment_message")
                            .val(response.data.error);
                        $(document)
                            .find("#payment_response")
                            .val(JSON.stringify(response.data));
                        // Call Payment Store
                        var paymentDBData = $(document)
                            .find("#payment-form")
                            .serializeArray();
                        storePaymentApi(paymentDBData, checkoutRoute);
                        //e.currentTarget.submit();
                        console.log(response.data.error);
                    } else {
                        $(document).find("#step_1").val(1);
                        $(document).find("#step_2").val(1);
                        $(document).find("#step_3").val(1);
                        // Call Payment Store
                        var paymentDBData = $(document)
                            .find("#payment-form")
                            .serializeArray();
                        storePaymentApi(paymentDBData, checkoutRoute);
                    }
                });
            } else if (response.data.error) {
                console.log("error2");

                //error messages
                $(document).find("#payment_error").val(response.data.code);
                $(document).find("#payment_message").val(response.data.error);
                $(document)
                    .find("#payment_response")
                    .val(JSON.stringify(response.data));

                var paymentDBData = $(document)
                    .find("#payment-form")
                    .serializeArray();
                storePaymentApi(paymentDBData, checkoutRoute);
            } else if (
                response.data?.requires_action ||
                response.data?.status === "requires_action"
            ) {
                console.log("requires_action");
                //console.log(response.data);
                //console.log(JSON.stringify(response));
                // Use Stripe.js to handle required card action
                var action = response.data.next_action;
                if (action && action.type === "redirect_to_url") {
                    window.location = action.redirect_to_url.url;
                }

                stripe
                    .handleCardAction(response.data.client_secret)
                    .then(function (result) {
                        $(loaderBgClass).addClass("show-bg");
                        $(document).find("#3DSecure_Popup").val(1);
                        if (result.error) {
                            console.log("error3");

                            $(document).find("#payment_error").val(result.code);
                            $(document)
                                .find("#payment_message")
                                .val(result.error.message);

                            // Call Payment Store
                            var paymentDBData = $(document)
                                .find("#payment-form")
                                .serializeArray();
                            storePaymentApi(paymentDBData, checkoutRoute);
                        } else {
                            $(document).find("#step_1").val(1);
                            //console.log(result);
                            //console.log(result.paymentIntent.id);

                            //var form_data = $(document).find("#payment-form").serialize();
                            paymentData.push({
                                name: "payment_intent_id",
                                value: result.paymentIntent.id,
                            });
                            paymentData.push({
                                name: "payment_method_id",
                                value: result.paymentIntent.payment_method,
                            });

                            // The card action has been handled
                            // The PaymentIntent can be confirmed again on the server
                            axios({
                                url: paymentintent3d,
                                method: "POST",
                                headers: {
                                    Accept: "application/json",
                                    "Content-Type":
                                        "application/json;charset=UTF-8",
                                    "X-CSRF-TOKEN": $(
                                        'meta[name="csrf-token"]'
                                    ).attr("content"),
                                },
                                data: {
                                    remainingPay: "yes",
                                    payment_intent_id: response.data.id,
                                    payment_method_id:
                                        response.data.payment_method,
                                    customer_id: customer_id,
                                    paymentData: paymentDataSanitize,
                                },
                            }).then(function (response) {
                                if (
                                    response.data?.success ||
                                    response.data?.status === "succeeded"
                                ) {
                                    $(document).find("#step_2").val(1);
                                    $(document).find("#step_3").val(1);
                                }
                                if (
                                    response.data.error &&
                                    response.data?.code !=
                                        "authentication_required"
                                ) {
                                    $(document).find("#step_1").val(0);
                                    console.log("error4");
                                    //var form_values = getFormData('#payment-form');
                                    // paymentMessages.push({name: "error_code", value: response.code});
                                    // paymentMessages.push({name: "error_message", value: response.error});

                                    $(document)
                                        .find("#payment_error")
                                        .val(response.data.code);
                                    $(document)
                                        .find("#payment_message")
                                        .val(response.data.error);

                                    // Call Payment Store
                                    var paymentDBData = $(document)
                                        .find("#payment-form")
                                        .serializeArray();
                                    storePaymentApi(
                                        paymentDBData,
                                        checkoutRoute
                                    );
                                    //e.currentTarget.submit();
                                    // console.log(
                                    //     JSON.stringify(paymentMessages)
                                    // );
                                } else {
                                    // Call Payment Store
                                    var paymentDBData = $(document)
                                        .find("#payment-form")
                                        .serializeArray();
                                    storePaymentApi(
                                        paymentDBData,
                                        checkoutRoute
                                    );
                                }
                            });
                        }
                    });
            } else {
                $(document).find("#payment_error").val("");
                $(document).find("#payment_message").val("");
            }
        }
    });
} else {
    console.log("Need stripe public key for payment.");
}
