<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $superAdmin = User::create([
            'first_name' => 'Syed. M',
            'last_name' => 'Mohsin',
            'email' => 'alex.logoorbit@gmail.com',
            'password' => bcrypt('12345678'),
            
        ]);

        $admin = User::create([
            'first_name' => 'Admin',
            'last_name' => 'One',
            'email' => 'admin@gmail.com',
            'password' => bcrypt('12345678'),
            
        ]);

        $manager = User::create([
            'first_name' => 'Brand',
            'last_name' => 'Manager',
            'email' => 'manager@gmail.com',
            'password' => bcrypt('12345678'),
            'created_by' => 1,
            
        ]);

        $salesperson = User::create([
            'first_name' => 'Salesperson',
            'last_name' => 'BrandX',
            'email' => 'salesperson@gmail.com',
            'password' => bcrypt('12345678'),
            'created_by' => 1,
            
        ]);

        $developer = User::create([
            'first_name' => 'Developer',
            'last_name' => 'BrandX',
            'email' => 'developer@gmail.com',
            'password' => bcrypt('12345678'),
            'created_by' => 1,
            
        ]);

        $customer = User::create([
            'first_name' => 'Customer',
            'last_name' => 'BrandX',
            'email' => 'customer@gmail.com',
            'password' => bcrypt('12345678'),
            'created_by' => 1,
            
        ]);

        $qualityAssurance = User::create([
            'first_name' => 'Quality Assurance',
            'last_name' => 'BrandX',
            'email' => 'qualityassurance@gmail.com',
            'password' => bcrypt('12345678'),
            'created_by' => 1,
            
        ]);

        

        $adminRole = Role::create([
            'name' => 'Admin',
            'created_by' => 1
        ]);
        $brandManagerRole = Role::create([
            'name' => 'Brand Manager',
            'created_by' => 1
        ]);
        $salespersonRole = Role::create([
            'name' => 'Salesperson',
            'created_by' => 1
        ]);
        $developerRole = Role::create([
            'name' => 'Developer',
            'created_by' => 1
        ]);
        $customerRole = Role::create([
            'name' => 'Customer',
            'created_by' => 1
        ]);

        $qualityAssuranceRole = Role::create([
            'name' => 'Quality Assurance',
            'created_by' => 1
        ]);

        $superAdminRole = Role::create([
            'name' => 'Super Admin',
            'created_by' => 1
        ]);

        //Assigning roles to users
        $superAdmin->assignRole([$superAdminRole->id]);
        $admin->assignRole([$adminRole->id]);
        $manager->assignRole([$brandManagerRole->id]);
        $salesperson->assignRole([$salespersonRole->id]);
        $developer->assignRole([$developerRole->id]);
        $customer->assignRole([$customerRole->id]);
        $qualityAssurance->assignRole([$qualityAssuranceRole->id]);

        //Permissions Module Wise
        $Userpermission1 = Permission::create(['name'=>'User-Create','guard_name'=>'web']);
        $Userpermission2 = Permission::create([ 'name'=>'User-Edit','guard_name'=>'web', ]);
        $Userpermission3 = Permission::create([ 'name'=>'User-View', 'guard_name'=>'web', ]);
        $Userpermission4 = Permission::create([ 'name'=>'User-Delete', 'guard_name'=>'web', ]);

        //Customer Permissions
        $Customer1 = Permission::create(['name' => 'Customer-Create','guard_name' => 'web']);
        $Customer2 = Permission::create(['name' => 'Customer-Edit','guard_name' => 'web']);
        $Customer3 = Permission::create(['name' => 'Customer-View','guard_name' => 'web']);
        $Customer4 = Permission::create(['name' => 'Customer-Delete','guard_name' => 'web']);

        //Role Permissions
        $Role1 = Permission::create(['name' => 'Role-Create','guard_name' => 'web']);
        $Role2 = Permission::create(['name' => 'Role-Edit','guard_name' => 'web']);
        $Role3 = Permission::create(['name' => 'Role-View','guard_name' => 'web']);
        $Role4 = Permission::create(['name' => 'Role-Delete','guard_name' => 'web']);

        //Gallery Permissions
        $Coupon1 = Permission::create(['name' => 'Coupon-Create','guard_name' => 'web']);
        $Coupon2 = Permission::create(['name' => 'Coupon-Edit','guard_name' => 'web']);
        $Coupon3 = Permission::create(['name' => 'Coupon-View','guard_name' => 'web']);
        $Coupon4 = Permission::create(['name' => 'Coupon-Delete','guard_name' => 'web']);

        //Product Permissions
        $Product1 = Permission::create(['name' => 'Product-Create','guard_name' => 'web']);
        $Product2 = Permission::create(['name' => 'Product-Edit','guard_name' => 'web']);
        $Product3 = Permission::create(['name' => 'Product-View','guard_name' => 'web']);
        $Product4 = Permission::create(['name' => 'Product-Delete','guard_name' => 'web']);

        //Payment Permissions
        $Payment1 = Permission::create(['name' => 'Payment-Create','guard_name' => 'web']);
        $Payment2 = Permission::create(['name' => 'Payment-Edit','guard_name' => 'web']);
        $Payment3 = Permission::create(['name' => 'Payment-View','guard_name' => 'web']);
        $Payment4 = Permission::create(['name' => 'Payment-Delete','guard_name' => 'web']);

        //PaymentLinkGenerator Permissions
        $PaymentLinkGenerator1 = Permission::create(['name' => 'PaymentLinkGenerator-Create','guard_name' => 'web']);
        $PaymentLinkGenerator2 = Permission::create(['name' => 'PaymentLinkGenerator-Edit','guard_name' => 'web']);
        $PaymentLinkGenerator3 = Permission::create(['name' => 'PaymentLinkGenerator-View','guard_name' => 'web']);
        $PaymentLinkGenerator4 = Permission::create(['name' => 'PaymentLinkGenerator-Delete','guard_name' => 'web']);


        //Assign Permissions to Roles

        //Add Permissions to adminRole
        $adminRole->givePermissionTo([$Userpermission1, $Userpermission2, $Userpermission3, $Userpermission4]);
        $adminRole->givePermissionTo([$Customer1, $Customer2, $Customer3, $Customer4]);
        $adminRole->givePermissionTo([$Role1, $Role2, $Role3, $Role4]);
        $adminRole->givePermissionTo([$Coupon1, $Coupon2, $Coupon3, $Coupon4]);
        $adminRole->givePermissionTo([$Product1, $Product2, $Product3, $Product4]);
        $adminRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $adminRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);


        //Add Permissions to superAdminRole
        $superAdminRole->givePermissionTo([$Userpermission1, $Userpermission2, $Userpermission3, $Userpermission4]);
        $superAdminRole->givePermissionTo([$Customer1, $Customer2, $Customer3, $Customer4]);
        $superAdminRole->givePermissionTo([$Role1, $Role2, $Role3, $Role4]);
        $superAdminRole->givePermissionTo([$Coupon1, $Coupon2, $Coupon3, $Coupon4]);
        $superAdminRole->givePermissionTo([$Product1, $Product2, $Product3, $Product4]);
        $superAdminRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $superAdminRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);

        //Add Permissions to qualityAssuranceRole
        $qualityAssuranceRole->givePermissionTo([$Userpermission1, $Userpermission2, $Userpermission3, $Userpermission4]);
        $qualityAssuranceRole->givePermissionTo([$Customer1, $Customer2, $Customer3, $Customer4]);
        $qualityAssuranceRole->givePermissionTo([$Role1, $Role2, $Role3, $Role4]);
        $qualityAssuranceRole->givePermissionTo([$Coupon1, $Coupon2, $Coupon3, $Coupon4]);
        $qualityAssuranceRole->givePermissionTo([$Product1, $Product2, $Product3, $Product4]);
        $qualityAssuranceRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $qualityAssuranceRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);

        //Add Permissions to brandManagerRole
        $brandManagerRole->givePermissionTo([$Userpermission1, $Userpermission2, $Userpermission3, $Userpermission4]);
        $brandManagerRole->givePermissionTo([$Customer1, $Customer2, $Customer3, $Customer4]);
        $brandManagerRole->givePermissionTo([$Role1, $Role2, $Role3, $Role4]);
        $brandManagerRole->givePermissionTo([$Product1, $Product2, $Product3, $Product4]);
        $brandManagerRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $brandManagerRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);

        //Add Permissions to salespersonRole
        $salespersonRole->givePermissionTo([$Customer1, $Customer2, $Customer3,]);
        $salespersonRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $salespersonRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);

        //Add Permissions to developerRole
        $developerRole->givePermissionTo([$Userpermission1, $Userpermission2, $Userpermission3, $Userpermission4]);
        $developerRole->givePermissionTo([$Role1, $Role2, $Role3, $Role4]);
        $developerRole->givePermissionTo([$Product1, $Product2, $Product3, $Product4]);
        $developerRole->givePermissionTo([$Payment1, $Payment2, $Payment3, $Payment4]);
        $developerRole->givePermissionTo([$PaymentLinkGenerator1, $PaymentLinkGenerator2, $PaymentLinkGenerator3, $PaymentLinkGenerator4]);


       //Add Permissions to customerRole
        $customerRole->givePermissionTo([$Customer3]);
        $customerRole->givePermissionTo([$Payment3]);
    }
}
