<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCustomIdToBriefActivitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('brief_activities', function (Blueprint $table) {
            $table->string('custom_id')->nullable()->index()->after('id');
            $table->unsignedInteger('no_of_visits')->nullable()->after('activity_desc');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('brief_activities', function (Blueprint $table) {
            $table->dropColumn('custom_id');
            $table->dropColumn('no_of_visits');
        });
    }
}
